/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.csv;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdCsvUtils;
import crazydev.common.utils.CdLineReader;
import crazydev.iccube.builder.datasource.csv.OlapBuilderCSVLineScanner;
import crazydev.iccube.builder.datasource.file.OlapBuilderBaseFileDataTable;
import crazydev.iccube.builder.datasource.file.OlapBuilderDirectoryConnection;
import crazydev.iccube.builder.datasource.file.OlapBuilderLineScanner;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderCSVDataTableValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="csvDataTable")
public class OlapBuilderCSVDataTable
extends OlapBuilderBaseFileDataTable {
    public static final CdProperty SEPARATOR = new CdReadWriteProperty(OlapBuilderCSVDataTable.class, "csvseparator");
    public static final CdProperty QUOTE_CHAR = new CdReadWriteProperty(OlapBuilderCSVDataTable.class, "csvquotechar");
    public static final CdProperty ESCAPE = new CdReadWriteProperty(OlapBuilderCSVDataTable.class, "csvescape");
    public static final CdProperty STRICT_QUOTES = new CdReadWriteProperty(OlapBuilderCSVDataTable.class, "csvstrictQuotes");
    public static final CdProperty IGNORE_LEADING_WHITESPACE = new CdReadWriteProperty(OlapBuilderCSVDataTable.class, "csvignoreLeadingWhiteSpace");
    @XmlAttribute(required=true)
    private String csvseparator = ",";
    @XmlAttribute(required=true)
    private String csvquotechar = "\"";
    @XmlAttribute(required=true)
    private String csvescape = "\\";
    @XmlAttribute(required=true)
    private boolean csvstrictQuotes = false;
    @XmlAttribute(required=true)
    private boolean csvignoreLeadingWhiteSpace = true;

    public OlapBuilderCSVDataTable() {
    }

    public OlapBuilderCSVDataTable(String fileName) {
        super(fileName);
    }

    public OlapBuilderCSVDataTable(String fileName, String separator, String quotechar, String escape) {
        super(fileName);
        this.csvseparator = separator;
        this.csvquotechar = quotechar;
        this.csvescape = escape;
    }

    @Override
    public OlapBuilderLineScanner createLineScanner(OlapBuilderDirectoryConnection openedConnection, CdLineReader lineReader) {
        String csvSeparatorStr = CdCsvUtils.unescapeJava((String)this.csvseparator);
        String csvQuoteStr = CdCsvUtils.unescapeJava((String)this.csvquotechar);
        String csvEscapeStr = CdCsvUtils.unescapeJava((String)this.csvescape);
        char separator = csvSeparatorStr.charAt(0);
        char quote = csvQuoteStr.charAt(0);
        char escape = csvEscapeStr.charAt(0);
        return new OlapBuilderCSVLineScanner(this.getName(), lineReader, separator, quote, escape, this.csvstrictQuotes, this.csvignoreLeadingWhiteSpace);
    }

    @Override
    public String getInternalFriendlyTypeName() {
        return "CSV Table";
    }

    public String getCsvseparator() {
        return this.csvseparator;
    }

    public String getQuotechar() {
        return this.csvquotechar;
    }

    public String getEscape() {
        return this.csvescape;
    }

    @Override
    public String getCommentMarker() {
        return null;
    }

    @Override
    public String getArrayValueSeparator() {
        return ",".equals(this.getCsvseparator()) ? ";" : ",";
    }

    @Override
    public String getColumnSeparator() {
        return null;
    }

    @Override
    public boolean isWithHeader() {
        return true;
    }

    @Override
    public OlapBuilderValidator<IOlapBuilderDataSource<OlapBuilderDirectoryConnection>, IOlapBuilderDataTableDef<OlapBuilderDirectoryConnection>> getValidator() {
        return new OlapBuilderCSVDataTableValidator();
    }
}

