/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource;

import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderAbstractConnection<DATASOURCE extends OlapBuilderBaseDataSource>
implements IOlapBuilderConnection {
    protected final DATASOURCE dataSource;
    private boolean isOpen;

    public OlapBuilderAbstractConnection(DATASOURCE dataSource) {
        this.dataSource = dataSource;
        this.isOpen = false;
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    public DATASOURCE getDataSource() {
        return this.dataSource;
    }

    protected void forceIsOpen() {
        this.isOpen = true;
    }

    @Override
    public final void openForCheckConnection(OlapRuntimeContext context) throws OlapBuilderErrorException {
        this.open(context);
        this.checkOnOpenConnectionEx();
    }

    protected void checkOnOpenConnectionEx() throws OlapBuilderErrorException {
    }

    @Override
    public void open(@Nullable OlapRuntimeContext context) throws OlapBuilderErrorException {
        if (!this.isOpen) {
            this.onOpen(context);
            this.isOpen = true;
        }
    }

    @Override
    public void close() {
        this.isOpen = false;
        this.onClose();
    }

    protected abstract void onOpen(OlapRuntimeContext var1) throws OlapBuilderErrorException;

    protected abstract void onClose();

    @Override
    public boolean isClosed() {
        return !this.isOpen;
    }

    protected void assertIsOpen() {
        if (!this.isOpen) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.CONNECTION_CLOSED, new Serializable[]{((OlapBuilderBaseDataSource)this.dataSource).getName()});
        }
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }
}

