/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.common;

import com.google.gson.stream.JsonReader;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.utils.CdIoUtils;
import crazydev.common.utils.CdLineReader;
import crazydev.iccube.builder.common.OlapAbstractFileSystem;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public abstract class OlapSecureAbstractLocalFileSystem
extends OlapAbstractFileSystem {
    protected OlapFile resolvedTrustedDirectory;

    public void onOpen(OlapRuntimeContext context, String directoryOrFileName, boolean isFile) throws OlapBuilderErrorException {
        OlapFileSystem fs = context.getRootFileSystem();
        String directoryOrFileName_ = fs.evalPropertyForCubesLocation(directoryOrFileName);
        this.resolvedTrustedDirectory = fs.create(directoryOrFileName_);
        if (!this.resolvedTrustedDirectory.exists()) {
            if (isFile) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.FILE_NOT_EXISTS, new Serializable[]{this.resolvedTrustedDirectory.getUnderlyingAbsolutePathForUserError()});
            }
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DIRECTORY_NOT_EXISTS, new Serializable[]{this.resolvedTrustedDirectory.getUnderlyingAbsolutePathForUserError()});
        }
        if (isFile && !this.resolvedTrustedDirectory.isFile()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.FILE_EXPECTED_FOR_THE_PROVIDED_PATH, new Serializable[]{this.resolvedTrustedDirectory.getUnderlyingAbsolutePathForUserError()});
        }
        if (!isFile && !this.resolvedTrustedDirectory.isDirectory()) {
            if (this.resolvedTrustedDirectory.isFile()) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.DIRECTORY_EXPECTED_GOT_FILE, new Serializable[]{this.resolvedTrustedDirectory.getUnderlyingAbsolutePathForUserError()});
            }
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DIRECTORY_EXPECTED_FOR_THE_PROVIDED_PATH, new Serializable[]{this.resolvedTrustedDirectory.getUnderlyingAbsolutePathForUserError()});
        }
    }

    @Override
    public InputStream getInputStream(OlapRuntimeContext context, String untrustedFileName, String fileEncoding) {
        OlapFile existingFile = this.getExistingFile(context, untrustedFileName);
        try {
            return existingFile.createInputStreamX(fileEncoding);
        }
        catch (IOException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{ex.getMessage(), existingFile.getUnderlyingAbsolutePathForUserError()});
        }
    }

    @Override
    public BufferedReader getReader(OlapRuntimeContext context, String untrustedFileName, String fileEncoding) {
        OlapFile existingFile = this.getExistingFile(context, untrustedFileName);
        try {
            InputStream inputStream = existingFile.createInputStreamX(fileEncoding);
            return new BufferedReader(new InputStreamReader(inputStream, fileEncoding));
        }
        catch (UnsupportedEncodingException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.CHAR_ENCODING_NOT_SUPPORTED, new Serializable[]{fileEncoding});
        }
        catch (FileNotFoundException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DEFINITION_FILE_NOT_EXIST, new Serializable[]{existingFile.getUnderlyingAbsolutePathForUserError()});
        }
        catch (IOException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{ex.getMessage(), existingFile.getUnderlyingAbsolutePathForUserError()});
        }
    }

    @Override
    public JsonReader createMultiFileJsonReader(OlapRuntimeContext context, boolean sorted, @Nullable Predicate<String> fileFilter, String fileEncoding) {
        throw new CdShouldNotBeHereProgrammingException("Not yet supported");
    }

    @Override
    public List<Supplier<BufferedReader>> getMultiFileBufferedReaders(OlapRuntimeContext context, @Nullable Predicate<String> fileFilter, boolean sorted, String fileEncoding) {
        List<File> files = this.getFilesList(context, sorted, fileFilter);
        return files.stream().map(s -> () -> {
            try {
                return CdIoUtils.getBufferedReader((File)s, (String)fileEncoding);
            }
            catch (IOException e) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{e.getMessage()});
            }
        }).collect(Collectors.toList());
    }

    @Override
    public CdLineReader createMultiFileReader(OlapRuntimeContext context, boolean sorted, @Nullable Predicate<String> fileFilter, String fileEncoding) {
        List<File> files = this.getFilesList(context, sorted, fileFilter);
        return CdIoUtils.getFileReader(files, (String)fileEncoding, (boolean)true);
    }

    private List<File> getFilesList(OlapRuntimeContext context, boolean sorted, @Nullable Predicate<String> fileFilter) {
        try {
            OlapFileSystem fs = context.getRootFileSystem();
            List<OlapFile> files = sorted ? fs.sortedList(1024, this.resolvedTrustedDirectory.getPath(), false) : fs.list(1024, this.resolvedTrustedDirectory.getPath(), false);
            List<File> filteredFiles = files.stream().filter(file -> file.isFile() && file.exists() && (fileFilter == null || fileFilter.test(file.getName()))).map(OlapFile::__getUnderlying).collect(Collectors.toList());
            if (filteredFiles.isEmpty()) {
                return Collections.emptyList();
            }
            return filteredFiles;
        }
        catch (IOException ex) {
            OlapLoggers.BUILDER.error((Object)"[builder] could not retrieve the list of files", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public OlapFile getExistingFile(OlapRuntimeContext context, String untrustedFileName) {
        OlapFile trustedFile = this.getFile(context, untrustedFileName);
        if (!trustedFile.exists()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DEFINITION_FILE_NOT_EXIST, new Serializable[]{trustedFile.getUnderlyingAbsolutePathForUserError()});
        }
        if (!trustedFile.isFile()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.NOT_A_FILE_WAS_FOUND_FOR_THE_PATH, new Serializable[]{trustedFile.getUnderlyingAbsolutePathForUserError()});
        }
        return trustedFile;
    }

    public OlapFile getFile(OlapRuntimeContext context, String untrustedFileName) {
        OlapFileSystem fs = context.getRootFileSystem();
        if (this.resolvedTrustedDirectory == null) {
            return fs.create(untrustedFileName);
        }
        return fs.create(this.resolvedTrustedDirectory, untrustedFileName);
    }
}

