/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.common;

import com.google.gson.stream.JsonReader;
import crazydev.common.utils.CdBufferedLineReader;
import crazydev.common.utils.CdLineReader;
import crazydev.iccube.builder.common.OlapHttpFileSystem;
import crazydev.iccube.builder.common.OlapSecureLocalFileSystem;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.fs.OlapFileNameFilter;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OlapAbstractFileSystem {
    public static OlapAbstractFileSystem createOlapSecureLocalFileSystem(String untrustedDirectory, String user, String pwd, String httpHeader) {
        try {
            URL uRL = new URI(untrustedDirectory).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            return new OlapSecureLocalFileSystem(untrustedDirectory);
        }
        return new OlapHttpFileSystem(untrustedDirectory, user, pwd, httpHeader);
    }

    public abstract void onOpen(OlapRuntimeContext var1) throws OlapBuilderErrorException;

    public abstract void onClose();

    public abstract InputStream getInputStream(OlapRuntimeContext var1, String var2, String var3);

    public abstract BufferedReader getReader(OlapRuntimeContext var1, String var2, String var3);

    public CdLineReader createSingleFileReader(OlapRuntimeContext context, String untrustedFileName, String fileEncoding) {
        return new CdBufferedLineReader(this.getReader(context, untrustedFileName, fileEncoding), fileEncoding);
    }

    public JsonReader createSingleFileJsonReader(OlapRuntimeContext context, String untrustedFileName, String fileEncoding) {
        return new JsonReader((Reader)this.getReader(context, untrustedFileName, fileEncoding));
    }

    public JsonReader createMultiFileJsonReader(OlapRuntimeContext context, boolean sorted, @Nullable Predicate<String> fileFilter, String fileEncoding) {
        final List<Supplier<BufferedReader>> readers = this.getMultiFileBufferedReaders(context, fileFilter, sorted, fileEncoding);
        return new JsonReader(new Reader(this){
            int pos;
            BufferedReader current;
            {
                Objects.requireNonNull(this$0);
                this.pos = 0;
                this.current = this.get(0);
            }

            public BufferedReader get(int i) {
                return i >= readers.size() ? null : (BufferedReader)((Supplier)readers.get(i)).get();
            }

            @Override
            public int read(@NotNull char[] cbuf, int off, int len) throws IOException {
                if (this.current == null) {
                    return -1;
                }
                int ret = this.current.read(cbuf, off, len);
                if (ret == -1) {
                    this.current.close();
                    this.current = this.get(++this.pos);
                    return this.read(cbuf, off, len);
                }
                return ret;
            }

            @Override
            public void close() throws IOException {
                if (this.current != null) {
                    this.current.close();
                }
            }
        });
    }

    public abstract List<Supplier<BufferedReader>> getMultiFileBufferedReaders(OlapRuntimeContext var1, @Nullable Predicate<String> var2, boolean var3, String var4);

    public abstract CdLineReader createMultiFileReader(OlapRuntimeContext var1, boolean var2, @Nullable Predicate<String> var3, String var4);

    public abstract List<String> listLocalFileNames(OlapFileNameFilter var1);

    public abstract boolean fileExists(OlapRuntimeContext var1, String var2);

    public abstract String getUnderlyingAbsolutePathForUserError(OlapRuntimeContext var1, @Nullable String var2);
}

