/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder;

import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class OlapBuilderUnloadEntityContext {
    private final Logger schemaLogger;
    private final OlapFileCleaner fileCleaner;
    private final List<RequestedCube> requestedCubes = new ArrayList<RequestedCube>();
    private final List<String> unloadedPartitions = new ArrayList<String>();
    private int currentTask;

    public OlapBuilderUnloadEntityContext(Logger schemaLogger, OlapFileCleaner fileCleaner) {
        this.schemaLogger = schemaLogger;
        this.fileCleaner = fileCleaner;
    }

    public abstract String commandForLogsAndErrors();

    public Logger getSchemaLogger() {
        return this.schemaLogger;
    }

    public OlapFileCleaner getFileCleaner() {
        return this.fileCleaner;
    }

    public int getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(int currentTask) {
        this.currentTask = currentTask;
    }

    public void addRequestedCubes(OlapRegularCube cube, List<OlapFactMeasureGroupBaseManager> measureGroups) {
        this.requestedCubes.add(new RequestedCube(cube, measureGroups));
    }

    public List<RequestedCube> getRequestedCubes() {
        return this.requestedCubes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAsUnloadedPartition(String partition) {
        List<String> list = this.unloadedPartitions;
        synchronized (list) {
            this.unloadedPartitions.add(partition);
        }
    }

    public OlapSchemaUnloadPartitionsInfo getUnloadPartitionsInfo(OlapSchema loadedSchema) {
        return new OlapSchemaUnloadPartitionsInfo(loadedSchema, this.unloadedPartitions);
    }

    public static class RequestedCube {
        public final OlapRegularCube cube;
        public final List<OlapFactMeasureGroupBaseManager> measureGroups;

        public RequestedCube(OlapRegularCube cube, List<OlapFactMeasureGroupBaseManager> measureGroups) {
            this.cube = cube;
            this.measureGroups = measureGroups;
        }

        public String getNameX() {
            Object measureGroupNames = " :";
            for (int ii = 0; ii < this.measureGroups.size(); ++ii) {
                OlapFactMeasureGroupBaseManager measureGroup = this.measureGroups.get(ii);
                measureGroupNames = (String)measureGroupNames + (ii > 0 ? ", " : " ") + measureGroup.getMeasureGroupName();
            }
            return this.cube.getNameX() + (String)measureGroupNames;
        }
    }
}

