/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.babylon.CdLoggingBabylonService;
import crazydev.common.collection.CdAction;
import crazydev.common.collection.CdCollections;
import crazydev.common.collection.CdSetList;
import crazydev.common.exception.ICdException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.math.CdSortingGraph;
import crazydev.common.mdx.error.CdMdxException;
import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdSystemUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.common.xml.CdXmlSerializable;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaPermissions;
import crazydev.iccube.builder.OlapBuilderCacheTableHelper;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderContextMode;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.datasource.buffer.OlapBuilderBufferDataSource;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.errors.OlapBuilderErrorManagerHelper;
import crazydev.iccube.builder.errors.OlapBuilderErrorsException;
import crazydev.iccube.builder.errors.OlapBuilderIncrLoadLimitNotAuthException;
import crazydev.iccube.builder.errors.OlapBuilderIncrLoadNotAuthException;
import crazydev.iccube.builder.executor.common.OlapBuilderTableProcessingHelper;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.model.builders.IOlapBuilderTableListener;
import crazydev.iccube.builder.model.builders.OlapBuilderNopDataTableListener;
import crazydev.iccube.builder.model.builders.bridge.OlapBridgeDef;
import crazydev.iccube.builder.model.builders.bridge.OlapSingleBridgeDef;
import crazydev.iccube.builder.model.builders.dimension.BaseDimensionBuilder;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderBaseFactBuilder;
import crazydev.iccube.builder.model.builders.lookuptable.OlapLookupTable;
import crazydev.iccube.builder.model.def.IOlapBuilderAttributeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderColorsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHeaderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderLocalizationDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPerspectiveDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderScriptDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.def.OlapBuilderDataViewLinksType;
import crazydev.iccube.builder.model.entityfactory.OlapDimensionFactory;
import crazydev.iccube.builder.model.entityfactory.OlapMeasuresDimensionFactory;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.OlapBuilderDataSourceHelper;
import crazydev.iccube.builder.model.impl.OlapBuilderPerspective;
import crazydev.iccube.builder.model.impl.colors.OlapBuilderColorsBuilder;
import crazydev.iccube.builder.model.impl.localization.OlapBuilderLocalizationBuilder;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderViewCycleDetector;
import crazydev.iccube.builder.model.validation.OlapBuilderSchemaValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.type.SchemaGarbageCollectorType;
import crazydev.iccube.cluster.master.local.M_LocalCluster;
import crazydev.iccube.cluster.node.engine.N_OlapEngine;
import crazydev.iccube.cluster.node.facts.N_FactPageBitmapGutsBitmapCount;
import crazydev.iccube.cluster.shared.facts.bitmap.S_FactBitmapContainerFactory;
import crazydev.iccube.cluster.shared.facts.bitmap.S_FactRoaringBitmapFileContainerFactory;
import crazydev.iccube.cluster.shared.facts.bitmap.S_FactRoaringBitmapRamContainerFactory;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorTaskSchedulingPolicy;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.enums.OlapIncrementalLoadStrategy;
import crazydev.iccube.enums.OlapPartitioningType;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.mdx.parser.MdxParserIdentifierHelper;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxHelper;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxScriptCompilationInfo;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxScriptExecutionInfo;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperty;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSet;
import crazydev.iccube.olap.entity.result.script.OlapResScriptDataSet;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityHelper;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.facts.OlapFactCubeManager;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.facts.column.memlist.OlapFactPaginatedListFactory;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactMemMapListFactory;
import crazydev.iccube.olap.goodies.incrload.IncrLoadInstanceManager;
import crazydev.iccube.olap.goodies.incrload.IncrLoadPhase;
import crazydev.iccube.olap.goodies.incrload.IncrLoadSavePoints;
import crazydev.iccube.olap.goodies.incrload.IncrLoadSchemaDef;
import crazydev.iccube.olap.goodies.incrload.IncrLoadUnresolvedRows;
import crazydev.iccube.olap.goodies.incrload.IncrLoadUnresolvedRowsM2Ms;
import crazydev.iccube.olap.goodies.perspective.OlapPerspective;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveBuilder;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveParser;
import crazydev.iccube.olap.goodies.unresolverows.OlapUnresolvedRowsKey;
import crazydev.iccube.olap.goodies.unresolverows.OlapUnresolvedRowsManager;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepository;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.olap.schema.colors.OlapDefaultSchemaColors;
import crazydev.iccube.olap.schema.colors.OlapEmptySchemaColors;
import crazydev.iccube.olap.schema.colors.OlapSchemaColors;
import crazydev.iccube.olap.schema.localization.OlapDefaultSchemaLocalization;
import crazydev.iccube.olap.schema.localization.OlapEmptySchemaLocalization;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import crazydev.iccube.olap.schema.stats.OlapDimensionStats;
import crazydev.iccube.olap.schema.stats.OlapFactsStats;
import crazydev.iccube.olap.schema.stats.OlapHierarchyStats;
import crazydev.iccube.olap.schema.stats.OlapIncrLoadStats;
import crazydev.iccube.olap.schema.stats.OlapSavePointStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaFullLoadStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaStatsHolder;
import crazydev.iccube.olap.schema.stats.OlapSchemaTimingStats;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderSchemaMain {
    static final OlapNameContext nameContext = OlapNameContext.DEFAULT_VALUES;

    private OlapBuilderSchemaMain() {
    }

    public static OlapSchema create(OlapEngineRequestContext requestContext, IOlapEngineLoadSchemaParams params, OlapProperties properties, OlapFunctionRepository functionRepository, boolean stopOnError, IOlapBuilderSchemaDefFactory factory) throws OlapContextualBigException {
        OlapEngineRequestContext elevatedRequestContext = requestContext.elevateForBuilder();
        elevatedRequestContext.deactivateScriptStatementApplied();
        try {
            OlapSchema olapSchema = OlapBuilderSchemaMain.unsafeCreate(elevatedRequestContext, params, properties, functionRepository, stopOnError, factory);
            return olapSchema;
        }
        catch (OlapContextualBigException ex) {
            List<? extends OlapContextualError> errors = ex.getErrors();
            OlapLoggers.BUILDER.error((Object)("could not create schema (most likely validation errors) : " + factory.getSchemaName()));
            for (OlapContextualError olapContextualError : errors) {
                OlapLoggers.BUILDER.error((Object)("-" + olapContextualError.asFullMessage((CdBabylonService)CdLoggingBabylonService.INSTANCE)));
            }
            OlapBuilderContext builderContext = elevatedRequestContext.getBuilderContext();
            if (builderContext != null) {
                builderContext.onSchemaProcessingOnError();
            }
            throw ex;
        }
        finally {
            requestContext.setBuilderContext(elevatedRequestContext.getBuilderContext_());
        }
    }

    @Nullable
    public static OlapBuilderContext incrementalLoadPhaseI(OlapEngineRequestContext engineRequestContext, IOlapEngineLoadSchemaParams params, OlapSchema schema) throws OlapBuilderIncrLoadNotAuthException, OlapBuilderIncrLoadLimitNotAuthException, OlapContextualBigException {
        if (!engineRequestContext.isIncrLoadLicensed() && !schema.isMonitoring()) {
            throw new OlapBuilderIncrLoadNotAuthException();
        }
        if (!schema.acceptIncrLoad()) {
            OlapLoggers.BUILDER.warn((Object)("[incr. load] incr. load not accepted (" + schema.incrLoads() + ")"));
            throw new OlapBuilderIncrLoadLimitNotAuthException();
        }
        OlapBuilderErrorManager errorManager = new OlapBuilderErrorManager(true);
        try {
            if (schema.isIncrLoadDeActivatedOnError()) {
                return null;
            }
            OlapBuilderContext context = new OlapBuilderContext(engineRequestContext, params, OlapBuilderContextMode.INCR_LOAD, IncrLoadPhase.LOADING_DATA, schema);
            try {
                OlapBuilderSchemaMain.unsafeIncrementalLoadPhaseI(context, errorManager, schema);
            }
            catch (RuntimeException ex) {
                context.onIncrLoadWithErrorPhaseI();
                throw ex;
            }
            if (schema.getCallGC() == SchemaGarbageCollectorType.ACTIVE) {
                long ms = 1000L;
                CdSystemUtils.callGC((long)1000L);
                M_LocalCluster cluster = context.getCluster();
                N_OlapEngine engine = cluster.getEngine();
                engine.callGC(1000L);
            }
            return context;
        }
        catch (OlapBuilderErrorException ex) {
            engineRequestContext.getLoggers().builder().warn((Object)"schema incr. load (I) recoverable error", (Throwable)((Object)ex));
            errorManager.addError(ex.getError());
            throw errorManager.asException();
        }
        catch (RuntimeException ex) {
            engineRequestContext.getLoggers().builder().warn((Object)"schema incr. load (I) recoverable exception", (Throwable)ex);
            errorManager.addException(ex);
            throw errorManager.asException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unsafeIncrementalLoadPhaseI(OlapBuilderContext context, OlapBuilderErrorManager errorManager, OlapSchema schema) {
        try (OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();){
            if (context.incrLoadPhase() != IncrLoadPhase.LOADING_DATA) {
                throw new RuntimeException("internal error : inconsistent incr-load phase [" + String.valueOf((Object)context.incrLoadPhase()) + "]");
            }
            IOlapBuilderSchemaDef schemaDef = schema.getDefinitionFactory().createSchemaDefinition(connectionPool, errorManager);
            IncrLoadSavePoints incrementalLoad = schema.getIncrementalLoad();
            OlapBuilderSchemaMain.removeAllListeners(schemaDef);
            incrementalLoad.removeAllListeners();
            ArrayList<IOlapBuilderDataTableDef> tables = new ArrayList<IOlapBuilderDataTableDef>();
            OlapBuilderSchemaMain.onAllDataTables(schemaDef, (CdAction<IOlapBuilderDataTableDef>)((CdAction)dataTable -> {
                if (incrementalLoad.handlesTable((IOlapBuilderDataTableDef)dataTable)) {
                    tables.add((IOlapBuilderDataTableDef)dataTable);
                }
            }));
            OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy = OlapThreadPoolExecutorTaskSchedulingPolicy.POST_ORDER;
            List<IOlapBuilderDataTableDef> triggerTables = OlapBuilderSchemaMain.filterTables(incrementalLoad, tables, OlapIncrementalLoadStrategy.INCREMENTAL_TRIGGER);
            boolean hasTrigger = !triggerTables.isEmpty();
            OlapBuilderTableProcessingHelper.processTables(context, connectionPool, processingSchedulingPolicy, triggerTables);
            if (!hasTrigger || incrementalLoad.hasData()) {
                List<IOlapBuilderDataTableDef> incrementalTables = OlapBuilderSchemaMain.filterTables(incrementalLoad, tables, OlapIncrementalLoadStrategy.INCREMENTAL);
                OlapBuilderTableProcessingHelper.processTables(context, connectionPool, processingSchedulingPolicy, incrementalTables);
                List<IOlapBuilderDataTableDef> reloadTables = OlapBuilderSchemaMain.filterTables(incrementalLoad, tables, OlapIncrementalLoadStrategy.FULL_RELOAD);
                OlapBuilderTableProcessingHelper.processTables(context, connectionPool, processingSchedulingPolicy, reloadTables);
            }
        }
    }

    private static List<IOlapBuilderDataTableDef> filterTables(IncrLoadSavePoints incrementalLoad, List<IOlapBuilderDataTableDef> tables, OlapIncrementalLoadStrategy incremental) {
        ArrayList<IOlapBuilderDataTableDef> otherTables = new ArrayList<IOlapBuilderDataTableDef>();
        for (int ii = 0; ii < tables.size(); ++ii) {
            IOlapBuilderDataTableDef table = tables.get(ii);
            if (table.getIncrementalLoadStrategy() != incremental) continue;
            incrementalLoad.addListener(table);
            otherTables.add(table);
        }
        return otherTables;
    }

    public static OlapSchemaIncrLoadInfo incrementalLoadPhaseII(OlapBuilderContext context, OlapSchema schema) throws OlapBuilderIncrLoadNotAuthException, OlapContextualBigException {
        if (!context.isIncrLoadLicensed() && !schema.isMonitoring()) {
            throw new OlapBuilderIncrLoadNotAuthException();
        }
        OlapBuilderErrorManager errorManager = new OlapBuilderErrorManager(true);
        try {
            return OlapBuilderSchemaMain.unsafeIncrementalLoadPhaseII(context, errorManager, schema);
        }
        catch (OlapBuilderErrorException ex) {
            context.getLoggers().builder().warn((Object)"schema incr. load (II) error", (Throwable)((Object)ex));
            schema.deActivateIncrLoadOnError();
            errorManager.addError(ex.getError());
            throw errorManager.asException();
        }
        catch (RuntimeException ex) {
            context.getLoggers().builder().warn((Object)"schema incr. load (II) exception", (Throwable)ex);
            schema.deActivateIncrLoadOnError();
            errorManager.addException(ex);
            throw errorManager.asException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OlapSchemaIncrLoadInfo unsafeIncrementalLoadPhaseII(OlapBuilderContext context, OlapBuilderErrorManager errorManager, OlapSchema schema) {
        try (OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();){
            IncrLoadSavePoints incrementalLoad = schema.getIncrementalLoad();
            try {
                long start = System.currentTimeMillis();
                if (context.getLoggers().builder().isInfoEnabled()) {
                    context.getLoggers().builder().info((Object)("schema (" + schema.getName() + ") incr. load start"));
                }
                boolean hasNewData = incrementalLoad.hasData();
                OlapSchemaIncrLoadInfo incrLoadInfo = new OlapSchemaIncrLoadInfo(schema, hasNewData);
                if (hasNewData) {
                    context.setIncrLoadPhase(IncrLoadPhase.BUILDING_SCHEMA);
                    IOlapBuilderSchemaDef schemaDef = schema.getDefinitionFactory().createSchemaDefinition(connectionPool, errorManager);
                    OlapBuilderBufferDataSource dataSource = incrementalLoad.createDataSource(schemaDef);
                    IncrLoadSchemaDef newSchemaDef = new IncrLoadSchemaDef(schemaDef, dataSource, schema.getUnresolvedRowsManager());
                    OlapBuilderSchemaMain.doIncrementalLoad(context, errorManager, connectionPool, newSchemaDef, schema, incrLoadInfo);
                    incrementalLoad.onIncrLoadFinishAllDataProcessing(context);
                    OlapBuilderSchemaMain.setLastDataUpdatedTime(schema);
                    context.setupRebuildMdxResultCacheInfos();
                }
                if (context.getLoggers().builder().isInfoEnabled()) {
                    context.getLoggers().builder().info((Object)("schema (" + schema.getName() + ") incr. load done : " + CdStringUtils.formatNice((long)(System.currentTimeMillis() - start)) + " s."));
                }
                context.__setIncrLoadInfoForTest(incrLoadInfo);
                OlapSchemaIncrLoadInfo olapSchemaIncrLoadInfo = incrLoadInfo;
                incrementalLoad.cleanup();
                return olapSchemaIncrLoadInfo;
            }
            catch (Throwable throwable) {
                incrementalLoad.cleanup();
                throw throwable;
            }
        }
    }

    private static OlapSchema unsafeCreate(OlapEngineRequestContext requestContext, IOlapEngineLoadSchemaParams params, OlapProperties properties, OlapFunctionRepository functionRepository, boolean stopOnError, IOlapBuilderSchemaDefFactory factory) throws OlapContextualBigException {
        OlapBuilderErrorManager errorManager = new OlapBuilderErrorManager(stopOnError);
        try {
            OlapSchema schema = OlapBuilderSchemaMain.create(requestContext, properties, params, errorManager, functionRepository, factory);
            if (errorManager.hasErrors()) {
                throw errorManager.asException();
            }
            return schema;
        }
        catch (OlapBuilderErrorException ex) {
            requestContext.getLoggers().builder().warn((Object)"schema-main builder-error-exception", (Throwable)((Object)ex));
            errorManager.addError(ex.getError());
            throw errorManager.asException();
        }
        catch (RuntimeException ex) {
            errorManager.addException(ex);
            throw errorManager.asException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OlapSchema create(OlapEngineRequestContext requestContext, OlapProperties properties, IOlapEngineLoadSchemaParams params, OlapBuilderErrorManager errorManager, OlapFunctionRepository functionRepository, IOlapBuilderSchemaDefFactory factory) {
        try (OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();){
            OlapSchema olapSchema = OlapBuilderSchemaMain.doCreate(requestContext, connectionPool, properties, params, errorManager, functionRepository, factory);
            return olapSchema;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OlapSchema doCreate(OlapEngineRequestContext requestContext, OlapBuilderConnectionPool connectionPool, OlapProperties properties, IOlapEngineLoadSchemaParams params, OlapBuilderErrorManager errorManager, OlapFunctionRepository functionRepository, IOlapBuilderSchemaDefFactory factory) {
        IOlapBuilderSchemaDef schemaDef = OlapBuilderSchemaMain.validate(requestContext, params, properties, functionRepository, errorManager, connectionPool, factory);
        try {
            OlapSchema olapSchema = OlapBuilderSchemaMain.doCreateX(requestContext, connectionPool, params, errorManager, functionRepository, factory, schemaDef);
            return olapSchema;
        }
        finally {
            OlapBuilderSchemaMain.removeAllListeners(schemaDef);
        }
    }

    private static OlapSchema doCreateX(OlapEngineRequestContext requestContext, OlapBuilderConnectionPool connectionPool, IOlapEngineLoadSchemaParams params, OlapBuilderErrorManager errorManager, OlapFunctionRepository functionRepository, IOlapBuilderSchemaDefFactory factory, IOlapBuilderSchemaDef schemaDef) {
        OlapSchemaInformation information = requestContext.getLoadingSchemaInformation();
        if (information == null) {
            information = new OlapSchemaInformation(requestContext.getRequestClientUUID(), factory.getSchemaGroup(), factory.getSchemaName(), factory.getXmlFile(), factory, factory.incrementalLoadActive(), params.getOfflineSnapshot());
        }
        OlapSchemaLocalization localization = schemaDef.getLocalization().isActivated() ? new OlapDefaultSchemaLocalization(schemaDef.getSchemaLocalizationFallbackLocale()) : new OlapEmptySchemaLocalization();
        OlapSchemaColors colors = schemaDef.getColors().isActivated() ? new OlapDefaultSchemaColors() : new OlapEmptySchemaColors();
        OlapProperties properties = requestContext.getOlapEngineProperties();
        IncrLoadInstanceManager manager = IncrLoadInstanceManager.setup(requestContext, factory);
        final OlapSchema schema = new OlapSchema(requestContext.getApplicationContext(), properties, manager, information, factory, functionRepository, localization, colors);
        if (errorManager.hasErrors()) {
            return schema;
        }
        OlapBuilderContext context = new OlapBuilderContext(requestContext, params, OlapBuilderContextMode.FULL_LOAD, IncrLoadPhase.FULL_LOAD, schema);
        requestContext.setBuilderContext(context);
        boolean succeeded = false;
        try {
            OlapEngineMdxScriptExecutionInfo scriptPhaseII;
            long startMS = OlapBuilderSchemaMain.onBuildStarted(context, schema.getName());
            context.onBuildStarted();
            OlapBuilderSchemaMain.removeAllListeners(schemaDef);
            IOlapFactListFactory dimListFactory = OlapBuilderSchemaMain.setupDimensionsColumnListFactory(requestContext, schema);
            IOlapFactListFactory factColumnListFactory = OlapBuilderSchemaMain.setupFactsColumnListFactory(requestContext, schema);
            S_FactBitmapContainerFactory factsBitmapContainerFactory = OlapBuilderSchemaMain.setupFactsBitmapContainerFactory(requestContext, schema);
            final OlapEngineMdxHelper mdxHelper = OlapEngineMdxHelper.create(requestContext);
            OlapBuilderSchemaMain.onAllDataSources(schemaDef, (CdAction<IOlapBuilderDataSource>)((CdAction)ds -> OlapBuilderDataSourceHelper.assertUsage(context.isAllDataSourcesLicensed(), ds.getClass(), ds.getName())));
            OlapBuilderSchemaMain.addDataSourceDefinitions(schemaDef, schema);
            if (schemaDef.getLocalization().isActivated()) {
                OlapBuilderSchemaMain.processLocalization(context, errorManager, connectionPool, schemaDef, schema);
                OlapBuilderSchemaMain.removeAllListeners(schemaDef);
            }
            if (schemaDef.getColors().isActivated()) {
                OlapBuilderSchemaMain.processColors(context, errorManager, connectionPool, schemaDef, schema);
                OlapBuilderSchemaMain.removeAllListeners(schemaDef);
            }
            OlapBuilderSchemaMain.setFactIndexingFlagInLevels(schemaDef);
            List<IOlapBuilderDimensionDef> sortedDimensionDefinitions = OlapBuilderSchemaMain.sortedDimensionDefinitions(schemaDef);
            Map<IOlapBuilderDimensionDef, OlapDimension> dimensions = OlapBuilderSchemaMain.setupDimensionsMap(sortedDimensionDefinitions, schema, dimListFactory);
            for (IOlapBuilderDimensionDef dimensionDef2 : dimensions.keySet()) {
                List hierarchyDefs = dimensionDef2.getHierarchies();
                if (hierarchyDefs == null) continue;
                for (Object hierarchyDef : hierarchyDefs) {
                    int tupleDimensionalityIndex = schema.getNextHierarchyIndexAndIncrement();
                    hierarchyDef.setTupleDimensionalityIndex(tupleDimensionalityIndex);
                }
                List<IOlapBuilderAttributeDef> attributes = dimensionDef2.getAttributes();
                attributes.forEach(attribute -> attribute.setTupleDimensionalityIndex(schema.getNextHierarchyIndexAndIncrement()));
            }
            OlapBuilderSchemaMain.onAllDimensions(schemaDef, (cubeDef_, dimensionDef) -> {
                OlapDimension dimension = OlapBuilderSchemaMain.getDimension(dimensionDef, dimensions);
                BaseDimensionBuilder builder = dimensionDef.createBuilder(context, dimension);
                dimensionDef.getDataView().addListener(builder);
                OlapBuilderSchemaMain.onAllFactsExcludingM2M(schemaDef, new FactProcessor(){

                    @Override
                    public void onFact(@Nullable IOlapBuilderCubeDef cube, IOlapBuilderBaseFactsDef fact) {
                    }
                });
            });
            OlapBuilderSchemaMain.flagDimensionHolowness(schemaDef, dimensions);
            OlapBuilderSchemaMain.setupBridgeTables(context, schemaDef, schema);
            OlapBuilderSchemaMain.setupTableCacheInfo(context, schemaDef);
            OlapBuilderSchemaMain.processDataToBuildDimensions(context, errorManager, schemaDef, connectionPool, dimensions);
            OlapBuilderSchemaMain.setupDynHierarchyIndex(context, dimensions);
            OlapBuilderSchemaMain.setupLevelIndex(context, dimensions);
            OlapBuilderSchemaMain.addSchemaDimensionsToSchema(dimensions, schema);
            long dimensionDoneMS = OlapBuilderSchemaMain.onBuildDimensionDone(context, schema.getName(), startMS);
            OlapBuilderSchemaMain.addPartitioning(context, context.isFactsPartitioningLicensed(), errorManager, schemaDef, schema);
            List<IOlapBuilderCubeDef> sortedCubeDefinitions = OlapBuilderSchemaMain.sortedCubeDefinitions(schemaDef);
            final HashMap<IOlapBuilderCubeDef, OlapRegularCube> cubes = new HashMap<IOlapBuilderCubeDef, OlapRegularCube>();
            for (IOlapBuilderCubeDef cubeDefinition : sortedCubeDefinitions) {
                List<IOlapBuilderBaseFactsDef> cubeFacts = cubeDefinition.getFacts();
                int dimensionIndex = schema.getNextDimensionIndexAndIncrement();
                int tupleDimensionalityIndex = OlapTupleDimensionalityHelper.SINGLE_MEASURE_DIMENSIONALITY_OFF ? schema.getNextHierarchyIndexAndIncrement() : 0;
                OlapMeasuresDimension olapMeasuresDimension = new OlapMeasuresDimension(schema, dimListFactory, dimensionIndex, tupleDimensionalityIndex);
                OlapMeasuresDimensionFactory.createMeasureMembers(olapMeasuresDimension, cubeFacts);
                OlapRegularCube cube2 = new OlapRegularCube(context, factColumnListFactory, factsBitmapContainerFactory, schema, cubeDefinition.getName(), cubeDefinition.getDescription(), cubeFacts, olapMeasuresDimension);
                schema.addCube(cube2);
                cubes.put(cubeDefinition, cube2);
            }
            OlapBuilderSchemaMain.removeAllListeners(schemaDef);
            if (!context.isOfflineWriteOnly()) {
                scriptPhaseII = OlapBuilderSchemaMain.addScriptPhaseI(context, errorManager, schemaDef, mdxHelper, schema);
                schema.registerScriptNativeFunctions();
            } else {
                scriptPhaseII = null;
            }
            if (!context.isOfflineWriteOnly()) {
                OlapBuilderSchemaMain.addPerspectives(context.isPerspectivesLicensed(), context.getNameContext(), context.getEngineContext(), errorManager, schemaDef, schema);
                OlapBuilderSchemaMain.validationDimensionsConsistency(errorManager, schemaDef, cubes, dimensions);
                OlapBuilderSchemaMain.addRollupHierarchyToMeasures(context, requestContext, errorManager, schemaDef, schema, cubes);
            }
            if (errorManager.hasErrors()) {
                OlapSchema cubeDefinition = schema;
                return cubeDefinition;
            }
            context.createClusterContext(factColumnListFactory, factsBitmapContainerFactory);
            OlapBuilderSchemaMain.processManyToManyAndBridges(context, schemaDef, connectionPool);
            long many2ManyDoneMS = OlapBuilderSchemaMain.onBuildMany2ManyDone(context, schema.getName(), startMS, dimensionDoneMS);
            OlapBuilderSchemaMain.removeAllListeners(schemaDef);
            OlapLoggers.BUILDER.info((Object)"[facts] creating facts builders");
            context.onFactsProcessingStarted();
            OlapSchemaFullLoadStats stats = context.getFullLoadStats();
            if (stats != null) {
                stats.onFactsProcessingStarted();
            }
            OlapBuilderSchemaMain.onAllFactsExcludingM2M(schemaDef, (cube, fact) -> {
                OlapRegularCube cube_ = (OlapRegularCube)cubes.get(cube);
                OlapLoggers.BUILDER.debug((Object)("[facts] creating facts builder for cube [" + cube_.getNameX() + "]"));
                IOlapBuilderTableListener factBuilder = fact.createFactBuilder(context, cube_);
                fact.getDataView().addListener(factBuilder);
            });
            OlapLoggers.BUILDER.info((Object)"[facts] creating facts builders completed");
            if (errorManager.hasErrors()) {
                OlapSchema tupleDimensionalityIndex = schema;
                return tupleDimensionalityIndex;
            }
            OlapBuilderSchemaMain.processFacts(context, schemaDef, schema, connectionPool, null);
            OlapLoggers.BUILDER.info((Object)"[facts] completed: notifications");
            if (stats != null) {
                stats.onFactsProcessingCompleted(context, schema);
                schema.setFullLoadStats(stats);
            }
            for (OlapCube olapCube : schema.getCubes()) {
                OlapFactCubeManager cubeFactManager = olapCube.getCubeFactManager();
                for (OlapFactMeasureGroupBaseManager factBaseManager : cubeFactManager.getFactManagers()) {
                    context.onFactsProcessingCompleted(factBaseManager);
                }
            }
            IncrLoadSavePoints incrementalLoad = schema.getIncrementalLoad();
            if (incrementalLoad != null) {
                OlapLoggers.BUILDER.info((Object)"[facts] completed: incr-load");
                ArrayList<IOlapBuilderDataTableDef> arrayList = new ArrayList<IOlapBuilderDataTableDef>();
                OlapBuilderSchemaMain.onAllDataTables(schemaDef, (CdAction<IOlapBuilderDataTableDef>)((CdAction)table -> {
                    if (table.getIncrementalLoadStrategy() == OlapIncrementalLoadStrategy.INCREMENTAL_TRIGGER && !incrementalLoad.handlesTable((IOlapBuilderDataTableDef)table)) {
                        table.addListener(new OlapBuilderNopDataTableListener());
                        arrayList.add((IOlapBuilderDataTableDef)table);
                    }
                }));
                OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy = OlapThreadPoolExecutorTaskSchedulingPolicy.POST_ORDER;
                OlapBuilderTableProcessingHelper.processTables(context, connectionPool, processingSchedulingPolicy, arrayList);
            }
            if (errorManager.hasErrors()) {
                OlapSchema olapSchema = schema;
                return olapSchema;
            }
            OlapLoggers.BUILDER.info((Object)"[facts] completed: activating the schema");
            context.activateSchemaCluster();
            if (scriptPhaseII != null) {
                OlapLoggers.BUILDER.info((Object)"[facts] completed: script (II)");
                OlapBuilderSchemaMain.addScriptsPhaseII(context, errorManager, schemaDef, mdxHelper, schema, scriptPhaseII);
            }
            OlapLoggers.BUILDER.info((Object)"[facts] completed: cell properties");
            OlapBuilderSchemaMain.onAllCubes(schemaDef, new CdAction<IOlapBuilderCubeDef>(){

                public void apply(IOlapBuilderCubeDef cubeDefinition) {
                    OlapRegularCube cube = (OlapRegularCube)cubes.get(cubeDefinition);
                    OlapMeasuresDimension measures = cube.getMeasuresDimension();
                    for (IOlapBuilderBaseFactsDef factsDef : cubeDefinition.getFacts()) {
                        List<IOlapBuilderMeasureDef> measureDefinitions = factsDef.getMeasures();
                        for (IOlapBuilderMeasureDef measureDefinition : measureDefinitions) {
                            String cellPropertiesDefinition = measureDefinition.getCellProperties();
                            if (cellPropertiesDefinition == null || cellPropertiesDefinition.trim().isEmpty()) continue;
                            try {
                                OlapCellProperties cellProperties = mdxHelper.createMeasureCellPropertiesForBuilder(schema, measureDefinition.getName(), cellPropertiesDefinition);
                                measures.setCellProperties(nameContext, measureDefinition.getName(), cellProperties);
                            }
                            catch (CdMdxException ex) {
                                throw new OlapBuilderErrorException(OlapBuilderErrorCode.CUBE_FACT_MEASURE_CELL_PROPERTIES_MDX_ERROR, new Serializable[]{measureDefinition.getName(), ex.getError()});
                            }
                        }
                    }
                    OlapCubeCalculatedMemberManager cmManager = cube.getCalcMemberManager();
                    cmManager.setupUserMeasureCellProperties();
                }
            });
            OlapBuilderSchemaMain.setLastDataUpdatedTime(schema);
            long l = OlapBuilderSchemaMain.onBuildFactsDone(context, schema.getName(), startMS, dimensionDoneMS, many2ManyDoneMS);
            OlapSchemaTimingStats timingStats = OlapBuilderSchemaMain.onBuildDone(context, schema.getName(), startMS, dimensionDoneMS, many2ManyDoneMS, l);
            schema.setTimingStats(timingStats);
            OlapLoggers.BUILDER.info((Object)"[facts] completed: done");
            context.onSchemaProcessingCompleted();
            OlapLoggers.BUILDER.info((Object)"[facts] completed: succeeded");
            succeeded = true;
            OlapSchema olapSchema = schema;
            return olapSchema;
        }
        catch (RuntimeException ex) {
            context.onSchemaProcessingOnErrorCleanup();
            throw ex;
        }
        finally {
            context.onSchemaProcessingDone(succeeded);
        }
    }

    private static void flagDimensionHolowness(IOlapBuilderSchemaDef schemaDef, Map<IOlapBuilderDimensionDef, OlapDimension> dimensions) {
        OlapBuilderSchemaMain.onAllFactsExcludingM2M(schemaDef, (cube, fact) -> {
            Map<IOlapBuilderDimensionDef, IOlapBuilderDataViewLinksDef> links = fact.getDimensionMap();
            links.forEach((key, value) -> {
                if (value.getType() != OlapBuilderDataViewLinksType.LAST_LEVEL) {
                    ((OlapDimension)dimensions.get(key)).setCanNotDoHollow();
                }
            });
        });
    }

    private static void setupBridgeTables(OlapBuilderContext context, IOlapBuilderSchemaDef schemaDef, OlapSchema schema) {
        OlapBuilderSchemaMain.onAllFactsLinksExcludingM2M(schemaDef, (cube, fact, link) -> {
            OlapBridgeDef bridge = link.buildBridge();
            schema.setupBridges(s -> OlapBuilderSchemaMain.solveTableOrViewDef(schemaDef, s).getName(), link, bridge);
        });
    }

    private static void onAllFactsLinksExcludingM2M(IOlapBuilderSchemaDef schema, FactLinkProcessor processor) {
        OlapBuilderSchemaMain.onAllFactsExcludingM2M(schema, (cube, fact) -> {
            Map<IOlapBuilderDimensionDef, IOlapBuilderDataViewLinksDef> map = fact.getDimensionMap();
            map.forEach((dim, link) -> processor.onLink(cube, fact, (IOlapBuilderDataViewLinksDef)link));
        });
    }

    private static void setupDynHierarchyIndex(OlapBuilderContext context, Map<IOlapBuilderDimensionDef, OlapDimension> dimensions) {
        ArrayList<OlapDimension> sortedDimensions = new ArrayList<OlapDimension>(dimensions.values());
        sortedDimensions.sort(Comparator.comparingInt(OlapDimension::getDimensionalityIndex));
        for (OlapDimension dimension : sortedDimensions) {
            ArrayList<OlapHierarchy> sortedHierarchies = new ArrayList<OlapHierarchy>(dimension.getHierarchies());
            sortedHierarchies.sort(Comparator.comparing(OlapHierarchy::getNameX));
            for (OlapHierarchy sortedHierarchy : sortedHierarchies) {
                int index = sortedHierarchy.getTupleDimensionalityIndex();
                if (index == -2) {
                    OlapSchema schema = context.getSchema();
                    int nextIndex = schema.getNextHierarchyIndexAndIncrement();
                    sortedHierarchy.resetTupleDimensionalityIndexForDynamicHierarchy(nextIndex);
                    continue;
                }
                if (index != -1) continue;
                throw new RuntimeException("internal error : missing index for hierarchy " + sortedHierarchy.getUniqueName(OlapNameContext.DEFAULT_VALUES));
            }
        }
    }

    private static void setupLevelIndex(OlapBuilderContext context, Map<IOlapBuilderDimensionDef, OlapDimension> dimensions) {
        ArrayList<OlapDimension> sortedDimensions = new ArrayList<OlapDimension>(dimensions.values());
        sortedDimensions.sort(Comparator.comparingInt(OlapDimension::getDimensionalityIndex));
        for (OlapDimension dimension : sortedDimensions) {
            ArrayList<OlapHierarchy> sortedHierarchies = new ArrayList<OlapHierarchy>(dimension.getHierarchies());
            sortedHierarchies.sort(Comparator.comparingInt(OlapHierarchy::getTupleDimensionalityIndex));
            for (OlapHierarchy sortedHierarchy : sortedHierarchies) {
                List<OlapLevel> levels = sortedHierarchy.getLevels();
                for (OlapLevel level : levels) {
                    OlapSchema schema = context.getSchema();
                    int index = schema.getNextLevelIndexAndIncrement();
                    level.setUniqueIndex(index);
                }
            }
        }
    }

    private static void setupTableCacheInfo(OlapBuilderContext context, IOlapBuilderSchemaDef schemaDef) {
        if (context.isRestoring() || context.isOfflineReadActive()) {
            return;
        }
        if (!schemaDef.isCacheTable()) {
            return;
        }
        Logger logger = context.getLoggers().builder();
        CdSetList dimTables = new CdSetList();
        OlapBuilderSchemaMain.onAllDimensions(schemaDef, (cube, dimensionDef) -> {
            IOlapBuilderTabularDataDef tabularData = dimensionDef.getDataView();
            dimTables.addAll(tabularData.getUnderlyingTables());
        });
        if (logger.isDebugEnabled()) {
            for (Object dimTable : dimTables) {
                logger.debug((Object)("[table-cache] dims   : " + dimTable.getName()));
            }
        }
        CdSetList bridgeTables = new CdSetList();
        OlapBuilderSchemaMain.onAllBridgeResolvers(context.getSchema(), bridge -> bridge.getSingleBridgeDefs().forEach(bridgeS -> {
            String tableId = bridgeS.getTableId();
            IOlapBuilderTabularDataDef table = OlapBuilderSchemaMain.solveTableOrViewDef(schemaDef, tableId);
            bridgeTables.addAll(table.getUnderlyingTables());
        }));
        if (logger.isDebugEnabled()) {
            for (Object bridgesTable : bridgeTables) {
                logger.debug((Object)("[table-cache] bridge : " + bridgesTable.getName()));
            }
        }
        CdSetList factTables = new CdSetList();
        OlapBuilderSchemaMain.onAllFactsExcludingM2M(schemaDef, (cube, fact) -> {
            IOlapBuilderTabularDataDef tabularData = fact.getDataView();
            factTables.addAll(tabularData.getUnderlyingTables());
        });
        if (logger.isDebugEnabled()) {
            for (Object factTable : factTables) {
                logger.debug((Object)("[table-cache] facts  : " + factTable.getName()));
            }
        }
        CdSetList cachedTables = new CdSetList();
        for (IOlapBuilderDataTableDef bridgeTable : bridgeTables) {
            if (!dimTables.contains((Object)bridgeTable)) continue;
            OlapBuilderSchemaMain.addTableToCachedTables((CdSetList<IOlapBuilderDataTableDef>)cachedTables, bridgeTable);
        }
        for (IOlapBuilderDataTableDef factTable : factTables) {
            if (!dimTables.contains((Object)factTable) && !bridgeTables.contains((Object)factTable)) continue;
            OlapBuilderSchemaMain.addTableToCachedTables((CdSetList<IOlapBuilderDataTableDef>)cachedTables, factTable);
        }
        for (IOlapBuilderDataTableDef cachedTable : cachedTables) {
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("[table-cache] cached : " + cachedTable.getName()));
        }
        OlapBuilderCacheTableHelper helper = context.getCacheTableHelper();
        helper.setupTableCache((CdSetList<IOlapBuilderDataTableDef>)cachedTables);
    }

    private static void addTableToCachedTables(CdSetList<IOlapBuilderDataTableDef> cachedTables, IOlapBuilderDataTableDef table) {
        IOlapBuilderDataSource owner = table.getDataSource();
        if (owner.acceptCachedTable()) {
            cachedTables.add((Object)table);
        }
    }

    private static long onBuildStarted(OlapBuilderContext context, String schema) {
        long now = System.currentTimeMillis();
        Logger logger = context.getLoggers().builder();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[load] schema [" + schema + "] load started"));
        }
        return now;
    }

    private static long onBuildDimensionDone(OlapBuilderContext context, String schema, long startMS) {
        long now = System.currentTimeMillis();
        Logger logger = context.getLoggers().builder();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[load] schema [" + schema + "] load dimension done : " + CdTimeUtils.formatMillis((long)(now - startMS))));
        }
        return now;
    }

    private static long onBuildMany2ManyDone(OlapBuilderContext context, String schema, long startMS, long dimensionDoneMS) {
        long now = System.currentTimeMillis();
        Logger logger = context.getLoggers().builder();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[load] schema [" + schema + "] load many-2-many done : " + CdTimeUtils.formatMillis((long)(now - dimensionDoneMS))));
        }
        return now;
    }

    private static long onBuildFactsDone(OlapBuilderContext context, String schema, long startMS, long dimensionDoneMS, long many2ManyDoneMS) {
        long now = System.currentTimeMillis();
        Logger logger = context.getLoggers().builder();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[load] schema [" + schema + "] load facts done : " + CdTimeUtils.formatMillis((long)(now - many2ManyDoneMS))));
        }
        return now;
    }

    private static OlapSchemaTimingStats onBuildDone(OlapBuilderContext context, String schema, long startMS, long dimensionDoneMS, long many2ManyDoneMS, long endMS) {
        long dimensionMS = dimensionDoneMS - startMS;
        long many2manyMS = many2ManyDoneMS - dimensionDoneMS;
        long factsMS = endMS - many2ManyDoneMS;
        long totalMS = endMS - startMS;
        Logger logger = context.getLoggers().builder();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[load] schema [" + schema + "] done : [ dim : " + CdTimeUtils.formatMillis((long)dimensionMS) + " ] [ m-2-m : " + CdTimeUtils.formatMillis((long)many2manyMS) + " ] [ facts : " + CdTimeUtils.formatMillis((long)factsMS) + " ] [ total : " + CdTimeUtils.formatMillis((long)totalMS) + " ] "));
        }
        return new OlapSchemaTimingStats(dimensionMS, many2manyMS, factsMS, totalMS);
    }

    private static void setFactIndexingFlagInLevels(IOlapBuilderSchemaDef schemaDef) {
        OlapBuilderSchemaMain.onAllDimensions(schemaDef, (cube, dimension) -> {
            for (IOlapBuilderHierarchyLevelDef levelDef : dimension.getDefaultHierarchy().getLevels()) {
                levelDef.setIsFactIndexing(false);
            }
        });
        OlapBuilderSchemaMain.onAllFactsExcludingM2M(schemaDef, (cube, fact) -> {
            Set<Map.Entry<IOlapBuilderDimensionDef, IOlapBuilderDataViewLinksDef>> keyValues = fact.getDimensionMap().entrySet();
            for (Map.Entry<IOlapBuilderDimensionDef, IOlapBuilderDataViewLinksDef> keyValue : keyValues) {
                IOlapBuilderDimensionDef dimensionDef = keyValue.getKey();
                IOlapBuilderHierarchyLevelDef indexingLevel = OlapBuilderBaseFactBuilder.getIndexingFactLevel(dimensionDef.getDefaultHierarchy(), keyValue.getValue());
                if (indexingLevel == null) continue;
                indexingLevel.setIsFactIndexing(true);
            }
        });
    }

    private static void processLocalization(OlapBuilderContext context, OlapBuilderErrorManager errorManager, OlapBuilderConnectionPool connectionPool, IOlapBuilderSchemaDef schemaDef, OlapSchema schema) {
        IOlapBuilderLocalizationDef localizationDef = schemaDef.getLocalization();
        IOlapBuilderTabularDataDef view = localizationDef.getDataView();
        if (view == null) {
            return;
        }
        OlapSchemaLocalization localization = schema.getLocalization();
        OlapBuilderLocalizationBuilder builder = new OlapBuilderLocalizationBuilder(localization);
        view.addListener(builder);
        OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy = OlapThreadPoolExecutorTaskSchedulingPolicy.POST_ORDER;
        CdSetList<IOlapBuilderDataTableDef> tables = view.getUnderlyingTables();
        OlapBuilderTableProcessingHelper.processTables(context, connectionPool, processingSchedulingPolicy, tables);
    }

    private static void processColors(OlapBuilderContext context, OlapBuilderErrorManager errorManager, OlapBuilderConnectionPool connectionPool, IOlapBuilderSchemaDef schemaDef, OlapSchema schema) {
        IOlapBuilderColorsDef colorsDef = schemaDef.getColors();
        IOlapBuilderTabularDataDef view = colorsDef.getDataView();
        if (view == null) {
            return;
        }
        OlapSchemaColors colors = schema.getColors();
        OlapBuilderColorsBuilder builder = new OlapBuilderColorsBuilder(colors);
        view.addListener(builder);
        OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy = OlapThreadPoolExecutorTaskSchedulingPolicy.POST_ORDER;
        CdSetList<IOlapBuilderDataTableDef> tables = view.getUnderlyingTables();
        OlapBuilderTableProcessingHelper.processTables(context, connectionPool, processingSchedulingPolicy, tables);
    }

    public static void addPartitioning(OlapBuilderContext context, boolean factsPartitioningLicensed, OlapBuilderErrorManager errorManager, IOlapBuilderSchemaDef schemaDef, final OlapSchema schema) {
        if (schemaDef.useFactPartitioning() && !factsPartitioningLicensed) {
            errorManager.addError(OlapBuilderErrorCode.FACT_PARTITION_NOT_LICENSED, new Serializable[0]);
            return;
        }
        if (schemaDef.useFactPartitioning()) {
            OlapBuilderSchemaMain.onAllFactsExcludingM2M(schemaDef, new FactProcessor(){

                @Override
                public void onFact(IOlapBuilderCubeDef cube, IOlapBuilderBaseFactsDef fact) {
                    String levelName;
                    OlapBuilderFacts factDef = (OlapBuilderFacts)fact;
                    OlapPartitioningType partitioningType = factDef.getPartitioningType();
                    if (partitioningType == OlapPartitioningType.OLAP_LEVEL_DEFINED) {
                        String levelName2 = factDef.getPartitioningLevelName();
                        this.setPartitioningLevel(factDef, levelName2);
                    } else if (partitioningType == OlapPartitioningType.DATA_TABLE_DEFINED && CdStringUtils.isNotNullAndNotBlank((String)(levelName = factDef.getPartitioningLevelName()))) {
                        this.setPartitioningLevel(factDef, levelName);
                    }
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                private void setPartitioningLevel(OlapBuilderFacts factDef, String levelName) {
                    OlapEntityIdentifier identifier = MdxParserIdentifierHelper.parseIdentifier(levelName, "facts partitioning level");
                    if (identifier == null) throw new OlapBuilderErrorException(OlapBuilderErrorCode.FACT_PARTITION_LEVEL_NAME_ERROR, new Serializable[]{levelName});
                    List<OlapDimension> dimensions = schema.getDimensions();
                    OlapNonScalarEntity partitionLevel = OlapCube.lookupEntityByMdxIdentifier(nameContext, schema.getFullControlPermissions(), null, null, dimensions, dimensions, identifier);
                    if (!(partitionLevel instanceof OlapLevel)) throw new OlapBuilderErrorException(OlapBuilderErrorCode.FACT_PARTITION_LEVEL_NAME_MISMATCH, new Serializable[]{levelName, partitionLevel.getFriendlyTypeName()});
                    OlapLevel level = (OlapLevel)partitionLevel;
                    if (!level.getHierarchy().isBase()) {
                        throw new OlapBuilderErrorException(OlapBuilderErrorCode.FACT_PARTITION_LEVEL_HIERARCHY_MISMATCH, new Serializable[]{levelName});
                    }
                    factDef.setPartitioningLevel(level);
                }
            });
        }
    }

    public static IOlapFactListFactory setupDimensionsColumnListFactory(OlapEngineRequestContext requestContext, OlapSchema schema) {
        OlapProperties properties = requestContext.getOlapEngineProperties();
        int bits = properties.getDimMemBufferSize();
        return new OlapFactPaginatedListFactory(bits);
    }

    public static IOlapFactListFactory setupFactsColumnListFactory(OlapEngineRequestContext requestContext, OlapSchema schema) {
        OlapProperties properties = requestContext.getOlapEngineProperties();
        int memoryBits = properties.getFactMemBufferSize();
        OlapFactPaginatedListFactory memory = new OlapFactPaginatedListFactory(memoryBits);
        if (schema.isFactsInFiles() && requestContext.isMmapFactsLicensed()) {
            return OlapBuilderSchemaMain.setupFactsColumnMmapListFactory(requestContext, schema, memory);
        }
        return memory;
    }

    private static IOlapFactListFactory setupFactsColumnMmapListFactory(OlapEngineRequestContext requestContext, OlapSchema schema, OlapFactPaginatedListFactory fallback) {
        String schemaName = schema.getName();
        OlapEngineApplicationContext applicationContext = requestContext.getApplicationContext();
        File mmapDirectory = applicationContext.createFactsColumnDirectory(requestContext.asRuntimeContext(), schemaName);
        OlapSchemaInformation information = schema.getInformation();
        if (information != null) {
            OlapRuntimeContext runtimeContext = requestContext.asRuntimeContext();
            OlapDirectoriesResolved directories = runtimeContext.getDirectoriesResolved();
            File schemaDataDirectory = directories.getSchemaDataDirectory();
            File mmapDirectoryPathForStats = CdVFileSystem.toRelativePath((File)schemaDataDirectory, (File)mmapDirectory);
            information.setMmapDirectory(mmapDirectory, mmapDirectoryPathForStats.getPath());
        }
        if (OlapLoggers.FACTS.isDebugEnabled()) {
            OlapLoggers.FACTS.debug((Object)("[mmap] schema [" + schemaName + "] facts mmap directory created [" + mmapDirectory.getAbsolutePath() + "]"));
        }
        OlapProperties properties = requestContext.getOlapEngineProperties();
        int fileBits = properties.getFactFileSize();
        int bufferBits = properties.getFactFileBufferSize();
        CdVFileSystem vfs = requestContext.asRuntimeContext().getVfs();
        return new OlapFactMemMapListFactory(vfs, fallback, fileBits, bufferBits, mmapDirectory);
    }

    public static S_FactBitmapContainerFactory setupFactsBitmapContainerFactory(OlapEngineRequestContext requestContext, OlapSchema schema) {
        if (schema.isIndexInFiles() && requestContext.isMmapFactsLicensed()) {
            return new S_FactRoaringBitmapFileContainerFactory(requestContext.getApplicationContext());
        }
        return new S_FactRoaringBitmapRamContainerFactory(requestContext.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPerspectives(boolean isPerspectivesLicensed, OlapNameContext nameContext, OlapEngineRequestContext engineRequestContext, OlapBuilderErrorManager errorManager, IOlapBuilderSchemaDef schemaDef, OlapSchema schema) {
        List<IOlapBuilderPerspectiveDef> perspectives = schemaDef.getPerspectives();
        if (perspectives != null) {
            errorManager.pushContext(schemaDef);
            try {
                for (IOlapBuilderPerspectiveDef perspectiveDef : perspectives) {
                    errorManager.pushContext(perspectiveDef);
                    if (!isPerspectivesLicensed) {
                        errorManager.addError(OlapBuilderErrorCode.PERSPECTIVE_NOT_LICENSED, new Serializable[0]);
                        break;
                    }
                    try {
                        OlapPerspectiveBuilder perspectiveBuilder = OlapPerspectiveParser.createPerspectiveBuilder(nameContext, engineRequestContext, schema, perspectiveDef);
                        OlapPerspective perspective = perspectiveBuilder.build();
                        schema.addPerspective(perspective);
                    }
                    catch (CdMdxScannerException | OlapException | MdxParserException ex) {
                        errorManager.addError(OlapBuilderPerspective.DEFINITION, ((ICdException)ex).getError().getLocation(), OlapBuilderErrorCode.PERSPECTIVE_DEFINITION_PARSER_ERROR, new Serializable[]{perspectiveDef.getName(), ((ICdException)ex).getError()});
                    }
                    finally {
                        errorManager.popContext();
                    }
                }
            }
            finally {
                errorManager.popContext();
            }
        }
    }

    private static void addDataSourceDefinitions(IOlapBuilderSchemaDef schemaDef, OlapSchema schema) {
        OlapBuilderSchemaMain.onAllDataSources(schemaDef, (CdAction<IOlapBuilderDataSource>)((CdAction)dataSource -> {
            if (dataSource instanceof OlapBuilderBaseDataSource) {
                schema.addDataSource((OlapBuilderBaseDataSource)dataSource);
            }
        }));
    }

    private static OlapDimension getDimension(IOlapBuilderDimensionDef dimensionDef, Map<IOlapBuilderDimensionDef, OlapDimension> allSchemaDimensions) {
        return allSchemaDimensions.get(dimensionDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setDefaultMember(OlapBuilderContext context, OlapBuilderErrorManager errorManager, IOlapBuilderDimensionDef dimensionDef, Map<IOlapBuilderDimensionDef, OlapDimension> allSchemaDimensions) {
        errorManager.pushContext(dimensionDef);
        try {
            OlapDimension dimension = OlapBuilderSchemaMain.getDimension(dimensionDef, allSchemaDimensions);
            OlapRoleSchemaPermissions permissions = context.getSchema().getFullControlPermissions();
            List hierarchies = dimensionDef.getHierarchies();
            for (IOlapBuilderHierarchyDef hierarchyDef : hierarchies) {
                String defaultMemberName = hierarchyDef.getDefaultMemberName();
                if (defaultMemberName != null && !defaultMemberName.isEmpty()) {
                    OlapHierarchy olapHierarchy = dimension.lookupHierarchyByName(nameContext, hierarchyDef.getName());
                    if (olapHierarchy == null) {
                        context.getLoggers().builder().error((Object)("Dimension : " + dimension.getUniqueName(nameContext) + ", " + Arrays.toString(dimension.getHierarchies().toArray())));
                        throw new CdShouldNotBeHereProgrammingException("[" + dimension.getName(nameContext) + "], [" + hierarchyDef.getName() + "], [" + defaultMemberName + "]");
                    }
                    try {
                        errorManager.pushContext(hierarchyDef);
                        OlapEntityIdentifier identifier = MdxParserIdentifierHelper.parseIdentifierX(defaultMemberName, "default member");
                        OlapNonScalarEntity defaultMember = olapHierarchy.lookupEntityByMdxIdentifier(nameContext, permissions, identifier);
                        if (defaultMember instanceof OlapMember) {
                            OlapMember olapDefaultMember = (OlapMember)defaultMember;
                            olapHierarchy.setDefaultMember(olapDefaultMember);
                            continue;
                        }
                        if (defaultMember.isMdxNull()) {
                            errorManager.addError(OlapBuilderErrorCode.HIERARCHY_DEFAULT_MEMBER_NOT_FOUND, new Serializable[]{defaultMemberName, olapHierarchy.getUniqueName(nameContext)});
                            continue;
                        }
                        errorManager.addError(OlapBuilderErrorCode.HIERARCHY_DEFAULT_MEMBER_UNEXPECTED_TYPE, new Serializable[]{defaultMemberName, defaultMember.getFriendlyTypeName(), olapHierarchy.getUniqueName(nameContext)});
                        continue;
                    }
                    catch (CdMdxException ex) {
                        errorManager.addError(OlapBuilderErrorCode.HIERARCHY_DEFAULT_MEMBER_PARSE_ERROR, new Serializable[]{defaultMemberName, olapHierarchy.getUniqueName(nameContext), ex.getError()});
                        continue;
                    }
                    finally {
                        errorManager.popContext();
                        continue;
                    }
                }
                OlapHierarchy hierarchy = dimension.lookupHierarchyByName(nameContext, hierarchyDef.getName());
                if (hierarchy == null) continue;
                hierarchy.setInitialDefaultMember();
            }
        }
        finally {
            errorManager.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addUnknownMemberToDimension(OlapBuilderContext context, OlapBuilderErrorManager errorManager, IOlapBuilderDimensionDef dimensionDef, Map<IOlapBuilderDimensionDef, OlapDimension> allSchemaDimensions) {
        errorManager.pushContext(dimensionDef);
        try {
            String unknownMemberName = dimensionDef.getUnknownMemberName();
            if (CdStringUtils.isNotNullAndNotBlank((String)unknownMemberName)) {
                OlapDimension dimension = OlapBuilderSchemaMain.getDimension(dimensionDef, allSchemaDimensions);
                OlapHierarchy baseHierarchy = dimension.getBaseHierarchy();
                boolean createNewMember = !unknownMemberName.startsWith("[") || !unknownMemberName.endsWith("]");
                String lookupName = createNewMember ? unknownMemberName.trim() : unknownMemberName.trim().substring(1, unknownMemberName.length() - 1);
                OlapLevel lastLevel = baseHierarchy.getLastLevel();
                OlapMember existingMember = lastLevel.lookupMemberByName(lookupName);
                if (existingMember == null) {
                    for (OlapLevel level = lastLevel.getPreviousLevel(); level != null && !level.isAll() && (existingMember = level.lookupMemberByName(lookupName)) == null; level = level.getPreviousLevel()) {
                    }
                }
                if (existingMember != null) {
                    dimension.setUnknownMember(existingMember);
                } else {
                    OlapBuilderSchemaMain.createUnknownMember(context, errorManager, lookupName, dimension);
                }
            }
        }
        finally {
            errorManager.popContext();
        }
    }

    private static void createUnknownMember(OlapBuilderContext context, OlapBuilderErrorManager errorManager, String unknownMemberName, OlapDimension dimension) {
        String hierarchyWithoutLevel = dimension.addUnknownMember(context, unknownMemberName);
        if (hierarchyWithoutLevel != null) {
            errorManager.addError(OlapBuilderErrorCode.DIMENSION_UNKNOWN_MEMBER_MISSING_LEVEL, new Serializable[]{unknownMemberName, hierarchyWithoutLevel});
        }
    }

    private static void addRollupHierarchyToMeasures(OlapBuilderContext context, OlapEngineRequestContext requestContext, final OlapBuilderErrorManager errorManager, IOlapBuilderSchemaDef schemaDefinition, OlapSchema schema, final Map<IOlapBuilderCubeDef, OlapRegularCube> cubesByDefinitions) {
        final OlapRoleSchemaPermissions schemaFullControlPermissions = schema.getFullControlPermissions();
        OlapBuilderSchemaMain.onAllMeasures(errorManager, schemaDefinition, new MeasureProcessor(){

            @Override
            public void onMeasure(IOlapBuilderSchemaDef schemaDefinition, IOlapBuilderCubeDef cubeDefinition, IOlapBuilderBaseFactsDef factsDefinition, IOlapBuilderMeasureDef measureDefinition) {
                block8: {
                    OlapCube cube = (OlapCube)cubesByDefinitions.get(cubeDefinition);
                    OlapAggregationType atype = measureDefinition.getAggregationType();
                    String rollupHierarchyName = measureDefinition.getRollupHierarchy();
                    if (atype.isRollupHierarchyRequired()) {
                        OlapMeasureMember measure = cube.lookupMeasureByName(nameContext, measureDefinition.getName());
                        if (measure != null && !CdStringUtils.isNullOrBlank((String)rollupHierarchyName)) {
                            try {
                                OlapEntityIdentifier identifier = MdxParserIdentifierHelper.parseIdentifierX(rollupHierarchyName, "rollup hierarchy (" + measureDefinition.getName() + "/" + atype.getFriendlyName() + ")");
                                OlapNonScalarEntity entity = cube.lookupEntityByMdxIdentifier(nameContext, schemaFullControlPermissions, null, null, identifier);
                                if (entity instanceof OlapHierarchy) {
                                    OlapHierarchy hierarchy = (OlapHierarchy)entity;
                                    measure.setRollupHierarchy(hierarchy);
                                    this.checkUnaryOperator(measure, hierarchy);
                                    break block8;
                                }
                                if (entity.isMdxNull()) {
                                    errorManager.addError(OlapBuilderErrorCode.MEASURE_ROLLUP_HIERARCHY_NOT_FOUND, new Serializable[]{rollupHierarchyName, measureDefinition.getName()});
                                    break block8;
                                }
                                errorManager.addError(OlapBuilderErrorCode.MEASURE_ROLLUP_HIERARCHY_UNEXPECTED_TYPE, new Serializable[]{rollupHierarchyName, measureDefinition.getName(), entity.getFriendlyTypeName()});
                            }
                            catch (CdMdxException ex) {
                                errorManager.addError(OlapBuilderErrorCode.MEASURE_ROLLUP_HIERARCHY_PARSE_ERROR, new Serializable[]{measureDefinition.getName(), rollupHierarchyName, ex.getError()});
                            }
                        } else {
                            OlapHierarchy defaultTimeHierarchy = cube.getDefaultTimeHierarchy(schemaFullControlPermissions);
                            if (defaultTimeHierarchy == null) {
                                errorManager.addError(OlapBuilderErrorCode.MEASURE_ROLLUP_HIERARCHY_DEFAULT_TIME_HIERARCHY_MISSING, new Serializable[]{measureDefinition.getName(), atype.getFriendlyName()});
                            }
                            measure.setRollupHierarchy(defaultTimeHierarchy);
                        }
                    }
                }
            }

            private void checkUnaryOperator(OlapMeasureMember measure, OlapHierarchy hierarchy) {
                if (measure.getHierarchyAggregationType() == OlapAggregationType.UNARY_OPERATOR) {
                    OlapTupleSet<OlapMember> members;
                    OlapMember member;
                    for (OlapLevel level : hierarchy.getLevels()) {
                        for (OlapUserDefinedMemberProperty property : level.getMemberProperties(null)) {
                            if (!"@UO".equals(property.getName())) continue;
                            return;
                        }
                    }
                    if (hierarchy.getMemberCount() == 0) {
                        return;
                    }
                    if (hierarchy.getMemberCount() == 1 && ((member = (members = hierarchy.getMembers())._getSlow(0)) == null || member.isAll())) {
                        return;
                    }
                    errorManager.addError(OlapBuilderErrorCode.MEASURE_ROLLUP_UNARY_OPERATOR_MISSING_PROPERTY, new Serializable[]{hierarchy.getUniqueName(nameContext), measure.getName(nameContext), "@UO"});
                }
            }
        });
    }

    private static IOlapBuilderSchemaDef validate(OlapEngineRequestContext requestContext, IOlapEngineLoadSchemaParams params, OlapProperties properties, OlapFunctionRepository functionRepository, OlapBuilderErrorManager errorManager, OlapBuilderConnectionPool connectionPool, IOlapBuilderSchemaDefFactory factory) {
        OlapEngineApplicationContext applicationContext = requestContext.getApplicationContext();
        OlapEngineComponent olapEngine = applicationContext.getOlapEngineComponent();
        OlapSchemaFunctionRepository schemaFunctionRepository = new OlapSchemaFunctionRepository(functionRepository);
        OlapBuilderValidationContext context = new OlapBuilderValidationContext(requestContext.asRuntimeContext(), params.isRestoreActivated(), params.getOfflineMode(), requestContext.isPerspectivesLicensed(), requestContext.isTablePartitioningLicensed(), requestContext.isFactsPartitioningLicensed(), requestContext.isJavaMdxNativesActivated(), properties, olapEngine.getFunctionRepository(), schemaFunctionRepository.createSnapshot(), requestContext.getOlapEngineComponent().getModuleMethodsRepository(), connectionPool, errorManager);
        return OlapBuilderSchemaMain.validate(context, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOlapBuilderSchemaDef validate(OlapBuilderValidationContext context, IOlapBuilderSchemaDefFactory factory) {
        IOlapBuilderSchemaDef schemaDef = factory.createSchemaDefinition(context.getConnectionPool(), (OlapBuilderErrorManager)context.getErrorManager());
        context.setSchemaDef(schemaDef);
        try {
            OlapBuilderSchemaMain.setUpXMLFilesToDataSources(schemaDef, factory);
            OlapBuilderSchemaMain.removeAllListeners(schemaDef);
            OlapBuilderSchemaValidator validator = new OlapBuilderSchemaValidator(OlapLoggers.BUILDER);
            validator.validate(context, null, schemaDef);
            IOlapBuilderSchemaDef iOlapBuilderSchemaDef = schemaDef;
            return iOlapBuilderSchemaDef;
        }
        finally {
            OlapBuilderSchemaMain.removeAllListeners(schemaDef);
        }
    }

    private static void setUpXMLFilesToDataSources(IOlapBuilderSchemaDef schemaDef, IOlapBuilderSchemaDefFactory schemaDefFactory) {
        File xmlFile = schemaDefFactory.getXmlFile();
        if (xmlFile != null) {
            OlapBuilderSchemaMain.onAllDataSources(schemaDef, (CdAction<IOlapBuilderDataSource>)((CdAction)dataSource -> {
                CdXmlSerializable xmlSerializable;
                if (dataSource instanceof CdXmlSerializable && (xmlSerializable = (CdXmlSerializable)dataSource).getXmlFile() == null) {
                    xmlSerializable.setXmlFile(xmlFile);
                }
            }));
        }
    }

    @Nullable
    private static OlapEngineMdxScriptExecutionInfo addScriptPhaseI(OlapBuilderContext context, OlapBuilderErrorManager errorManager, IOlapBuilderSchemaDef schemaDef, OlapEngineMdxHelper mdxHelper, OlapSchema schema) {
        context.onProgressPhase("scriptStartedPhaseI", new Serializable[0]);
        OlapEngineMdxScriptExecutionInfo[] phaseII = new OlapEngineMdxScriptExecutionInfo[1];
        IOlapBuilderScriptDef script = schemaDef.getScript();
        OlapBuilderErrorManagerHelper.performValidation(errorManager, () -> {
            try {
                OlapResScriptDataSet result;
                String scriptName = schema.getName() + "." + script.getName();
                String mdx = script.getContent();
                OlapEngineMdxScriptCompilationInfo compilationInfo = mdxHelper.compileMdxScript(schema.getName(), scriptName, mdx, scriptName);
                OlapResScriptDataSet compilationResult = compilationInfo.getResult();
                if (compilationResult != null) {
                    result = compilationResult;
                } else {
                    OlapEngineMdxScriptExecutionInfo executionInfo = compilationInfo.asExecutionInfo();
                    OlapEngineMdxScriptExecutionInfo phaseI = executionInfo.asBuilderPhaseI();
                    phaseII[0] = executionInfo.asBuilderPhaseII();
                    result = mdxHelper.executeMdxScriptForBuilder(phaseI, schema, true);
                }
                if (result.isError()) {
                    ICdException error = result.getError();
                    OlapBuilderError builderError = new OlapBuilderError(error.getError(), OlapBuilderErrorCode.SCHEMA_SCRIPT_EMBEDDED_MDX_ERROR, new Serializable[0]);
                    errorManager.addErrorWithContextual(script, builderError);
                } else {
                    List<OlapResStatementDataSet> statementResults = result.getStatementResults();
                    for (OlapResStatementDataSet statementResult : statementResults) {
                        if (!statementResult.isError()) continue;
                        ICdException error = statementResult.getException();
                        OlapBuilderError builderError = new OlapBuilderError(error.getError(), OlapBuilderErrorCode.SCHEMA_SCRIPT_EMBEDDED_MDX_ERROR, new Serializable[0]);
                        errorManager.addErrorWithContextual(script, builderError);
                    }
                }
            }
            catch (OlapEvaluationException ex) {
                OlapBuilderError builderError = new OlapBuilderError(ex.getError(), OlapBuilderErrorCode.SCHEMA_SCRIPT_EMBEDDED_MDX_ERROR, new Serializable[0]);
                errorManager.addErrorWithContextual(script, builderError);
            }
            finally {
                context.onProgressPhase("scriptCompletedPhaseI", new Serializable[0]);
            }
        }, script);
        return phaseII[0];
    }

    private static void addScriptsPhaseII(OlapBuilderContext context, OlapBuilderErrorManager errorManager, IOlapBuilderSchemaDef schemaDef, OlapEngineMdxHelper mdxHelper, OlapSchema schema, OlapEngineMdxScriptExecutionInfo scriptPhaseII) {
        context.onProgressPhase("scriptStartedPhaseII", new Serializable[0]);
        IOlapBuilderScriptDef script = schemaDef.getScript();
        OlapBuilderErrorManagerHelper.performValidation(errorManager, () -> {
            try {
                OlapResScriptDataSet result = mdxHelper.executeMdxScriptForBuilder(scriptPhaseII, schema, false);
                if (result.isError()) {
                    ICdException error = result.getError();
                    OlapBuilderError builderError = new OlapBuilderError(error.getError(), OlapBuilderErrorCode.SCHEMA_SCRIPT_EMBEDDED_MDX_ERROR, new Serializable[0]);
                    errorManager.addErrorWithContextual(script, builderError);
                } else {
                    List<OlapResStatementDataSet> statementResults = result.getStatementResults();
                    for (OlapResStatementDataSet statementResult : statementResults) {
                        if (!statementResult.isError()) continue;
                        ICdException error = statementResult.getException();
                        OlapBuilderError builderError = new OlapBuilderError(error.getError(), OlapBuilderErrorCode.SCHEMA_SCRIPT_EMBEDDED_MDX_ERROR, new Serializable[0]);
                        errorManager.addErrorWithContextual(script, builderError);
                    }
                }
            }
            catch (OlapEvaluationException ex) {
                OlapBuilderError builderError = new OlapBuilderError(ex.getError(), OlapBuilderErrorCode.SCHEMA_SCRIPT_EMBEDDED_MDX_ERROR, new Serializable[0]);
                errorManager.addErrorWithContextual(script, builderError);
            }
            finally {
                context.onProgressPhase("scriptCompletedPhaseII", new Serializable[0]);
            }
        }, script);
    }

    private static void validationDimensionsConsistency(OlapBuilderErrorManager errorManager, IOlapBuilderSchemaDef schemaDef, Map<IOlapBuilderCubeDef, OlapRegularCube> cubeMap, Map<IOlapBuilderDimensionDef, OlapDimension> allSchemaDimensions) {
        OlapBuilderSchemaMain.onAllCubes(schemaDef, (CdAction<IOlapBuilderCubeDef>)((CdAction)cubeDefinition -> {
            OlapRegularCube cube = (OlapRegularCube)cubeMap.get(cubeDefinition);
            for (OlapDimension olapDimension : cube.getDimensions()) {
            }
        }));
        for (OlapDimension dimension : allSchemaDimensions.values()) {
            dimension.validateConsistency(errorManager);
        }
    }

    private static void addSchemaDimensionsToSchema(Map<IOlapBuilderDimensionDef, OlapDimension> allSchemaDimensions, OlapSchema schema) {
        for (OlapDimension dimension : allSchemaDimensions.values()) {
            schema.addDimension(dimension);
        }
    }

    private static List<IOlapBuilderDimensionDef> sortedDimensionDefinitions(IOlapBuilderSchemaDef schemaDef) {
        ArrayList<IOlapBuilderDimensionDef> dimensions = new ArrayList<IOlapBuilderDimensionDef>();
        OlapBuilderSchemaMain.onAllDimensions(schemaDef, (cube_, definition) -> dimensions.add(definition));
        return dimensions;
    }

    private static List<IOlapBuilderCubeDef> sortedCubeDefinitions(IOlapBuilderSchemaDef schemaDef) {
        ArrayList<IOlapBuilderCubeDef> cubes = new ArrayList<IOlapBuilderCubeDef>();
        OlapBuilderSchemaMain.onAllCubes(schemaDef, (CdAction<IOlapBuilderCubeDef>)((CdAction)cubes::add));
        return cubes;
    }

    private static Map<IOlapBuilderDimensionDef, OlapDimension> setupDimensionsMap(List<IOlapBuilderDimensionDef> sortedDimensionDefinitions, OlapSchema schema, IOlapFactListFactory listFactory) {
        LinkedHashMap<IOlapBuilderDimensionDef, OlapDimension> allSchemaDimensions = new LinkedHashMap<IOlapBuilderDimensionDef, OlapDimension>();
        OlapDimensionFactory dimFactory = OlapDimensionFactory.getInstance();
        for (IOlapBuilderDimensionDef definition : sortedDimensionDefinitions) {
            int dimensionIndex = schema.getNextDimensionIndexAndIncrement();
            OlapDimension dimension = dimFactory.create(schema, listFactory, definition, dimensionIndex);
            allSchemaDimensions.put(definition, dimension);
        }
        return allSchemaDimensions;
    }

    public static void removeAllListeners(IOlapBuilderSchemaDef schemaDef) {
        OlapBuilderSchemaMain.onAllDataTables(schemaDef, (CdAction<IOlapBuilderDataTableDef>)((CdAction)table -> {
            table.clearAllListeners();
            table.clearAllRowFilters();
        }));
        OlapBuilderSchemaMain.onAllDimensions(schemaDef, (cube, dimension) -> {
            IOlapBuilderTabularDataDef dataView = dimension.getDataView();
            if (dataView != null) {
                dataView.clearAllListeners();
                dataView.clearAllRowFilters();
            }
        });
        OlapBuilderSchemaMain.removeAllViewListeners(schemaDef);
    }

    private static void removeAllViewListeners(IOlapBuilderSchemaDef schemaDef) {
        for (IOlapBuilderDataViewDef viewDef : schemaDef.getViews()) {
            viewDef.clearAllListeners();
            viewDef.clearAllRowFilters();
        }
    }

    public static void solveViewsColumnsBestEffortUI(boolean validationError, IOlapBuilderSchemaDef schemaDef, @Nullable IOlapBuilderDataViewDef requestedView) throws OlapBuilderErrorsException {
        block4: {
            try {
                OlapBuilderSchemaMain.removeAllListeners(schemaDef);
                Set<IOlapBuilderDataViewDef> views = OlapBuilderSchemaMain.getAndCheckViewsForRequestedView(validationError, schemaDef, requestedView);
                if (views.isEmpty()) {
                    return;
                }
                OlapBuilderErrorManager errorManager = new OlapBuilderErrorManager(false);
                OlapBuilderReferenceSolver refSolver = OlapBuilderSchemaMain.createReferenceSolver(errorManager, schemaDef);
                OlapBuilderSchemaMain.doSolveViewsReferences(errorManager, refSolver, views);
                if (validationError && errorManager.hasErrors()) {
                    throw new OlapBuilderErrorsException(errorManager.getErrors());
                }
            }
            catch (RuntimeException ex) {
                OlapLoggers.BUILDER.error((Object)("[view] solveViewsColumnsBestEffortUI() : unexpected error : " + ex.getMessage()), (Throwable)ex);
                if (!validationError) break block4;
                throw ex;
            }
        }
    }

    private static Set<IOlapBuilderDataViewDef> getAndCheckViewsForRequestedView(boolean validationError, IOlapBuilderSchemaDef schemaDef, @Nullable IOlapBuilderDataViewDef requestedView) {
        HashMap<IOlapBuilderDataViewDef, OlapBuilderErrorManager> viewsOnError = new HashMap<IOlapBuilderDataViewDef, OlapBuilderErrorManager>();
        for (IOlapBuilderDataViewDef viewDef : schemaDef.getViews()) {
            OlapBuilderErrorManager errorManager = new OlapBuilderErrorManager(false);
            OlapBuilderReferenceSolver refSolver = OlapBuilderSchemaMain.createReferenceSolver(errorManager, schemaDef);
            viewDef.solveDirectReferences(refSolver);
            if (!errorManager.hasErrors()) continue;
            viewsOnError.put(viewDef, errorManager);
        }
        HashSet<IOlapBuilderDataViewDef> views = new HashSet<IOlapBuilderDataViewDef>();
        if (requestedView == null) {
            views.addAll(schemaDef.getViews());
        } else {
            views.add(requestedView);
            OlapBuilderViewCycleDetector cycleDetector = new OlapBuilderViewCycleDetector();
            OlapBuilderSchemaMain.addAllUnderlyings(cycleDetector, views, requestedView);
        }
        ArrayList errors = new ArrayList();
        for (IOlapBuilderDataViewDef view : views) {
            OlapBuilderErrorManager errorManager = (OlapBuilderErrorManager)viewsOnError.get(view);
            if (errorManager == null) continue;
            errors.addAll(errorManager.getErrors());
        }
        if (!errors.isEmpty()) {
            if (validationError) {
                throw new OlapBuilderErrorsException(errors);
            }
            return Collections.emptySet();
        }
        return views;
    }

    public static void solveViewsReferences(OlapBuilderErrorManager errorManager, OlapBuilderReferenceSolver referenceSolver, IOlapBuilderSchemaDef schemaDef) {
        List<IOlapBuilderDataViewDef> views = schemaDef.getViews();
        OlapBuilderSchemaMain.doSolveViewsReferences(errorManager, referenceSolver, views);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doSolveViewsReferences(OlapBuilderErrorManager errorManager, OlapBuilderReferenceSolver referenceSolver, Collection<IOlapBuilderDataViewDef> views) {
        for (IOlapBuilderDataViewDef iOlapBuilderDataViewDef : views) {
            iOlapBuilderDataViewDef.onReferenceStarted();
        }
        for (IOlapBuilderDataViewDef iOlapBuilderDataViewDef : views) {
            errorManager.pushContext(iOlapBuilderDataViewDef);
            try {
                iOlapBuilderDataViewDef.solveReferences(referenceSolver, new OlapBuilderViewCycleDetector());
            }
            finally {
                errorManager.popContext();
            }
        }
        for (IOlapBuilderDataViewDef iOlapBuilderDataViewDef : views) {
            iOlapBuilderDataViewDef.setupSelectedColumns(errorManager, referenceSolver, new OlapBuilderViewCycleDetector());
        }
        CdSortingGraph graph = new CdSortingGraph();
        for (IOlapBuilderDataViewDef view : views) {
            view.onReferenceSolved(errorManager, (CdSortingGraph<IOlapBuilderTabularDataDef>)graph);
        }
        try {
            Map map = graph.solveOrder();
            map.forEach(IOlapBuilderTabularDataDef::setDepth);
        }
        catch (CdSortingGraph.GraphCycleException graphCycleException) {
            errorManager.addError(OlapBuilderErrorCode.DATA_VIEW_CYCLE, new Serializable[]{"", graphCycleException.getMessage()});
            return;
        }
        for (IOlapBuilderDataViewDef view : views) {
            view.onReferenceSolvedFinished(errorManager);
        }
    }

    private static void addAllUnderlyings(OlapBuilderViewCycleDetector cycleDetector, Set<IOlapBuilderDataViewDef> views, IOlapBuilderDataViewDef view) {
        try {
            cycleDetector.add(view);
        }
        catch (OlapBuilderViewCycleDetector.CycleError error) {
            OlapLoggers.BUILDER.error((Object)("getUnderlyingTables() : cycle in view : " + error.cycle()), (Throwable)error);
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DATA_VIEW_CYCLE, new Serializable[]{view.getName(), error.cycle()});
        }
        for (IOlapBuilderTabularDataDef underlyingTable : view.getDirectUnderlyings()) {
            if (!(underlyingTable instanceof IOlapBuilderDataViewDef)) continue;
            IOlapBuilderDataViewDef underlyingView = (IOlapBuilderDataViewDef)underlyingTable;
            views.add(underlyingView);
            OlapBuilderSchemaMain.addAllUnderlyings(cycleDetector, views, underlyingView);
        }
    }

    public static void solveReferences(final OlapBuilderErrorManager errorManager, IOlapBuilderSchemaDef schemaDef, final OlapBuilderReferenceSolver referenceSolver) {
        IOlapBuilderColorsDef colors;
        OlapBuilderSchemaMain.solveViewsReferences(errorManager, referenceSolver, schemaDef);
        OlapBuilderSchemaMain.onAllPerspectives(schemaDef, perspectiveDef -> perspectiveDef.solveReference(referenceSolver, null));
        OlapBuilderSchemaMain.onAllDimensions(schemaDef, (cube, dimension) -> OlapBuilderErrorManagerHelper.performValidation(errorManager, () -> referenceSolver.solveReference(dimension, null), cube));
        OlapBuilderSchemaMain.onAllFactsExcludingM2M(schemaDef, new FactProcessor(){

            @Override
            public void onFact(IOlapBuilderCubeDef cube, IOlapBuilderBaseFactsDef fact) {
                OlapBuilderErrorManagerHelper.performValidation(errorManager, () -> fact.solveReference(referenceSolver), cube, fact);
            }
        });
        IOlapBuilderLocalizationDef localization = schemaDef.getLocalization();
        if (localization != null) {
            localization.solveReference(referenceSolver, null);
        }
        if ((colors = schemaDef.getColors()) != null) {
            colors.solveReference(referenceSolver, null);
        }
    }

    public static OlapBuilderReferenceSolver createReferenceSolver(OlapBuilderErrorManager errorManager, IOlapBuilderSchemaDef schemaDef) {
        OlapBuilderReferenceSolver referenceSolver = new OlapBuilderReferenceSolver(errorManager);
        OlapBuilderSchemaMain.onAllCubes(schemaDef, (CdAction<IOlapBuilderCubeDef>)((CdAction)referenceSolver::add));
        OlapBuilderSchemaMain.onAllDataSources(schemaDef, (CdAction<IOlapBuilderDataSource>)((CdAction)item -> {
            List tables = item.getTables();
            int size = tables.size();
            for (int ii = 0; ii < size; ++ii) {
                OlapBuilderBaseDataTable table = (OlapBuilderBaseDataTable)tables.get(ii);
                table.setDataSource((IOlapBuilderDataSource)item);
                referenceSolver.add(table);
            }
            List<IOlapBuilderDataViewDef> tViews = item.getTransientViews();
            for (IOlapBuilderTabularDataDef iOlapBuilderTabularDataDef : tViews) {
                referenceSolver.add(iOlapBuilderTabularDataDef);
            }
        }));
        List<IOlapBuilderDataViewDef> pViews = schemaDef.getViews();
        for (IOlapBuilderDataViewDef pView : pViews) {
            referenceSolver.addForColumnsSetup(pView);
        }
        OlapBuilderSchemaMain.onAllDimensions(schemaDef, (cube, dimension) -> referenceSolver.add(dimension));
        return referenceSolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processDataToBuildDimensions(OlapBuilderContext context, OlapBuilderErrorManager errorManager, IOlapBuilderSchemaDef schemaDef, OlapBuilderConnectionPool connectionPool, Map<IOlapBuilderDimensionDef, OlapDimension> defDimensionsMap) {
        CdSetList allTables = new CdSetList();
        HashSet<IOlapBuilderDimensionDef> allDimensions = new HashSet<IOlapBuilderDimensionDef>();
        OlapBuilderSchemaMain.onAllDimensions(schemaDef, (arg_0, arg_1) -> OlapBuilderSchemaMain.lambda$processDataToBuildDimensions$0((List)allTables, allDimensions, arg_0, arg_1));
        context.onProgressPhase("dimensionProcessingStarted", new Serializable[0]);
        context.onProgressEvent("dimensionProcessingStarted", new Serializable[0]);
        try {
            OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy = OlapThreadPoolExecutorTaskSchedulingPolicy.POST_ORDER;
            OlapBuilderTableProcessingHelper.processTables(context, connectionPool, processingSchedulingPolicy, (List<IOlapBuilderDataTableDef>)allTables);
            OlapBuilderSchemaMain.onDimensionFinishLoad(context, errorManager, defDimensionsMap, allDimensions);
            context.onAllDimensionsProcessingCompleted();
        }
        finally {
            context.onProgressPhase("dimensionProcessingDone", new Serializable[0]);
            context.onProgressEvent("dimensionProcessingDone", new Serializable[0]);
        }
        for (IOlapBuilderDataTableDef table : allTables) {
            table.clearAllListeners();
            table.clearAllRowFilters();
        }
    }

    private static void onDimensionFinishLoad(OlapBuilderContext context, OlapBuilderErrorManager errorManager, Map<IOlapBuilderDimensionDef, OlapDimension> allSchemaDimensions, Set<IOlapBuilderDimensionDef> dimensionDefs) {
        for (IOlapBuilderDimensionDef dimensionDef : dimensionDefs) {
            if (context.incrLoadPhase() != IncrLoadPhase.BUILDING_SCHEMA) {
                OlapBuilderSchemaMain.addUnknownMemberToDimension(context, errorManager, dimensionDef, allSchemaDimensions);
                OlapBuilderSchemaMain.setDefaultMember(context, errorManager, dimensionDef, allSchemaDimensions);
            }
            OlapDimension dimension = allSchemaDimensions.get(dimensionDef);
            context.onDimensionProcessingCompleted(dimension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processFacts(OlapBuilderContext context, IOlapBuilderSchemaDef schemaDef, OlapSchema schema, OlapBuilderConnectionPool connectionPool, @Nullable Map<OlapUnresolvedRowsKey, IOlapBuilderTableListener> factsBuilders) {
        Logger logger = context.getLoggers().builder();
        logger.info((Object)"[facts] processing started");
        CdSetList factsTables = new CdSetList();
        OlapBuilderSchemaMain.onAllFactsExcludingM2M(schemaDef, (cube, fact) -> factsTables.addAll(fact.getDataView().getUnderlyingTables()));
        context.setForFactProcessing(true);
        context.onProgressPhase("factProcessingStarted", new Serializable[0]);
        context.onProgressEvent("factProcessingStarted", new Serializable[0]);
        try {
            for (IOlapBuilderDataTableDef factTable : factsTables) {
                factTable.forEachListener((CdAction<IOlapBuilderTableListener>)((CdAction)listener -> {
                    if (!listener.isForFactBuilding()) {
                        throw new RuntimeException("internal error : unexpected fact builder [" + listener.getClass().getName() + "]");
                    }
                }));
            }
            OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy = OlapThreadPoolExecutorTaskSchedulingPolicy.PARTITION;
            if (factsBuilders != null) {
                OlapBuilderSchemaMain.processFactsUnresolvedRows(context, schema, connectionPool, processingSchedulingPolicy, factsBuilders);
            }
            if (!context.isRestoring() || context.isIncrLoad()) {
                OlapBuilderTableProcessingHelper.processTables(context, connectionPool, processingSchedulingPolicy, (List<IOlapBuilderDataTableDef>)factsTables);
            } else {
                context.restoreFacts(null);
                context.restoreFactsContent();
                context.restoreIncrLoadSavePoints(OlapBuilderSchemaMain.allDataTables(schemaDef));
                OlapBuilderSchemaMain.removeAllListeners(schemaDef);
                for (IOlapBuilderDataTableDef factsTable : factsTables) {
                    factsTable.init(context);
                }
                context.restoreCubesUnresolvedRows((Collection<IOlapBuilderDataTableDef>)factsTables);
            }
        }
        finally {
            context.setForFactProcessing(false);
            context.onProgressPhase("factProcessingDone", new Serializable[0]);
            context.onProgressEvent("factProcessingDone", new Serializable[0]);
        }
        logger.info((Object)"[facts] processing completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processFactsUnresolvedRows(OlapBuilderContext context, OlapSchema schema, OlapBuilderConnectionPool connectionPool, OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy, Map<OlapUnresolvedRowsKey, IOlapBuilderTableListener> factsBuilders) {
        Logger logger = context.getLoggers().builder();
        OlapUnresolvedRowsManager manager = schema.getUnresolvedRowsManager();
        if (!manager.requiresCubesRowsProcessing(context)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"[u-rows] processing not required");
            }
            return;
        }
        Map<OlapUnresolvedRowsKey, IncrLoadUnresolvedRows> allUnresolvedRows = manager.getCubesUnresolvedRowsForProcessing();
        if (allUnresolvedRows.isEmpty()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[u-rows] processing started");
        }
        try {
            ArrayList<IOlapBuilderDataTableDef> factsTables = new ArrayList<IOlapBuilderDataTableDef>();
            for (Map.Entry<OlapUnresolvedRowsKey, IncrLoadUnresolvedRows> entry : allUnresolvedRows.entrySet()) {
                OlapUnresolvedRowsKey key = entry.getKey();
                IncrLoadUnresolvedRows uRows = entry.getValue();
                IOlapBuilderDataTableDef uRowsTable = uRows.asTable();
                IOlapBuilderTableListener facts = factsBuilders.get(key);
                if (facts == null) {
                    throw new RuntimeException("internal error: inconsistent unresolved rows processing ( missing facts definition )");
                }
                uRowsTable.addListener(facts);
                factsTables.add(uRowsTable);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("[u-rows] registering facts : " + key.getNameForLogging()));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"[u-rows] starting to replay unresolved rows");
            }
            OlapBuilderTableProcessingHelper.processTables(context, connectionPool, processingSchedulingPolicy, factsTables);
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"[u-rows] processing completed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processM2MsUnresolvedRows(OlapBuilderContext context, OlapSchema schema, OlapBuilderConnectionPool connectionPool, OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy, Map<String, IOlapBuilderTableListener> factsBuilders) {
        OlapUnresolvedRowsManager manager = schema.getUnresolvedRowsManager();
        if (!manager.requiresM2MsRowsProcessing()) {
            if (OlapLoggers.BUILDER.isDebugEnabled()) {
                OlapLoggers.BUILDER.debug((Object)"[u-rows] m2m processing not required");
            }
            return;
        }
        Map<String, IncrLoadUnresolvedRowsM2Ms> allUnresolvedRows = manager.getM2MsUnresolvedRowsForProcessing();
        if (allUnresolvedRows.isEmpty()) {
            return;
        }
        if (OlapLoggers.BUILDER.isDebugEnabled()) {
            OlapLoggers.BUILDER.debug((Object)"[u-rows] m2m processing started");
        }
        try {
            ArrayList<IOlapBuilderDataTableDef> factsTables = new ArrayList<IOlapBuilderDataTableDef>();
            for (Map.Entry<String, IncrLoadUnresolvedRowsM2Ms> entry : allUnresolvedRows.entrySet()) {
                String key = entry.getKey();
                IncrLoadUnresolvedRowsM2Ms uRows = entry.getValue();
                IOlapBuilderDataTableDef uRowsTable = uRows.asTable();
                IOlapBuilderTableListener facts = factsBuilders.get(key);
                if (facts == null) {
                    throw new RuntimeException("internal error: inconsistent unresolved rows processing ( missing m2m definition )");
                }
                uRowsTable.addListener(facts);
                factsTables.add(uRowsTable);
                if (!OlapLoggers.BUILDER.isDebugEnabled()) continue;
                OlapLoggers.BUILDER.debug((Object)("[u-rows] registering m2m : " + key));
            }
            if (OlapLoggers.BUILDER.isDebugEnabled()) {
                OlapLoggers.BUILDER.debug((Object)"[u-rows] m2m starting to replay unresolved rows");
            }
            OlapBuilderTableProcessingHelper.processTables(context, connectionPool, processingSchedulingPolicy, factsTables);
        }
        finally {
            if (OlapLoggers.BUILDER.isDebugEnabled()) {
                OlapLoggers.BUILDER.debug((Object)"[u-rows] m2m processing completed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processManyToManyAndBridges(OlapBuilderContext context, IOlapBuilderSchemaDef schemaDef, OlapBuilderConnectionPool connectionPool) {
        boolean backuping = context.isBackuping();
        boolean restoring = context.isRestoring();
        boolean incrLoad = context.isIncrLoad();
        Logger logger = context.getLoggers().builder();
        logger.info((Object)("[m-2-m] processing started [backup:" + backuping + "] [restore:" + restoring + "] [incr-load:" + incrLoad + "]"));
        context.setForMany2ManyProcessing(true);
        context.onProgressPhase("manyToManyProcessingStarted", new Serializable[0]);
        context.onProgressEvent("manyToManyProcessingStarted", new Serializable[0]);
        try {
            boolean processTables;
            boolean bl = processTables = !restoring;
            if (processTables) {
                HashMap<String, IOlapBuilderTableListener> factsBuilders = new HashMap<String, IOlapBuilderTableListener>();
                CdSetList tables = new CdSetList();
                Collection<OlapBridgeDef> bridgeResolvers = context.getSchema().getBridgeResolverDefinitions();
                bridgeResolvers.forEach(bridgeResolver -> bridgeResolver.getSingleBridgeDefs().forEach(bridge -> {
                    String tableId = bridge.getTableId();
                    IOlapBuilderTabularDataDef tabularData = OlapBuilderSchemaMain.solveTableOrViewDef(schemaDef, tableId);
                    tables.addAll(tabularData.getUnderlyingTables());
                    IOlapBuilderTableListener singleBridgeTableListener = context.getSchema().getBridgeTableListenerForBuilding(context, (OlapSingleBridgeDef)bridge);
                    tabularData.addListener(singleBridgeTableListener);
                }));
                Collection<OlapLookupTable> lookupTables = context.getSchema().getLookupTables();
                for (OlapLookupTable lookupTable : lookupTables) {
                    String tableId = lookupTable.getTableId();
                    IOlapBuilderTabularDataDef tabularData = OlapBuilderSchemaMain.solveTableOrViewDef(schemaDef, tableId);
                    logger.info((Object)("[lookup-table] adding listener for [" + tabularData.getName() + "]"));
                    tables.addAll(tabularData.getUnderlyingTables());
                    IOlapBuilderTableListener listener2 = lookupTable.createListener();
                    tabularData.addListener(listener2);
                }
                for (IOlapBuilderDataTableDef table : tables) {
                    table.forEachListener((CdAction<IOlapBuilderTableListener>)((CdAction)listener -> {
                        if (!listener.isForFactBuilding()) {
                            throw new RuntimeException("internal error : unexpected m2m builder [" + listener.getClass().getName() + "]");
                        }
                    }));
                }
                OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy = OlapThreadPoolExecutorTaskSchedulingPolicy.NONE;
                if (!factsBuilders.isEmpty()) {
                    OlapBuilderSchemaMain.processM2MsUnresolvedRows(context, context.getSchema(), connectionPool, processingSchedulingPolicy, factsBuilders);
                }
                OlapBuilderTableProcessingHelper.processTables(context, connectionPool, processingSchedulingPolicy, (List<IOlapBuilderDataTableDef>)tables);
                context.saveBridges();
                context.commitBridgesDiff();
            }
            if (restoring) {
                context.restoreBridges();
                CdSetList tables = new CdSetList();
                context.restoreM2MsUnresolvedRows((List<IOlapBuilderDataTableDef>)tables);
            }
            logger.info((Object)"[m-2-m] processing completed");
        }
        finally {
            context.setForMany2ManyProcessing(false);
            context.onProgressPhase("manyToManyProcessingDone", new Serializable[0]);
            context.onProgressEvent("manyToManyProcessingDone", new Serializable[0]);
        }
    }

    private static IOlapBuilderTabularDataDef solveTableOrViewDef(IOlapBuilderSchemaDef schemaDef, String tableId) {
        IOlapBuilderTabularDataDef table;
        MutableObject myString = new MutableObject();
        OlapBuilderSchemaMain.onAllDataTables(schemaDef, (CdAction<IOlapBuilderDataTableDef>)((CdAction)tableDef -> {
            if (tableDef.getId().equals(tableId)) {
                myString.setValue(tableDef);
            }
        }));
        if (myString.get() == null) {
            OlapBuilderSchemaMain.onAllDataViews(schemaDef, (CdAction<IOlapBuilderTabularDataDef>)((CdAction)viewDef -> {
                if (viewDef.getId().equals(tableId)) {
                    myString.setValue(viewDef);
                }
            }));
        }
        if ((table = (IOlapBuilderTabularDataDef)myString.get()) == null) {
            throw new CdShouldNotBeHereProgrammingException(tableId);
        }
        return table;
    }

    private static void onAllDataSources(IOlapBuilderSchemaDef schema, CdAction<IOlapBuilderDataSource> action) {
        CdCollections.apply(schema.getDataSources(), action);
        List<IOlapBuilderCubeDef> cubes = schema.getCubes();
        for (int ii = 0; ii < cubes.size(); ++ii) {
            IOlapBuilderCubeDef cubeDef = cubes.get(ii);
            if (!(cubeDef instanceof IOlapBuilderHeaderCubeDef)) continue;
            CdCollections.apply(((IOlapBuilderHeaderCubeDef)cubeDef).getDataSources(), action);
        }
    }

    public static List<IOlapBuilderDataTableDef> allDataTables(IOlapBuilderSchemaDef schema) {
        ArrayList<IOlapBuilderDataTableDef> tables = new ArrayList<IOlapBuilderDataTableDef>();
        OlapBuilderSchemaMain.onAllDataTables(schema, (CdAction<IOlapBuilderDataTableDef>)((CdAction)tables::add));
        return tables;
    }

    public static void onAllDataViews(IOlapBuilderSchemaDef schema, CdAction<IOlapBuilderTabularDataDef> action) {
        List<IOlapBuilderDataViewDef> views = schema.getViews();
        for (IOlapBuilderDataViewDef view : views) {
            action.apply((Object)view);
        }
    }

    public static void onAllDataTables(IOlapBuilderSchemaDef schema, CdAction<IOlapBuilderDataTableDef> action) {
        final CdSetList allTables = new CdSetList();
        CdCollections.apply(schema.getDataSources(), dataSource -> OlapBuilderSchemaMain.onAllDataTables(dataSource, (CdAction<IOlapBuilderDataTableDef>)((CdAction)arg_0 -> ((CdSetList)allTables).add(arg_0))));
        List<IOlapBuilderCubeDef> cubes = schema.getCubes();
        for (int ii = 0; ii < cubes.size(); ++ii) {
            IOlapBuilderCubeDef cubeDef = cubes.get(ii);
            if (!(cubeDef instanceof IOlapBuilderHeaderCubeDef)) continue;
            CdCollections.apply(((IOlapBuilderHeaderCubeDef)cubeDef).getDataSources(), (CdAction)new CdAction<IOlapBuilderDataSource>(){

                public void apply(IOlapBuilderDataSource dataSource) {
                    OlapBuilderSchemaMain.onAllDataTables(dataSource, (CdAction<IOlapBuilderDataTableDef>)((CdAction)arg_0 -> ((CdSetList)allTables).add(arg_0)));
                }
            });
        }
        List<IOlapBuilderDataViewDef> views = schema.getViews();
        for (IOlapBuilderDataViewDef view : views) {
            CdSetList tables = view.getUnderlyingTables();
            for (IOlapBuilderDataTableDef table : tables) {
                allTables.add((Object)table);
            }
        }
        for (IOlapBuilderDataTableDef table : allTables) {
            action.apply((Object)table);
        }
    }

    private static void onAllDataTables(IOlapBuilderDataSource ds, CdAction<IOlapBuilderDataTableDef> action) {
        CdSetList allTables = new CdSetList();
        List<IOlapBuilderDataViewDef> transientViews = ds.getTransientViews();
        for (IOlapBuilderDataViewDef transientView : transientViews) {
            CdSetList cdSetList = transientView.getUnderlyingTables();
            for (IOlapBuilderDataTableDef table : cdSetList) {
                allTables.add((Object)table);
            }
        }
        List tables = ds.getTables();
        for (IOlapBuilderDataTableDef iOlapBuilderDataTableDef : tables) {
            allTables.add(iOlapBuilderDataTableDef);
        }
        for (IOlapBuilderDataTableDef iOlapBuilderDataTableDef : allTables) {
            action.apply((Object)iOlapBuilderDataTableDef);
        }
    }

    public static void onAllFactsExcludingM2M(IOlapBuilderSchemaDef schema, @Nullable FactProcessor processor) {
        List<IOlapBuilderCubeDef> cubes = schema.getCubes();
        int size = cubes.size();
        for (int ii = 0; ii < size; ++ii) {
            IOlapBuilderCubeDef cube = cubes.get(ii);
            List<IOlapBuilderBaseFactsDef> facts = cube.getFacts();
            int factsSize = facts.size();
            if (processor == null) continue;
            for (int jj = 0; jj < factsSize; ++jj) {
                IOlapBuilderBaseFactsDef factsDef = facts.get(jj);
                processor.onFact(cube, factsDef);
            }
        }
    }

    private static void onAllPerspectives(IOlapBuilderSchemaDef schema, PerspectiveProcessor processor) {
        List<IOlapBuilderPerspectiveDef> items = schema.getPerspectives();
        if (items != null) {
            int size = items.size();
            for (int ii = 0; ii < size; ++ii) {
                IOlapBuilderPerspectiveDef item = items.get(ii);
                processor.onPerspective(item);
            }
        }
    }

    private static void onAllDimensions(IOlapBuilderSchemaDef schema, DimensionProcessor processor) {
        List<IOlapBuilderDimensionDef> dimensions = schema.getDimensions();
        if (dimensions != null) {
            int size = dimensions.size();
            for (int ii = 0; ii < size; ++ii) {
                IOlapBuilderDimensionDef dimension = dimensions.get(ii);
                processor.onDimension(null, dimension);
            }
        }
    }

    private static void onAllBridgeResolvers(OlapSchema schema, BridgeProcessor processor) {
        Collection<OlapBridgeDef> bridges = schema.getBridgeResolverDefinitions();
        if (bridges != null) {
            for (OlapBridgeDef bridge : bridges) {
                processor.onBridge(bridge);
            }
        }
    }

    public static void onAllCubes(IOlapBuilderSchemaDef schemaDefinition, CdAction<IOlapBuilderCubeDef> action) {
        CdCollections.apply(schemaDefinition.getCubes(), action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onAllMeasures(OlapBuilderErrorManager errorManager, IOlapBuilderSchemaDef schemaDefinition, MeasureProcessor processor) {
        for (IOlapBuilderCubeDef cubeDefinition : schemaDefinition.getCubes()) {
            errorManager.pushContext(cubeDefinition);
            try {
                for (IOlapBuilderBaseFactsDef factsDefinition : cubeDefinition.getFacts()) {
                    List<IOlapBuilderMeasureDef> list = factsDefinition.getDefinedMeasures();
                    for (IOlapBuilderMeasureDef measureDefinition : list) {
                        errorManager.pushContext(measureDefinition);
                        try {
                            processor.onMeasure(schemaDefinition, cubeDefinition, factsDefinition, measureDefinition);
                        }
                        finally {
                            errorManager.popContext();
                        }
                    }
                }
            }
            finally {
                errorManager.popContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doIncrementalLoad(OlapBuilderContext context, OlapBuilderErrorManager errorManager, OlapBuilderConnectionPool connectionPool, IncrLoadSchemaDef schemaDef, OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
        boolean succeeded = false;
        try {
            context.onBuildStarted();
            if (schema.getIncrementalLoad().redefinesTables()) {
                OlapBuilderReferenceSolver referenceSolver = OlapBuilderSchemaMain.createReferenceSolver(errorManager, schemaDef);
                OlapBuilderSchemaMain.solveReferences(errorManager, schemaDef, referenceSolver);
            }
            OlapBuilderSchemaMain.removeAllListeners(schemaDef);
            LinkedHashMap<IOlapBuilderDimensionDef, OlapDimension> dim2odimMap = new LinkedHashMap<IOlapBuilderDimensionDef, OlapDimension>();
            OlapBuilderSchemaMain.onAllDimensions(schemaDef, (cube, dimension) -> {
                OlapDimension olapDimension = schema.lookupDimensionByName(nameContext, dimension.getName());
                dim2odimMap.put(dimension, olapDimension);
            });
            OlapBuilderSchemaMain.onAllDimensions(schemaDef, (cubeDef, dimensionDef) -> {
                if (dimensionDef.changesOnIncrementalLoad()) {
                    OlapDimension dimension = OlapBuilderSchemaMain.getDimension(dimensionDef, dim2odimMap);
                    BaseDimensionBuilder builder = dimensionDef.createBuilder(context, dimension);
                    IOlapBuilderTabularDataDef dataView = dimensionDef.getDataView();
                    dataView.addListener(builder);
                    dataView.addListener(incrLoadInfo.asDimensionTableListener());
                    OlapBuilderSchemaMain.onAllFactsExcludingM2M(schemaDef, null);
                }
            });
            OlapBuilderSchemaMain.processDataToBuildDimensions(context, errorManager, schemaDef, connectionPool, dim2odimMap);
            OlapBuilderSchemaMain.setupDynHierarchyIndex(context, dim2odimMap);
            Map<IOlapBuilderCubeDef, OlapRegularCube> cubesByDefinitions = OlapBuilderSchemaMain.setupCubesByDefinitions(schemaDef, schema);
            OlapBuilderSchemaMain.removeAllListeners(schemaDef);
            context.createClusterContext(null, null);
            context.onDimensionChanged(schema);
            if (incrLoadInfo.hasNewMembers()) {
                OlapUnresolvedRowsManager manager = schema.getUnresolvedRowsManager();
                manager.onIncrLoadNewMembers();
                schema.requiresLoadSchemaMembersPostProcessing(true);
            }
            OlapBuilderSchemaMain.processManyToManyAndBridges(context, schemaDef, connectionPool);
            OlapBuilderSchemaMain.removeAllListeners(schemaDef);
            Map<OlapUnresolvedRowsKey, IOlapBuilderTableListener> factsBuilders = OlapBuilderSchemaMain.setupFactsBuilders(context, schemaDef, cubesByDefinitions);
            OlapBuilderSchemaMain.processFacts(context, schemaDef, schema, connectionPool, factsBuilders);
            for (OlapCube olapCube : schema.getCubes()) {
                OlapFactCubeManager cubeFactManager = olapCube.getCubeFactManager();
                for (OlapFactMeasureGroupBaseManager factBaseManager : cubeFactManager.getFactManagers()) {
                    context.onIncrLoadFactsProcessingCompleted(factBaseManager);
                }
            }
            context.onSchemaProcessingCompleted();
            OlapSchemaStatsHolder stats = schema.getStatsHolder();
            stats.onIncrLoadProcessingCompleted(context.getLoggers().builderIncrLoad(), schema);
            succeeded = true;
        }
        finally {
            context.onSchemaProcessingDone(succeeded);
        }
    }

    public static Map<IOlapBuilderCubeDef, OlapRegularCube> setupCubesByDefinitions(IOlapBuilderSchemaDef schemaDef, OlapSchema schema) {
        HashMap<IOlapBuilderCubeDef, OlapRegularCube> cubesByDefinitions = new HashMap<IOlapBuilderCubeDef, OlapRegularCube>();
        OlapBuilderSchemaMain.onAllCubes(schemaDef, (CdAction<IOlapBuilderCubeDef>)((CdAction)cubeDef -> {
            String cubeName = cubeDef.getName();
            OlapRegularCube cube = schema.lookupCubeByName(nameContext, cubeName);
            if (cube == null) {
                throw new RuntimeException("internal error: missing cube [" + cubeName + "] from schema [" + schemaDef.getName() + "]");
            }
            cubesByDefinitions.put((IOlapBuilderCubeDef)cubeDef, cube);
        }));
        return cubesByDefinitions;
    }

    public static Map<OlapUnresolvedRowsKey, IOlapBuilderTableListener> setupFactsBuilders(OlapBuilderContext context, IOlapBuilderSchemaDef schemaDef, Map<IOlapBuilderCubeDef, OlapRegularCube> cubesByDefinitions) {
        HashMap<OlapUnresolvedRowsKey, IOlapBuilderTableListener> factsBuilders = new HashMap<OlapUnresolvedRowsKey, IOlapBuilderTableListener>();
        OlapBuilderSchemaMain.onAllFactsExcludingM2M(schemaDef, (cubeDef, factsDef) -> {
            OlapRegularCube cube = (OlapRegularCube)cubesByDefinitions.get(cubeDef);
            IOlapBuilderTableListener factsBuilder = factsDef.createFactBuilder(context, cube);
            factsDef.getDataView().addListener(factsBuilder);
            OlapUnresolvedRowsKey uRowsKey = new OlapUnresolvedRowsKey(cube.getNameX(), factsDef.getName());
            if (factsBuilders.get(uRowsKey) != null) {
                throw new RuntimeException("internal error: inconsistent unresolved rows processing");
            }
            factsBuilders.put(uRowsKey, factsBuilder);
        });
        return factsBuilders;
    }

    public static void setLastDataUpdatedTime(OlapSchema schema) {
        OlapSchemaInformation info = schema.getInformation();
        Date timestamp = info.getOfflineSnapshotTimestamp();
        Date now = timestamp != null ? timestamp : new Date();
        schema.setLastDataUpdatedTime(now);
        List<OlapRegularCube> cubes = schema.getCubes();
        int size = cubes.size();
        for (int ii = 0; ii < size; ++ii) {
            OlapRegularCube cube = cubes.get(ii);
            cube.setLastDataUpdatedTime(now);
        }
    }

    public static void debugLogIncrLoadDimensionStatistics(Logger logger, String schemaName, @Nullable OlapIncrLoadStats prevStats, @Nullable OlapIncrLoadStats newStats) {
        if (prevStats == null || newStats == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Schema Incr. Load Statistics : " + schemaName));
            List<OlapDimensionStats> newDimensionsStats = newStats.getDimensions();
            for (OlapDimensionStats newDimensionStats : newDimensionsStats) {
                String dimensionName = newDimensionStats.getName();
                OlapDimensionStats prevDimensionStats = prevStats.getDimension(dimensionName);
                long prevMemberCount = prevDimensionStats != null ? prevDimensionStats.getMemberCount() : -1L;
                long newMemberCount = newDimensionStats.getMemberCount();
                logger.debug((Object)"");
                logger.debug((Object)("  D : " + dimensionName + " , members : " + CdStringUtils.formatNice((long)newMemberCount, (long)prevMemberCount)));
                List<OlapHierarchyStats> newHierarchiesStats = newDimensionStats.getHierarchies();
                for (OlapHierarchyStats newHierarchyStats : newHierarchiesStats) {
                    String hierarchyName = newHierarchyStats.getName();
                    OlapHierarchyStats prevHierarchyStats = prevDimensionStats != null ? prevDimensionStats.getHierarchy(hierarchyName) : null;
                    boolean base = prevHierarchyStats != null && prevHierarchyStats.isBase();
                    prevMemberCount = prevHierarchyStats != null ? prevHierarchyStats.getMemberCount() : -1L;
                    newMemberCount = newHierarchyStats.getMemberCount();
                    logger.debug((Object)("      H : " + hierarchyName + (base ? " (base) " : "") + " : " + CdStringUtils.formatNice((long)newMemberCount, (long)prevMemberCount) + " members"));
                }
            }
            logger.debug((Object)"");
            List<OlapFactsStats> newFactsStats = newStats.getFacts();
            for (OlapFactsStats newFactsStat : newFactsStats) {
                String factsName = newFactsStat.getName();
                OlapFactsStats prevFactsStats = prevStats.getFacts(factsName);
                long prevURowsCount = prevFactsStats != null ? prevFactsStats.getUnresolvedRowCount() : 0L;
                long newURowsCount = newFactsStat.getUnresolvedRowCount();
                long prevRowsCount = prevFactsStats != null ? prevFactsStats.getRowCount() : 0L;
                long newRowsCount = newFactsStat.getRowCount();
                N_FactPageBitmapGutsBitmapCount prevBitmapCount = prevFactsStats != null ? prevFactsStats.getBitmapCount() : null;
                N_FactPageBitmapGutsBitmapCount newBitmapCount = newFactsStat.getBitmapCount();
                logger.debug((Object)("  F : " + factsName + " , u-rows-count : " + CdStringUtils.formatNice((long)newURowsCount, (long)prevURowsCount) + " , rows-count : " + CdStringUtils.formatNice((long)newRowsCount, (long)prevRowsCount) + " , index-count : " + N_FactPageBitmapGutsBitmapCount.formatCount(prevBitmapCount, newBitmapCount)));
            }
            logger.debug((Object)"");
            List<OlapSavePointStats> savePoints = newStats.getSavePoints();
            if (savePoints != null && !savePoints.isEmpty()) {
                for (OlapSavePointStats savePoint : savePoints) {
                    logger.debug((Object)("  SP : " + savePoint.getTableId() + savePoint.getValue()));
                }
            }
            logger.debug((Object)"");
        }
    }

    private static /* synthetic */ void lambda$processDataToBuildDimensions$0(List allTables, Set allDimensions, IOlapBuilderCubeDef cube, IOlapBuilderDimensionDef dimensionDef) {
        CdSetList<IOlapBuilderDataTableDef> dataTables = dimensionDef.getDataView().getUnderlyingTables();
        allTables.addAll(dataTables);
        allDimensions.add(dimensionDef);
    }

    static interface DimensionProcessor {
        public void onDimension(@Nullable IOlapBuilderCubeDef var1, IOlapBuilderDimensionDef var2);
    }

    public static interface FactProcessor {
        public void onFact(IOlapBuilderCubeDef var1, IOlapBuilderBaseFactsDef var2);
    }

    public static interface FactLinkProcessor {
        public void onLink(IOlapBuilderCubeDef var1, IOlapBuilderBaseFactsDef var2, IOlapBuilderDataViewLinksDef var3);
    }

    static interface BridgeProcessor {
        public void onBridge(OlapBridgeDef var1);
    }

    static interface MeasureProcessor {
        public void onMeasure(IOlapBuilderSchemaDef var1, IOlapBuilderCubeDef var2, IOlapBuilderBaseFactsDef var3, IOlapBuilderMeasureDef var4);
    }

    static interface PerspectiveProcessor {
        public void onPerspective(IOlapBuilderPerspectiveDef var1);
    }
}

