/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder;

import crazydev.common.collection.CdSetList;
import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.iccube.builder.OlapBuilderCacheTableHelper;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.datasource.reader.cache.OlapBuilderCacheReadTableRowReader;
import crazydev.iccube.builder.datasource.reader.cache.OlapBuilderCacheWriteTableRowReader;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderRegularCacheTableHelper
implements OlapBuilderCacheTableHelper {
    private final OlapBuilderContext owner;
    private final CdSetList<IOlapBuilderDataTableDef> cachedTables = new CdSetList();
    @Nullable
    private File cacheTableDirectory;
    @Nullable
    private CdSetList<IOlapBuilderDataTableDef> tablesToCache;

    public OlapBuilderRegularCacheTableHelper(OlapBuilderContext owner) {
        this.owner = owner;
    }

    @Override
    public void setupTableCache(@Nullable CdSetList<IOlapBuilderDataTableDef> tables) {
        if (tables != null && !tables.isEmpty()) {
            String schemaName = this.owner.getSchema().getName();
            OlapEngineRequestContext requestContext = this.owner.getRequestContext();
            OlapEngineApplicationContext applicationContext = requestContext.getApplicationContext();
            this.cacheTableDirectory = applicationContext.createCacheTableDirectory(this.owner.asRuntimeContext(), schemaName);
            this.tablesToCache = tables;
        } else {
            if (this.cacheTableDirectory != null) {
                boolean deleted = CdVFileSystemUtils.deleteQuietly((File)this.cacheTableDirectory);
                if (OlapLoggers.GENERAL.isDebugEnabled()) {
                    OlapLoggers.GENERAL.debug((Object)("[builder] deleted [" + deleted + "] table-cache directory [" + this.cacheTableDirectory.getAbsolutePath() + "]"));
                }
            }
            this.cacheTableDirectory = null;
            this.tablesToCache = null;
        }
    }

    @Override
    public void cleanupTableCache() {
        if (this.cacheTableDirectory != null) {
            boolean deleted = CdVFileSystemUtils.deleteQuietly((File)this.cacheTableDirectory);
            if (OlapLoggers.GENERAL.isDebugEnabled()) {
                OlapLoggers.GENERAL.debug((Object)("[builder] deleted [" + deleted + "] table-cache directory [" + this.cacheTableDirectory.getAbsolutePath() + "]"));
            }
        }
        this.cacheTableDirectory = null;
        this.tablesToCache = null;
    }

    @Override
    @Nullable
    public IOlapBuilderTableRowReader createReadingRowReader(IOlapBuilderDataTableDef table) {
        if (this.tablesToCache == null || this.tablesToCache.isEmpty()) {
            return null;
        }
        if (this.owner.isOfflineReadActive()) {
            return null;
        }
        if (this.cacheTableDirectory == null) {
            return null;
        }
        if (this.hasCache(table)) {
            OlapBuilderCacheReadTableRowReader readingReader = new OlapBuilderCacheReadTableRowReader(this.owner, this.cacheTableDirectory, table);
            return readingReader;
        }
        return null;
    }

    @Override
    public IOlapBuilderTableRowReader createWritingRowReader(IOlapBuilderTableRowReader reader) {
        if (this.tablesToCache == null || this.tablesToCache.isEmpty()) {
            return reader;
        }
        if (this.owner.isOfflineReadActive()) {
            return reader;
        }
        IOlapBuilderDataTableDef table = reader.getTable();
        if (!this.requiresCache(table)) {
            return reader;
        }
        if (this.cacheTableDirectory == null) {
            return reader;
        }
        if (!this.hasCache(table)) {
            OlapBuilderCacheWriteTableRowReader writingReader = new OlapBuilderCacheWriteTableRowReader(this.owner, this.cacheTableDirectory, reader);
            this.registerCacheForTable(table);
            return writingReader;
        }
        return reader;
    }

    private boolean requiresCache(IOlapBuilderDataTableDef table) {
        return this.tablesToCache != null && this.tablesToCache.contains((Object)table);
    }

    private boolean hasCache(IOlapBuilderDataTableDef table) {
        return this.cachedTables.contains((Object)table);
    }

    private void registerCacheForTable(IOlapBuilderDataTableDef table) {
        this.cachedTables.add((Object)table);
    }
}

