/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder;

import crazydev.common.collection.CdPair;
import crazydev.common.utils.CdClassUtils;
import crazydev.common.xml.CdXmlFieldNavigator;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.builder.OlapBuilderUxModel;
import crazydev.iccube.builder.datasource.csv.OlapBuilderCSVDataSource;
import crazydev.iccube.builder.datasource.csv.OlapBuilderCSVDataTable;
import crazydev.iccube.builder.datasource.csv.OlapBuilderHttpCSVDataTable;
import crazydev.iccube.builder.datasource.csv.OlapBuilderMultiFilesCSVDataTable;
import crazydev.iccube.builder.datasource.empty.OlapBuilderEmptyDataSource;
import crazydev.iccube.builder.datasource.empty.OlapBuilderEmptyDataTable;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.datasource.file.OlapBuilderFileDataSource;
import crazydev.iccube.builder.datasource.file.OlapBuilderFileLineDataTable;
import crazydev.iccube.builder.datasource.file.OlapBuilderHttpFileLineDataTable;
import crazydev.iccube.builder.datasource.file.OlapBuilderMultiFileLineDataTable;
import crazydev.iccube.builder.datasource.file.json.OlapBuilderFileJsonDataTable;
import crazydev.iccube.builder.datasource.file.json.OlapBuilderHttpJsonDataTable;
import crazydev.iccube.builder.datasource.file.json.OlapBuilderJsonDataSource;
import crazydev.iccube.builder.datasource.file.json.OlapBuilderMultiFileJsonDataTable;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataTable;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcStatementDataTable;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcUnionDataTable;
import crazydev.iccube.builder.datasource.jdbc.ux.UxBuilderSnowflakeJdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.ux.UxBuilderSqlAnywhereJdbcDataSource;
import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryBufferDataTable;
import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryDataSource;
import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryDirectBufferDataTable;
import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryLineDataTable;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssDataSource;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssTable;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.factory.cube.IOlapBuilderCubeDefFactory;
import crazydev.iccube.builder.factory.cube.OlapBuilderBaseCubeDefFactory;
import crazydev.iccube.builder.factory.cube.OlapBuilderClassCubeDefFactory;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.factory.schema.OlapBuilderCubeBasedSchemaDefFactory;
import crazydev.iccube.builder.factory.schema.OlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.goodies.headerdef.factory.OlapBuilderSingleFileHeaderCubeDefFactory;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderAdvancedDimension;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderBaseDimension;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderMultiLevelDimension;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderParentChildDimension;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderPathDimension;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderStatisticalDimension;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderTimeWizardDimension;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderBaseHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderMultiLevelHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderParentChildHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderPathHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderStatsHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderTimeWizardHierarchy;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.model.impl.view.colsrows.OlapBuilderColsRowsDataView;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataView;
import crazydev.iccube.builder.model.impl.view.dump.OlapBuilderDumpDataView;
import crazydev.iccube.builder.model.impl.view.groupby.OlapBuilderGroupByDataView;
import crazydev.iccube.builder.model.impl.view.java.OlapBuilderJavaDataView;
import crazydev.iccube.builder.model.impl.view.javasimple.OlapBuilderSimpleJavaDataView;
import crazydev.iccube.builder.model.impl.view.join.OlapBuilderJoinDataView;
import crazydev.iccube.builder.model.impl.view.parentchildsort.sort.OlapBuilderParentChildSortDataView;
import crazydev.iccube.builder.model.impl.view.rename.OlapBuilderRenameDataView;
import crazydev.iccube.builder.model.impl.view.rowscols.OlapBuilderRowToColsDataView;
import crazydev.iccube.builder.model.impl.view.sort.OlapBuilderSortDataView;
import crazydev.iccube.builder.model.impl.view.union.OlapBuilderUnionDataView;
import crazydev.iccube.builder.ux.meta.UxBuilderMetaInfo;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderMetaInformationRepository {
    public static boolean TEST_IGNORE_FIELD_ANNOTATION = false;
    private static final Set<Class> checked = new HashSet<Class>();
    private final boolean withJavaViews;
    private final List<CdPair<Class, Set<Class>>> listOfSets = new ArrayList<CdPair<Class, Set<Class>>>();
    private final List<CdPair<Class, Class>> listOfInterfacesInstances = new ArrayList<CdPair<Class, Class>>();
    private final Set<Class> persistentClasses = new HashSet<Class>();
    private final Set<Class<IOlapBuilderSchemaDefFactory>> schemaFacts = new HashSet<Class<IOlapBuilderSchemaDefFactory>>();
    private final Set<Class<OlapBuilderBaseCubeDefFactory>> cubeFacts = new HashSet<Class<OlapBuilderBaseCubeDefFactory>>();
    private final Set<Class<OlapBuilderBaseDataSource>> dataSources = new HashSet<Class<OlapBuilderBaseDataSource>>();
    private final Set<Class<OlapBuilderBaseDataView>> dataViews = new HashSet<Class<OlapBuilderBaseDataView>>();
    private final Set<Class<OlapBuilderBaseDataTable>> dataTable = new HashSet<Class<OlapBuilderBaseDataTable>>();
    private final Set<Class<OlapBuilderFacts>> facts = new HashSet<Class<OlapBuilderFacts>>();
    private final Set<Class<OlapBuilderBaseHierarchy>> hierarchies = new HashSet<Class<OlapBuilderBaseHierarchy>>();
    private final Set<Class<OlapBuilderBaseDimension>> dimensions = new HashSet<Class<OlapBuilderBaseDimension>>();
    private final Set<Class<OlapBuilderUxModel>> uxModels = new HashSet<Class<OlapBuilderUxModel>>();
    private final UxBuilderMetaInfo uxMetaInfo;

    public OlapBuilderMetaInformationRepository(boolean withJavaViews) {
        this.withJavaViews = withJavaViews;
        this.uxMetaInfo = new UxBuilderMetaInfo(this);
        this.reset();
    }

    public OlapBuilderMetaInformationRepository() {
        this(false);
    }

    public Set<Class<OlapBuilderBaseDataSource>> getAvailableDataSources() {
        return this.dataSources;
    }

    @Nullable
    public Class<?> getDataSourceClass(String className) {
        for (Class<OlapBuilderBaseDataSource> dataSource : this.dataSources) {
            if (!dataSource.getName().equals(className)) continue;
            return dataSource;
        }
        return null;
    }

    public Set<Class<OlapBuilderBaseDataView>> getAvailableDataViews() {
        return this.dataViews;
    }

    public Set<Class<OlapBuilderBaseDimension>> getAvailableDimensions() {
        return this.dimensions;
    }

    public Set<Class<OlapBuilderBaseCubeDefFactory>> getAvailableCubeDefFactories() {
        return this.cubeFacts;
    }

    public Class[] getPersistentClasses() {
        return this.persistentClasses.toArray(new Class[this.persistentClasses.size()]);
    }

    public void reset() {
        this.listOfSets.clear();
        this.listOfInterfacesInstances.clear();
        this.persistentClasses.clear();
        this.schemaFacts.clear();
        this.cubeFacts.clear();
        this.dataSources.clear();
        this.dataViews.clear();
        this.facts.clear();
        this.dataTable.clear();
        this.hierarchies.clear();
        this.dimensions.clear();
        this.registerBuiltins();
    }

    private void registerBuiltins() {
        this.register(this.schemaFacts, IOlapBuilderSchemaDefFactory.class);
        this.registerBuiltinClass(OlapBuilderCubeBasedSchemaDefFactory.class);
        this.registerBuiltinClass(OlapBuilderSchemaDefFactory.class);
        this.register(this.cubeFacts, OlapBuilderBaseCubeDefFactory.class, IOlapBuilderCubeDefFactory.class);
        this.registerBuiltinClass(OlapBuilderSingleFileHeaderCubeDefFactory.class);
        this.registerBuiltinClass(OlapBuilderClassCubeDefFactory.class);
        this.register(this.dataSources, OlapBuilderBaseDataSource.class, IOlapBuilderDataSource.class);
        this.registerBuiltinClass(OlapBuilderEmptyDataSource.class);
        this.registerBuiltinClass(OlapBuilderInMemoryDataSource.class);
        this.registerBuiltinClass(OlapBuilderFileDataSource.class);
        this.registerBuiltinClass(OlapBuilderJdbcDataSource.class);
        this.registerBuiltinClass(UxBuilderSnowflakeJdbcDataSource.class);
        this.registerBuiltinClass(UxBuilderSqlAnywhereJdbcDataSource.class);
        this.registerBuiltinClass(OlapBuilderCSVDataSource.class);
        this.registerBuiltinClass(OlapBuilderJsonDataSource.class);
        this.registerBuiltinClass(OlapBuilderSpssDataSource.class);
        this.register(this.dataTable, OlapBuilderBaseDataTable.class, IOlapBuilderDataTableDef.class);
        this.registerBuiltinClass(OlapBuilderEmptyDataTable.class);
        this.registerBuiltinClass(OlapBuilderInMemoryLineDataTable.class);
        this.registerBuiltinClass(OlapBuilderFileLineDataTable.class);
        this.registerBuiltinClass(OlapBuilderMultiFileLineDataTable.class);
        this.registerBuiltinClass(OlapBuilderJdbcDataTable.class);
        this.registerBuiltinClass(OlapBuilderJdbcUnionDataTable.class);
        this.registerBuiltinClass(OlapBuilderJdbcStatementDataTable.class);
        this.registerBuiltinClass(OlapBuilderCSVDataTable.class);
        this.registerBuiltinClass(OlapBuilderHttpCSVDataTable.class);
        this.registerBuiltinClass(OlapBuilderHttpFileLineDataTable.class);
        this.registerBuiltinClass(OlapBuilderFileJsonDataTable.class);
        this.registerBuiltinClass(OlapBuilderMultiFileJsonDataTable.class);
        this.registerBuiltinClass(OlapBuilderHttpJsonDataTable.class);
        this.registerBuiltinClass(OlapBuilderMultiFilesCSVDataTable.class);
        this.registerBuiltinClass(OlapBuilderInMemoryDirectBufferDataTable.class);
        this.registerBuiltinClass(OlapBuilderInMemoryBufferDataTable.class);
        this.registerBuiltinClass(OlapBuilderSpssTable.class);
        this.register(this.dataViews, OlapBuilderBaseDataView.class, IOlapBuilderDataViewDef.class);
        this.registerBuiltinClass(OlapBuilderColsRowsDataView.class);
        this.registerBuiltinClass(OlapBuilderGroupByDataView.class);
        this.registerBuiltinClass(OlapBuilderUnionDataView.class);
        this.registerBuiltinClass(OlapBuilderJoinDataView.class);
        this.registerBuiltinClass(OlapBuilderSortDataView.class);
        this.registerBuiltinClass(OlapBuilderParentChildSortDataView.class);
        this.registerBuiltinClass(OlapBuilderDumpDataView.class);
        this.registerBuiltinClass(OlapBuilderRowToColsDataView.class);
        this.registerBuiltinClass(OlapBuilderRenameDataView.class);
        if (this.withJavaViews) {
            this.registerBuiltinClass(OlapBuilderSimpleJavaDataView.class);
            this.registerBuiltinClass(OlapBuilderJavaDataView.class);
        }
        this.register(this.facts, OlapBuilderFacts.class, IOlapBuilderFactsDef.class);
        this.registerBuiltinClass(OlapBuilderFacts.class);
        this.register(this.dimensions, OlapBuilderBaseDimension.class, IOlapBuilderDimensionDef.class);
        this.registerBuiltinClass(OlapBuilderAdvancedDimension.class);
        this.registerBuiltinClass(OlapBuilderMultiLevelDimension.class);
        this.registerBuiltinClass(OlapBuilderParentChildDimension.class);
        this.registerBuiltinClass(OlapBuilderPathDimension.class);
        this.registerBuiltinClass(OlapBuilderTimeWizardDimension.class);
        this.registerBuiltinClass(OlapBuilderStatisticalDimension.class);
        this.register(this.hierarchies, OlapBuilderBaseHierarchy.class, IOlapBuilderHierarchyDef.class);
        this.registerBuiltinClass(OlapBuilderParentChildHierarchy.class);
        this.registerBuiltinClass(OlapBuilderPathHierarchy.class);
        this.registerBuiltinClass(OlapBuilderStatsHierarchy.class);
        this.registerBuiltinClass(OlapBuilderMultiLevelHierarchy.class);
        this.registerBuiltinClass(OlapBuilderTimeWizardHierarchy.class);
        this.register(this.uxModels, OlapBuilderUxModel.class);
    }

    private void registerBuiltinClass(Class builderClass) throws OlapBuilderErrorException {
        this.register(false, builderClass);
    }

    public void register(boolean isPlugin, Class builderClass) throws OlapBuilderErrorException {
        for (CdPair<Class, Set<Class>> cdPair : this.listOfSets) {
            if (!this.addClass(isPlugin, (Set)cdPair.snd, (Class)cdPair.fst, builderClass)) continue;
            return;
        }
        for (CdPair cdPair : this.listOfInterfacesInstances) {
            if (!((Class)cdPair.snd).isAssignableFrom(builderClass)) continue;
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.CLASS_SHOULD_EXTEND_FRAMEWORK_CLASS, new Serializable[]{builderClass.getName(), (Serializable)cdPair.fst});
        }
        throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNKNOWN_CLASS_TO_BUILDER_FRAMEWORK, new Serializable[]{builderClass.getName()});
    }

    private <T> void register(Set<Class<T>> set, Class<T> neededClass) {
        this.register(set, neededClass, null);
    }

    private <T> void register(Set<Class<T>> set, Class<T> neededClass, Class interfaceType) {
        this._register(set, neededClass, interfaceType);
    }

    private void _register(Set set, Class neededClass, @Nullable Class interfaceType) {
        this.listOfSets.add((CdPair<Class, Set<Class>>)new CdPair((Object)neededClass, (Object)set));
        if (interfaceType != null) {
            this.listOfInterfacesInstances.add((CdPair<Class, Class>)new CdPair((Object)neededClass, (Object)interfaceType));
        }
    }

    @Nullable
    public Class lookupClass(String className) {
        for (Class persistentClass : this.persistentClasses) {
            if (!persistentClass.getName().equals(className)) continue;
            return persistentClass;
        }
        return null;
    }

    private boolean addClass(boolean isPlugin, Set<Class> set, Class targetClazz, Class builderClass) {
        if (targetClazz == OlapBuilderUxModel.class) {
            checked.add(builderClass);
            set.add(builderClass);
            return true;
        }
        if (targetClazz.isAssignableFrom(builderClass)) {
            if (!checked.contains(builderClass)) {
                this.checkXmlRootName(set, builderClass);
                this.checkFieldAnnotation(builderClass);
            }
            checked.add(builderClass);
            set.add(builderClass);
            this.persistentClasses.add(builderClass);
            return true;
        }
        return false;
    }

    private void checkXmlRootName(Set<Class> set, Class builderClass) {
        String rootName = this.getXmlRootName(builderClass);
        for (Class aClass : set) {
            String itemRootName = this.getXmlRootName(aClass);
            if (!itemRootName.equals(rootName)) continue;
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.CLASS_WITH_DUPLICATED_ROOT_NAME, new Serializable[]{builderClass, rootName, aClass.getName()});
        }
    }

    private String getXmlRootName(Class builderClass) {
        XmlRootElement rootElement = builderClass.getAnnotation(XmlRootElement.class);
        if (rootElement == null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.ROOT_ANNOTATION_MISSED, builderClass);
        }
        return rootElement.name();
    }

    private void checkFieldAnnotation(Class builderClass) {
        try {
            Object item = CdClassUtils.instantiateClass((Class)builderClass);
            CdXmlFieldNavigator.navigate((Object)item, (CdXmlFieldNavigator.Navigator)new CdXmlFieldNavigator.Navigator());
        }
        catch (NoClassDefFoundError ex) {
            if (TEST_IGNORE_FIELD_ANNOTATION) {
                return;
            }
            throw ex;
        }
    }

    public void refreshMetaInformation() {
        try {
            OlapLoggers.BUILDER.info((Object)"[builder] JAXB reset started");
            Class[] persistentClasses = this.getPersistentClasses();
            CdXmlUtils.resetJAXBMarshaller((Class[])persistentClasses);
            CdXmlUtils.resetJAXBUnmarshaller((Class[])persistentClasses);
            OlapLoggers.BUILDER.info((Object)"[builder] JAXB reset completed");
        }
        catch (Exception ex) {
            OlapLoggers.BUILDER.error((Object)"JAXB reset error", (Throwable)ex);
        }
    }

    public void onAllPluginsLoaded() {
        this.uxMetaInfo.setupDataSourceTypes(this.dataSources);
        this.uxMetaInfo.setupDataViewTypes(this.dataViews);
        new Thread(() -> {
            try {
                OlapLoggers.BUILDER.info((Object)"[builder] JAXB setup started");
                Class[] persistentClasses = this.getPersistentClasses();
                CdXmlUtils.setupJAXBMarshaller((Class[])persistentClasses);
                CdXmlUtils.setupJAXBUnmarshaller((Class[])persistentClasses);
                OlapLoggers.BUILDER.info((Object)"[builder] JAXB setup completed");
            }
            catch (Exception ex) {
                OlapLoggers.BUILDER.error((Object)"JAXB setup error", (Throwable)ex);
            }
        }, "JAXB setup (builder)").start();
    }

    public UxBuilderMetaInfo getUxMetaInfo() {
        return this.uxMetaInfo;
    }
}

