/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder;

import crazydev.common.collection.CdAction;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.builder.IOlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderBaseToNoBaseMapper;
import crazydev.iccube.builder.OlapBuilderCacheTableHelper;
import crazydev.iccube.builder.OlapBuilderContextMode;
import crazydev.iccube.builder.OlapBuilderMetaInformationRepository;
import crazydev.iccube.builder.OlapBuilderNilCacheTableHelper;
import crazydev.iccube.builder.OlapBuilderRegularCacheTableHelper;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.executor.rowprocessing.OlapBuilderTableRowProcessingTaskExecutor;
import crazydev.iccube.builder.executor.rowreading.OlapBuilderTableRowReadingTaskExecutor;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderBaseFactBuilder;
import crazydev.iccube.builder.model.builders.facts.cache.N_FactPageResolvedMembersCache;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.offline.read.OlapBuilderOfflineReadHelper;
import crazydev.iccube.builder.offline.write.OlapBuilderOfflineWriteHelper;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.master.backup.restore.M_RestoreContext;
import crazydev.iccube.cluster.master.backup.restore.M_RestorePartitionManager;
import crazydev.iccube.cluster.master.backup.restore.M_RestoreRowReader;
import crazydev.iccube.cluster.master.backup.save.M_BackupContext;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.cluster.master.local.M_LocalCluster;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalMeasureGroupManager;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalPartition;
import crazydev.iccube.cluster.node.engine.N_OlapEngine;
import crazydev.iccube.cluster.shared.backup.S_BackupMode;
import crazydev.iccube.cluster.shared.facts.bitmap.S_FactBitmapContainerFactory;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextInitData;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextKind;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextRef;
import crazydev.iccube.cluster.shared.schema.S_HollowUpdate;
import crazydev.iccube.cluster.shared.schema.S_IncrLoadDimensionUpdateDef;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.component.context.IGCActivityListener;
import crazydev.iccube.olap.component.context.IOlapContextLoggers;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapDefaultNamesContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.hierarchy.OlapMultiLevelHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapHollowableMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.facts.OlapFactCubeManager;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.goodies.incrload.IncrLoadPhase;
import crazydev.iccube.olap.goodies.incrload.IncrLoadSavePoints;
import crazydev.iccube.olap.goodies.incrload.IncrLoadTableSavePoint;
import crazydev.iccube.olap.goodies.unresolverows.OlapUnresolvedRowsManager;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.olap.schema.stats.OlapSchemaFullLoadStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaStatsHolder;
import crazydev.iccube.request.log.OlapRequestId;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderContext
implements IOlapBuilderContext {
    public static final int MAGIC_COUNT = 16;
    private final OlapEngineRequestContext requestContext;
    private final IOlapContextLoggers loggers;
    private final OlapBuilderContextMode mode;
    private final boolean keepMdxResultCache;
    private final boolean continueBackupOnError;
    @Nullable
    private final S_BuildSchemaContextRef clusterContextRef;
    @Nullable
    private final OlapSchema schema;
    private final OlapBuilderCacheTableHelper cacheTableHelper;
    private final OlapEngineOfflineMode offlineMode;
    @Nullable
    private final OlapBuilderOfflineWriteHelper offlineWriteHelper;
    @Nullable
    private final OlapBuilderOfflineReadHelper offlineReadHelper;
    @Nullable
    private final OlapBuilderBaseToNoBaseMapper baseNoBaseMapper;
    private final boolean keepBaseNoBaseMapper;
    @Nullable(value="LOAD_PARTITIONS only")
    private final @Nullable(value="LOAD_PARTITIONS only") IncrLoadPhase incrLoadPhase;
    private final boolean incrLoadLogRows;
    @Nullable
    private final OlapUnresolvedRowsManager unresolvedRows;
    @Nullable
    private final M_BackupContext backupContext;
    @Nullable
    private final M_RestoreContext restoreContext;
    private final Map<OlapHollowableMember, OlapMember> hollowRemapping = new HashMap<OlapHollowableMember, OlapMember>();
    private final ConcurrentHashMap<OlapFactMeasureGroupBaseManager, ConcurrentHashMap<Thread, N_FactPageResolvedMembersCache>> resolverCachesBP = new ConcurrentHashMap();
    @Nullable
    private final OlapSchemaFullLoadStats stats;
    private final Map<IOlapBuilderTabularDataDef, List<IOlapBuilderTablePartitionKey>> requestedTablePartitionKeys = new ConcurrentHashMap<IOlapBuilderTabularDataDef, List<IOlapBuilderTablePartitionKey>>();
    @Nullable
    private volatile IGCActivityListener gcListener;
    private IncrLoadSavePoints incrLoadSavePoints;
    private volatile boolean forFactProcessing;
    private int processingRowNumber = -1;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OlapBuilderContext(OlapEngineRequestContext requestContext, IOlapEngineLoadSchemaParams params, OlapBuilderContextMode mode, @Nullable IncrLoadPhase incrLoadPhase, @Nullable OlapSchema schema) {
        this.requestContext = requestContext;
        this.loggers = requestContext.getLoggers();
        this.mode = mode;
        this.keepMdxResultCache = params.isKeepMdxResultCache();
        this.continueBackupOnError = params.isContinueBackupOnError();
        this.schema = schema;
        this.incrLoadPhase = incrLoadPhase;
        boolean bl = this.incrLoadLogRows = incrLoadPhase != null && incrLoadPhase != IncrLoadPhase.FULL_LOAD && OlapLoggers.BUILDER_INCR_LOAD_ROWS.isDebugEnabled();
        if (schema != null) {
            if (OlapBuilderContextMode.UNLOAD_PARTITIONS == mode) {
                if (incrLoadPhase != null) {
                    throw new RuntimeException("internal error : unexpected schema [" + schema.getName() + "] incr-load phase [" + String.valueOf((Object)incrLoadPhase) + "]");
                }
                this.incrLoadSavePoints = null;
                this.baseNoBaseMapper = new OlapBuilderBaseToNoBaseMapper();
                this.keepBaseNoBaseMapper = false;
                this.unresolvedRows = null;
            } else if (OlapBuilderContextMode.LOAD_PARTITIONS == mode || OlapBuilderContextMode.LOAD_MEASURE_GROUPS == mode) {
                if (incrLoadPhase != null) {
                    throw new RuntimeException("internal error : unexpected schema [" + schema.getName() + "] incr-load phase [" + String.valueOf((Object)incrLoadPhase) + "]");
                }
                if (schema.getIncrementalLoad() == null) {
                    throw new OlapBuilderErrorException(OlapBuilderErrorCode.LOAD_PARTITIONS_MISSING_INCR_LOAD, new Serializable[0]);
                }
                this.baseNoBaseMapper = schema.getIncrementalLoad().getBaseMapper();
                this.keepBaseNoBaseMapper = true;
                OlapUnresolvedRowsManager uRows = schema.getUnresolvedRowsManager();
                this.unresolvedRows = new OlapUnresolvedRowsManager(uRows.getSchemaName(), uRows.getMaxRowCount());
            } else {
                if (OlapBuilderContextMode.FULL_LOAD != mode && OlapBuilderContextMode.INCR_LOAD != mode) throw new RuntimeException("internal error : unexpected schema [" + schema.getName() + "] building mode [" + String.valueOf((Object)mode) + "]");
                if (incrLoadPhase == null || incrLoadPhase == IncrLoadPhase.BUILDING_SCHEMA) {
                    throw new RuntimeException("internal error : unexpected schema [" + schema.getName() + "] incr-load phase [" + String.valueOf((Object)incrLoadPhase) + "]");
                }
                this.incrLoadSavePoints = schema.getIncrementalLoad();
                if (this.incrLoadSavePoints != null) {
                    this.baseNoBaseMapper = this.incrLoadSavePoints.getBaseMapper();
                    this.keepBaseNoBaseMapper = true;
                    this.incrLoadSavePoints.debugMarkers(this.loggers.incrLoad(), "load started");
                } else {
                    this.baseNoBaseMapper = new OlapBuilderBaseToNoBaseMapper();
                    this.keepBaseNoBaseMapper = false;
                }
                if ((incrLoadPhase == IncrLoadPhase.FULL_LOAD || incrLoadPhase == IncrLoadPhase.LOADING_DATA) && this.incrLoadSavePoints != null) {
                    this.incrLoadSavePoints.setPhase(incrLoadPhase);
                }
                this.unresolvedRows = null;
            }
        } else {
            this.incrLoadSavePoints = null;
            this.baseNoBaseMapper = new OlapBuilderBaseToNoBaseMapper();
            this.keepBaseNoBaseMapper = false;
            this.unresolvedRows = null;
        }
        OlapEngineOfflineMode olapEngineOfflineMode = this.offlineMode = params.getOfflineMode() == null ? OlapEngineOfflineMode.OFF : params.getOfflineMode();
        if (this.incrLoadSavePoints == null || this.incrLoadPhase() == IncrLoadPhase.FULL_LOAD) {
            this.offlineWriteHelper = this.offlineMode.isWriteActive() ? new OlapBuilderOfflineWriteHelper(this, params) : null;
            this.offlineReadHelper = this.offlineMode.isReadActive() ? new OlapBuilderOfflineReadHelper(this, params) : null;
        } else {
            this.offlineWriteHelper = null;
            this.offlineReadHelper = null;
        }
        this.cacheTableHelper = this.incrLoadSavePoints == null || this.incrLoadPhase() == IncrLoadPhase.FULL_LOAD ? new OlapBuilderRegularCacheTableHelper(this) : new OlapBuilderNilCacheTableHelper();
        this.restoreContext = this.setupRestoreContext(requestContext, params, mode, schema);
        this.backupContext = this.setupBackupContext(requestContext, params, mode, schema);
        OlapRuntimeContext runtimeContext = requestContext.asRuntimeContext();
        this.clusterContextRef = schema != null && mode != OlapBuilderContextMode.UNLOAD_PARTITIONS ? new S_BuildSchemaContextRef(requestContext.getRequestClientUUID(), OlapBuilderContext.setupClusterContextKind(mode, schema), schema, this.backupContext, this.restoreContext, runtimeContext, this) : null;
        this.stats = this.mode == OlapBuilderContextMode.FULL_LOAD ? new OlapSchemaFullLoadStats(requestContext.getOlapEngineProperties()) : null;
    }

    @Nullable
    private M_RestoreContext setupRestoreContext(OlapEngineRequestContext requestContext, IOlapEngineLoadSchemaParams params, OlapBuilderContextMode mode, @Nullable OlapSchema schema) {
        M_RestoreContext restoreContext;
        if (schema != null && params.isRestoreActivated() && requestContext.isBackupLicensed()) {
            try {
                M_BackupManager backupManager = requestContext.getOrCreateBackupManager();
                if (OlapBuilderContextMode.UNLOAD_PARTITIONS == mode) {
                    restoreContext = backupManager.onRestoreStarted(this, schema.getBackupDir(), params.getRestoringMode(), S_BackupMode.UNLOAD_PARTITIONS, params.getRestoreTimestamp());
                }
                if (OlapBuilderContextMode.LOAD_PARTITIONS == mode) {
                    restoreContext = backupManager.onRestoreStarted(this, schema.getBackupDir(), params.getRestoringMode(), S_BackupMode.LOAD_PARTITIONS, params.getRestoreTimestamp());
                }
                if (OlapBuilderContextMode.LOAD_MEASURE_GROUPS == mode) {
                    restoreContext = backupManager.onRestoreStarted(this, schema.getBackupDir(), params.getRestoringMode(), S_BackupMode.LOAD_MEASURE_GROUPS, params.getRestoreTimestamp());
                }
                if (OlapBuilderContextMode.INCR_LOAD == mode) {
                    if (!schema.hasClusterSchemaDef()) {
                        throw new RuntimeException("internal error : unexpected missing cluster definition for schema [" + schema.getName() + "]");
                    }
                    restoreContext = backupManager.onRestoreStarted(this, schema.getBackupDir(), params.getRestoringMode(), S_BackupMode.INCR_LOAD, params.getRestoreTimestamp());
                }
                if (schema.hasClusterSchemaDef()) {
                    throw new RuntimeException("internal error : unexpected schema [" + schema.getName() + "] cluster definition");
                }
                restoreContext = backupManager.onRestoreStarted(this, null, params.getRestoringMode(), S_BackupMode.FULL_LOAD, params.getRestoreTimestamp());
                CdVFileSystem vfs = requestContext.asRuntimeContext().getVfs();
                M_RestorePartitionManager restoringPartitionManager = new M_RestorePartitionManager(vfs, schema.getName(), params.getRestoringMode(), restoreContext.getDir());
                schema.setBackupDir(restoreContext.getDir(), true, restoringPartitionManager);
            }
            catch (IOException ex) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"could not setup the restoring backup context [" + schema.getName() + "] [" + String.valueOf(schema.getBackupDir()) + "]"});
            }
        } else {
            restoreContext = null;
        }
        return restoreContext;
    }

    @Nullable
    private M_BackupContext setupBackupContext(OlapEngineRequestContext requestContext, IOlapEngineLoadSchemaParams params, OlapBuilderContextMode mode, @Nullable OlapSchema schema) {
        try {
            M_BackupContext backupContext;
            if (schema != null && (schema.isBackupActivated() || schema.isBackuping() || params.isForceBackupOn()) && !schema.isBackupDisabledOnError() && requestContext.isBackupLicensed() && this.restoreContext == null) {
                M_BackupManager backupManager = requestContext.getOrCreateBackupManager();
                File backupDir = schema.getBackupDir();
                if (OlapBuilderContextMode.UNLOAD_PARTITIONS == mode) {
                    backupContext = backupDir != null ? backupManager.createBackupContext(this, backupDir, S_BackupMode.UNLOAD_PARTITIONS, params) : null;
                } else if (OlapBuilderContextMode.LOAD_PARTITIONS == mode) {
                    backupContext = backupDir != null ? backupManager.createBackupContext(this, backupDir, S_BackupMode.LOAD_PARTITIONS, params) : null;
                } else if (OlapBuilderContextMode.LOAD_MEASURE_GROUPS == mode) {
                    backupContext = backupDir != null ? backupManager.createBackupContext(this, backupDir, S_BackupMode.LOAD_MEASURE_GROUPS, params) : null;
                } else if (OlapBuilderContextMode.INCR_LOAD == mode) {
                    if (!schema.hasClusterSchemaDef()) {
                        throw new RuntimeException("internal error : unexpected missing cluster definition for schema [" + schema.getName() + "]");
                    }
                    backupContext = backupDir != null ? backupManager.createBackupContext(this, backupDir, S_BackupMode.INCR_LOAD, params) : null;
                } else {
                    if (schema.hasClusterSchemaDef()) {
                        throw new RuntimeException("internal error : unexpected schema [" + schema.getName() + "] cluster definition");
                    }
                    backupContext = backupManager.createBackupContext(this);
                    if (backupContext != null) {
                        schema.setBackupDir(backupContext.getDir(), false, null);
                    }
                }
            } else {
                backupContext = null;
            }
            return backupContext;
        }
        catch (RuntimeException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] backup could not be activated for schema [" + schema.getName() + "] mode [" + String.valueOf((Object)mode) + "] due to an unexpected error (backup *** disabled *** for this schema)"), (Throwable)ex);
            schema.disableBackupOnError();
            return null;
        }
    }

    private static S_BuildSchemaContextKind setupClusterContextKind(OlapBuilderContextMode mode, OlapSchema schema) {
        switch (mode) {
            case FULL_LOAD: {
                return S_BuildSchemaContextKind.FULL_LOAD;
            }
            case INCR_LOAD: {
                return S_BuildSchemaContextKind.INCREMENTAL_LOAD;
            }
            case LOAD_PARTITIONS: 
            case LOAD_MEASURE_GROUPS: {
                return S_BuildSchemaContextKind.PARTITION_LOAD;
            }
        }
        throw new RuntimeException("internal error : unexpected schema [" + schema.getName() + "] building mode [" + String.valueOf((Object)mode) + "]");
    }

    public OlapBuilderContextMode getMode() {
        return this.mode;
    }

    @Nullable
    public OlapUnresolvedRowsManager getUnresolvedRows() {
        return this.unresolvedRows;
    }

    public M_LocalCluster getCluster() {
        return this.requestContext.getCluster();
    }

    @Nullable
    public S_BuildSchemaContextRef getClusterContextRef() {
        return this.clusterContextRef;
    }

    public void createClusterContext(@Nullable IOlapFactListFactory factsColumnListFactory, @Nullable S_FactBitmapContainerFactory factsBitmapContainerFactory) {
        S_BuildSchemaContextKind kind;
        if (this.clusterContextRef == null) {
            return;
        }
        M_LocalCluster cluster = this.getCluster();
        S_BuildSchemaContextInitData data = this.clusterContextRef.createObjectInitData(factsColumnListFactory, factsBitmapContainerFactory);
        cluster.createBuildSchemaContext(data);
        if (this.schema == null) {
            throw new RuntimeException("internal error: inconsistent build schema context setup");
        }
        if (!this.schema.hasClusterSchemaDef()) {
            S_SchemaDef schemaDef = data.getSchemaDef();
            this.schema.setClusterDef(schemaDef);
        }
        if ((kind = data.getKind()) == S_BuildSchemaContextKind.FULL_LOAD) {
            for (OlapRegularCube cube : this.schema.getCubes()) {
                OlapFactCubeManager factManager = cube.getCubeFactManager();
                factManager.setupClusterInformation();
            }
        }
    }

    @Nullable
    public OlapSchemaFullLoadStats getFullLoadStats() {
        return this.stats;
    }

    public void onDimensionChanged(OlapSchema schema) {
        Logger logger = this.loggers.builder();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[builder] on-dimension-changed [schema:" + schema.getName() + "] [" + (this.clusterContextRef != null) + "]"));
        }
        if (this.clusterContextRef != null) {
            S_IncrLoadDimensionUpdateDef incrLoadUpdate = this.createClusterDimensionUpdate(schema);
            M_LocalCluster cluster = this.getCluster();
            N_OlapEngine engine = cluster.getEngine();
            S_HollowUpdate hollowUpdate = this.createHollowUpdate();
            engine.onDimensionChanged(this.clusterContextRef, incrLoadUpdate, hollowUpdate);
        }
    }

    private S_HollowUpdate createHollowUpdate() {
        S_HollowUpdate update = new S_HollowUpdate();
        this.forEachHollowPair(update::addUpdate);
        return update;
    }

    private S_IncrLoadDimensionUpdateDef createClusterDimensionUpdate(OlapSchema schema) {
        ArrayList<Integer> hierarchyIdx = new ArrayList<Integer>();
        ArrayList<Integer> hierarchyMaxMemberIdx = new ArrayList<Integer>();
        List<OlapDimension> dimensions = schema.getDimensions();
        for (int ii = 0; ii < dimensions.size(); ++ii) {
            OlapDimension dimension = dimensions.get(ii);
            List<OlapHierarchy> hierarchies = dimension.getHierarchies();
            int hierarchiesSize = hierarchies.size();
            for (int jj = 0; jj < hierarchiesSize; ++jj) {
                OlapHierarchy hierarchy = hierarchies.get(jj);
                hierarchyIdx.add(hierarchy.getTupleDimensionalityIndex());
                hierarchyMaxMemberIdx.add(hierarchy.getMaxUniqueMemberIndex());
            }
        }
        return new S_IncrLoadDimensionUpdateDef(hierarchyIdx, hierarchyMaxMemberIdx);
    }

    public void activateSchemaCluster() {
        if (this.clusterContextRef != null) {
            M_LocalCluster cluster = this.getCluster();
            N_OlapEngine engine = cluster.getEngine();
            engine.activateSchema(this.clusterContextRef);
        }
    }

    public OlapBuilderMetaInformationRepository getBuilderMetaInformationRepository() {
        OlapEngineComponent olapEngine = this.requestContext.getOlapEngineComponent();
        OlapBuilderMetaInformationRepository metaInfo = olapEngine.getBuilderMetaInformationRepository();
        return metaInfo;
    }

    public void setIncrLoadPhase(IncrLoadPhase incrLoadPhase) {
        if (this.incrLoadSavePoints != null) {
            this.incrLoadSavePoints.setPhase(incrLoadPhase);
        }
    }

    @Nullable
    public IncrLoadPhase incrLoadPhase() {
        return this.incrLoadSavePoints == null ? null : this.incrLoadSavePoints.getPhase();
    }

    @Override
    public boolean isIncrLoadActive() {
        return this.schema != null && this.schema.isIncrLoadActive();
    }

    public boolean isIncrLoad() {
        return this.incrLoadPhase != null && this.incrLoadPhase != IncrLoadPhase.FULL_LOAD;
    }

    public boolean isIncrLoadLogRows() {
        return this.incrLoadLogRows;
    }

    public OlapBuilderCacheTableHelper getCacheTableHelper() {
        return this.cacheTableHelper;
    }

    public OlapEngineRequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setForFactProcessing(boolean forFactProcessing) {
        this.forFactProcessing = forFactProcessing;
        if (this.backupContext != null) {
            this.backupContext.setFactProcessing(forFactProcessing);
        }
    }

    public void setForMany2ManyProcessing(boolean m2mProcessing) {
        if (this.backupContext != null) {
            this.backupContext.setForMany2ManyProcessing(m2mProcessing);
        }
    }

    public boolean isForFactsProcessing() {
        return this.forFactProcessing;
    }

    public boolean isForDataTableBrowsing() {
        return false;
    }

    @Override
    public OlapRequestId getRequestId() {
        return this.requestContext.getRequestId();
    }

    @Override
    public boolean isCancelling() {
        return this.requestContext != null && this.requestContext.isCancelling();
    }

    @Override
    public void assertNotCancelling(String message) {
        if (this.requestContext != null) {
            this.requestContext.assertNotCancelling(message);
        }
    }

    public OlapBuilderTableRowReadingTaskExecutor getBuilderReadingExecutor() {
        return this.requestContext.getBuilderLoadReadingExecutor();
    }

    public OlapBuilderTableRowProcessingTaskExecutor getBuilderProcessingExecutor() {
        return this.requestContext.getBuilderLoadProcessingExecutor();
    }

    @Nullable
    public OlapBuilderTableRowProcessingTaskExecutor getBuilderProcessingExecutorX() {
        return this.requestContext.getBuilderLoadProcessingExecutorX();
    }

    public int getMaxTablePartitionCount() {
        OlapProperties properties = this.requestContext.getOlapEngineProperties();
        return properties.getMaxTablePartitionCount();
    }

    public OlapFileCleaner getFileCleaner() {
        return this.requestContext.getFileCleaner();
    }

    public boolean isMmapFactsLicensed() {
        return this.requestContext.isMmapFactsLicensed();
    }

    public boolean isIncrLoadLicensed() {
        return this.requestContext.isIncrLoadLicensed();
    }

    public boolean isPerspectivesLicensed() {
        return this.requestContext.isPerspectivesLicensed();
    }

    public boolean isTablePartitioningLicensed() {
        return this.requestContext.isTablePartitioningLicensed();
    }

    public boolean isFactsPartitioningLicensed() {
        return this.requestContext.isFactsPartitioningLicensed();
    }

    public boolean isAllDataSourcesLicensed() {
        return this.requestContext.isAllDataSourcesLicensed();
    }

    public boolean isOfflineActive() {
        return this.offlineMode.isActive();
    }

    public boolean isOfflineReadActive() {
        return this.offlineMode.isReadActive();
    }

    public boolean isOfflineWriteActive() {
        return this.offlineMode.isWriteActive();
    }

    public boolean isOfflineWriteOnly() {
        return this.offlineMode == OlapEngineOfflineMode.WRITE_ONLY;
    }

    @Nullable
    public OlapBuilderOfflineWriteHelper getOfflineWriteHelper() {
        return this.offlineWriteHelper;
    }

    @Nullable
    public OlapBuilderOfflineReadHelper getOfflineReadHelper() {
        return this.offlineReadHelper;
    }

    public void onBuildStarted() {
        if (this.offlineWriteHelper != null) {
            this.offlineWriteHelper.onBuildStarted();
        }
        if (this.offlineReadHelper != null) {
            this.offlineReadHelper.onBuildStarted();
        }
        if (this.mode == OlapBuilderContextMode.FULL_LOAD) {
            OlapEngineRequestContext eContext = this.getEngineContext();
            OlapEngineApplicationContext aContext = eContext.getApplicationContext();
            this.gcListener = (name, elapsedMS, freeM, totalM, maxM) -> {
                OlapSchemaStatsHolder statsH;
                if (this.schema != null && (statsH = this.schema.getStatsHolder()) != null) {
                    statsH.onGCActivity(name, elapsedMS, freeM, totalM, maxM);
                }
            };
            aContext.addGCActivityListener(this.gcListener);
        }
    }

    public void onIncrLoadWithErrorPhaseI() {
        if (this.backupContext != null) {
            this.backupContext.onIncrLoadWithErrorPhaseI();
        }
    }

    public void onIncrLoadWithoutData() {
        if (this.backupContext != null) {
            this.backupContext.onIncrLoadWithoutData();
        }
    }

    @Override
    public void onSchemaProcessingOnError() {
        if (this.schema != null) {
            OlapEngineComponent olapEngine = this.requestContext.getOlapEngineComponent();
            olapEngine.loadSchemaOnError(this.requestContext, this.schema);
        }
        if (this.offlineWriteHelper != null) {
            this.offlineWriteHelper.onError();
        }
    }

    public void onSchemaProcessingOnErrorCleanup() {
        try {
            if (this.schema != null) {
                OlapEngineComponent olapEngine = this.requestContext.getOlapEngineComponent();
                olapEngine.loadSchemaOnErrorCleanup(this.requestContext, this.schema);
            }
        }
        catch (Exception ex) {
            OlapLoggers.BUILDER.warn((Object)"[builder] could not properly clean up the schema's resources", (Throwable)ex);
        }
    }

    public void onLoadPartitionAdopted() {
        if (this.backupContext != null) {
            this.backupContext.onLoadPartitionAdopted();
        }
    }

    @Override
    public void onSchemaProcessingCompleted() {
        if (this.incrLoadSavePoints != null) {
            this.incrLoadSavePoints.debugMarkers(this.loggers.incrLoad(), "schema processing completed");
        }
        if (!this.keepBaseNoBaseMapper && this.baseNoBaseMapper != null) {
            this.baseNoBaseMapper.clear();
            if (this.schema != null) {
                this.schema.clearMany2ManyAndBridges();
            }
        }
        if (this.offlineWriteHelper != null) {
            this.offlineWriteHelper.onBuildSchemaDone();
        }
        if (this.backupContext != null) {
            this.backupContext.onBuildCompleted();
        }
    }

    @Override
    public void onSchemaProcessingDone(boolean succeeded) {
        if (this.schema != null) {
            OlapEngineRequestContext olapEngineRequestContext = this.requestContext;
            OlapEngineComponent olapEngine = this.requestContext.getOlapEngineComponent();
            olapEngine.loadSchemaDone(olapEngineRequestContext, this.schema);
        }
        if (this.offlineWriteHelper != null && this.schema != null) {
            this.offlineWriteHelper.onBuildDone(this.schema);
        }
        this.cacheTableHelper.cleanupTableCache();
        IGCActivityListener listener = this.gcListener;
        if (listener != null) {
            OlapEngineRequestContext eContext = this.getEngineContext();
            OlapEngineApplicationContext aContext = eContext.getApplicationContext();
            aContext.removeGCActivityListener(listener);
            this.gcListener = null;
        }
    }

    public void onSchemaCompletedPhaseII(boolean succeeded) {
        try {
            if (this.backupContext != null && this.schema != null) {
                this.backupContext.onBuildFinally(this.schema, succeeded);
            }
        }
        catch (RuntimeException unexpected) {
            OlapLoggers.BUILDER.warn((Object)"unexpected error on schema backup done", (Throwable)unexpected);
        }
    }

    @Override
    public void onDimensionProcessingCompleted(OlapDimension dimension) {
        dimension.onFinishBuild(this.isIncrLoad(), this.isIncrLoadActive());
    }

    @Override
    public void onAllDimensionsProcessingCompleted() {
        if (this.baseNoBaseMapper != null) {
            this.baseNoBaseMapper.onDimensionLoadDone();
            if (this.schema != null) {
                this.schema.onAllDimensionsProcessingCompleted();
                this.schema.getAutoExistContainer().build(this, this.baseNoBaseMapper, this.hollowRemapping);
            }
        }
    }

    public void onFactsProcessingStarted() {
        OlapSchemaStatsHolder statsH;
        if (this.schema != null && (statsH = this.schema.getStatsHolder()) != null) {
            statsH.onFactsProcessingStarted();
        }
    }

    @Override
    public void onFactsProcessingCompleted(OlapFactMeasureGroupBaseManager facts) {
        ConcurrentHashMap<Thread, N_FactPageResolvedMembersCache> caches = this.resolverCachesBP.remove(facts);
        if (caches != null) {
            for (N_FactPageResolvedMembersCache cache : caches.values()) {
                cache.onProcessingCompleted();
            }
            caches.clear();
        }
        OlapFileCleaner fileCleaner = this.requestContext.getFileCleaner();
        facts.onProcessFactsCompleted(this, fileCleaner);
    }

    public void onIncrLoadFactsProcessingCompleted(OlapFactMeasureGroupBaseManager factsManager) {
        factsManager.onIncrLoadProcessFactsCompleted(this);
    }

    public void commitBridgesDiff() {
        if (this.schema != null) {
            this.schema.commitBridgesDiff();
        }
    }

    public File getTmpDirectory() {
        return this.requestContext.getApplicationContext().getTmpDirectory();
    }

    public OlapMember addMember(OlapLevel level, OlapMember member) {
        level.addMember(member, false);
        if (member.getKey() == null) {
            throw new CdProgrammingException("missing key for member : " + ONames.uname4Log(member));
        }
        return member;
    }

    public void addNoBaseBaseLink(OlapMember noBaseMember, OlapMember baseMember) {
        if (noBaseMember.getHierarchy().isBase()) {
            throw new CdProgrammingException("inconsistent member [" + ONames.name4Log(noBaseMember) + "]");
        }
        boolean add = true;
        if (this.baseNoBaseMapper != null) {
            add = this.baseNoBaseMapper.addLink(baseMember, noBaseMember);
        }
        if (add) {
            noBaseMember.addBaseHierarchyChild(this, baseMember);
        }
    }

    @Nullable
    public OlapMember lookupMember(OlapLevel level, @Nullable OlapMemberKey key) {
        if (key == null) {
            return null;
        }
        OlapMember member = level.lookupMemberByKeyValue(key.asJavaNativeValue());
        return member;
    }

    @Nullable
    public OlapMember lookupMember(OlapLevel level, String name) {
        OlapMember member = level.lookupMemberByName(name);
        return member;
    }

    public void onRestorePartitionStarted(String tableName, String partitionName, Date timestamp) {
        if (this.requestContext != null) {
            this.requestContext.onTableReadStarted(true, tableName, 1, timestamp);
            this.requestContext.onTablePartitionReadStarted(true, tableName, partitionName, timestamp);
        }
    }

    public void onRestorePartitionCompleted(String tableName, String partitionName, Date timestamp, long rowCount) {
        if (this.requestContext != null) {
            this.requestContext.onTablePartitionReadCompleted(true, tableName, partitionName, timestamp, rowCount);
            this.requestContext.onTableReadCompleted(this, true, tableName, timestamp, rowCount);
            this.requestContext.onTablePartitionProcessingCompleted(true, tableName, partitionName, timestamp);
            this.requestContext.onTableProcessingCompleted(this, true, tableName, timestamp, rowCount);
        }
    }

    public void onTableReadStarted(String tableName, int partitionCount, Date timestamp) {
        if (this.requestContext != null) {
            this.requestContext.onTableReadStarted(this.forFactProcessing, tableName, partitionCount, timestamp);
        }
    }

    public void onTablePartitionReadStarted(String tableName, String partitionName, Date timestamp) {
        if (this.requestContext != null) {
            this.requestContext.onTablePartitionReadStarted(this.forFactProcessing, tableName, partitionName, timestamp);
        }
    }

    public void onTablePartitionReadProgress(String tableName, String partitionName, Date timestamp, long readRowCount, int readRowCountPerSec, int processingQueuedTaskCount, long processingQueueTaskSize) {
        if (this.requestContext != null) {
            this.requestContext.onTablePartitionReadProgress(this.forFactProcessing, tableName, partitionName, timestamp, readRowCount, readRowCountPerSec, processingQueuedTaskCount, processingQueueTaskSize);
        }
    }

    public void onTablePartitionReadCompleted(String tableName, String partitionName, Date timestamp, long rowCount) {
        if (this.requestContext != null) {
            this.requestContext.onTablePartitionReadCompleted(this.forFactProcessing, tableName, partitionName, timestamp, rowCount);
        }
    }

    public void onTablePartitionProcessingCompleted(String tableName, String partitionName, Date timestamp) {
        if (this.requestContext != null) {
            this.requestContext.onTablePartitionProcessingCompleted(this.forFactProcessing, tableName, partitionName, timestamp);
        }
    }

    public void onTableReadCompleted(String tableName, Date timestamp, long rowCount) {
        if (this.requestContext != null) {
            this.requestContext.onTableReadCompleted(this, this.forFactProcessing, tableName, timestamp, rowCount);
        }
    }

    public void onTableProcessingCompleted(String tableName, Date timestamp, long rowCount) {
        if (this.requestContext != null) {
            this.requestContext.onTableProcessingCompleted(this, this.forFactProcessing, tableName, timestamp, rowCount);
        }
    }

    public void onProgressEvent(String messageTag, Serializable ... params) {
        if (this.requestContext != null) {
            this.requestContext.onProgressEvent(messageTag, params);
        }
    }

    public void onProgressPhase(String messageTag, Serializable ... params) {
        if (this.requestContext != null) {
            this.requestContext.onProgressPhase(messageTag, params);
        }
    }

    public OlapSchema getSchema() {
        if (this.schema == null) {
            throw new RuntimeException("internal error: inconsistent usage of builder context (missing schema)");
        }
        return this.schema;
    }

    public OlapEngineRequestContext getEngineContext() {
        return this.requestContext;
    }

    @Nullable
    public OlapBuilderBaseToNoBaseMapper getBaseMemberToMemberMap() {
        return this.baseNoBaseMapper;
    }

    public void onProcessingTableRowStart(IOlapBuilderDataTableDef dataTable) {
        if (this.incrLoadSavePoints != null) {
            this.incrLoadSavePoints.onFullLoadStartDataProcessing(this, dataTable);
        }
    }

    @Nullable
    public IncrLoadSavePoints getIncrLoadTableSavePoints() {
        return this.incrLoadSavePoints;
    }

    @Nullable
    public IncrLoadTableSavePoint getIncrLoadTableSavePoint(IOlapBuilderDataTableDef table) {
        if (this.incrLoadSavePoints != null) {
            return this.incrLoadSavePoints.getIncrLoadTableSavePoint(table.getId());
        }
        return null;
    }

    @Nullable
    public Comparable getIncrementalLoadMarker(IOlapBuilderDataTableDef table) {
        IncrLoadSavePoints myIncrLoad = this.incrLoadSavePoints;
        if (myIncrLoad == null || myIncrLoad.getPhase() == IncrLoadPhase.FULL_LOAD) {
            return null;
        }
        Comparable marker = myIncrLoad.getIncrementalLoadMarker(table);
        if (this.getLoggers().incrLoad().isDebugEnabled()) {
            this.getLoggers().incrLoad().debug((Object)("[incr-load] marker [" + String.valueOf(marker) + "] for table [" + table.getName() + "] [" + table.getId() + "]"));
        }
        return marker;
    }

    public void __setIncrLoadSavePointForTest(IncrLoadSavePoints incrLoad) {
        this.incrLoadSavePoints = incrLoad;
    }

    public void __setIncrLoadInfoForTest(OlapSchemaIncrLoadInfo incrLoadInfo) {
        this.requestContext.__setIncrLoadedInfoPhaseII(incrLoadInfo);
    }

    public OlapNameContext getNameContext() {
        return OlapDefaultNamesContext.SINGLETON;
    }

    public IOlapContextLoggers getLoggers() {
        return this.loggers;
    }

    public void reportUnresolvedRow(@Nullable OlapCube cube, IOlapBuilderBaseFactsDef factsDefinition, IOlapBuilderTabularDataDef tabularData, @Nullable IOlapBuilderTablePartitionKey partition, IOlapBuilderTableRow row) {
        if (this.schema != null) {
            OlapUnresolvedRowsManager uRows;
            if (this.mode == OlapBuilderContextMode.LOAD_PARTITIONS || this.mode == OlapBuilderContextMode.LOAD_MEASURE_GROUPS) {
                if (this.unresolvedRows == null) {
                    throw new RuntimeException("internal error: missing unresolved rows manager (PHASE I) for schema [" + this.schema.getName() + "]");
                }
                uRows = this.unresolvedRows;
            } else {
                uRows = this.schema.getUnresolvedRowsManager();
            }
            uRows.reportUnresolvedRow(this, cube, factsDefinition, tabularData, partition, row);
        }
    }

    public OlapLevel getLevelByName(OlapMultiLevelHierarchy olapHierarchy, String lookupLevel) {
        List<OlapLevel> levels = olapHierarchy.getLevels();
        int size = levels.size();
        for (int i = 0; i < size; ++i) {
            OlapLevel level = levels.get(i);
            if (!lookupLevel.equals(level.getCreationName())) continue;
            return level;
        }
        throw new CdProgrammingException();
    }

    public boolean handleErrors() {
        return false;
    }

    public void onError(OlapBuilderErrorException ex) throws OlapBuilderErrorException {
        throw ex;
    }

    public IOlapBuilderTableRowReader decorateRowReaderForBackup(IOlapBuilderTableRowReader reader, boolean tablePartition) {
        if (this.backupContext == null) {
            return reader;
        }
        reader = this.backupContext.decorateTableReaderForBackup(reader, tablePartition);
        return reader;
    }

    public void setupUnloadPartitionForBackup(M_FactsLocalMeasureGroupManager measureGroup, M_FactsLocalPartition partition) {
        if (this.backupContext == null) {
            return;
        }
        this.backupContext.setupUnloadPartitionForBackup(measureGroup, partition);
    }

    public void setupPartitionForBackup(M_FactsLocalMeasureGroupManager measureGroup, M_FactsLocalPartition partition) {
        if (this.backupContext == null) {
            return;
        }
        this.backupContext.setupPartitionForBackup(measureGroup, partition);
    }

    public boolean isBackuping() {
        return this.backupContext != null;
    }

    public boolean isRestoring() {
        return this.restoreContext != null;
    }

    @Nullable
    public IOlapBuilderTableRowReader createRowReaderForRestore(OlapBuilderBaseDataTable table, boolean tablePartition) {
        if (this.restoreContext == null) {
            return null;
        }
        M_RestoreRowReader reader = this.restoreContext.createRowReaderForRestore(table, tablePartition);
        return reader;
    }

    public void saveBridges() {
        if (this.backupContext != null) {
            this.backupContext.saveBridges();
        }
    }

    public void restoreBridges() {
        if (this.restoreContext != null) {
            this.restoreContext.restoreBridges();
        }
    }

    public void restoreFacts(@Nullable List<OlapRegularCube> cubes) {
        if (this.restoreContext == null) {
            throw new RuntimeException("internal error: missing restore context [" + (this.schema != null ? this.schema.getName() : "") + "]");
        }
        this.restoreContext.restoreFacts(cubes);
    }

    public void restoreFactsContent() {
        if (this.restoreContext == null) {
            throw new RuntimeException("internal error: missing restore context [" + (this.schema != null ? this.schema.getName() : "") + "]");
        }
        this.restoreContext.restoreFactsContent();
    }

    public void restoreIncrLoadSavePoints(List<IOlapBuilderDataTableDef> allTables) {
        if (this.restoreContext == null) {
            throw new RuntimeException("internal error: missing restore context [" + (this.schema != null ? this.schema.getName() : "") + "]");
        }
        this.restoreContext.restoreIncrLoadSavePoints(allTables);
    }

    public void restoreCubesUnresolvedRows(IOlapBuilderDataTableDef factsTable) {
        this.restoreCubesUnresolvedRows(Collections.singletonList(factsTable));
    }

    public void restoreCubesUnresolvedRows(Collection<IOlapBuilderDataTableDef> factsTables) {
        if (this.restoreContext == null) {
            throw new RuntimeException("internal error: missing restore context [" + (this.schema != null ? this.schema.getName() : "") + "]");
        }
        if ((this.mode == OlapBuilderContextMode.LOAD_PARTITIONS || this.mode == OlapBuilderContextMode.LOAD_MEASURE_GROUPS) && this.unresolvedRows == null) {
            throw new RuntimeException("internal error: missing unresolved rows manager (PHASE I) for schema [" + (this.schema != null ? this.schema.getName() : "null") + "]");
        }
        this.restoreContext.restoreCubesUnresolvedRows(this.unresolvedRows, factsTables);
    }

    public void restoreM2MsUnresolvedRows(List<IOlapBuilderDataTableDef> factsTables) {
        if (this.restoreContext == null) {
            throw new RuntimeException("internal error: missing restore context [" + (this.schema != null ? this.schema.getName() : "") + "]");
        }
        this.restoreContext.restoreM2MsUnresolvedRows(this.unresolvedRows, factsTables);
    }

    public Map<IOlapBuilderTabularDataDef, List<IOlapBuilderTablePartitionKey>> getRequestedTablePartitionKeys() {
        return this.requestedTablePartitionKeys;
    }

    public void setRequestedTablePartitionKeys(IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderTablePartitionKey> keys) {
        this.requestedTablePartitionKeys.computeIfAbsent(tabularData, key -> keys);
    }

    public void setOfflineSnapshotTimestamp(long timestamp) {
        if (this.schema != null) {
            OlapSchemaInformation info = this.schema.getInformation();
            info.setOfflineSnapshotTimestamp(timestamp);
        }
    }

    public boolean isIncrLoadWithMdxResultCache() {
        return this.keepMdxResultCache;
    }

    public void setupRebuildMdxResultCacheInfos() {
        if (this.isIncrLoadWithMdxResultCache()) {
            this.requestContext.setupRebuildMdxResultCacheInfos();
        }
    }

    public void onRemoveHollow(OlapHollowableMember member, OlapMember formerFactIndexingMember) {
        if (this.isIncrLoad()) {
            this.hollowRemapping.put(member, formerFactIndexingMember);
        }
    }

    public void forEachHollowPair(BiConsumer<? super OlapMember, ? super OlapMember> consumer) {
        this.hollowRemapping.forEach(consumer);
    }

    public boolean isJavaViewActivated() {
        return this.requestContext.isJavaViewActivated();
    }

    public void assertJavaViewActivated() {
        if (!this.isJavaViewActivated()) {
            OlapLoggers.BUILDER_VIEW_JAVASCRIPT.error((Object)"[builder] java views are not activated");
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DATA_VIEW_JAVA_NOT_ACTIVATED, new Serializable[0]);
        }
    }

    public int getProcessingRowNumber() {
        return this.processingRowNumber;
    }

    public void setProcessingRowNumber(int rowNb) {
        this.processingRowNumber = rowNb;
    }

    public void forEachNoBaseMembers(OlapMember baseMember, CdAction<OlapMember> action) {
        if (this.baseNoBaseMapper != null) {
            if (baseMember.getDimension().getHierarchyCount() > 1) {
                this.baseNoBaseMapper.forEachNoBaseMembers(baseMember, action);
            }
        } else {
            baseMember.getDimension().forEachNoBaseTerminalMember(baseMember, action);
        }
    }

    public N_FactPageResolvedMembersCache getOrCreateResolverCacheBP(OlapBuilderBaseFactBuilder builder, Thread thread) {
        OlapFactMeasureGroupBaseManager facts = builder.getFacts();
        ConcurrentHashMap<Thread, N_FactPageResolvedMembersCache> caches = this.resolverCachesBP.get(facts);
        if (caches == null) {
            caches = this.createResolverCachesBP(facts);
        }
        N_FactPageResolvedMembersCache cache = this.getOrCreateResolverCacheBP(caches, builder, thread);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentHashMap<Thread, N_FactPageResolvedMembersCache> createResolverCachesBP(OlapFactMeasureGroupBaseManager facts) {
        ConcurrentHashMap<OlapFactMeasureGroupBaseManager, ConcurrentHashMap<Thread, N_FactPageResolvedMembersCache>> concurrentHashMap = this.resolverCachesBP;
        synchronized (concurrentHashMap) {
            ConcurrentHashMap<Thread, N_FactPageResolvedMembersCache> caches = this.resolverCachesBP.get(facts);
            if (caches != null) {
                return caches;
            }
            caches = new ConcurrentHashMap();
            this.resolverCachesBP.put(facts, caches);
            return caches;
        }
    }

    private N_FactPageResolvedMembersCache getOrCreateResolverCacheBP(ConcurrentHashMap<Thread, N_FactPageResolvedMembersCache> caches, OlapBuilderBaseFactBuilder builder, Thread thread) {
        N_FactPageResolvedMembersCache cache = caches.get(thread);
        if (cache != null) {
            return cache;
        }
        return this.createResolverCacheBP(caches, builder, thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private N_FactPageResolvedMembersCache createResolverCacheBP(ConcurrentHashMap<Thread, N_FactPageResolvedMembersCache> caches, OlapBuilderBaseFactBuilder builder, Thread thread) {
        ConcurrentHashMap<Thread, N_FactPageResolvedMembersCache> concurrentHashMap = caches;
        synchronized (concurrentHashMap) {
            N_FactPageResolvedMembersCache cache = caches.get(thread);
            if (cache != null) {
                return cache;
            }
            cache = new N_FactPageResolvedMembersCache(builder);
            caches.put(thread, cache);
            return cache;
        }
    }

    public boolean isContinueBackupOnLoadPartitionsOnError() {
        return this.continueBackupOnError;
    }

    public OlapRuntimeContext asRuntimeContext() {
        return this.requestContext.asRuntimeContext();
    }

    public boolean hasMemberPropertyConsistencyCheck() {
        return this.schema.hasMemberPropertyConsistencyCheck();
    }

    public long memberMapperRamSize() {
        if (this.baseNoBaseMapper != null) {
            return this.baseNoBaseMapper.sizeOf();
        }
        return 0L;
    }
}

