/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderConnectionPool {
    public static final Logger LOGGER = OlapLoggers.BUILDER;
    private final Map<IOlapBuilderDataSource, List<IOlapBuilderConnection>> availableConnections = new HashMap<IOlapBuilderDataSource, List<IOlapBuilderConnection>>();
    private final List<IOlapBuilderConnection> usedConnections = new ArrayList<IOlapBuilderConnection>();

    public synchronized int getConnectionCount() {
        int count = this.usedConnections.size();
        for (List<IOlapBuilderConnection> connections : this.availableConnections.values()) {
            count += connections.size();
        }
        return count;
    }

    public synchronized <CONNECTION extends IOlapBuilderConnection> CONNECTION getOrCreateOpenedConnection(IOlapBuilderDataSource<CONNECTION> dataSource) {
        return this.getOrCreateOpenedConnection(null, dataSource);
    }

    public synchronized <CONNECTION extends IOlapBuilderConnection> CONNECTION getOrCreateOpenedConnection(OlapRuntimeContext context, IOlapBuilderDataSource<CONNECTION> dataSource) {
        Object connection;
        List<IOlapBuilderConnection> connections = this.availableConnections.get(dataSource);
        if (connections == null) {
            connections = new ArrayList<IOlapBuilderConnection>();
            this.availableConnections.put(dataSource, connections);
        }
        if (connections.isEmpty()) {
            connection = dataSource.createConnection(context, true);
            connection.open(context);
        } else {
            connection = connections.remove(0);
        }
        this.usedConnections.add((IOlapBuilderConnection)connection);
        return (CONNECTION)connection;
    }

    public synchronized <CONNECTION extends IOlapBuilderConnection> void releaseOpenedConnection(@Nullable CONNECTION connection) {
        if (connection == null) {
            return;
        }
        if (!connection.isInvalid()) {
            IOlapBuilderDataSource dataSource = connection.getDataSource();
            List<IOlapBuilderConnection> connections = this.availableConnections.get(dataSource);
            if (connections == null) {
                throw new CdProgrammingException("internal error : missing available connections for datasource");
            }
            if (connections.contains(connection)) {
                throw new CdProgrammingException("internal error : duplicated released connections");
            }
            connections.add(connection);
        } else {
            try {
                connection.close();
            }
            catch (RuntimeException ignored) {
                LOGGER.warn((Object)"[conn-pool] error while closing an invalid connection", (Throwable)ignored);
            }
        }
        boolean removed = this.usedConnections.remove(connection);
        if (!removed) {
            throw new CdProgrammingException("internal error : missing used connection");
        }
    }

    public synchronized void close() {
        Collection<List<IOlapBuilderConnection>> values = this.availableConnections.values();
        for (List<IOlapBuilderConnection> connections : values) {
            int size = connections.size();
            for (int ii = 0; ii < size; ++ii) {
                IOlapBuilderConnection connection = connections.get(ii);
                connection.close();
            }
        }
        this.availableConnections.clear();
        int size = this.usedConnections.size();
        for (int ii = 0; ii < size; ++ii) {
            IOlapBuilderConnection connection = this.usedConnections.get(ii);
            LOGGER.warn((Object)("[conn-pool] closing a not-released connection : " + connection.toString()));
            connection.close();
        }
        this.usedConnections.clear();
    }
}

