/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder;

import crazydev.common.collection.CdAction;
import crazydev.common.collection.CdArrayList;
import crazydev.common.collection.CdIIntArrayList;
import crazydev.common.collection.CdIntArrayList;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.utils.CdPackedBitList;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderBaseToNoBaseMapper {
    private static long SHALLOW_SIZE_OF = -1L;
    private final AtomicInteger nextBaseToNoBaseIndex = new AtomicInteger(0);
    private final Map<OlapHierarchy, Integer> hierarchyIndices = new ConcurrentHashMap<OlapHierarchy, Integer>();
    private final CdArrayList<HierarchyMapper> hierarchyMappers = new CdArrayList();

    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        size += CdRamUsageEstimator.shallowSizeOfEx(this.hierarchyMappers);
        for (HierarchyMapper hierarchyMapper : this.hierarchyMappers) {
            if (hierarchyMapper == null) continue;
            size += hierarchyMapper.sizeOf();
        }
        return size;
    }

    public void clear() {
        this.hierarchyMappers.clear();
    }

    private int getHierarchyIndex(OlapHierarchy hierarchy) {
        return this.hierarchyIndices.computeIfAbsent(hierarchy, h -> this.nextBaseToNoBaseIndex.getAndIncrement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLink(OlapMember baseMember, OlapMember noBaseMember) {
        OlapHierarchy noBaseHierarchy = noBaseMember.getHierarchy();
        if (noBaseHierarchy.isHollow()) {
            return true;
        }
        int noBaseHierarchyIndex = this.getHierarchyIndex(noBaseHierarchy);
        HierarchyMapper mapper = null;
        CdArrayList<HierarchyMapper> cdArrayList = this.hierarchyMappers;
        synchronized (cdArrayList) {
            mapper = (HierarchyMapper)this.hierarchyMappers.getExtra(noBaseHierarchyIndex, null);
            if (mapper == null) {
                mapper = new HierarchyMapper(noBaseHierarchy);
                this.hierarchyMappers.set(noBaseHierarchyIndex, (Object)mapper);
            }
        }
        boolean ret = mapper.addLink(baseMember, noBaseMember);
        this.handleNoTerminalMembersLinking(baseMember, noBaseMember, mapper);
        return ret;
    }

    private void handleNoTerminalMembersLinking(OlapMember baseMember, OlapMember noBaseMember, HierarchyMapper mapper) {
        for (OlapMember parent = baseMember.getParent(); parent != null && !parent.isAll(); parent = parent.getParent()) {
            if (!parent.getLevel().isFactIndexing()) continue;
            mapper.addLink(parent, noBaseMember);
        }
    }

    public void forEachNoBaseMembers(OlapMember baseMember, CdAction<OlapMember> action) {
        List<OlapHierarchy> hierarchies = baseMember.getDimension().getHierarchies();
        int size = hierarchies.size();
        for (int i = 0; i < size; ++i) {
            OlapHierarchy hierarchy = hierarchies.get(i);
            int hierarchyIndex = this.getHierarchyIndex(hierarchy);
            HierarchyMapper mapper = (HierarchyMapper)this.hierarchyMappers.getExtra(hierarchyIndex, null);
            if (mapper == null) continue;
            mapper.forEach(baseMember, action);
        }
    }

    public void onDimensionLoadDone() {
        this.hierarchyMappers.trimToSize();
        int size = this.hierarchyMappers.size();
        for (int ii = 0; ii < size; ++ii) {
            HierarchyMapper hierarchyMapper = (HierarchyMapper)this.hierarchyMappers.get(ii);
            if (hierarchyMapper == null) continue;
            hierarchyMapper.trimToSize();
        }
    }

    @Nullable
    public HierarchyMapper get(OlapHierarchy noBaseHierarchy) {
        return (HierarchyMapper)this.hierarchyMappers.getExtra(this.getHierarchyIndex(noBaseHierarchy), null);
    }

    public static class HierarchyMapper {
        private static long SHALLOW_SIZE_OF = -1L;
        private final OlapHierarchy noBaseHierarchy;
        private final CdArrayList<CdArrayList<LevelCache>> bigMap = new CdArrayList();

        private HierarchyMapper(OlapHierarchy noBaseHierarchy) {
            this.noBaseHierarchy = noBaseHierarchy;
        }

        public long sizeOf() {
            long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
            size += CdRamUsageEstimator.shallowSizeOfEx(this.bigMap);
            for (CdArrayList map : this.bigMap) {
                if (map == null) continue;
                size += CdRamUsageEstimator.shallowSizeOfEx((ArrayList)map);
                for (LevelCache cache : map) {
                    if (cache == null) continue;
                    size += cache.sizeOf();
                }
            }
            return size;
        }

        private boolean addLink(OlapMember baseMember, OlapMember noBaseMember) {
            LevelCache levelCache;
            OlapLevel noBaseLevel = noBaseMember.getLevel();
            OlapLevel baseLevel = baseMember.getLevel();
            CdArrayList map = (CdArrayList)this.bigMap.getExtra(baseLevel.getDepth(), null);
            if (map == null) {
                map = new CdArrayList();
                this.bigMap.set(baseLevel.getDepth(), (Object)map);
            }
            if ((levelCache = (LevelCache)map.getExtra(noBaseLevel.getDepth(), null)) == null) {
                levelCache = new LevelCache(baseLevel, noBaseLevel);
                map.set(noBaseLevel.getDepth(), (Object)levelCache);
            }
            return levelCache.addLink(baseMember, noBaseMember);
        }

        public void forEach(BaseNoBaseLink action) {
            this.bigMap.forEach(levelCaches -> levelCaches.forEach(levelCache -> levelCache.forEach(action)));
        }

        private void forEach(OlapMember baseMember, CdAction<OlapMember> action) {
            CdArrayList map = (CdArrayList)this.bigMap.getExtra(baseMember.getLevel().getDepth(), null);
            if (map != null) {
                int size = map.size();
                for (int i = 0; i < size; ++i) {
                    LevelCache levelCache = (LevelCache)map.get(i);
                    if (levelCache == null) continue;
                    levelCache.forEach(baseMember, action);
                }
            }
        }

        private void trimToSize() {
            this.bigMap.trimToSize();
            for (CdArrayList map : this.bigMap) {
                if (map == null) continue;
                map.trimToSize();
                for (LevelCache levelCache : map) {
                    if (levelCache == null) continue;
                    levelCache.trimToSize();
                }
            }
        }

        @FunctionalInterface
        public static interface BaseNoBaseLink {
            public void onLink(OlapMember var1, OlapMember var2);
        }
    }

    private static class LevelCache {
        private static long SHALLOW_SIZE_OF = -1L;
        private final OlapLevel baseLevel;
        private final OlapLevel noBaseLevel;
        @Nullable
        private CdIIntArrayList simpleMapper = new CdIntArrayList();
        @Nullable
        private CdArrayList<Object> many2ManyMapper = null;

        public LevelCache(OlapLevel baseLevel, OlapLevel noBaseLevel) {
            this.baseLevel = baseLevel;
            this.noBaseLevel = noBaseLevel;
        }

        public long sizeOf() {
            long size;
            long l = size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
            if (this.simpleMapper != null) {
                size += this.simpleMapper.sizeOf();
            }
            if (this.many2ManyMapper != null) {
                size += CdRamUsageEstimator.shallowSizeOfEx(this.many2ManyMapper);
                for (Object m2m : this.many2ManyMapper) {
                    if (m2m == null) continue;
                    if (m2m instanceof CdIntArrayList) {
                        size += ((CdIntArrayList)m2m).sizeOf();
                        continue;
                    }
                    if (!(m2m instanceof Integer)) continue;
                    size += CdRamUsageEstimator.sizeOf((Integer)((Integer)m2m));
                }
            }
            return size;
        }

        public void forEach(OlapMember baseMember, CdAction<OlapMember> action) {
            int baseIdx = this.getMemberIdx(baseMember);
            if (this.simpleMapper != null) {
                this.forEachSimple(action, baseIdx);
            } else {
                this.forEachMany2Many(action, baseIdx);
            }
        }

        private int getMemberIdx(OlapMember baseMember) {
            return baseMember.getDataHandlerIdx() + 1;
        }

        private void forEachSimple(CdAction<OlapMember> action, int baseIdx) {
            int pos = this.simpleMapper.getInt(baseIdx);
            if (pos > 0) {
                OlapMember member = this.noBaseLevel.getMemberAtDataIdx(pos - 1);
                action.apply((Object)member);
            }
        }

        private void forEachMany2Many(CdAction<OlapMember> action, int baseIdx) {
            Object item = this.many2ManyMapper.getExtra(baseIdx, null);
            if (item != null) {
                if (item instanceof CdIntArrayList) {
                    CdIntArrayList list = (CdIntArrayList)item;
                    for (int i = 0; i < list.size(); ++i) {
                        int pos = list.getInt(i);
                        OlapMember member = this.noBaseLevel.getMemberAtDataIdx(pos - 1);
                        action.apply((Object)member);
                    }
                } else {
                    int pos = (Integer)item;
                    OlapMember member = this.noBaseLevel.getMemberAtDataIdx(pos - 1);
                    action.apply((Object)member);
                }
            }
        }

        public boolean addLink(OlapMember baseMember, OlapMember noBaseMember) {
            if (this.noBaseLevel != noBaseMember.getLevel() || baseMember.getLevel() != this.baseLevel) {
                throw new CdShouldNotBeHereProgrammingException();
            }
            int noBasememberIdx = this.getMemberIdx(noBaseMember);
            int baseIdx = this.getMemberIdx(baseMember);
            boolean added = false;
            if (this.simpleMapper != null) {
                int lookupNoBaseMemberIdx;
                if (this.simpleMapper instanceof CdPackedBitList) {
                    this.moveToResizableList();
                }
                if ((lookupNoBaseMemberIdx = this.simpleMapper.getInt(baseIdx)) == 0) {
                    this.simpleMapper.set(baseIdx, noBasememberIdx);
                    added = true;
                } else if (lookupNoBaseMemberIdx != noBasememberIdx) {
                    this.moveSimpleToManyToMany();
                }
            }
            if (this.many2ManyMapper != null) {
                added = this.addMany2Many(baseIdx, noBasememberIdx);
            }
            return added;
        }

        private void moveToResizableList() {
            CdIntArrayList newList = new CdIntArrayList(this.simpleMapper.size());
            for (int i = 0; i < this.simpleMapper.size(); ++i) {
                newList.set(i, this.simpleMapper.getInt(i));
            }
            this.simpleMapper = newList;
        }

        private void moveSimpleToManyToMany() {
            this.many2ManyMapper = new CdArrayList(this.simpleMapper.size());
            for (int i = 0; i < this.simpleMapper.size(); ++i) {
                int pos = this.simpleMapper.getInt(i);
                if (pos == 0) continue;
                this.many2ManyMapper.set(i, (Object)pos);
            }
            this.simpleMapper = null;
        }

        private boolean addMany2Many(int baseIdx, int noBasememberIdx) {
            Object item = this.many2ManyMapper.getExtra(baseIdx, null);
            boolean added = false;
            if (item == null) {
                this.many2ManyMapper.set(baseIdx, (Object)noBasememberIdx);
                added = true;
            } else if (item instanceof CdIntArrayList) {
                CdIntArrayList list = (CdIntArrayList)item;
                if (!list.contains(noBasememberIdx)) {
                    list.add(noBasememberIdx);
                    added = true;
                }
            } else if ((Integer)item != noBasememberIdx) {
                CdIntArrayList list = new CdIntArrayList();
                list.add(((Integer)item).intValue());
                list.add(noBasememberIdx);
                this.many2ManyMapper.set(baseIdx, (Object)list);
                added = true;
            }
            return added;
        }

        public void trimToSize() {
            CdIIntArrayList cdIIntArrayList;
            if (this.simpleMapper != null && (cdIIntArrayList = this.simpleMapper) instanceof CdIntArrayList) {
                CdIntArrayList intList = (CdIntArrayList)cdIIntArrayList;
                CdPackedBitList packed = CdPackedBitList.buildIfCompressing((CdIIntArrayList)intList);
                if (packed != null) {
                    this.simpleMapper = packed;
                } else {
                    intList.trimToSize();
                }
            }
            if (this.many2ManyMapper != null) {
                this.many2ManyMapper.trimToSize();
                for (Object item : this.many2ManyMapper) {
                    if (item == null || !(item instanceof CdIntArrayList)) continue;
                    CdIntArrayList list = (CdIntArrayList)item;
                    list.trimToSize();
                }
            }
        }

        public void forEach(HierarchyMapper.BaseNoBaseLink action) {
            OlapMember baseMember;
            int baseIdx;
            if (this.simpleMapper != null) {
                for (baseIdx = 1; baseIdx < this.simpleMapper.size(); ++baseIdx) {
                    int noBaseIdx = this.simpleMapper.getInt(baseIdx);
                    if (noBaseIdx <= 0) continue;
                    baseMember = this.baseLevel.getMemberAtDataIdx(baseIdx - 1);
                    OlapMember noBaseMember = this.noBaseLevel.getMemberAtDataIdx(noBaseIdx - 1);
                    action.onLink(baseMember, noBaseMember);
                }
            }
            if (this.many2ManyMapper != null) {
                for (baseIdx = 1; baseIdx < this.many2ManyMapper.size(); ++baseIdx) {
                    Object item = this.many2ManyMapper.get(baseIdx);
                    if (item == null) continue;
                    baseMember = this.baseLevel.getMemberAtDataIdx(baseIdx - 1);
                    if (item instanceof CdIntArrayList) {
                        CdIntArrayList list = (CdIntArrayList)item;
                        for (int i = 0; i < list.size(); ++i) {
                            int pos = list.getInt(i);
                            OlapMember noBaseMember = this.noBaseLevel.getMemberAtDataIdx(pos - 1);
                            action.onLink(baseMember, noBaseMember);
                        }
                        continue;
                    }
                    int pos = (Integer)item;
                    OlapMember noBaseMember = this.noBaseLevel.getMemberAtDataIdx(pos - 1);
                    action.onLink(baseMember, noBaseMember);
                }
            }
        }
    }
}

