/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.permissions.schema;

import crazydev.iccube.authorization.errors.OlapRoleDefinitionError;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationRuntimeException;
import crazydev.iccube.authorization.permissions.filter.fact.OlapRoleFactFilter;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaPermissions;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.cluster.shared.perms.S_FactOnErrorPermsDef;
import crazydev.iccube.cluster.shared.perms.S_FactPermsDef;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapPerspectiveCube;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapRoleSchemaOnErrorPermissions
extends OlapRoleSchemaPermissions {
    private final String roleName;
    private final List<? extends OlapContextualError> errors;

    public OlapRoleSchemaOnErrorPermissions(String roleName, OlapSchema schema, String message) {
        this(roleName, schema, OlapRoleSchemaOnErrorPermissions.setupErrors(message));
    }

    public OlapRoleSchemaOnErrorPermissions(String roleName, OlapSchema schema, List<? extends OlapContextualError> errors) {
        super(schema);
        this.roleName = roleName;
        this.errors = errors;
    }

    @Override
    @Nullable
    public S_FactPermsDef createClusterPerms() {
        return new S_FactOnErrorPermsDef();
    }

    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public boolean isError() {
        return true;
    }

    @Override
    public List<? extends OlapContextualError> getErrors() {
        return this.errors;
    }

    private static List<OlapContextualError> setupErrors(String message) {
        ArrayList<OlapContextualError> errors = new ArrayList<OlapContextualError>();
        errors.add(new OlapRoleDefinitionError(OlapRoleDefinitionErrorCode.UNEXPECTED_ERROR, new Serializable[]{message}));
        return errors;
    }

    @Override
    public boolean isReadOnly() {
        throw new OlapRoleAuthorizationRuntimeException("Access to the schema [" + this.schema.getName() + "] is not authorized due to invalid permissions", this.errors);
    }

    @Override
    public boolean isDrillthroughDenied() {
        throw new OlapRoleAuthorizationRuntimeException("Access to the schema [" + this.schema.getName() + "] is not authorized due to invalid permissions", this.errors);
    }

    @Override
    public boolean isDimensionAuthorized(OlapDimension dimension) {
        throw new OlapRoleAuthorizationRuntimeException("Access to the schema [" + this.schema.getName() + "] is not authorized due to invalid permissions", this.errors);
    }

    @Override
    public IOlapDimensionPermission getDimensionPermissions(OlapDimension dimension) {
        throw new OlapRoleAuthorizationRuntimeException("Access to the schema [" + this.schema.getName() + "] is not authorized due to invalid permissions", this.errors);
    }

    @Override
    public boolean isReportingDataSourceAuthorized(OlapBuilderBaseDataSource dataSource) {
        throw new OlapRoleAuthorizationRuntimeException("Access to the schema [" + this.schema.getName() + "] is not authorized due to invalid permissions", this.errors);
    }

    @Override
    public boolean isCubeAuthorized(OlapCube cube) {
        throw new OlapRoleAuthorizationRuntimeException("Access to the schema [" + this.schema.getName() + "] is not authorized due to invalid permissions", this.errors);
    }

    @Override
    public boolean isPerspectiveAuthorized(OlapPerspectiveCube perspective) {
        throw new OlapRoleAuthorizationRuntimeException("Access to the schema [" + this.schema.getName() + "] is not authorized due to invalid permissions", this.errors);
    }

    @Override
    public IOlapCubePermission getCubePermissions(OlapCube cube) {
        throw new OlapRoleAuthorizationRuntimeException("Access to the schema [" + this.schema.getName() + "] is not authorized due to invalid permissions", this.errors);
    }

    @Override
    public OlapMemberFilter getMemberFilter() {
        throw new OlapRoleAuthorizationRuntimeException("Access to the schema [" + this.schema.getName() + "] is not authorized due to invalid permissions", this.errors);
    }

    @Override
    public OlapMemberFilter getInvisibleMemberFilter() {
        throw new OlapRoleAuthorizationRuntimeException("Access to the schema [" + this.schema.getName() + "] is not authorized due to invalid permissions", this.errors);
    }

    @Override
    public OlapRoleFactFilter getFactFilter() {
        throw new OlapRoleAuthorizationRuntimeException("Access to the schema [" + this.schema.getName() + "] is not authorized due to invalid permissions", this.errors);
    }
}

