/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.permissions.schema;

import crazydev.iccube.authorization.permissions.common.OlapRoleAccess;
import crazydev.iccube.authorization.permissions.filter.fact.OlapRoleFactFilter;
import crazydev.iccube.authorizationx.permissions.cube.OlapRoleCubeAllPermissions;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaPermissions;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.cluster.shared.perms.S_FactFullControlPermsDef;
import crazydev.iccube.cluster.shared.perms.S_FactPermsDef;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapPerspectiveCube;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.eval.filter.dimension.OlapEmptyMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;

public class OlapRoleSchemaAllPermissions
extends OlapRoleSchemaPermissions {
    private final OlapRoleAccess defaultAccess;
    private final boolean drillthroughDenied;
    private final OlapMemberFilter invisibleDimensionFilter = new OlapEmptyMemberFilter();

    public OlapRoleSchemaAllPermissions(OlapSchema schema, OlapRoleAccess defaultAccess, boolean drillthroughDenied) {
        super(schema);
        this.defaultAccess = defaultAccess;
        this.drillthroughDenied = drillthroughDenied;
    }

    @Override
    public S_FactPermsDef createClusterPerms() {
        return new S_FactFullControlPermsDef();
    }

    @Override
    public boolean isReadOnly() {
        return this.defaultAccess.isReadOnly();
    }

    @Override
    public boolean isDrillthroughDenied() {
        return this.drillthroughDenied;
    }

    @Override
    public IOlapSchemaPermission increment(String roleName, OlapSchemaIncrLoadInfo incrLoadInfo) {
        if (!this.schema.equals(incrLoadInfo.getSchema())) {
            throw new RuntimeException("internal error: incremental permissions schema inconsistency");
        }
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)("[auth] create incremental (load-partitions) permissions for role [" + roleName + "] schema [" + this.schema.getName() + "] ALL"));
        }
        return new OlapRoleSchemaAllPermissions(this.schema, this.defaultAccess, this.drillthroughDenied);
    }

    @Override
    public IOlapSchemaPermission increment(String roleName, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        if (!this.schema.equals(loadPartitionsInfo.getSchema())) {
            throw new RuntimeException("internal error: incremental permissions schema inconsistency");
        }
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)("[auth] create incremental (load-partitions) permissions for role [" + roleName + "] schema [" + this.schema.getName() + "] ALL"));
        }
        return new OlapRoleSchemaAllPermissions(this.schema, this.defaultAccess, this.drillthroughDenied);
    }

    @Override
    public IOlapSchemaPermission increment(String roleName, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        if (!this.schema.equals(unloadPartitionsInfo.getSchema())) {
            throw new RuntimeException("internal error: incremental permissions schema inconsistency");
        }
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)("[auth] create incremental (unload-partitions) permissions for role [" + roleName + "] schema [" + this.schema.getName() + "] ALL"));
        }
        return new OlapRoleSchemaAllPermissions(this.schema, this.defaultAccess, this.drillthroughDenied);
    }

    @Override
    public boolean isDimensionAuthorized(OlapDimension dimension) {
        return true;
    }

    @Override
    public IOlapDimensionPermission getDimensionPermissions(OlapDimension dimension) {
        return dimension.getAllPermissions();
    }

    @Override
    public boolean isReportingDataSourceAuthorized(OlapBuilderBaseDataSource dataSource) {
        return true;
    }

    @Override
    public boolean isCubeAuthorized(OlapCube cube) {
        return true;
    }

    @Override
    public boolean isPerspectiveAuthorized(OlapPerspectiveCube perspective) {
        return true;
    }

    @Override
    public IOlapCubePermission getCubePermissions(OlapCube cube) {
        return new OlapRoleCubeAllPermissions(cube, this.defaultAccess);
    }

    @Override
    public OlapMemberFilter getMemberFilter() {
        return null;
    }

    @Override
    public OlapMemberFilter getInvisibleMemberFilter() {
        return this.invisibleDimensionFilter;
    }

    @Override
    public OlapRoleFactFilter getFactFilter() {
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + " (all:" + String.valueOf((Object)this.defaultAccess) + ")";
    }
}

