/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.permissions.schema;

import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapRoleDefaultMembers {
    public static final OlapRoleDefaultMembers NONE = new OlapRoleDefaultMembers();
    private final List<OlapHierarchy> hierarchies;
    private final List<OlapMember> members;

    private OlapRoleDefaultMembers() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    private OlapRoleDefaultMembers(List<OlapHierarchy> hierarchies, List<OlapMember> members) {
        this.hierarchies = hierarchies;
        this.members = members;
    }

    public boolean isNone() {
        return this == NONE;
    }

    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    public int size() {
        return this.members.size();
    }

    @Nullable
    public OlapMember getMember(int idx) {
        return this.members.get(idx);
    }

    public OlapHierarchy getHierarchy(int idx) {
        return this.hierarchies.get(idx);
    }

    public static OlapRoleDefaultMembers createDefaults(IOlapDimensionsPermission dimensionsPermissions, List<OlapDimension> dimensions) {
        List<OlapMember> defaultMembers = null;
        List<OlapHierarchy> defaultMemberHierarchies = null;
        OlapMemberFilter asFilter = dimensionsPermissions.getMemberFilter();
        if (dimensions != null) {
            for (int dimensionIdx = 0; dimensionIdx < dimensions.size(); ++dimensionIdx) {
                OlapDimension dimension = dimensions.get(dimensionIdx);
                if (dimension.isMeasures() || !dimension.isFactIndexing() || !dimensionsPermissions.isDimensionAuthorized(dimension)) continue;
                List<OlapHierarchy> hierarchies = dimension.getHierarchies(dimensionsPermissions);
                for (int hierarchyIdx = 0; hierarchyIdx < hierarchies.size(); ++hierarchyIdx) {
                    OlapHierarchy hierarchy = hierarchies.get(hierarchyIdx);
                    OlapMember defaultMember = hierarchy.getNullableDefaultMember(asFilter);
                    if (defaultMember != null && (defaultMember.isAll() || defaultMember.isCalculated())) continue;
                    if (defaultMembers == null) {
                        defaultMembers = new ArrayList<OlapMember>();
                    }
                    defaultMembers.add(defaultMember);
                    if (defaultMemberHierarchies == null) {
                        defaultMemberHierarchies = new ArrayList<OlapHierarchy>();
                    }
                    defaultMemberHierarchies.add(hierarchy);
                }
            }
        }
        defaultMembers = defaultMembers == null ? Collections.emptyList() : defaultMembers;
        defaultMemberHierarchies = defaultMemberHierarchies == null ? Collections.emptyList() : defaultMemberHierarchies;
        return new OlapRoleDefaultMembers(defaultMemberHierarchies, defaultMembers);
    }
}

