/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.permissions.schema;

import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OlapRoleDefaultCalcMembers {
    public static final OlapRoleDefaultCalcMembers NONE = new OlapRoleDefaultCalcMembers();
    private final List<OlapCalculatedMember> members;

    private OlapRoleDefaultCalcMembers() {
        this(Collections.emptyList());
    }

    private OlapRoleDefaultCalcMembers(List<OlapCalculatedMember> members) {
        this.members = members;
    }

    public static OlapRoleDefaultCalcMembers createDefaultAsCalcMembers(IOlapDimensionsPermission dimensionsPermissions, OlapCube cube) {
        ArrayList<OlapCalculatedMember> defaults = null;
        List<OlapDimension> dimensions = cube.getDimensions();
        OlapMemberFilter asFilter = dimensionsPermissions.getMemberFilter();
        for (int dimensionIdx = 0; dimensionIdx < dimensions.size(); ++dimensionIdx) {
            OlapDimension dimension = dimensions.get(dimensionIdx);
            if (!dimensionsPermissions.isDimensionAuthorized(dimension)) continue;
            List<OlapHierarchy> hierarchies = dimension.getHierarchies(dimensionsPermissions);
            for (int hierarchyIdx = 0; hierarchyIdx < hierarchies.size(); ++hierarchyIdx) {
                OlapHierarchy hierarchy = hierarchies.get(hierarchyIdx);
                OlapMember member = hierarchy.getNullableDefaultMember(asFilter);
                if (!(member instanceof OlapCalculatedMember)) continue;
                if (defaults == null) {
                    defaults = new ArrayList<OlapCalculatedMember>();
                }
                defaults.add((OlapCalculatedMember)member);
            }
        }
        if (defaults == null) {
            return NONE;
        }
        return new OlapRoleDefaultCalcMembers(defaults);
    }

    public boolean isNone() {
        return this == NONE;
    }

    public int size() {
        return this.members.size();
    }

    public OlapCalculatedMember getMember(int idx) {
        return this.members.get(idx);
    }
}

