/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.permissions.schema;

import crazydev.iccube.authorization.permissions.common.OlapRoleAccess;
import crazydev.iccube.authorizationx.permissions.cube.OlapRoleBuilderCubeFullControlPermissions;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaAllPermissions;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;

public class OlapRoleBuilderSchemaFullControlPermissions
extends OlapRoleSchemaAllPermissions {
    public OlapRoleBuilderSchemaFullControlPermissions(OlapSchema schema) {
        super(schema, OlapRoleAccess.READ_WRITE, false);
    }

    @Override
    public IOlapSchemaPermission increment(String roleName, OlapSchemaIncrLoadInfo incrLoadInfo) {
        if (!this.schema.equals(incrLoadInfo.getSchema())) {
            throw new RuntimeException("internal error: incremental permissions schema inconsistency");
        }
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)("[auth] create incremental (incr-load) permissions for role [" + roleName + "] schema [" + this.schema.getName() + "] FULL"));
        }
        return new OlapRoleBuilderSchemaFullControlPermissions(this.schema);
    }

    @Override
    public IOlapSchemaPermission increment(String roleName, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        if (!this.schema.equals(loadPartitionsInfo.getSchema())) {
            throw new RuntimeException("internal error: incremental permissions schema inconsistency");
        }
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)("[auth] create incremental (load-partitions) permissions for role [" + roleName + "] schema [" + this.schema.getName() + "] FULL"));
        }
        return new OlapRoleBuilderSchemaFullControlPermissions(this.schema);
    }

    @Override
    public IOlapSchemaPermission increment(String roleName, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        if (!this.schema.equals(unloadPartitionsInfo.getSchema())) {
            throw new RuntimeException("internal error: incremental permissions schema inconsistency");
        }
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)("[auth] create incremental (unload-partitions) permissions for role [" + roleName + "] schema [" + this.schema.getName() + "] FULL"));
        }
        return new OlapRoleBuilderSchemaFullControlPermissions(this.schema);
    }

    @Override
    public IOlapCubePermission getCubePermissions(OlapCube cube) {
        return new OlapRoleBuilderCubeFullControlPermissions(cube);
    }

    @Override
    public String toString() {
        return super.toString() + " (full-control-builder)";
    }
}

