/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.flat.permissions.schemas;

import crazydev.common.mdx.scanner.CdMdxPreProcessorTokenKind;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorManager;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionApplyValidationContext;
import crazydev.iccube.exception.OlapError;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationCurrent;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationDrillthroughStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationElseStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationEndforeachStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationEndifStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationForEachStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationIfStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationSchemaAccessStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationSchemaExpression;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationSchemaExpressionPP;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationSchemaScopeStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationStatement;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxHelper;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapRoleFlatPermissionsPPHelper {
    private final OlapRoleDefinitionErrorManager errorManager;
    private final OlapRoleDefinitionApplyValidationContext context;
    private final OlapSchema schema;

    public OlapRoleFlatPermissionsPPHelper(OlapRoleDefinitionErrorManager errorManager, OlapRoleDefinitionApplyValidationContext context, OlapSchema schema) {
        this.errorManager = errorManager;
        this.context = context;
        this.schema = schema;
    }

    public MdxAuthorizationSchemaExpression evalPP(MdxAuthorizationSchemaExpressionPP schemaProfilePP) {
        List<MdxAuthorizationStatement> allStatements = !schemaProfilePP.containsPP() ? schemaProfilePP.getStatements() : this.evalPPStatements(schemaProfilePP.getStatements());
        MdxAuthorizationSchemaScopeStatement scope = schemaProfilePP.getScope();
        Details details = OlapRoleFlatPermissionsPPHelper.extractDetails(allStatements);
        return new MdxAuthorizationSchemaExpression(scope, details.access, details.drillthrough, details.statements);
    }

    private List<MdxAuthorizationStatement> evalPPStatements(List<MdxAuthorizationStatement> allStatements) {
        return this.evalForEachStatements(this.evalPPConditionalStatements(allStatements));
    }

    private List<MdxAuthorizationStatement> evalForEachStatements(List<MdxAuthorizationStatement> allStatements) {
        ArrayList<MdxAuthorizationStatement> resolvedStatements = new ArrayList<MdxAuthorizationStatement>();
        ArrayList<MdxAuthorizationStatement> innerStatements = new ArrayList<MdxAuthorizationStatement>();
        MdxAuthorizationForEachStatement forEachStatement = null;
        for (MdxAuthorizationStatement statement : allStatements) {
            if (statement instanceof MdxAuthorizationForEachStatement) {
                forEachStatement = (MdxAuthorizationForEachStatement)statement;
                continue;
            }
            if (statement instanceof MdxAuthorizationEndforeachStatement) {
                resolvedStatements.addAll(this.evalForEachStatement(forEachStatement, innerStatements));
                forEachStatement = null;
                innerStatements.clear();
                continue;
            }
            if (forEachStatement == null) {
                resolvedStatements.add(statement);
                continue;
            }
            innerStatements.add(statement);
        }
        return resolvedStatements;
    }

    private List<MdxAuthorizationStatement> evalForEachStatement(MdxAuthorizationForEachStatement forEachStatement, List<MdxAuthorizationStatement> innerStatements) {
        ArrayList<MdxAuthorizationStatement> resolvedStatements = new ArrayList<MdxAuthorizationStatement>();
        if (forEachStatement.isStar()) {
            MdxExpression filterExpr = forEachStatement.getFilterExpr();
            for (OlapDimension dimension : this.schema.getDimensions()) {
                for (OlapHierarchy hierarchy : dimension.getHierarchies()) {
                    MdxAuthorizationCurrent current = MdxAuthorizationCurrent.create(dimension, hierarchy);
                    if (filterExpr != null && !this.evalPPConditionForEachHierarchyFilter(filterExpr, current)) continue;
                    for (MdxAuthorizationStatement innerStatement : innerStatements) {
                        resolvedStatements.add(innerStatement.attachCurrent(current));
                    }
                }
            }
        } else {
            MdxIdentifierExpression dimensionExpr = forEachStatement.getDimension();
            OlapDimension dimension = this.evalPPConditionForEachHierarchyDimension(dimensionExpr);
            MdxExpression filterExpr = forEachStatement.getFilterExpr();
            for (OlapHierarchy hierarchy : dimension.getHierarchies()) {
                MdxAuthorizationCurrent current = MdxAuthorizationCurrent.create(dimension, hierarchy);
                if (filterExpr != null && !this.evalPPConditionForEachHierarchyFilter(filterExpr, current)) continue;
                for (MdxAuthorizationStatement innerStatement : innerStatements) {
                    resolvedStatements.add(innerStatement.attachCurrent(current));
                }
            }
        }
        return resolvedStatements;
    }

    private OlapDimension evalPPConditionForEachHierarchyDimension(MdxExpression expression) {
        OlapEngineRequestContext requestContext = this.context.createdOlapEngineContext__();
        try {
            OlapEngineMdxHelper helper = OlapEngineMdxHelper.create(requestContext);
            OlapRegularCube cube = this.schema.getFirstCube();
            OlapEntity result = helper.executeFlatAuthorizationExpression(this.schema, cube, Collections.emptyMap(), Collections.emptyMap(), null, expression);
            if (result instanceof OlapDimension) {
                OlapDimension olapDimension = (OlapDimension)result;
                return olapDimension;
            }
            throw new OlapEvaluationException(new OlapError(OlapErrorCode.TYPE_MISMATCH, new Serializable[]{"dimension", result.getFriendlyTypeName()}));
        }
        finally {
            requestContext.getSessionContext().onSessionDestroyed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evalPPConditionForEachHierarchyFilter(MdxExpression expression, MdxAuthorizationCurrent current) {
        OlapEngineRequestContext requestContext = this.context.createdOlapEngineContext__();
        try {
            OlapEngineMdxHelper helper = OlapEngineMdxHelper.create(requestContext);
            OlapRegularCube cube = this.schema.getFirstCube();
            OlapEntity result = helper.executeFlatAuthorizationExpression(this.schema, cube, Collections.emptyMap(), Collections.emptyMap(), current, expression);
            if (result instanceof OlapScalarEntity) {
                OlapScalarEntity sResult = (OlapScalarEntity)result;
                boolean bl = OlapScalarOperators.isTrue(sResult);
                return bl;
            }
            boolean bl = !result.isMdxNull();
            return bl;
        }
        finally {
            requestContext.getSessionContext().onSessionDestroyed();
        }
    }

    private List<MdxAuthorizationStatement> evalPPConditionalStatements(List<MdxAuthorizationStatement> allStatements) {
        ArrayList<MdxAuthorizationStatement> resolvedStatements = new ArrayList<MdxAuthorizationStatement>();
        CdMdxPreProcessorTokenKind pp = null;
        Boolean condition = null;
        for (MdxAuthorizationStatement statement : allStatements) {
            if (statement instanceof MdxAuthorizationIfStatement) {
                pp = CdMdxPreProcessorTokenKind.IF;
                condition = this.evalPPCondition(statement.getMdxExpression());
                continue;
            }
            if (statement instanceof MdxAuthorizationElseStatement) {
                pp = CdMdxPreProcessorTokenKind.ELSE;
                continue;
            }
            if (statement instanceof MdxAuthorizationEndifStatement) {
                pp = null;
                condition = null;
                continue;
            }
            if (pp == null) {
                resolvedStatements.add(statement);
                continue;
            }
            if (condition == null) {
                throw new RuntimeException("internal error: inconsistent #IF/#ELSE/#ENDIF directives");
            }
            if (pp == CdMdxPreProcessorTokenKind.IF && condition.booleanValue()) {
                resolvedStatements.add(statement);
                continue;
            }
            if (pp != CdMdxPreProcessorTokenKind.ELSE || condition.booleanValue()) continue;
            resolvedStatements.add(statement);
        }
        return resolvedStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evalPPCondition(MdxExpression expression) {
        OlapEngineRequestContext requestContext = this.context.createdOlapEngineContext__();
        try {
            OlapEngineMdxHelper helper = OlapEngineMdxHelper.create(requestContext);
            OlapRegularCube cube = this.schema.getFirstCube();
            OlapEntity result = helper.executeFlatAuthorizationExpression(this.schema, cube, Collections.emptyMap(), Collections.emptyMap(), null, expression);
            if (result instanceof OlapScalarEntity) {
                OlapScalarEntity sResult = (OlapScalarEntity)result;
                boolean bl = OlapScalarOperators.isTrue(sResult);
                return bl;
            }
            boolean bl = !result.isMdxNull();
            return bl;
        }
        finally {
            requestContext.getSessionContext().onSessionDestroyed();
        }
    }

    private static Details extractDetails(List<MdxAuthorizationStatement> allStatements) {
        MdxAuthorizationSchemaAccessStatement access = null;
        MdxAuthorizationDrillthroughStatement drillthrough = null;
        ArrayList<MdxAuthorizationStatement> statements = new ArrayList<MdxAuthorizationStatement>();
        for (MdxAuthorizationStatement statement : allStatements) {
            if (statement.isPP()) {
                throw new RuntimeException("internal error: unexpected #IF/#ELSE/#ENDIF directive");
            }
            if (statement instanceof MdxAuthorizationSchemaAccessStatement) {
                access = (MdxAuthorizationSchemaAccessStatement)statement;
                continue;
            }
            if (statement instanceof MdxAuthorizationDrillthroughStatement) {
                drillthrough = (MdxAuthorizationDrillthroughStatement)statement;
                continue;
            }
            statements.add(statement);
        }
        return new Details(access, drillthrough, statements);
    }

    static class Details {
        @Nullable
        final MdxAuthorizationSchemaAccessStatement access;
        @Nullable
        final MdxAuthorizationDrillthroughStatement drillthrough;
        final List<MdxAuthorizationStatement> statements;

        public Details(@Nullable MdxAuthorizationSchemaAccessStatement access, @Nullable MdxAuthorizationDrillthroughStatement drillthrough, List<MdxAuthorizationStatement> statements) {
            this.access = access;
            this.drillthrough = drillthrough;
            this.statements = statements;
        }
    }
}

