/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.flat.permissions.schema;

import crazydev.iccube.authorization.permissions.common.OlapRoleAccess;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationRuntimeException;
import crazydev.iccube.authorization.permissions.filter.fact.OlapRoleFactFilter;
import crazydev.iccube.authorizationx.flat.permissions.cube.OlapRoleFlatAuthorizedCube;
import crazydev.iccube.authorizationx.flat.permissions.cube.OlapRoleFlatCubeRegularPermissions;
import crazydev.iccube.authorizationx.flat.permissions.dimension.OlapRoleFlatDimensionRegularPermissions;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatSchemaFactFilter;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatSchemaMemberFilter;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaPermissions;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapPerspectiveCube;
import crazydev.iccube.olap.entity.OlapMeasureGroup;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.eval.filter.dimension.OlapEmptyMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapRoleFlatSchemaRegularPermissions
extends OlapRoleSchemaPermissions {
    private final String roleName;
    private final OlapRoleAccess access;
    private final boolean drillthroughDenied;
    private final Set<OlapBuilderBaseDataSource> authorizedReportingDataSources;
    private final OlapEmptyMemberFilter invisibleMemberFilter = new OlapEmptyMemberFilter();
    private final OlapRoleFlatSchemaMemberFilter memberFilter;
    private final Set<OlapMeasureGroup> authorizedMeasureGroups;
    @Nullable
    private final OlapRoleFlatSchemaFactFilter factFilter;
    private final Map<OlapDimension, IOlapDimensionPermission> authorizedDimensionsPermissions;
    private final Map<OlapCube, IOlapCubePermission> authorizedCubesPermissions;
    private final Set<OlapPerspectiveCube> authorizedPerspectives;

    public OlapRoleFlatSchemaRegularPermissions(String roleName, OlapSchema schema, OlapRoleAccess access, boolean drillthroughDenied, Set<OlapBuilderBaseDataSource> authorizedReportingDataSources, Set<OlapDimension> authorizedDimensions, OlapRoleFlatSchemaMemberFilter memberFilter, Map<OlapCube, OlapRoleFlatAuthorizedCube> authorizedCubes, Set<OlapMeasureGroup> authorizedMeasureGroups, Set<OlapPerspectiveCube> authorizedPerspectives, @Nullable OlapRoleFlatSchemaFactFilter factFilter) {
        super(schema);
        this.roleName = roleName;
        this.access = access;
        this.drillthroughDenied = drillthroughDenied;
        this.authorizedReportingDataSources = authorizedReportingDataSources;
        this.memberFilter = memberFilter;
        this.authorizedMeasureGroups = authorizedMeasureGroups;
        this.factFilter = factFilter;
        this.authorizedDimensionsPermissions = new HashMap<OlapDimension, IOlapDimensionPermission>();
        for (OlapDimension dimension : authorizedDimensions) {
            this.authorizedDimensionsPermissions.put(dimension, new OlapRoleFlatDimensionRegularPermissions(dimension, memberFilter));
        }
        this.authorizedCubesPermissions = new HashMap<OlapCube, IOlapCubePermission>();
        for (OlapRoleFlatAuthorizedCube cube : authorizedCubes.values()) {
            this.authorizedCubesPermissions.put(cube.getCube(), new OlapRoleFlatCubeRegularPermissions(cube.getCube(), cube.getAccess(), authorizedMeasureGroups));
        }
        this.authorizedPerspectives = authorizedPerspectives;
    }

    public OlapRoleFlatSchemaRegularPermissions(String roleName, OlapSchema schema, OlapRoleAccess access, boolean drillthroughDenied, Set<OlapBuilderBaseDataSource> authorizedReportingDataSources, OlapRoleFlatSchemaMemberFilter memberFilter, Set<OlapMeasureGroup> authorizedMeasureGroups, @Nullable OlapRoleFlatSchemaFactFilter factFilter, Map<OlapDimension, IOlapDimensionPermission> authorizedDimensionsPermissions, Map<OlapCube, IOlapCubePermission> authorizedCubesPermissions, Set<OlapPerspectiveCube> authorizedPerspectives) {
        super(schema);
        this.roleName = roleName;
        this.access = access;
        this.drillthroughDenied = drillthroughDenied;
        this.authorizedReportingDataSources = authorizedReportingDataSources;
        this.memberFilter = memberFilter;
        this.authorizedMeasureGroups = authorizedMeasureGroups;
        this.factFilter = factFilter;
        this.authorizedDimensionsPermissions = authorizedDimensionsPermissions;
        this.authorizedCubesPermissions = authorizedCubesPermissions;
        this.authorizedPerspectives = authorizedPerspectives;
    }

    @Override
    public boolean isReadOnly() {
        return this.access.isReadOnly();
    }

    @Override
    public boolean isDrillthroughDenied() {
        return this.drillthroughDenied;
    }

    @Override
    public boolean isDimensionAuthorized(OlapDimension dimension) {
        return this.authorizedDimensionsPermissions.containsKey(dimension);
    }

    @Override
    public IOlapDimensionPermission getDimensionPermissions(OlapDimension dimension) {
        IOlapDimensionPermission perms = this.authorizedDimensionsPermissions.get(dimension);
        if (perms == null) {
            throw new OlapRoleAuthorizationRuntimeException("The dimension [" + ONames.name4Log(dimension) + "] in schema [" + this.schema.getName() + "] is not authorized");
        }
        return perms;
    }

    @Override
    @Nullable
    public OlapMemberFilter getMemberFilter() {
        return this.memberFilter;
    }

    @Override
    @Nullable
    public OlapTupleFilter getMemberTupleFilter() {
        return this.memberFilter.getAuthorizedTuples();
    }

    @Override
    public OlapMemberFilter getInvisibleMemberFilter() {
        return this.invisibleMemberFilter;
    }

    @Override
    public boolean isReportingDataSourceAuthorized(OlapBuilderBaseDataSource dataSource) {
        return this.authorizedReportingDataSources.contains(dataSource);
    }

    @Override
    public boolean isCubeAuthorized(OlapCube cube) {
        return this.authorizedCubesPermissions.containsKey(cube);
    }

    @Override
    public boolean isPerspectiveAuthorized(OlapPerspectiveCube perspective) {
        return this.authorizedPerspectives.contains(perspective);
    }

    @Override
    public IOlapCubePermission getCubePermissions(OlapCube cube) {
        IOlapCubePermission perms = this.authorizedCubesPermissions.get(cube);
        if (perms == null) {
            throw new OlapRoleAuthorizationRuntimeException("The cube [" + ONames.name4Log(cube) + "] in schema [" + this.schema.getName() + "] is not authorized");
        }
        return perms;
    }

    @Override
    @Nullable
    public OlapRoleFactFilter getFactFilter() {
        return this.factFilter;
    }

    @Override
    public final IOlapSchemaPermission increment(String roleName, OlapSchemaIncrLoadInfo incrLoadInfo) {
        if (!this.schema.equals(incrLoadInfo.getSchema())) {
            throw new RuntimeException("internal error: incremental permissions schema inconsistency");
        }
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)("[auth] create (incremental) permissions for role [" + roleName + "] schema [" + this.schema.getName() + "] REGULAR"));
        }
        return this.doIncrement(roleName, incrLoadInfo);
    }

    private IOlapSchemaPermission doIncrement(String roleName, OlapSchemaIncrLoadInfo incrLoadInfo) {
        if (incrLoadInfo.hasNewMembers()) {
            throw new RuntimeException("internal error: incr. load permissions inconsistent usage (members update)");
        }
        OlapRoleFlatSchemaMemberFilter memberFilter_ = this.memberFilter.copyForIncrementalLoad(incrLoadInfo);
        OlapRoleFlatSchemaFactFilter factFilter_ = this.factFilter != null ? this.factFilter.copyForIncrementalLoad(incrLoadInfo) : null;
        return new OlapRoleFlatSchemaRegularPermissions(roleName, this.schema, this.access, this.drillthroughDenied, this.authorizedReportingDataSources, memberFilter_, this.authorizedMeasureGroups, factFilter_, this.authorizedDimensionsPermissions, this.authorizedCubesPermissions, this.authorizedPerspectives);
    }

    @Override
    public IOlapSchemaPermission increment(String roleName, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        OlapRoleFlatSchemaMemberFilter memberFilter_ = this.memberFilter.copyForLoadPartitions(loadPartitionsInfo);
        OlapRoleFlatSchemaFactFilter factFilter_ = this.factFilter != null ? this.factFilter.copyForLoadPartitions(loadPartitionsInfo) : null;
        return new OlapRoleFlatSchemaRegularPermissions(roleName, this.schema, this.access, this.drillthroughDenied, this.authorizedReportingDataSources, memberFilter_, this.authorizedMeasureGroups, factFilter_, this.authorizedDimensionsPermissions, this.authorizedCubesPermissions, this.authorizedPerspectives);
    }

    @Override
    public IOlapSchemaPermission increment(String roleName, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        OlapRoleFlatSchemaMemberFilter memberFilter_ = this.memberFilter.copyForUnloadPartitions(unloadPartitionsInfo);
        OlapRoleFlatSchemaFactFilter factFilter_ = this.factFilter != null ? this.factFilter.copyForUnloadPartitions(unloadPartitionsInfo) : null;
        return new OlapRoleFlatSchemaRegularPermissions(roleName, this.schema, this.access, this.drillthroughDenied, this.authorizedReportingDataSources, memberFilter_, this.authorizedMeasureGroups, factFilter_, this.authorizedDimensionsPermissions, this.authorizedCubesPermissions, this.authorizedPerspectives);
    }
}

