/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.flat.permissions.schema;

import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorManager;
import crazydev.iccube.authorization.permissions.common.OlapRoleAccess;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionApplyValidationContext;
import crazydev.iccube.authorizationx.flat.definition.schemas.OlapRoleFlatSchemasProfile;
import crazydev.iccube.authorizationx.flat.permissions.cube.OlapRoleFlatAuthorizedCube;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatDenyAllSchemaRegularPermissions;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatQualifiedMeasureGroupName;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatSchemaFactFilter;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatSchemaMemberFilter;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatSchemaRegularPermissions;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaAllPermissions;
import crazydev.iccube.authorizationx.permissions.schemas.OlapRoleSchemasPermissionsTimings;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.cluster.shared.context.S_MdxStatementRequestContextRef;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationCreateFunctionStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationCreateSetStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationCubeStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationCurrent;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationDefaultMemberStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationDenyAllStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationDenyPerspectivesStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationDenyReportingDataSourcesStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationDimensionStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationHierarchyStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationLevelStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationMeasureGroupStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationMeasureStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationPerspectiveStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationReportingDataSourceStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationSchemaExpression;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationTuplesStatement;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectFunction;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.compiler.ast.create.MdxCreateStatementCompiler;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxHelper;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapPerspectiveCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapMeasureGroup;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.function.mdx.OlapConstDeclaredFunction;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunction;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunctionParameter;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementWithCubeSelectExecutionContext;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveManager;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapRoleFlatSchemaRegularPermissionBuilder {
    public static boolean SCHEMA_PERMISSIONS_CACHE_ACTIVATED = true;
    private final OlapRoleDefinitionApplyValidationContext context;
    private final OlapRoleDefinitionErrorManager errorManager;
    private final OlapRoleDefinition roleDefinition;
    private final OlapRoleFlatSchemasProfile schemasProfile;
    private final MdxAuthorizationSchemaExpression schemaProfile;
    private final List<MdxAuthorizationStatement> schemaStatements;
    private final OlapSchema schema;
    private final Map<String, OlapTupleSet> sets = new HashMap<String, OlapTupleSet>();
    private final Map<String, OlapDeclaredFunction> functions = new HashMap<String, OlapDeclaredFunction>();

    public OlapRoleFlatSchemaRegularPermissionBuilder(OlapRoleDefinitionApplyValidationContext context, OlapRoleDefinition roleDefinition, OlapRoleFlatSchemasProfile schemasProfile, MdxAuthorizationSchemaExpression schemaProfile, OlapSchema schema) {
        this.context = context;
        this.errorManager = (OlapRoleDefinitionErrorManager)context.getErrorManager();
        this.roleDefinition = roleDefinition;
        this.schemasProfile = schemasProfile;
        this.schemaProfile = schemaProfile;
        this.schemaStatements = schemaProfile.getStatements();
        this.schema = schema;
    }

    public IOlapSchemaPermission createPermissions(OlapRoleSchemasPermissionsTimings timings, OlapRoleAccess schemaAccess, boolean drillthroughDenied) {
        if (this.schemaProfile.isAllAuthorized()) {
            return new OlapRoleSchemaAllPermissions(this.schema, schemaAccess, drillthroughDenied);
        }
        try {
            if (this.isDenyAll()) {
                return new OlapRoleFlatDenyAllSchemaRegularPermissions(this.schema);
            }
            this.setupFunctions();
            this.setupSets();
            Set<OlapBuilderBaseDataSource> authorizedReportingDataSources = this.setupAuthorizedReportingDataSources();
            Set<OlapDimension> authorizedDimensions = this.setupAuthorizedDimensions();
            OlapRoleFlatSchemaMemberFilter memberFilter = this.setupAuthorizedHierarchies(authorizedDimensions);
            Map<OlapCube, OlapRoleFlatAuthorizedCube> authorizedCubes = this.setupAuthorizedCubes(schemaAccess);
            Map<OlapCube, Set<OlapMeasureGroup>> authorizedMeasureGroupsPerCube = this.setupAuthorizedMeasureGroups(authorizedCubes.keySet());
            Map<OlapCube, Set<OlapMeasureMember>> authorizedMeasuresPerCube = this.setupAuthorizedMeasures(authorizedCubes.keySet(), authorizedMeasureGroupsPerCube);
            Set<OlapPerspectiveCube> authorizedPerspectives = this.setupAuthorizedPerspectives(authorizedCubes.keySet());
            this.setupMeasures(authorizedDimensions, memberFilter, authorizedMeasuresPerCube);
            OlapRoleFlatSchemaFactFilter factFilter = this.setupTuples(timings, memberFilter);
            HashSet<OlapMeasureGroup> authorizedMeasureGroups = new HashSet<OlapMeasureGroup>();
            for (Set<OlapMeasureGroup> measureGroups : authorizedMeasureGroupsPerCube.values()) {
                authorizedMeasureGroups.addAll(measureGroups);
            }
            memberFilter.onBuildDone(this.errorManager, authorizedMeasureGroups);
            if (factFilter != null) {
                factFilter.onBuildDone();
            }
            return new OlapRoleFlatSchemaRegularPermissions(this.roleDefinition.getName(), this.schema, schemaAccess, drillthroughDenied, authorizedReportingDataSources, authorizedDimensions, memberFilter, authorizedCubes, authorizedMeasureGroups, authorizedPerspectives, factFilter);
        }
        catch (CdMdxScannerException | MdxParserException ex) {
            OlapLoggers.AUTHORIZATION.error((Object)"[auth] invalid flat authorization definition", (Throwable)ex);
            this.errorManager.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{ex.getMessage()});
            return null;
        }
    }

    private boolean isDenyAll() {
        for (MdxAuthorizationStatement statement : this.schemaStatements) {
            if (!(statement instanceof MdxAuthorizationDenyAllStatement)) continue;
            return true;
        }
        return false;
    }

    private Set<OlapBuilderBaseDataSource> setupAuthorizedReportingDataSources() throws CdMdxScannerException, MdxParserException {
        HashSet<OlapBuilderBaseDataSource> authorized = new HashSet<OlapBuilderBaseDataSource>();
        authorized.addAll(this.schema.getReportingDataSources(null));
        if (!this.schemaStatements.isEmpty()) {
            boolean isFirstStatement = true;
            for (MdxAuthorizationStatement statement : this.schemaStatements) {
                if (statement instanceof MdxAuthorizationDenyReportingDataSourcesStatement) {
                    authorized.clear();
                    continue;
                }
                if (!(statement instanceof MdxAuthorizationReportingDataSourceStatement)) continue;
                MdxAuthorizationReportingDataSourceStatement dsStatement = (MdxAuthorizationReportingDataSourceStatement)statement;
                String name = dsStatement.getName();
                OlapBuilderBaseDataSource<?> ds = this.schema.getReportingDataSource(null, name);
                if (ds == null) {
                    this.errorManager.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"+reportingDataSource references an unknown REPORTING datasource [" + name + "]"});
                    continue;
                }
                if (isFirstStatement && statement.isPlus()) {
                    authorized.clear();
                }
                isFirstStatement = false;
                if (statement.isPlus()) {
                    authorized.add(ds);
                    continue;
                }
                authorized.remove(ds);
            }
        }
        return authorized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupFunctions() {
        for (MdxAuthorizationStatement schemaStatement : this.schemaStatements) {
            if (!(schemaStatement instanceof MdxAuthorizationCreateFunctionStatement)) continue;
            MdxAuthorizationCreateFunctionStatement create = (MdxAuthorizationCreateFunctionStatement)schemaStatement;
            MdxSelectFunction function = create.getFunction();
            String name = function.getName().getLastPartAsString();
            List<OlapDeclaredFunctionParameter> argNames = MdxCreateStatementCompiler.asDeclaredFunctionParameters(name, function.getArgNameExpressions());
            OlapEngineRequestContext requestContext = this.context.createdOlapEngineContext__();
            try {
                OlapEngineApplicationContext applicationContext = requestContext.getApplicationContext();
                OlapEngineComponent olapEngine = applicationContext.getOlapEngineComponent();
                OlapCompilationContext cContext = new OlapCompilationContext(requestContext.getXmlaCaller(), requestContext.getMdxDefaultRequestedCellProperties(), olapEngine.getProperties(), olapEngine.getFunctionRepository(), requestContext.getOlapEngineComponent().getModuleMethodsRepository());
                try {
                    cContext.setDeclaredFunction(name, argNames);
                    Object body = cContext.compile(function.getBody());
                    boolean constant = function.isConstant();
                    if (constant) {
                        boolean cached = function.isCached();
                        this.functions.put(name, new OlapConstDeclaredFunction(name, (OlapInstr)body, cached));
                        continue;
                    }
                    this.functions.put(name, new OlapDeclaredFunction(name, argNames, (OlapInstr)body));
                }
                finally {
                    cContext.resetDeclaredFunction();
                }
            }
            finally {
                requestContext.getSessionContext().onSessionDestroyed();
            }
        }
    }

    private void setupSets() {
        for (MdxAuthorizationStatement schemaStatement : this.schemaStatements) {
            if (!(schemaStatement instanceof MdxAuthorizationCreateSetStatement)) continue;
            MdxAuthorizationCreateSetStatement create = (MdxAuthorizationCreateSetStatement)schemaStatement;
            MdxExpression mdxExpression = create.getMdxExpression();
            MdxAuthorizationCurrent current = create.getCurrent();
            String cubeName = create.getCubeName();
            OlapRegularCube cube = cubeName != null ? this.schema.lookupCubeByName(this.context.getNameContext(), cubeName) : this.schema.getFirstCube();
            OlapEntity entity = this.executeMdxExpression(cube, current, mdxExpression);
            if (entity instanceof OlapTupleSet) {
                String setName = create.getSetName();
                this.sets.put(setName, (OlapTupleSet)entity);
                continue;
            }
            this.errorManager.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"create set type mismatch [" + entity.getFriendlyTypeName() + "]"});
        }
    }

    private Set<OlapDimension> setupAuthorizedDimensions() throws CdMdxScannerException, MdxParserException {
        HashSet<OlapDimension> authorizedDimensions = new HashSet<OlapDimension>();
        authorizedDimensions.addAll(this.schema.getDimensions());
        if (!this.schemaStatements.isEmpty()) {
            boolean isFirstStatement = true;
            for (MdxAuthorizationStatement statement : this.schemaStatements) {
                if (!(statement instanceof MdxAuthorizationDimensionStatement)) continue;
                MdxAuthorizationDimensionStatement dimensionStatement = (MdxAuthorizationDimensionStatement)statement;
                MdxExpression mdxExpression = dimensionStatement.getMdxExpression();
                MdxAuthorizationCurrent current = dimensionStatement.getCurrent();
                OlapEntity entity = this.executeMdxExpression(null, current, mdxExpression);
                if (!(entity instanceof OlapDimension)) {
                    this.errorManager.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"+dimension expects a dimension name (actual:" + entity.getFriendlyTypeName() + ")"});
                    continue;
                }
                if (isFirstStatement && statement.isPlus()) {
                    authorizedDimensions.clear();
                }
                isFirstStatement = false;
                OlapDimension dimension = (OlapDimension)entity;
                if (statement.isPlus()) {
                    authorizedDimensions.add(dimension);
                    continue;
                }
                authorizedDimensions.remove(dimension);
            }
        }
        return authorizedDimensions;
    }

    private OlapRoleFlatSchemaMemberFilter setupAuthorizedHierarchies(Set<OlapDimension> authorizedDimensions) throws CdMdxScannerException, MdxParserException {
        OlapRoleFlatSchemaMemberFilter memberFilter = new OlapRoleFlatSchemaMemberFilter(this.schema.getName());
        HashMap<OlapDimension, HashSet<OlapHierarchy>> allAuthorizedDimensionHierarchies = new HashMap<OlapDimension, HashSet<OlapHierarchy>>();
        for (OlapDimension olapDimension : authorizedDimensions) {
            allAuthorizedDimensionHierarchies.put(olapDimension, new HashSet<OlapHierarchy>(olapDimension.getHierarchies()));
        }
        if (!this.schemaStatements.isEmpty()) {
            HashSet<OlapDimension> firstStatements = new HashSet<OlapDimension>();
            for (MdxAuthorizationStatement statement : this.schemaStatements) {
                Set authorizedDimensionHierarchies;
                if (!(statement instanceof MdxAuthorizationHierarchyStatement)) continue;
                MdxAuthorizationHierarchyStatement hierarchyStatement = (MdxAuthorizationHierarchyStatement)statement;
                MdxExpression mdxExpression = hierarchyStatement.getMdxExpression();
                MdxAuthorizationCurrent current = hierarchyStatement.getCurrent();
                OlapEntity entity = this.executeMdxExpression(null, current, mdxExpression);
                if (!(entity instanceof OlapHierarchy)) {
                    this.errorManager.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"+hierarchy expects a hierarchy name (actual:" + entity.getFriendlyTypeName() + ")"});
                    continue;
                }
                OlapHierarchy hierarchy = (OlapHierarchy)entity;
                OlapDimension dimension = hierarchy.getDimension();
                if (!firstStatements.contains(dimension)) {
                    if (hierarchyStatement.isPlus() && (authorizedDimensionHierarchies = (Set)allAuthorizedDimensionHierarchies.get(dimension)) != null) {
                        authorizedDimensionHierarchies.clear();
                    }
                    firstStatements.add(dimension);
                }
                if (hierarchyStatement.isPlus()) {
                    authorizedDimensionHierarchies = (Set)allAuthorizedDimensionHierarchies.get(dimension);
                    if (authorizedDimensionHierarchies == null) continue;
                    authorizedDimensionHierarchies.add(hierarchy);
                    continue;
                }
                authorizedDimensionHierarchies = (Set)allAuthorizedDimensionHierarchies.get(dimension);
                if (authorizedDimensionHierarchies == null) continue;
                authorizedDimensionHierarchies.remove(hierarchy);
            }
        }
        for (Set set : allAuthorizedDimensionHierarchies.values()) {
            for (OlapHierarchy hierarchy : set) {
                memberFilter.authorizeRegularHierarchy(this.errorManager, hierarchy);
            }
        }
        this.setupRedefinedDefaultMembers(this.schemaStatements, memberFilter);
        this.setupDeniedLevels(this.schemaStatements, memberFilter);
        return memberFilter;
    }

    private void setupRedefinedDefaultMembers(List<MdxAuthorizationStatement> schemaStatements, OlapRoleFlatSchemaMemberFilter memberFilter) {
        for (MdxAuthorizationStatement statement : schemaStatements) {
            if (!(statement instanceof MdxAuthorizationDefaultMemberStatement)) continue;
            MdxAuthorizationDefaultMemberStatement defaultMemberStatement = (MdxAuthorizationDefaultMemberStatement)statement;
            MdxExpression mdxExpression = defaultMemberStatement.getMdxExpression();
            MdxAuthorizationCurrent current = defaultMemberStatement.getCurrent();
            OlapEntity entity = this.executeMdxExpression(null, current, mdxExpression);
            if (!(entity instanceof OlapMember)) {
                this.errorManager.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"+defaultMember expects a member name (actual:" + entity.getFriendlyTypeName() + ")"});
                continue;
            }
            OlapMember member = (OlapMember)entity;
            memberFilter.addRedefinedDefaultMember(this.errorManager, member);
        }
    }

    private void setupDeniedLevels(List<MdxAuthorizationStatement> schemaStatements, OlapRoleFlatSchemaMemberFilter memberFilter) throws CdMdxScannerException, MdxParserException {
        for (MdxAuthorizationStatement statement : schemaStatements) {
            if (!(statement instanceof MdxAuthorizationLevelStatement)) continue;
            MdxAuthorizationLevelStatement levelStatement = (MdxAuthorizationLevelStatement)statement;
            MdxExpression mdxExpression = levelStatement.getMdxExpression();
            MdxAuthorizationCurrent current = levelStatement.getCurrent();
            OlapEntity entity = this.executeMdxExpression(null, current, mdxExpression);
            if (!(entity instanceof OlapLevel)) {
                this.errorManager.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"-level expects a level name (actual:" + entity.getFriendlyTypeName() + ")"});
                continue;
            }
            OlapLevel level = (OlapLevel)entity;
            memberFilter.addHierarchyDeniedLevel(this.errorManager, level);
        }
    }

    private OlapEntity executeMdxExpression(@Nullable OlapCube cube, @Nullable MdxAuthorizationCurrent current, MdxExpression mdx) {
        return this.executeMdxExpression(cube, current, mdx, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapEntity executeMdxExpression(@Nullable OlapCube cube, @Nullable MdxAuthorizationCurrent current, MdxExpression mdx, @Nullable OlapMdxStatementWithCubeSelectExecutionContext[] sContextCache) {
        OlapEngineRequestContext requestContext = this.context.createdOlapEngineContext__();
        try {
            OlapEntity result;
            OlapEngineMdxHelper helper = OlapEngineMdxHelper.create(requestContext);
            OlapEntity olapEntity = result = helper.executeFlatAuthorizationExpression(this.schema, cube, this.sets, this.functions, current, mdx, sContextCache);
            return olapEntity;
        }
        finally {
            requestContext.getSessionContext().onSessionDestroyed();
        }
    }

    private Map<OlapCube, OlapRoleFlatAuthorizedCube> setupAuthorizedCubes(OlapRoleAccess schemaAccess) throws CdMdxScannerException, MdxParserException {
        HashMap<OlapCube, OlapRoleFlatAuthorizedCube> authorizedCubes = new HashMap<OlapCube, OlapRoleFlatAuthorizedCube>();
        for (OlapRegularCube schemaCube : this.schema.getCubes()) {
            authorizedCubes.put(schemaCube, new OlapRoleFlatAuthorizedCube(schemaCube, schemaAccess));
        }
        if (!this.schemaStatements.isEmpty()) {
            boolean isFirstStatement = true;
            for (MdxAuthorizationStatement statement : this.schemaStatements) {
                if (!(statement instanceof MdxAuthorizationCubeStatement)) continue;
                MdxAuthorizationCubeStatement cubeStatement = (MdxAuthorizationCubeStatement)statement;
                String cubeName = cubeStatement.getName();
                OlapRegularCube cube = this.schema.lookupCubeByName(this.context.getNameContext(), cubeName);
                if (cube == null) {
                    this.errorManager.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"+cube reference an unknown cube '" + cubeName + "'"});
                    continue;
                }
                if (isFirstStatement && statement.isPlus()) {
                    authorizedCubes.clear();
                }
                isFirstStatement = false;
                if (cubeStatement.isPlus()) {
                    Boolean isWrite = cubeStatement.isWrite();
                    OlapRoleAccess access = isWrite == null ? schemaAccess : (isWrite != false ? OlapRoleAccess.READ_WRITE : OlapRoleAccess.READ);
                    authorizedCubes.remove(cube);
                    authorizedCubes.put(cube, new OlapRoleFlatAuthorizedCube(cube, access));
                    continue;
                }
                authorizedCubes.remove(cube);
            }
        }
        return authorizedCubes;
    }

    private Map<OlapCube, Set<OlapMeasureGroup>> setupAuthorizedMeasureGroups(Set<OlapCube> authorizedCubes) throws CdMdxScannerException, MdxParserException {
        HashMap<OlapCube, Set<OlapMeasureGroup>> allAuthorizedMeasureGroups = new HashMap<OlapCube, Set<OlapMeasureGroup>>();
        for (OlapCube authorizedCube : authorizedCubes) {
            Set<String> measureGroupNames = authorizedCube.getMeasureGroupNames(null);
            HashSet<OlapMeasureGroup> measureGroups = new HashSet<OlapMeasureGroup>();
            for (String measureGroupName : measureGroupNames) {
                measureGroups.add(new OlapMeasureGroup(authorizedCube, measureGroupName));
            }
            allAuthorizedMeasureGroups.put(authorizedCube, measureGroups);
        }
        if (!this.schemaStatements.isEmpty()) {
            HashSet<OlapCube> firstStatements = new HashSet<OlapCube>();
            for (MdxAuthorizationStatement statement : this.schemaStatements) {
                Set authorizedMeasureGroups;
                if (!(statement instanceof MdxAuthorizationMeasureGroupStatement)) continue;
                MdxAuthorizationMeasureGroupStatement measureGroupStatement = (MdxAuthorizationMeasureGroupStatement)statement;
                MdxExpression mdxExpression = measureGroupStatement.getMdxExpression();
                MdxAuthorizationCurrent current = measureGroupStatement.getCurrent();
                OlapEntity entity = this.executeMdxExpression(null, current, mdxExpression);
                if (!(entity instanceof OlapMeasureGroup)) {
                    this.errorManager.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"+measureGroup expects a measure-group name (actual:" + entity.getFriendlyTypeName() + ")"});
                    continue;
                }
                OlapMeasureGroup measureGroup = (OlapMeasureGroup)entity;
                OlapCube cube = measureGroup.getCube();
                if (!firstStatements.contains(cube)) {
                    if (measureGroupStatement.isPlus() && (authorizedMeasureGroups = (Set)allAuthorizedMeasureGroups.get(cube)) != null) {
                        authorizedMeasureGroups.clear();
                    }
                    firstStatements.add(cube);
                }
                if (measureGroupStatement.isPlus()) {
                    authorizedMeasureGroups = (Set)allAuthorizedMeasureGroups.get(cube);
                    if (authorizedMeasureGroups == null) continue;
                    authorizedMeasureGroups.add(measureGroup);
                    continue;
                }
                authorizedMeasureGroups = (Set)allAuthorizedMeasureGroups.get(cube);
                if (authorizedMeasureGroups == null) continue;
                authorizedMeasureGroups.remove(measureGroup);
            }
        }
        return allAuthorizedMeasureGroups;
    }

    private Map<OlapCube, Set<OlapMeasureMember>> setupAuthorizedMeasures(Set<OlapCube> authorizedCubes, Map<OlapCube, Set<OlapMeasureGroup>> authorizedMeasureGroupsPerCube) throws CdMdxScannerException, MdxParserException {
        HashMap<OlapCube, Set<OlapMeasureMember>> allAuthorizedMeasures = new HashMap<OlapCube, Set<OlapMeasureMember>>();
        for (OlapCube olapCube : authorizedCubes) {
            HashSet<OlapMeasureMember> measures = new HashSet<OlapMeasureMember>();
            Set<OlapMeasureGroup> measureGroups = authorizedMeasureGroupsPerCube.get(olapCube);
            if (measureGroups != null) {
                for (OlapMeasureGroup measureGroup : measureGroups) {
                    measures.addAll(measureGroup.getMeasures());
                }
            }
            allAuthorizedMeasures.put(olapCube, measures);
        }
        boolean withDefinedMeasureGroups = false;
        for (MdxAuthorizationStatement statement : this.schemaStatements) {
            if (!(statement instanceof MdxAuthorizationMeasureGroupStatement)) continue;
            withDefinedMeasureGroups = true;
            break;
        }
        if (!this.schemaStatements.isEmpty()) {
            HashSet<OlapCube> hashSet = new HashSet<OlapCube>();
            for (MdxAuthorizationStatement statement : this.schemaStatements) {
                Set authorizedMeasures;
                if (!(statement instanceof MdxAuthorizationMeasureStatement)) continue;
                MdxAuthorizationMeasureStatement measureStatement = (MdxAuthorizationMeasureStatement)statement;
                MdxExpression mdxExpression = measureStatement.getMdxExpression();
                MdxAuthorizationCurrent current = measureStatement.getCurrent();
                OlapEntity entity = this.executeMdxExpression(null, current, mdxExpression);
                if (!(entity instanceof OlapMeasureMember)) {
                    this.errorManager.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"+measure expects a measure name (actual:" + entity.getFriendlyTypeName() + ")"});
                    continue;
                }
                OlapMeasureMember measure = (OlapMeasureMember)entity;
                OlapCube cube = measure.getCube();
                if (!withDefinedMeasureGroups && !hashSet.contains(cube)) {
                    if (measureStatement.isPlus() && (authorizedMeasures = (Set)allAuthorizedMeasures.get(cube)) != null) {
                        authorizedMeasures.clear();
                    }
                    hashSet.add(cube);
                }
                if (measureStatement.isPlus()) {
                    authorizedMeasures = (Set)allAuthorizedMeasures.get(cube);
                    if (authorizedMeasures == null) continue;
                    authorizedMeasures.add(measure);
                    continue;
                }
                authorizedMeasures = (Set)allAuthorizedMeasures.get(cube);
                if (authorizedMeasures == null) continue;
                authorizedMeasures.remove(measure);
            }
        }
        return allAuthorizedMeasures;
    }

    private void setupMeasures(Set<OlapDimension> authorizedDimensions, OlapRoleFlatSchemaMemberFilter memberFilter, Map<OlapCube, Set<OlapMeasureMember>> authorizedMeasuresPerCube) {
        for (Map.Entry<OlapCube, Set<OlapMeasureMember>> entry : authorizedMeasuresPerCube.entrySet()) {
            OlapCube cube = entry.getKey();
            Set<OlapMeasureMember> measures = entry.getValue();
            OlapMeasuresDimension measuresDimension = cube.getMeasuresDimension();
            authorizedDimensions.add(measuresDimension);
            OlapHierarchy measuresHierarchy = measuresDimension.getHierarchy();
            memberFilter.authorizeMeasuresHierarchy(this.errorManager, measuresHierarchy, measures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private OlapRoleFlatSchemaFactFilter setupTuples(OlapRoleSchemasPermissionsTimings timings, OlapRoleFlatSchemaMemberFilter memberFilter) throws CdMdxScannerException, MdxParserException {
        OlapRoleFlatSchemaFactFilter factFilter = null;
        if (!this.schemaStatements.isEmpty()) {
            S_MdxStatementRequestContextRef clusterContextRef;
            OlapMdxStatementWithCubeSelectExecutionContext cachedContext;
            OlapMdxStatementWithCubeSelectExecutionContext[] sContextCache = SCHEMA_PERMISSIONS_CACHE_ACTIVATED ? new OlapMdxStatementWithCubeSelectExecutionContext[1] : null;
            try {
                Set<String> qNamesU = this.schema.getMeasureGroupQNamesU();
                for (MdxAuthorizationStatement statement : this.schemaStatements) {
                    if (!(statement instanceof MdxAuthorizationTuplesStatement)) continue;
                    MdxAuthorizationTuplesStatement tuplesStatement = (MdxAuthorizationTuplesStatement)statement;
                    MdxExpression mdxExpression = tuplesStatement.getMdxExpression();
                    MdxAuthorizationCurrent current = tuplesStatement.getCurrent();
                    OlapEntity entity = this.executeMdxExpression(this.schema.getFirstNullableCube(), current, mdxExpression, sContextCache);
                    if (tuplesStatement.isForDimensions()) {
                        memberFilter.authorizeTuples(this.errorManager, tuplesStatement.isForAttributes(), tuplesStatement.isPlus(), tuplesStatement.isNoDescendant(), entity);
                    }
                    if (!tuplesStatement.isForCells()) continue;
                    if (factFilter == null) {
                        factFilter = new OlapRoleFlatSchemaFactFilter(this.roleDefinition.getName(), this.schema, this.schema.getName(), timings);
                    }
                    boolean measureGroupNamesMinus = tuplesStatement.measureGroupNamesMinus();
                    List<OlapRoleFlatQualifiedMeasureGroupName> measureGroupNames = tuplesStatement.measureGroupNames();
                    for (OlapRoleFlatQualifiedMeasureGroupName measureGroupName : measureGroupNames) {
                        String qNameU = (measureGroupName.cube + "." + measureGroupName.measureGroup).toUpperCase();
                        if (qNamesU.contains(qNameU)) continue;
                        this.errorManager.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"+tuples (C) unexpected non existing measure group : " + measureGroupName.cube + "." + measureGroupName.measureGroup});
                    }
                    factFilter.authorizeTuples(this.errorManager, tuplesStatement, entity, measureGroupNamesMinus, measureGroupNames);
                }
                OlapMdxStatementWithCubeSelectExecutionContext olapMdxStatementWithCubeSelectExecutionContext = cachedContext = sContextCache != null ? sContextCache[0] : null;
            }
            catch (Throwable throwable) {
                S_MdxStatementRequestContextRef clusterContextRef2;
                OlapMdxStatementWithCubeSelectExecutionContext cachedContext2;
                OlapMdxStatementWithCubeSelectExecutionContext olapMdxStatementWithCubeSelectExecutionContext = cachedContext2 = sContextCache != null ? sContextCache[0] : null;
                if (cachedContext2 != null && (clusterContextRef2 = cachedContext2.getClusterContextRef()).isCreated()) {
                    OlapEngineRequestContext requestContext = cachedContext2.getRequestContext();
                    requestContext.deleteMdxStatementContext(clusterContextRef2);
                }
                throw throwable;
            }
            if (cachedContext != null && (clusterContextRef = cachedContext.getClusterContextRef()).isCreated()) {
                OlapEngineRequestContext requestContext = cachedContext.getRequestContext();
                requestContext.deleteMdxStatementContext(clusterContextRef);
            }
        }
        return factFilter;
    }

    private Set<OlapPerspectiveCube> setupAuthorizedPerspectives(Set<OlapCube> authorizedCubes) throws CdMdxScannerException, MdxParserException {
        HashSet<OlapPerspectiveCube> authorizedPerspectives = new HashSet<OlapPerspectiveCube>();
        OlapPerspectiveManager perspectiveManager = this.schema.getPerspectiveManager();
        List<OlapPerspectiveCube> cubePerspectives = perspectiveManager.getCubePerspectives();
        for (OlapPerspectiveCube olapPerspectiveCube : cubePerspectives) {
            authorizedPerspectives.add(olapPerspectiveCube);
        }
        if (!this.schemaStatements.isEmpty()) {
            boolean isFirstStatement = true;
            for (MdxAuthorizationStatement statement : this.schemaStatements) {
                if (statement instanceof MdxAuthorizationDenyPerspectivesStatement) {
                    authorizedPerspectives.clear();
                    continue;
                }
                if (!(statement instanceof MdxAuthorizationPerspectiveStatement)) continue;
                MdxAuthorizationPerspectiveStatement perspectiveStatement = (MdxAuthorizationPerspectiveStatement)statement;
                String perspectiveName = perspectiveStatement.getName();
                OlapPerspectiveCube perspectiveCube = this.schema.lookupCubePerspectiveByName(this.context.getNameContext(), perspectiveName);
                if (perspectiveCube == null) {
                    this.errorManager.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"+perspective reference an unknown perspective'" + perspectiveName + "'"});
                    continue;
                }
                if (isFirstStatement && statement.isPlus()) {
                    authorizedPerspectives.clear();
                }
                isFirstStatement = false;
                if (perspectiveStatement.isPlus()) {
                    authorizedPerspectives.add(perspectiveCube);
                    continue;
                }
                authorizedPerspectives.remove(perspectiveCube);
            }
        }
        for (OlapPerspectiveCube olapPerspectiveCube : authorizedPerspectives) {
            OlapRegularCube actualCube = olapPerspectiveCube.getRegularCube();
            if (authorizedCubes.contains(actualCube)) continue;
            this.errorManager.addError(OlapRoleDefinitionErrorCode.PERSPECTIVE_WITH_DENIED_CUBE, new Serializable[]{this.schema.getName(), olapPerspectiveCube.getName(OlapNameContext.DEFAULT_VALUES), actualCube.getName(OlapNameContext.DEFAULT_VALUES)});
        }
        return authorizedPerspectives;
    }
}

