/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.flat.permissions.schema;

import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorManager;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatHierarchyMemberFilter;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatMeasuresHierarchyMemberFilter;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatRegularHierarchyMemberFilter;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatSchemaMemberTupleFilter;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.component.naming.OlapDefaultNamesContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapMeasureGroup;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.filter.dimension.OlapAbstractMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapAuthorizedMeasureGroupMemberFilterHelper;
import crazydev.iccube.olap.eval.filter.dimension.OlapMeasureGroupMemberFilterHelper;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class OlapRoleFlatSchemaMemberFilter
extends OlapAbstractMemberFilter {
    private final String name;
    private final Map<OlapHierarchy, OlapRoleFlatHierarchyMemberFilter> authorizedHierarchyFilters;
    private final OlapMeasureGroupMemberFilterHelper authorizedMeasureGroups;
    private final OlapRoleFlatSchemaMemberTupleFilter authorizedTuples;

    public OlapRoleFlatSchemaMemberFilter(String name) {
        this.name = name;
        this.authorizedHierarchyFilters = new HashMap<OlapHierarchy, OlapRoleFlatHierarchyMemberFilter>();
        this.authorizedMeasureGroups = new OlapAuthorizedMeasureGroupMemberFilterHelper();
        this.authorizedTuples = new OlapRoleFlatSchemaMemberTupleFilter();
    }

    private OlapRoleFlatSchemaMemberFilter(String name, Map<OlapHierarchy, OlapRoleFlatHierarchyMemberFilter> authorizedHierarchyFilters, OlapMeasureGroupMemberFilterHelper authorizedMeasureGroups, OlapRoleFlatSchemaMemberTupleFilter authorizedTuples) {
        this.name = name;
        this.authorizedHierarchyFilters = authorizedHierarchyFilters;
        this.authorizedMeasureGroups = authorizedMeasureGroups;
        this.authorizedTuples = authorizedTuples;
    }

    public OlapRoleFlatSchemaMemberFilter copyForIncrementalLoad(OlapSchemaIncrLoadInfo incrLoadInfo) {
        return new OlapRoleFlatSchemaMemberFilter(this.name, this.authorizedHierarchyFilters, this.authorizedMeasureGroups, this.authorizedTuples);
    }

    public OlapRoleFlatSchemaMemberFilter copyForLoadPartitions(OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        return new OlapRoleFlatSchemaMemberFilter(this.name, this.authorizedHierarchyFilters, this.authorizedMeasureGroups, this.authorizedTuples);
    }

    public OlapRoleFlatSchemaMemberFilter copyForUnloadPartitions(OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        return new OlapRoleFlatSchemaMemberFilter(this.name, this.authorizedHierarchyFilters, this.authorizedMeasureGroups, this.authorizedTuples);
    }

    @Nullable
    public OlapRoleFlatSchemaMemberTupleFilter getAuthorizedTuples() {
        if (this.authorizedTuples.isEmpty()) {
            return null;
        }
        return this.authorizedTuples;
    }

    public void authorizeRegularHierarchy(OlapRoleDefinitionErrorManager errorManager, OlapHierarchy hierarchy) {
        if (hierarchy.isMeasures()) {
            errorManager.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"+hierarchy cannot reference the [Measures] hierarchy"});
            return;
        }
        this.authorizedHierarchyFilters.put(hierarchy, new OlapRoleFlatRegularHierarchyMemberFilter(hierarchy));
    }

    public void authorizeMeasuresHierarchy(OlapRoleDefinitionErrorManager errorManager, OlapHierarchy hierarchy, Set<OlapMeasureMember> authorizedMeasures) {
        this.authorizedHierarchyFilters.put(hierarchy, new OlapRoleFlatMeasuresHierarchyMemberFilter(hierarchy, authorizedMeasures));
    }

    public void addRedefinedDefaultMember(OlapRoleDefinitionErrorManager errorManager, OlapMember member) {
        OlapHierarchy hierarchy = member.getHierarchy();
        OlapRoleFlatHierarchyMemberFilter filter = this.authorizedHierarchyFilters.get(hierarchy);
        if (filter == null) {
            errorManager.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"+defaultMember (" + member.getUniqueName(OlapDefaultNamesContext.DEFAULT_VALUES) + ") is from a denied hierarchy : " + hierarchy.getUniqueName(OlapDefaultNamesContext.DEFAULT_VALUES)});
            return;
        }
        filter.setRedefinedDefaultMember(member);
    }

    public void addHierarchyDeniedLevel(OlapRoleDefinitionErrorManager errorManager, OlapLevel level) {
        OlapHierarchy hierarchy = level.getHierarchy();
        OlapRoleFlatHierarchyMemberFilter filter = this.authorizedHierarchyFilters.get(hierarchy);
        if (filter != null) {
            filter.addDeniedLevel(errorManager, level);
        }
    }

    public void authorizeTuples(OlapRoleDefinitionErrorManager errorManager, boolean forAttributes, boolean plus, boolean noDescendant, OlapEntity entity) {
        OlapTupleSet<OlapTuple> set;
        OlapListTupleSet<OlapTuple> list;
        List<OlapTuple> tuples;
        OlapTupleSet tuples2;
        OlapTupleSet<OlapMember> members;
        if (entity instanceof OlapMember) {
            OlapMember member = (OlapMember)((Object)entity);
            OlapHierarchy hierarchy = member.getHierarchy();
            OlapRoleFlatHierarchyMemberFilter authorizedHierarchyFilter = this.authorizedHierarchyFilters.get(hierarchy);
            if (authorizedHierarchyFilter != null) {
                authorizedHierarchyFilter.authorizeMember(errorManager, plus, noDescendant, member);
            }
            if (forAttributes && hierarchy.isBase()) {
                Stream<OlapHierarchy> attributes = hierarchy.getDimension().getHierarchies().stream().filter(OlapHierarchy::isAttributeHierarchy);
                attributes.forEach(attributeHier -> {
                    OlapMember attributeMember;
                    OlapRoleFlatHierarchyMemberFilter attributeFilter = this.authorizedHierarchyFilters.get(attributeHier);
                    if (authorizedHierarchyFilter != null && (attributeMember = member.getAttributeMember((OlapHierarchy)attributeHier)) != null) {
                        attributeFilter.authorizeMember(errorManager, plus, noDescendant, attributeMember);
                    }
                });
            }
            return;
        }
        if (entity instanceof OlapTupleSet && (members = (tuples2 = (OlapTupleSet)entity).asMemberSet()) != null) {
            OlapHierarchy hierarchy;
            OlapRoleFlatHierarchyMemberFilter authorizedHierarchyFilter;
            OlapIterator iterator = members.getIterator(false);
            iterator.reset();
            OlapMember member = (OlapMember)iterator.next();
            if (member != null && (authorizedHierarchyFilter = this.authorizedHierarchyFilters.get(hierarchy = member.getHierarchy())) != null) {
                do {
                    List<OlapHierarchy> attributes;
                    authorizedHierarchyFilter.authorizeMember(errorManager, plus, noDescendant, member);
                    if (!forAttributes || !hierarchy.isBase() || (attributes = hierarchy.getDimension().getHierarchies().stream().filter(OlapHierarchy::isAttributeHierarchy).collect(Collectors.toList())).isEmpty()) continue;
                    OlapMember finalMember = member;
                    attributes.forEach(attributeHier -> {
                        OlapMember attributeMember;
                        OlapRoleFlatHierarchyMemberFilter attributeFilter = this.authorizedHierarchyFilters.get(attributeHier);
                        if (attributeFilter != null && (attributeMember = finalMember.getAttributeMember((OlapHierarchy)attributeHier)) != null) {
                            attributeFilter.authorizeMember(errorManager, plus, noDescendant, attributeMember);
                        }
                    });
                } while ((member = (OlapMember)iterator.next()) != null);
            }
            return;
        }
        if (entity instanceof OlapTuple) {
            entity = OlapSetFactory.singleton((OlapTuple)((Object)entity));
        }
        if (entity instanceof OlapTupleSet && !(tuples = (list = (set = entity).asTupleList()).getTuples()).isEmpty()) {
            for (OlapTuple tuple : tuples) {
                this.authorizedTuples.authorizeTuple(errorManager, plus, tuple);
            }
            return;
        }
        errorManager.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"+tuples (D) expects a member/tuple set expression (actual:" + entity.getFriendlyTypeName() + ")"});
    }

    public void onBuildDone(OlapRoleDefinitionErrorManager errorManager, Set<OlapMeasureGroup> authorizedMeasureGroups) {
        this.authorizedMeasureGroups.addAuthorizedMeasureGroups(authorizedMeasureGroups);
        for (OlapRoleFlatHierarchyMemberFilter hierarchyMemberFilter : this.authorizedHierarchyFilters.values()) {
            hierarchyMemberFilter.onBuildDone(errorManager);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isAccepting(OlapHierarchy hierarchy) {
        return this.authorizedHierarchyFilters.containsKey(hierarchy);
    }

    @Override
    @Nullable
    public boolean isNotFiltering(OlapHierarchy hierarchy) {
        OlapRoleFlatHierarchyMemberFilter filter = this.authorizedHierarchyFilters.get(hierarchy);
        return filter != null && filter.isNotFiltering() != false;
    }

    @Override
    public boolean isAccepting(OlapLevel level) {
        OlapHierarchy hierarchy = level.getHierarchy();
        OlapRoleFlatHierarchyMemberFilter filter = this.authorizedHierarchyFilters.get(hierarchy);
        if (filter != null) {
            return filter.isAccepting(level);
        }
        return false;
    }

    @Override
    @Nullable
    public OlapMember getRedefinedDefaultMember(OlapHierarchy hierarchy) {
        OlapRoleFlatHierarchyMemberFilter filter = this.authorizedHierarchyFilters.get(hierarchy);
        if (filter != null) {
            return filter.getRedefinedDefaultMember();
        }
        return null;
    }

    @Override
    public boolean isAccepting(OlapMember member) {
        boolean accepted = this.isAcceptingWithoutMeasureGroup(member);
        return this.authorizedMeasureGroups.isAuthorized(member, accepted);
    }

    @Override
    public boolean isAccepting(String propertyName, OlapLevel level) {
        OlapHierarchy hierarchy = level.getAttributeHierarchy(propertyName);
        return hierarchy == null || this.isAccepting(hierarchy);
    }

    private boolean isAcceptingWithoutMeasureGroup(OlapMember member) {
        OlapMember secMember = member.getMemberForSecurity();
        OlapHierarchy hierarchy = secMember.getHierarchy();
        OlapRoleFlatHierarchyMemberFilter filter = this.authorizedHierarchyFilters.get(hierarchy);
        if (filter != null) {
            return filter.isAccepting(secMember);
        }
        OlapHierarchyScope scope = hierarchy.getScope();
        return scope == OlapHierarchyScope.REQUEST;
    }
}

