/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.flat.permissions.schema;

import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorManager;
import crazydev.iccube.authorization.permissions.filter.fact.OlapRoleFactFilter;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatQualifiedMeasureGroupName;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatSchemaFactFilterLine;
import crazydev.iccube.authorizationx.permissions.schemas.OlapRoleSchemasPermissionsTimings;
import crazydev.iccube.cluster.shared.perms.S_FactAllMeasureGroupsPermsDef;
import crazydev.iccube.cluster.shared.perms.S_FactFullControlPermsDef;
import crazydev.iccube.cluster.shared.perms.S_FactPermsDef;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationTuplesStatement;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarAbstractEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class OlapRoleFlatSchemaFactFilter
extends OlapRoleFactFilter {
    private final OlapSchema schema;
    private final String roleName;
    private final String name;
    private final OlapRoleSchemasPermissionsTimings timings;
    private final List<OlapRoleFlatSchemaFactFilterLine> filterLines;

    public OlapRoleFlatSchemaFactFilter(String roleName, OlapSchema schema, String name, OlapRoleSchemasPermissionsTimings timings) {
        this.roleName = roleName;
        this.schema = schema;
        this.name = name;
        this.timings = timings;
        this.filterLines = new ArrayList<OlapRoleFlatSchemaFactFilterLine>();
    }

    private OlapRoleFlatSchemaFactFilter(OlapSchema schema, String roleName, String name, OlapRoleSchemasPermissionsTimings timings, List<OlapRoleFlatSchemaFactFilterLine> filterLines) {
        this.schema = schema;
        this.roleName = roleName;
        this.name = name;
        this.timings = timings;
        this.filterLines = filterLines;
    }

    public OlapRoleFlatSchemaFactFilter copyForIncrementalLoad(OlapSchemaIncrLoadInfo incrLoadInfo) {
        return new OlapRoleFlatSchemaFactFilter(this.schema, this.roleName, this.name, this.timings, this.filterLines);
    }

    public OlapRoleFlatSchemaFactFilter copyForLoadPartitions(OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        return new OlapRoleFlatSchemaFactFilter(this.schema, this.roleName, this.name, this.timings, this.filterLines);
    }

    public OlapRoleFlatSchemaFactFilter copyForUnloadPartitions(OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        return new OlapRoleFlatSchemaFactFilter(this.schema, this.roleName, this.name, this.timings, this.filterLines);
    }

    public void authorizeTuples(OlapRoleDefinitionErrorManager errorManager, MdxAuthorizationTuplesStatement statement, OlapEntity entity, boolean measureGroupNamesMinus, List<OlapRoleFlatQualifiedMeasureGroupName> measureGroupNames) {
        if (entity instanceof OlapMember || entity instanceof OlapTuple || entity instanceof OlapTupleSet) {
            this.filterLines.add(new OlapRoleFlatSchemaFactFilterLine(statement, (OlapNonScalarAbstractEntity)entity, measureGroupNamesMinus, measureGroupNames));
            return;
        }
        errorManager.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"+tuples (C) expects a member/tuple/tuple-set expression (actual:" + entity.getFriendlyTypeName() + ")"});
    }

    public void onBuildDone() {
    }

    @Override
    public S_FactPermsDef createClusterSchemaSecurityPermsDef() {
        if (this.filterLines.isEmpty()) {
            return new S_FactFullControlPermsDef();
        }
        return new S_FactAllMeasureGroupsPermsDef(this.timings, this.filterLines);
    }
}

