/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.flat.permissions.schema;

import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatSchemaMemberTuples;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.IOlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import java.util.ArrayList;
import java.util.List;

class OlapRoleFlatSchemaDeniedMemberTuples
extends OlapRoleFlatSchemaMemberTuples {
    private final List<OlapTuple> deniedTuples = new ArrayList<OlapTuple>();

    OlapRoleFlatSchemaDeniedMemberTuples() {
    }

    @Override
    boolean isPlus() {
        return false;
    }

    @Override
    void authorizeTuple(OlapTuple tuple) {
        this.deniedTuples.add(tuple);
    }

    @Override
    List<OlapTuple> getTuples() {
        return this.deniedTuples;
    }

    @Override
    boolean isAccepting(IOlapTuple tuple) {
        if (tuple.isKO()) {
            return true;
        }
        for (OlapTuple deniedTuple : this.deniedTuples) {
            if (!OlapRoleFlatSchemaDeniedMemberTuples.isDenied(deniedTuple, tuple)) continue;
            return false;
        }
        return true;
    }

    private static boolean isDenied(OlapTuple deniedTuple, IOlapTuple tuple) {
        int deniedTupleMC = deniedTuple.getMemberCount();
        int tupleMC = tuple.getMemberCount();
        if (tupleMC < deniedTupleMC) {
            return false;
        }
        for (int ii = 0; ii < deniedTupleMC; ++ii) {
            OlapMember deniedTupleMember = deniedTuple.getMember(ii);
            OlapMember tupleMember = tuple.getMember(deniedTupleMember.getHierarchy());
            if (tupleMember != null && deniedTupleMember.isAncestorOrSame(tupleMember)) continue;
            return false;
        }
        return true;
    }
}

