/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.flat.permissions.schema;

import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorManager;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatHierarchyMemberFilter;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.component.naming.OlapDefaultNamesContext;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class OlapRoleFlatRegularHierarchyMemberFilter
extends OlapRoleFlatHierarchyMemberFilter {
    @Nullable
    private Set<OlapLevel> deniedLevels;
    @Nullable
    private MutableRoaringBitmap membersBitmap;
    private boolean bitmapTypeSetup = false;
    private boolean allowedBitmap = false;

    public OlapRoleFlatRegularHierarchyMemberFilter(OlapHierarchy hierarchy) {
        super(hierarchy);
    }

    @Override
    public void addDeniedLevel(OlapRoleDefinitionErrorManager errorManager, OlapLevel level) {
        if (this.deniedLevels == null) {
            this.deniedLevels = new HashSet<OlapLevel>();
        }
        this.deniedLevels.add(level);
        for (OlapLevel nextLevel = level.getNextLevel(); nextLevel != null; nextLevel = nextLevel.getNextLevel()) {
            this.deniedLevels.add(nextLevel);
        }
    }

    @Override
    public void authorizeMember(OlapRoleDefinitionErrorManager errorManager, boolean plus, boolean noDescendant, OlapMember member) {
        MutableRoaringBitmap memberBitmap = this.createMemberBitmap(errorManager, member, plus, noDescendant);
        memberBitmap.runOptimize();
        this.authorizeMembers(memberBitmap, plus);
    }

    @Override
    public void authorizeMembers(OlapRoleDefinitionErrorManager errorManager, boolean plus, boolean noDescendant, OlapTupleSet<OlapMember> members) {
        MutableRoaringBitmap memberBitmap = this.createMemberBitmap(errorManager, members, plus, noDescendant);
        memberBitmap.runOptimize();
        this.authorizeMembers(memberBitmap, plus);
    }

    private void authorizeMembers(MutableRoaringBitmap memberBitmap, boolean plus) {
        if (this.initialAuthorizeMembers(plus, memberBitmap)) {
            return;
        }
        if (this.membersBitmap == null) {
            throw new RuntimeException("internal error: inconsistent member authorization setup");
        }
        if (this.allowedBitmap) {
            if (plus) {
                this.membersBitmap.or(memberBitmap);
            } else {
                this.membersBitmap.andNot(memberBitmap);
            }
        } else if (plus) {
            this.membersBitmap.andNot(memberBitmap);
        } else {
            this.membersBitmap.or(memberBitmap);
        }
    }

    private boolean initialAuthorizeMembers(boolean plus, MutableRoaringBitmap memberBitmap) {
        if (this.bitmapTypeSetup) {
            return false;
        }
        this.allowedBitmap = plus;
        this.membersBitmap = memberBitmap;
        this.bitmapTypeSetup = true;
        return true;
    }

    private MutableRoaringBitmap createMemberBitmap(OlapRoleDefinitionErrorManager errorManager, OlapTupleSet<OlapMember> members, boolean plus, boolean noDescendant) {
        OlapMember member;
        MutableRoaringBitmap memberBitmap = new MutableRoaringBitmap();
        OlapIterator allMembers = members.getIterator(false);
        allMembers.reset();
        while ((member = (OlapMember)allMembers.next()) != null) {
            this.createMemberBitmap(errorManager, memberBitmap, member, plus, noDescendant);
        }
        return memberBitmap;
    }

    private MutableRoaringBitmap createMemberBitmap(OlapRoleDefinitionErrorManager errorManager, OlapMember member, boolean plus, boolean noDescendant) {
        MutableRoaringBitmap memberBitmap = new MutableRoaringBitmap();
        this.createMemberBitmap(errorManager, memberBitmap, member, plus, noDescendant);
        return memberBitmap;
    }

    private void createMemberBitmap(OlapRoleDefinitionErrorManager errorManager, MutableRoaringBitmap memberBitmap, OlapMember member, boolean plus, boolean noDescendant) {
        if (member.isCalculated()) {
            errorManager.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"+tuples (D) calc. members are not supported (" + member.getUniqueName(OlapDefaultNamesContext.DEFAULT_VALUES) + ")"});
            return;
        }
        memberBitmap.add(member.getUniqueHierarchyMemberIndex());
        if (plus) {
            OlapMember ascendant;
            OlapIterator ascendants = member.getAscendants().getIterator(false);
            ascendants.reset();
            while ((ascendant = (OlapMember)ascendants.next()) != null) {
                memberBitmap.add(ascendant.getUniqueHierarchyMemberIndex());
            }
        }
        if (!noDescendant) {
            OlapMember child;
            OlapIterator<OlapMember> children = member.getChildrenR(null, null, false);
            children.reset();
            while ((child = children.next()) != null) {
                memberBitmap.add(child.getUniqueHierarchyMemberIndex());
            }
        }
    }

    @Override
    public void onBuildDone(OlapRoleDefinitionErrorManager errorManager) {
        if (this.membersBitmap != null) {
            this.membersBitmap.runOptimize();
        }
        super.onBuildDone(errorManager);
    }

    @Override
    public boolean isAccepting(OlapLevel level) {
        return this.deniedLevels == null || this.deniedLevels.isEmpty() || !this.deniedLevels.contains(level);
    }

    @Override
    public boolean isAccepting(OlapMember member) {
        OlapLevel level = member.getLevel();
        if (!this.isAccepting(level)) {
            return false;
        }
        if (member.isCalculated()) {
            return true;
        }
        if (this.membersBitmap == null) {
            return true;
        }
        boolean bit = this.membersBitmap.contains(member.getUniqueHierarchyMemberIndex());
        return this.allowedBitmap == bit;
    }

    @Override
    public Boolean isNotFiltering() {
        return this.deniedLevels == null && this.membersBitmap == null;
    }
}

