/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.flat.definition.schemas;

import crazydev.iccube.authorization.permissions.common.OlapRoleAccess;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationDenySchemasStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationSchemaExpressionPP;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationSchemaStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationStatement;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapRoleFlatSchemasProfile {
    @Nullable
    private final OlapRoleAccess defaultAccess;
    private final boolean defaultDrillthroughDenied;
    private final List<MdxAuthorizationSchemaStatement> schemaStatements;
    private final List<MdxAuthorizationSchemaExpressionPP> schemaExpressions;

    public OlapRoleFlatSchemasProfile(OlapRoleAccess defaultSchemaAccess, boolean drillthroughDenied) {
        this(defaultSchemaAccess, drillthroughDenied, Collections.emptyList(), Collections.emptyList());
    }

    public OlapRoleFlatSchemasProfile(@Nullable OlapRoleAccess defaultAccess, boolean defaultDrillthroughDenied, List<MdxAuthorizationSchemaStatement> schemaStatements, List<MdxAuthorizationSchemaExpressionPP> schemaExpressions) {
        this.defaultAccess = defaultAccess;
        this.defaultDrillthroughDenied = defaultDrillthroughDenied;
        this.schemaStatements = schemaStatements;
        this.schemaExpressions = schemaExpressions;
    }

    @Nullable
    public OlapRoleAccess defaultSchemaAccess() {
        return this.defaultAccess;
    }

    public boolean defaultDrillthroughDenied() {
        return this.defaultDrillthroughDenied;
    }

    public boolean isSchemaAuthorized(String schema) {
        if (this.defaultAccess == null) {
            return false;
        }
        if (this.schemaStatements.isEmpty()) {
            return true;
        }
        for (MdxAuthorizationSchemaStatement statement : this.schemaStatements) {
            if (!(statement instanceof MdxAuthorizationDenySchemasStatement)) continue;
            return false;
        }
        MdxAuthorizationStatement firstSchema = null;
        for (MdxAuthorizationSchemaStatement statement : this.schemaStatements) {
            if (firstSchema == null) {
                firstSchema = statement;
            }
            if (statement.isPlus() && OlapCaseInsensitiveName.equals(schema, statement.getName())) {
                return true;
            }
            if (!statement.isMinus() || !OlapCaseInsensitiveName.equals(schema, statement.getName())) continue;
            return false;
        }
        if (firstSchema == null) {
            return true;
        }
        return !firstSchema.isPlus();
    }

    @Nullable
    public MdxAuthorizationSchemaExpressionPP getSchemaProfile(String schema) {
        for (MdxAuthorizationSchemaExpressionPP profile : this.schemaExpressions) {
            if (!OlapCaseInsensitiveName.equals(schema, profile.getName())) continue;
            return profile;
        }
        return null;
    }
}

