/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.flat.definition.schemas;

import crazydev.common.exception.CdErrorLocation;
import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.permissions.common.OlapRoleAccess;
import crazydev.iccube.authorization.validation.common.OlapRoleAbstractDefinitionValidator;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.authorizationx.flat.definition.schemas.OlapRoleFlatSchemasDefinition;
import crazydev.iccube.authorizationx.flat.definition.schemas.OlapRoleFlatSchemasDefinitionParser;
import crazydev.iccube.authorizationx.flat.definition.schemas.OlapRoleFlatSchemasProfile;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationDenySchemasStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationExpression;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationSchemaAccessStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationSchemaExpressionPP;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationSchemaStatement;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapRoleFlatSchemasDefinitionValidator
extends OlapRoleAbstractDefinitionValidator<OlapRoleDefinition, OlapRoleFlatSchemasDefinition> {
    @Override
    protected void doValidate(OlapRoleDefinitionValidationContext context, OlapRoleDefinition owner, OlapRoleFlatSchemasDefinition me) {
        try {
            OlapRoleFlatSchemasProfile profile;
            if (me.hasValidatedDefinition()) {
                return;
            }
            long startMS = System.currentTimeMillis();
            OlapRoleFlatSchemasDefinitionParser parser = new OlapRoleFlatSchemasDefinitionParser();
            MdxAuthorizationExpression authorization = parser.parse(context, me);
            OlapLoggers.CHECKPOINTS.info((Object)"[ic3] parsed schemas permissions for role [%s] in [%s]".formatted(owner != null ? owner.getName() : "-", CdTimeUtils.formatMillisEx((long)startMS)));
            OlapRoleAccess defaultSchemaAccess = this.validateDefaultSchemaAccess(context, authorization);
            boolean drillthroughDenied = this.validatedDrillthroughDenied(context, authorization);
            if (authorization != null) {
                List<MdxAuthorizationSchemaStatement> schemaStatements = this.validateSchemaStatements(context, authorization);
                List<MdxAuthorizationSchemaExpressionPP> schemaExpressions = this.validateSchemaExpressions(context, authorization);
                profile = new OlapRoleFlatSchemasProfile(defaultSchemaAccess, drillthroughDenied, schemaStatements, schemaExpressions);
            } else {
                profile = new OlapRoleFlatSchemasProfile(defaultSchemaAccess, drillthroughDenied);
            }
            me.setValidatedDefinition(profile);
        }
        catch (CdMdxScannerException | MdxParserException ex) {
            CdErrorLocation location = ex.getLocation();
            int lineNumber = location != null ? location.lineNumber() : -1;
            OlapLoggers.AUTHORIZATION.error((Object)("[auth] invalid flat authorization definition [line:" + lineNumber + "]"), (Throwable)ex);
            context.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID_X, new Serializable[]{Integer.valueOf(lineNumber), ex.getMessage()});
        }
    }

    @Nullable
    private OlapRoleAccess validateDefaultSchemaAccess(OlapRoleDefinitionValidationContext context, @Nullable MdxAuthorizationExpression authorization) {
        if (authorization == null) {
            return OlapRoleFlatSchemasDefinitionValidator.defaultSchemaAccess();
        }
        for (MdxAuthorizationSchemaStatement statement : authorization.getSchemaStatements()) {
            if (!(statement instanceof MdxAuthorizationDenySchemasStatement)) continue;
            return null;
        }
        MdxAuthorizationSchemaAccessStatement defaultAccessStatement = authorization.getDefaultAccess();
        if (defaultAccessStatement != null) {
            return defaultAccessStatement.isWrite() ? OlapRoleAccess.READ_WRITE : OlapRoleAccess.READ;
        }
        return OlapRoleFlatSchemasDefinitionValidator.defaultSchemaAccess();
    }

    private static OlapRoleAccess defaultSchemaAccess() {
        return OlapRoleAccess.READ_WRITE;
    }

    private boolean validatedDrillthroughDenied(OlapRoleDefinitionValidationContext context, @Nullable MdxAuthorizationExpression authorization) {
        if (authorization == null) {
            return false;
        }
        return authorization.getDrillthrough() != null;
    }

    private List<MdxAuthorizationSchemaStatement> validateSchemaStatements(OlapRoleDefinitionValidationContext context, @Nullable MdxAuthorizationExpression authorization) {
        ArrayList<MdxAuthorizationSchemaStatement> schemaStatements = new ArrayList<MdxAuthorizationSchemaStatement>();
        if (authorization == null) {
            return schemaStatements;
        }
        HashSet<String> schemaNames = new HashSet<String>();
        for (MdxAuthorizationSchemaStatement schemaStatement : authorization.getSchemaStatements()) {
            if (schemaStatement instanceof MdxAuthorizationDenySchemasStatement) continue;
            String schemaName = schemaStatement.getName().toLowerCase();
            if (schemaNames.contains(schemaName)) {
                context.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"duplicated schema : " + schemaStatement.getName()});
                break;
            }
            schemaStatements.add(schemaStatement);
            schemaNames.add(schemaName);
        }
        return schemaStatements;
    }

    private List<MdxAuthorizationSchemaExpressionPP> validateSchemaExpressions(OlapRoleDefinitionValidationContext context, @Nullable MdxAuthorizationExpression authorization) {
        ArrayList<MdxAuthorizationSchemaExpressionPP> schemaExpressions = new ArrayList<MdxAuthorizationSchemaExpressionPP>();
        if (authorization == null) {
            return schemaExpressions;
        }
        HashSet<String> schemaNames = new HashSet<String>();
        for (MdxAuthorizationSchemaExpressionPP schemaExpression : authorization.getSchemaExpressions()) {
            String schemaName = schemaExpression.getName().toLowerCase();
            if (schemaNames.contains(schemaName)) {
                context.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"duplicated schema authorization : " + schemaExpression.getName()});
                break;
            }
            schemaExpressions.add(schemaExpression);
            schemaNames.add(schemaName);
        }
        return schemaExpressions;
    }
}

