/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.flat.definition.docs;

import crazydev.iccube.authorizationx.definition.docs.IOlapRoleDocsDefinition;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsAccessRights;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsPermissions;
import crazydev.iccube.fs.OlapPath;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapRoleFlatDocsProfile {
    private final String roleName;
    private final IOlapRoleDocsDefinition definition;
    private final Map<String, OlapRoleFlatDocsPermissions> permissions = new HashMap<String, OlapRoleFlatDocsPermissions>();
    private final boolean onError;
    private final boolean useDocs;

    public OlapRoleFlatDocsProfile(String roleName, IOlapRoleDocsDefinition definition, boolean onError) {
        this(roleName, definition, Collections.emptyMap(), onError, false);
    }

    public OlapRoleFlatDocsProfile(String roleName, IOlapRoleDocsDefinition definition, Map<String, OlapRoleFlatDocsAccessRights> accessRights) {
        this(roleName, definition, accessRights, false, false);
    }

    public OlapRoleFlatDocsProfile(String roleName, IOlapRoleDocsDefinition definition, boolean useDocs, Map<String, OlapRoleFlatDocsAccessRights> accessRights) {
        this(roleName, definition, accessRights, false, useDocs);
    }

    private OlapRoleFlatDocsProfile(String roleName, IOlapRoleDocsDefinition definition, Map<String, OlapRoleFlatDocsAccessRights> accessRights, boolean onError, boolean useDocs) {
        this.roleName = roleName;
        this.definition = definition;
        for (Map.Entry<String, OlapRoleFlatDocsAccessRights> rights : accessRights.entrySet()) {
            String path = rights.getKey();
            OlapRoleFlatDocsAccessRights perms = rights.getValue();
            this.permissions.put(path, new OlapRoleFlatDocsPermissions(roleName, perms));
        }
        this.onError = onError;
        this.useDocs = useDocs;
    }

    public String getDefinition() {
        return this.definition.getDefinition();
    }

    public boolean isEmpty() {
        return this.permissions.isEmpty();
    }

    public boolean isOnError() {
        return this.onError;
    }

    public boolean isUseDocs() {
        return this.useDocs;
    }

    public int size() {
        return this.permissions.size();
    }

    @Nullable
    public final OlapRoleFlatDocsPermissions getMeta(OlapPath path) {
        return this.getMeta(path.toSimplePath());
    }

    @Nullable
    public final OlapRoleFlatDocsPermissions getMeta(String path) {
        OlapRoleFlatDocsPermissions perms = this.permissions.get(path);
        if (perms == null) {
            if (path.endsWith(".icc-report")) {
                path = path.substring(0, path.length() - ".icc-report".length());
                perms = this.permissions.get(path);
            } else if (path.endsWith(".icc-app")) {
                path = path.substring(0, path.length() - ".icc-app".length());
                perms = this.permissions.get(path);
            } else if (path.endsWith(".icc-gadget")) {
                path = path.substring(0, path.length() - ".icc-gadget".length());
                perms = this.permissions.get(path);
            }
        }
        return perms;
    }
}

