/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.flat.definition.docs;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorizationx.definition.docs.IOlapRoleDocsDefinition;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsAccessRights;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsProfile;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class OlapRoleFlatDocsDefinitionParser {
    public static final String APPLICATIONS_ROOT = "/ic3-reporting/data/gizmos/applications";
    public static final String DASHBOARDS_ROOT = "/ic3-reporting/data/gizmos/dashboards";
    public static final String GADGETS_ROOT = "/ic3-reporting/data/gizmos/gadgets";
    public static final String QUERIES_ROOT = "/ic3-reporting/data/gizmos/queries";
    private static final Pattern RE = Pattern.compile("^\\+\\s*((dashboard|application|gadget|query|path)\\s+(.*)\\s+(READ|WRITE))|(useDocs)\\s*$", 2);

    public static OlapRoleFlatDocsProfile parse(String role, IOlapRoleDocsDefinition definition) {
        try {
            MutableBoolean onError = new MutableBoolean(false);
            MutableBoolean useDocs = new MutableBoolean(false);
            HashMap<String, OlapRoleFlatDocsAccessRights> accessRights = new HashMap<String, OlapRoleFlatDocsAccessRights>();
            String raw = definition.getDefinition().replace(",,", "$comma$").replace(",", "\n");
            new BufferedReader(new StringReader(raw)).lines().forEach(line -> {
                if (onError.booleanValue() || useDocs.booleanValue()) {
                    return;
                }
                if ((line = line.trim().replace("$comma$", ",")).startsWith("--")) {
                    return;
                }
                if (CdStringUtils.isNullOrBlank((String)line)) {
                    return;
                }
                try {
                    Matcher matcher = RE.matcher((CharSequence)line);
                    if (matcher.find()) {
                        int groupCount = matcher.groupCount();
                        String g0 = matcher.group(0);
                        String g1 = matcher.group(1);
                        String g2 = matcher.group(2);
                        String g3 = matcher.group(3);
                        String g4 = matcher.group(4);
                        if (g0 != null && g1 == null && g2 == null && g3 == null && g4 == null) {
                            useDocs.setValue(true);
                        } else {
                            String type = matcher.group(2).trim();
                            String path = matcher.group(3).trim();
                            String access = matcher.group(4).trim();
                            String dashboardPath = OlapRoleFlatDocsDefinitionParser.fixPath(type, path);
                            OlapRoleFlatDocsAccessRights mode = OlapRoleFlatDocsAccessRights.valueOf(access);
                            accessRights.put(dashboardPath, mode);
                        }
                    } else {
                        OlapLoggers.AUTHORIZATION.error((Object)("[auth] invalid docs authorization definition [" + line + "] in role [" + role + "]"));
                        onError.setValue(true);
                    }
                }
                catch (IllegalArgumentException ex) {
                    OlapLoggers.AUTHORIZATION.error((Object)("[auth] invalid docs authorization definition [" + line + "] in role [" + role + "]"), (Throwable)ex);
                    onError.setValue(true);
                }
            });
            if (onError.isTrue()) {
                return new OlapRoleFlatDocsProfile(role, definition, true);
            }
            if (useDocs.isTrue()) {
                return new OlapRoleFlatDocsProfile(role, definition, true, Collections.emptyMap());
            }
            return new OlapRoleFlatDocsProfile(role, definition, accessRights);
        }
        catch (RuntimeException ex) {
            OlapLoggers.AUTHORIZATION.error((Object)("[auth] invalid docs authorization definition in role [" + role + "]"), (Throwable)ex);
            return new OlapRoleFlatDocsProfile(role, definition, true);
        }
    }

    private static String fixPath(String type, String path) {
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (((String)path).endsWith("/")) {
            path = ((String)path).substring(0, ((String)path).length() - 2);
        }
        if (type.equalsIgnoreCase("application")) {
            return APPLICATIONS_ROOT + (String)path;
        }
        if (type.equalsIgnoreCase("dashboard")) {
            return DASHBOARDS_ROOT + (String)path;
        }
        if (type.equalsIgnoreCase("gadget")) {
            return GADGETS_ROOT + (String)path;
        }
        if (type.equalsIgnoreCase("query")) {
            return QUERIES_ROOT + (String)path;
        }
        if (type.equalsIgnoreCase("path")) {
            return path;
        }
        throw new IllegalArgumentException("unknown type [" + type + "]");
    }
}

