/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.flat.definition.dashboards;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorizationx.definition.dashboards.IOlapRoleDashboardsDefinition;
import crazydev.iccube.authorizationx.flat.definition.dashboards.OlapDashboardsFeature;
import crazydev.iccube.authorizationx.flat.definition.dashboards.OlapRoleFlatDashboardsProfile;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.HashSet;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class OlapRoleFlatDashboardsDefinitionParser {
    public static OlapRoleFlatDashboardsProfile parse(String role, IOlapRoleDashboardsDefinition definition) {
        try {
            MutableBoolean onError = new MutableBoolean(false);
            HashSet<OlapDashboardsFeature> features = new HashSet<OlapDashboardsFeature>();
            String raw = definition.getDefinition().replace(",", "\n");
            new BufferedReader(new StringReader(raw)).lines().forEach(line -> {
                if ((line = line.trim()).startsWith("--")) {
                    return;
                }
                if (CdStringUtils.isNullOrBlank((String)line)) {
                    return;
                }
                try {
                    features.add(OlapDashboardsFeature.valueOf(line));
                }
                catch (IllegalArgumentException ex) {
                    OlapLoggers.AUTHORIZATION.error((Object)("[auth] invalid dashboards authorization definition [" + line + "] in role [" + role + "]"), (Throwable)ex);
                    onError.setValue(true);
                }
            });
            if (onError.isTrue()) {
                return new OlapRoleFlatDashboardsProfile(definition, true);
            }
            return new OlapRoleFlatDashboardsProfile(definition, features);
        }
        catch (RuntimeException ex) {
            OlapLoggers.AUTHORIZATION.error((Object)("[auth] invalid dashboards authorization definition in role [" + role + "]"), (Throwable)ex);
            return new OlapRoleFlatDashboardsProfile(definition, true);
        }
    }
}

