/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.validation.schema;

import crazydev.common.property.CdProperty;
import crazydev.iccube.authorization.definition.cube.OlapRoleCubeDefinition;
import crazydev.iccube.authorization.definition.cube.OlapRoleCubeEntityListDefinition;
import crazydev.iccube.authorization.definition.cube.OlapRolePerspectiveEntityListDefinition;
import crazydev.iccube.authorization.definition.dimension.OlapRoleDimensionDefinition;
import crazydev.iccube.authorization.definition.dimension.OlapRoleDimensionEntityListDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemaDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemasDefinition;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorManager;
import crazydev.iccube.authorization.validation.common.OlapRoleAbstractDefinitionValidator;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.contextual.IOlapContextual;
import crazydev.iccube.olap.component.schemas.OlapEngineSchemaDefFactoryHelper;
import crazydev.iccube.olap.util.OlapCaseInsensitiveNames;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapRoleSchemaDefinitionValidator
extends OlapRoleAbstractDefinitionValidator<OlapRoleSchemasDefinition, OlapRoleSchemaDefinition> {
    @Override
    protected void doValidate(OlapRoleDefinitionValidationContext context, OlapRoleSchemasDefinition owner, OlapRoleSchemaDefinition me) {
        this.validateNotNullField(context, OlapRoleSchemaDefinition.NAME, me.getName());
        this.validateNotNullField(context, OlapRoleSchemaDefinition.ACCESS, (Object)me.getAccess());
        this.validateDimensions(context, owner, me);
        this.validateCubes(context, owner, me);
        this.validatePerspectives(context, owner, me);
        OlapRoleSchemaDefinitionValidator.validatePerspectivesEx(context, owner, me);
    }

    private void validateDimensions(OlapRoleDefinitionValidationContext context, OlapRoleSchemasDefinition owner, OlapRoleSchemaDefinition me) {
        OlapCaseInsensitiveNames resolvedAuthorizedDimensionNames;
        OlapEngineSchemaDefFactoryHelper helper;
        CdProperty DIMENSION_NAMES = OlapRoleSchemaDefinition.AUTHORIZED_DIMENSION_NAMES;
        OlapRoleDimensionEntityListDefinition authorizedDimensionNames = me.getAuthorizedDimensionNames();
        this.validateNotNullField(context, DIMENSION_NAMES, authorizedDimensionNames);
        if (authorizedDimensionNames.getType() == null) {
            context.addError(DIMENSION_NAMES, OlapRoleDefinitionErrorCode.AUTHORIZED_DIMENSION_NAMES_TYPE_IS_NULL, new Serializable[0]);
        }
        switch (authorizedDimensionNames.getType()) {
            case SELECTION: 
            case ALL_MINUS_SELECTION: {
                List<String> selection = authorizedDimensionNames.getNames();
                if (selection == null) break;
                helper = context.getSchemaDefFactoryHelper();
                OlapCaseInsensitiveNames allNames = helper.getAllDimensionNames(me.getName());
                for (String name : selection) {
                    if (allNames.contains(name)) continue;
                    context.addError(DIMENSION_NAMES, OlapRoleDefinitionErrorCode.AUTHORIZED_DIMENSION_NAME_UNKNOWN, new Serializable[]{name});
                }
                break;
            }
        }
        List<OlapRoleDimensionDefinition> dimensionPermissions = me.getDimensionPermissions();
        if (dimensionPermissions != null) {
            helper = context.getSchemaDefFactoryHelper();
            OlapCaseInsensitiveNames allDimensionNames = helper.getAllDimensionNames(me.getName());
            resolvedAuthorizedDimensionNames = authorizedDimensionNames.resolveAuthorizedNames(helper.getAllDimensionNames(me.getName()));
            for (OlapRoleDimensionDefinition dimensionPermission : dimensionPermissions) {
                String dimensionPermissionName = dimensionPermission.getName();
                if (dimensionPermissionName == null) continue;
                if (!allDimensionNames.contains(dimensionPermissionName)) {
                    context.addErrorWithContextual((IOlapContextual)dimensionPermission, OlapRoleDefinitionErrorCode.DIMENSION_PERMISSION_NAME_UNKNOWN, new Serializable[]{dimensionPermissionName});
                    continue;
                }
                if (resolvedAuthorizedDimensionNames.contains(dimensionPermissionName)) continue;
                context.addErrorWithContextual((IOlapContextual)dimensionPermission, OlapRoleDefinitionErrorCode.DIMENSION_PERMISSION_NOT_AUTHORIZED, new Serializable[]{dimensionPermissionName});
            }
            this.validateUniqueOlapNames(context, me, dimensionPermissions);
            this.validateChildren(context, me, dimensionPermissions);
        }
        helper = context.getSchemaDefFactoryHelper();
        OlapCaseInsensitiveNames availableDimensionNames = helper.getAllDimensionNames(me.getName());
        resolvedAuthorizedDimensionNames = authorizedDimensionNames.resolveAuthorizedNames(availableDimensionNames);
        if (!availableDimensionNames.isEmpty() && resolvedAuthorizedDimensionNames.isEmpty()) {
            context.addError(OlapRoleDefinitionErrorCode.EMPTY_RESOLVED_AUTHORIZED_DIMENSIONS, new Serializable[]{me.getName()});
        }
    }

    private void validateCubes(OlapRoleDefinitionValidationContext context, OlapRoleSchemasDefinition owner, OlapRoleSchemaDefinition me) {
        OlapEngineSchemaDefFactoryHelper helper;
        CdProperty CUBE_NAMES = OlapRoleSchemaDefinition.AUTHORIZED_CUBE_NAMES;
        OlapRoleCubeEntityListDefinition authorizedCubeNames = me.getAuthorizedCubeNames();
        this.validateNotNullField(context, CUBE_NAMES, authorizedCubeNames);
        if (authorizedCubeNames.getType() == null) {
            context.addError(CUBE_NAMES, OlapRoleDefinitionErrorCode.AUTHORIZED_CUBE_NAMES_TYPE_IS_NULL, new Serializable[0]);
        }
        switch (authorizedCubeNames.getType()) {
            case SELECTION: 
            case ALL_MINUS_SELECTION: {
                List<String> selection = authorizedCubeNames.getNames();
                if (selection == null) break;
                helper = context.getSchemaDefFactoryHelper();
                OlapCaseInsensitiveNames allNames = helper.getAllCubeNames(me.getName());
                for (String name : selection) {
                    if (allNames.contains(name)) continue;
                    context.addError(CUBE_NAMES, OlapRoleDefinitionErrorCode.AUTHORIZED_CUBE_NAME_UNKNOWN, new Serializable[]{name});
                }
                break;
            }
        }
        List<OlapRoleCubeDefinition> cubePermissions = me.getCubePermissions();
        if (cubePermissions != null) {
            helper = context.getSchemaDefFactoryHelper();
            OlapCaseInsensitiveNames allCubeNames = helper.getAllCubeNames(me.getName());
            OlapCaseInsensitiveNames resolvedAuthorizedCubeNames = authorizedCubeNames.resolveAuthorizedNames(helper.getAllCubeNames(me.getName()));
            for (OlapRoleCubeDefinition cubePermission : cubePermissions) {
                String cubePermissionName = cubePermission.getName();
                if (cubePermissionName == null) continue;
                if (!allCubeNames.contains(cubePermissionName)) {
                    context.addErrorWithContextual((IOlapContextual)cubePermission, OlapRoleDefinitionErrorCode.CUBE_PERMISSION_NAME_UNKNOWN, new Serializable[]{cubePermissionName});
                    continue;
                }
                if (resolvedAuthorizedCubeNames.contains(cubePermissionName)) continue;
                context.addErrorWithContextual((IOlapContextual)cubePermission, OlapRoleDefinitionErrorCode.CUBE_PERMISSION_NOT_AUTHORIZED, new Serializable[]{cubePermissionName});
            }
            this.validateUniqueOlapNames(context, me, cubePermissions);
            this.validateChildren(context, me, cubePermissions);
        }
    }

    private void validatePerspectives(OlapRoleDefinitionValidationContext context, OlapRoleSchemasDefinition owner, OlapRoleSchemaDefinition me) {
        CdProperty NAMES = OlapRoleSchemaDefinition.AUTHORIZED_PERSPECTIVE_NAMES;
        OlapRolePerspectiveEntityListDefinition authorizedNames = me.getAuthorizedPerspectiveNames();
        if (authorizedNames == null) {
            return;
        }
        if (authorizedNames.getType() == null) {
            context.addError(NAMES, OlapRoleDefinitionErrorCode.AUTHORIZED_PERSPECTIVE_NAMES_TYPE_IS_NULL, new Serializable[0]);
        }
        switch (authorizedNames.getType()) {
            case SELECTION: 
            case ALL_MINUS_SELECTION: {
                List<String> selection = authorizedNames.getNames();
                if (selection == null) break;
                OlapEngineSchemaDefFactoryHelper helper = context.getSchemaDefFactoryHelper();
                OlapCaseInsensitiveNames allNames = helper.getAllCubePerspectiveNames(me.getName());
                for (String name : selection) {
                    if (allNames.contains(name)) continue;
                    context.addError(NAMES, OlapRoleDefinitionErrorCode.AUTHORIZED_PERSPECTIVE_NAME_UNKNOWN, new Serializable[]{name});
                }
                break;
            }
        }
    }

    private static void validatePerspectivesEx(OlapRoleDefinitionValidationContext context, OlapRoleSchemasDefinition owner, OlapRoleSchemaDefinition me) {
        String schemaName = me.getName();
        if (schemaName == null) {
            return;
        }
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)context.getErrorManager();
        OlapEngineSchemaDefFactoryHelper helper = context.getSchemaDefFactoryHelper();
        List<IOlapBuilderCubeDef> allCubes = helper.getAllCubes(schemaName);
        OlapRoleCubeEntityListDefinition authorizedCubeNames = me.getAuthorizedCubeNames();
        if (authorizedCubeNames == null) {
            return;
        }
        OlapCaseInsensitiveNames authorizedCubes = authorizedCubeNames.resolveAuthorizedNames(helper.getAllCubeNames(schemaName));
        OlapRolePerspectiveEntityListDefinition authorizedPerspectiveNames = me.getAuthorizedPerspectiveNames();
        OlapCaseInsensitiveNames authorizedPerspectives = authorizedPerspectiveNames.resolveAuthorizedNames(helper.getAllCubePerspectiveNames(schemaName));
        for (int ii = 0; ii < authorizedPerspectives.size(); ++ii) {
            String authorizedPerspective = authorizedPerspectives.get(ii);
            String cubeId = helper.getPerspectiveCubeId(schemaName, authorizedPerspective);
            String cubeName = OlapRoleSchemaDefinitionValidator.toCubeName(allCubes, cubeId);
            if (cubeName == null || authorizedCubes.contains(cubeName)) continue;
            errorManager.addError(OlapRoleDefinitionErrorCode.PERSPECTIVE_WITH_DENIED_CUBE, new Serializable[]{schemaName, authorizedPerspective, cubeName});
        }
    }

    @Nullable
    private static String toCubeName(List<IOlapBuilderCubeDef> allCubes, @Nullable String cubeId) {
        if (cubeId == null) {
            return null;
        }
        for (IOlapBuilderCubeDef cube : allCubes) {
            if (!cubeId.equals(cube.getId())) continue;
            return cube.getName();
        }
        return null;
    }
}

