/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.validation.measuregroup;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.mdx.error.CdMdxException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorization.definition.cube.OlapRoleCubeDefinition;
import crazydev.iccube.authorization.definition.measuregroup.OlapRoleMeasureGroupDefinition;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionError;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorManager;
import crazydev.iccube.authorization.validation.common.OlapRoleAbstractDefinitionValidator;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import java.io.Serializable;
import java.util.UUID;

public class OlapRoleMeasureGroupDefinitionValidator
extends OlapRoleAbstractDefinitionValidator<OlapRoleCubeDefinition, OlapRoleMeasureGroupDefinition> {
    @Override
    protected void doValidate(OlapRoleDefinitionValidationContext context, OlapRoleCubeDefinition owner, OlapRoleMeasureGroupDefinition me) {
        String deniedCells;
        boolean hasDeniedCells;
        boolean hasAllowedCells;
        this.validateNotBlankField(context, OlapRoleMeasureGroupDefinition.NAME, me.getName());
        String allowedCells = me.getAllowedCells();
        boolean bl = hasAllowedCells = !CdStringUtils.isNullOrBlank((String)allowedCells);
        if (hasAllowedCells) {
            this.validateAllowedCellsMdxExpression(context, me, allowedCells);
        }
        boolean bl2 = hasDeniedCells = !CdStringUtils.isNullOrBlank((String)(deniedCells = me.getDeniedCells()));
        if (hasDeniedCells) {
            this.validateDeniedCellsMdxExpression(context, me, deniedCells);
        }
        if (!hasAllowedCells && !hasDeniedCells) {
            context.addError(OlapRoleDefinitionErrorCode.MDX_PARSE_MEASURE_GROUP_MISSING_CELLS, new Serializable[]{me.getName()});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateAllowedCellsMdxExpression(OlapRoleDefinitionValidationContext context, OlapRoleMeasureGroupDefinition measureGroupDefinition, String allowedCells) {
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)context.getErrorManager();
        try {
            MdxExpression expression = this.parseValueExpression(context, allowedCells, UUID.randomUUID().toString());
            if (expression == null) return;
        }
        catch (CdMdxException ex) {
            LOGGER.error((Object)"Role measure-group permissions setup : reporting an MDX (allowed-cells) parsing error", (Throwable)ex);
            errorManager.addError(new OlapRoleDefinitionError(ex.getError(), OlapRoleDefinitionErrorCode.MDX_PARSE_MEASURE_GROUP_ALLOWED_CELLS_ERROR, new Serializable[]{measureGroupDefinition.getName(), ex.getError()}));
            return;
        }
        catch (CdRuntimeException ex) {
            LOGGER.error((Object)"Role measure-group permissions setup : reporting an MDX (allowed-cells) parsing error", (Throwable)ex);
            errorManager.addError(new OlapRoleDefinitionError(ex.getError(), OlapRoleDefinitionErrorCode.MDX_PARSE_MEASURE_GROUP_ALLOWED_CELLS_ERROR, new Serializable[]{measureGroupDefinition.getName(), ex.getError()}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateDeniedCellsMdxExpression(OlapRoleDefinitionValidationContext context, OlapRoleMeasureGroupDefinition measureGroupDefinition, String deniedCells) {
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)context.getErrorManager();
        try {
            MdxExpression expression = this.parseValueExpression(context, deniedCells, UUID.randomUUID().toString());
            if (expression == null) return;
        }
        catch (CdMdxException ex) {
            LOGGER.error((Object)"Role measure-group permissions setup : reporting an MDX (denied-cells) parsing error", (Throwable)ex);
            errorManager.addError(new OlapRoleDefinitionError(ex.getError(), OlapRoleDefinitionErrorCode.MDX_PARSE_MEASURE_GROUP_DENIED_CELLS_ERROR, new Serializable[]{measureGroupDefinition.getName(), ex.getError()}));
            return;
        }
        catch (CdRuntimeException ex) {
            LOGGER.error((Object)"Role measure-group permissions setup : reporting an MDX (denied-cells) parsing error", (Throwable)ex);
            errorManager.addError(new OlapRoleDefinitionError(ex.getError(), OlapRoleDefinitionErrorCode.MDX_PARSE_MEASURE_GROUP_DENIED_CELLS_ERROR, new Serializable[]{measureGroupDefinition.getName(), ex.getError()}));
        }
    }
}

