/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.validation.hierarchy;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.mdx.error.CdMdxException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorization.definition.dimension.OlapRoleDimensionDefinition;
import crazydev.iccube.authorization.definition.hierarchy.OlapRoleHierarchyDefinition;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionError;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorManager;
import crazydev.iccube.authorization.validation.common.OlapRoleAbstractDefinitionValidator;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import java.io.Serializable;
import java.util.UUID;

public class OlapRoleHierarchyDefinitionValidator
extends OlapRoleAbstractDefinitionValidator<OlapRoleDimensionDefinition, OlapRoleHierarchyDefinition> {
    @Override
    protected void doValidate(OlapRoleDefinitionValidationContext context, OlapRoleDimensionDefinition owner, OlapRoleHierarchyDefinition me) {
        this.validateNotBlankField(context, OlapRoleHierarchyDefinition.NAME, me.getName());
        this.validateNotNullField(context, OlapRoleHierarchyDefinition.AUTHORIZED_MEMBER_NAMES_TYPE, (Object)me.getAuthorizedMemberNamesType());
        switch (me.getAuthorizedMemberNamesType()) {
            case SELECTION: 
            case ALL_MINUS_SELECTION: {
                this.validateMembersMdxExpression(context, me);
                this.validateDefaultMemberMdxExpression(context, me);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateMembersMdxExpression(OlapRoleDefinitionValidationContext context, OlapRoleHierarchyDefinition hierarchyDefinition) {
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)context.getErrorManager();
        try {
            MdxExpression expression;
            String mdx = hierarchyDefinition.getAuthorizedMemberNames();
            if (!CdStringUtils.isNullOrBlank((String)mdx) && (expression = this.parseValueExpression(context, mdx, UUID.randomUUID().toString())) == null) return;
        }
        catch (CdMdxException ex) {
            LOGGER.error((Object)"Role hierarchy permissions setup : reporting an MDX (default member) parsing error", (Throwable)ex);
            errorManager.addError(new OlapRoleDefinitionError(ex.getError(), OlapRoleDefinitionErrorCode.MDX_PARSE_HIERARCHY_DEFAULT_MEMBER_ERROR, new Serializable[]{hierarchyDefinition.getName(), ex.getError()}));
            return;
        }
        catch (CdRuntimeException ex) {
            LOGGER.error((Object)"Role hierarchy permissions setup : reporting an MDX (default member) parsing error", (Throwable)ex);
            errorManager.addError(new OlapRoleDefinitionError(ex.getError(), OlapRoleDefinitionErrorCode.MDX_PARSE_HIERARCHY_DEFAULT_MEMBER_ERROR, new Serializable[]{hierarchyDefinition.getName(), ex.getError()}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateDefaultMemberMdxExpression(OlapRoleDefinitionValidationContext context, OlapRoleHierarchyDefinition hierarchyDefinition) {
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)context.getErrorManager();
        try {
            String mdx = hierarchyDefinition.getDefaultMember();
            if (mdx == null) return;
            this.validateNotBlankField(context, OlapRoleHierarchyDefinition.DEFAULT_MEMBER_NAME, mdx);
            MdxExpression expression = this.parseValueExpression(context, mdx, UUID.randomUUID().toString());
            if (expression == null) return;
        }
        catch (CdMdxException ex) {
            LOGGER.error((Object)"Role hierarchy permissions setup : reporting an MDX (members) parsing error", (Throwable)ex);
            errorManager.addError(new OlapRoleDefinitionError(ex.getError(), OlapRoleDefinitionErrorCode.MDX_PARSE_HIERARCHY_MEMBERS_ERROR, new Serializable[]{hierarchyDefinition.getName(), ex.getError()}));
            return;
        }
        catch (CdRuntimeException ex) {
            LOGGER.error((Object)"Role hierarchy permissions setup : reporting an MDX (members) parsing error", (Throwable)ex);
            errorManager.addError(new OlapRoleDefinitionError(ex.getError(), OlapRoleDefinitionErrorCode.MDX_PARSE_HIERARCHY_MEMBERS_ERROR, new Serializable[]{hierarchyDefinition.getName(), ex.getError()}));
        }
    }
}

