/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.validation.cube;

import crazydev.common.property.CdProperty;
import crazydev.iccube.authorization.definition.cube.OlapRoleCubeDefinition;
import crazydev.iccube.authorization.definition.measuregroup.OlapRoleMeasureGroupDefinition;
import crazydev.iccube.authorization.definition.measuregroup.OlapRoleMeasureGroupEntityListDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemaDefinition;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.validation.common.OlapRoleAbstractDefinitionValidator;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.contextual.IOlapContextual;
import crazydev.iccube.olap.component.schemas.OlapEngineSchemaDefFactoryHelper;
import crazydev.iccube.olap.util.OlapCaseInsensitiveNames;
import java.io.Serializable;
import java.util.List;

public class OlapRoleCubeDefinitionValidator
extends OlapRoleAbstractDefinitionValidator<OlapRoleSchemaDefinition, OlapRoleCubeDefinition> {
    @Override
    protected void doValidate(OlapRoleDefinitionValidationContext context, OlapRoleSchemaDefinition owner, OlapRoleCubeDefinition me) {
        this.validateNotBlankField(context, OlapRoleCubeDefinition.NAME, me.getName());
        this.validateNotNullField(context, OlapRoleCubeDefinition.ACCESS, (Object)me.getAccess());
        this.validateMeasureGroups(context, owner, me);
    }

    private void validateMeasureGroups(OlapRoleDefinitionValidationContext context, OlapRoleSchemaDefinition owner, OlapRoleCubeDefinition me) {
        OlapCaseInsensitiveNames resolvedAuthorizedMeasureGroupNames;
        OlapEngineSchemaDefFactoryHelper helper;
        CdProperty MEASURE_GROUP_NAMES = OlapRoleCubeDefinition.AUTHORIZED_MEASURE_GROUP_NAMES;
        OlapRoleMeasureGroupEntityListDefinition authorizedMeasureGroupNames = me.getAuthorizedMeasureGroupNames();
        this.validateNotNullField(context, MEASURE_GROUP_NAMES, authorizedMeasureGroupNames);
        if (authorizedMeasureGroupNames.getType() == null) {
            context.addError(MEASURE_GROUP_NAMES, OlapRoleDefinitionErrorCode.AUTHORIZED_MEASURE_GROUP_NAMES_TYPE_IS_NULL, new Serializable[0]);
        }
        switch (authorizedMeasureGroupNames.getType()) {
            case SELECTION: 
            case ALL_MINUS_SELECTION: {
                List<String> selection = authorizedMeasureGroupNames.getNames();
                if (selection == null) break;
                helper = context.getSchemaDefFactoryHelper();
                OlapCaseInsensitiveNames allNames = helper.getAllMeasureGroupNames(owner.getName(), me.getName());
                for (String name : selection) {
                    if (allNames.contains(name)) continue;
                    context.addError(MEASURE_GROUP_NAMES, OlapRoleDefinitionErrorCode.AUTHORIZED_MEASURE_GROUP_NAME_UNKNOWN, new Serializable[]{name});
                }
                break;
            }
        }
        List<OlapRoleMeasureGroupDefinition> measureGroupPermissions = me.getMeasureGroupPermissions();
        if (measureGroupPermissions != null) {
            helper = context.getSchemaDefFactoryHelper();
            OlapCaseInsensitiveNames allMeasureGroupNames = helper.getAllMeasureGroupNames(owner.getName(), me.getName());
            resolvedAuthorizedMeasureGroupNames = authorizedMeasureGroupNames.resolveAuthorizedNames(helper.getAllMeasureGroupNames(owner.getName(), me.getName()));
            for (OlapRoleMeasureGroupDefinition measureGroupPermission : measureGroupPermissions) {
                String measureGroupPermissionName = measureGroupPermission.getName();
                if (measureGroupPermissionName == null) continue;
                if (!allMeasureGroupNames.contains(measureGroupPermissionName)) {
                    context.addErrorWithContextual((IOlapContextual)measureGroupPermission, OlapRoleDefinitionErrorCode.MEASURE_GROUP_PERMISSION_NAME_UNKNOWN, new Serializable[]{measureGroupPermissionName});
                    continue;
                }
                if (resolvedAuthorizedMeasureGroupNames.contains(measureGroupPermissionName)) continue;
                context.addErrorWithContextual((IOlapContextual)measureGroupPermission, OlapRoleDefinitionErrorCode.MEASURE_GROUP_PERMISSION_NOT_AUTHORIZED, new Serializable[]{measureGroupPermissionName});
            }
            this.validateUniqueOlapNames(context, me, measureGroupPermissions);
            this.validateChildren(context, me, measureGroupPermissions);
        }
        helper = context.getSchemaDefFactoryHelper();
        OlapCaseInsensitiveNames availableMeasureGroupNames = helper.getAllMeasureGroupNames(owner.getName(), me.getName());
        resolvedAuthorizedMeasureGroupNames = authorizedMeasureGroupNames.resolveAuthorizedNames(helper.getAllMeasureGroupNames(owner.getName(), me.getName()));
        if (!availableMeasureGroupNames.isEmpty() && resolvedAuthorizedMeasureGroupNames.isEmpty()) {
            context.addError(OlapRoleDefinitionErrorCode.EMPTY_RESOLVED_AUTHORIZED_MEASURE_GROUPS, new Serializable[]{owner.getName(), me.getName()});
        }
    }
}

