/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.validation.application;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorization.definition.application.OlapRoleApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleApplicationFeatureDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleApplicationsDefinition;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.validation.common.OlapRoleAbstractDefinitionValidator;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import java.io.Serializable;
import java.util.List;

public class OlapRoleApplicationsDefinitionValidator
extends OlapRoleAbstractDefinitionValidator<OlapRoleDefinition, OlapRoleApplicationsDefinition> {
    @Override
    protected void doValidate(OlapRoleDefinitionValidationContext context, OlapRoleDefinition owner, OlapRoleApplicationsDefinition me) {
        this.validateNotNullField(context, OlapRoleApplicationsDefinition.PERMISSIONS, me.getPermissions());
        for (OlapRoleApplicationDefinition permission : me.getPermissions()) {
            List<OlapRoleApplicationFeatureDefinition> features = permission.getFeatures();
            if (features == null || features.isEmpty()) {
                context.addError(OlapRoleDefinitionErrorCode.APP_MISSING_FEATURES, new Serializable[]{permission.getName()});
                continue;
            }
            for (OlapRoleApplicationFeatureDefinition feature : features) {
                if (!CdStringUtils.isNullOrBlank((String)feature.getName())) continue;
                context.addError(OlapRoleDefinitionErrorCode.APP_MISSING_FEATURE_NAME, new Serializable[]{permission.getName()});
            }
        }
        List<OlapRoleApplicationDefinition> expectedApplications = OlapRoleApplicationsDefinition.createAllPermissionsAsDisabled();
        for (OlapRoleApplicationDefinition expectedApplication : expectedApplications) {
            this.validateApplication(context, expectedApplication, me.getPermissions());
        }
    }

    private void validateApplication(OlapRoleDefinitionValidationContext context, OlapRoleApplicationDefinition expectedApplication, List<OlapRoleApplicationDefinition> permissions) {
        for (OlapRoleApplicationDefinition permission : permissions) {
            if (!permission.getName().equals(expectedApplication.getName())) continue;
            this.validateApplicationFeatures(context, expectedApplication, permission);
            return;
        }
        context.addError(OlapRoleDefinitionErrorCode.APP_MISSING_PERMISSION, new Serializable[]{expectedApplication.getName()});
    }

    private void validateApplicationFeatures(OlapRoleDefinitionValidationContext context, OlapRoleApplicationDefinition expectedApplication, OlapRoleApplicationDefinition permission) {
        if (expectedApplication.getFeatures().size() != permission.getFeatures().size()) {
            for (OlapRoleApplicationFeatureDefinition feature : permission.getFeatures()) {
                boolean found = false;
                for (OlapRoleApplicationFeatureDefinition expectedFeature : expectedApplication.getFeatures()) {
                    if (!expectedFeature.getName().equals(feature.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                context.addError(OlapRoleDefinitionErrorCode.APP_UNEXPECTED_FEATURE, new Serializable[]{permission.getName(), feature.getName()});
            }
        }
        if (permission.isSingleSelectionFeature()) {
            int selectedCount = 0;
            for (OlapRoleApplicationFeatureDefinition feature : permission.getFeatures()) {
                if (!feature.isEnabled() || ++selectedCount <= 1) continue;
                context.addError(OlapRoleDefinitionErrorCode.APP_MULTI_SELECT_FEATURE, new Serializable[]{permission.getName()});
            }
        }
    }
}

