/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.service;

import crazydev.iccube.authorization.definition.role.IOlapRoleDefinition;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinitions;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.authorization.permissions.role.UxPermissions;
import crazydev.iccube.authorization.permissions.role.UxPermissionsDetails;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.info.OlapLixContent;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.pub.authentication.OlapAuthenticationServiceException;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.pub.authorization.OlapMaxUserExceededException;
import crazydev.iccube.pub.authorization.OlapMissingRoleException;
import crazydev.iccube.pub.common.IOlapServiceConfiguration;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.request.log.OlapRequestId;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapRolePermissionsServiceWrapper
implements IOlapPermissionsService {
    private final OlapEngineComponent olapEngineComponent;
    private final IOlapPermissionsService service;
    private final Set<String> authorizedUsers = new HashSet<String>();

    public OlapRolePermissionsServiceWrapper(OlapEngineComponent olapEngineComponent, IOlapPermissionsService service) {
        this.olapEngineComponent = olapEngineComponent;
        this.service = service;
    }

    @Override
    public void configure(IOlapServiceConfiguration configuration) throws OlapAuthenticationServiceException {
        this.service.configure(configuration);
    }

    @Override
    public void configureEx(IOlapServiceConfiguration configuration) throws OlapAuthenticationServiceException {
        this.service.configureEx(configuration);
    }

    @Override
    public void setupOnConfigured() {
        this.service.setupOnConfigured();
    }

    @Override
    public void setupOnStartupError() {
        this.service.setupOnStartupError();
    }

    @Override
    public void reportDashboardsPermissionsOnStartup(OlapRequestId requestId) {
        this.service.reportDashboardsPermissionsOnStartup(requestId);
    }

    @Override
    public void reportDocsPermissionsOnStartup(OlapRequestId requestId) {
        this.service.reportDocsPermissionsOnStartup(requestId);
    }

    @Override
    public void setupApplicationsPermissionsOnStartup(OlapRequestId requestId, OlapRoleDefinitions roles) throws OlapContextualBigException {
        this.service.setupApplicationsPermissionsOnStartup(requestId, roles);
    }

    @Override
    public boolean applyPermissions(OlapEngineRequestContext requestContext, OlapRoleDefinitions roleDefinitions) throws OlapContextualBigException {
        return this.service.applyPermissions(requestContext, roleDefinitions);
    }

    @Override
    public void deleteAllOnTheFlyPermissions() {
        this.service.deleteAllOnTheFlyPermissions();
    }

    @Override
    public void deleteOnTheFlyPermissions(String uuid) {
        this.service.deleteOnTheFlyPermissions(uuid);
    }

    @Override
    public void checkUserRole(OlapPrincipal user) throws OlapMaxUserExceededException, OlapMissingRoleException {
        this.service.checkUserRole(user);
        this.assertUserLimit(user);
    }

    @Override
    public OlapRolePermissions authorizeUser(OlapRequestId requestId, OlapPrincipal user) throws OlapMaxUserExceededException, OlapMissingRoleException {
        OlapRolePermissions permissions = this.service.authorizeUser(requestId, user);
        this.assertUserLimit(user);
        return permissions;
    }

    @Override
    public OlapRoleApplicationPermissions authorizeUserForApplications(OlapPrincipal user) throws OlapMaxUserExceededException, OlapMissingRoleException {
        OlapRoleApplicationPermissions permissions = this.service.authorizeUserForApplications(user);
        this.assertUserLimit(user);
        return permissions;
    }

    private void assertUserLimit(OlapPrincipal user) throws OlapMaxUserExceededException {
        if (user.isInternal()) {
            return;
        }
        String key = user.getName() + "/" + user.getRoleName();
        if (this.authorizedUsers.contains(key)) {
            return;
        }
        OlapLixContent lix = this.olapEngineComponent.getLixContent();
        if (this.authorizedUsers.size() < lix.getUserLimit()) {
            this.authorizedUsers.add(key);
            return;
        }
        throw new OlapMaxUserExceededException(user.getName(), this.authorizedUsers.size());
    }

    @Override
    public int getRevisionNumber() {
        return this.service.getRevisionNumber();
    }

    @Override
    @Nullable
    public OlapRolePermissions getAdministratorRolePermissions() {
        return this.service.getAdministratorRolePermissions();
    }

    @Override
    public OlapRolePermissions getRolePermissions(String roleName) {
        return this.service.getRolePermissions(roleName);
    }

    @Override
    public List<String> getAllRoleNames(boolean withAdmin, boolean withAnonymous) {
        return this.service.getAllRoleNames(withAdmin, withAnonymous);
    }

    @Override
    public List<String> getAllRoleNamesForUX(boolean withAdmin, boolean withAnonymous) {
        return this.service.getAllRoleNamesForUX(withAdmin, withAnonymous);
    }

    @Override
    public List<IOlapRoleDefinition> getAllRoleDefinitionsForUX(boolean withAdmin, boolean withAnonymous) {
        return this.service.getAllRoleDefinitionsForUX(withAdmin, withAnonymous);
    }

    @Override
    @Nullable
    public OlapRoleDefinition getRoleDefinitionByUUID(String uuid) {
        return this.service.getRoleDefinitionByUUID(uuid);
    }

    @Override
    @Nullable
    public OlapRoleDefinition getRoleDefinitionByName(String name) {
        return this.service.getRoleDefinitionByName(name);
    }

    @Override
    public boolean hasRole(String roleName) {
        return this.service.hasRole(roleName);
    }

    @Override
    public boolean isNewOrUpdated(OlapRoleDefinition definition) {
        return this.service.isNewOrUpdated(definition);
    }

    @Override
    public List<UxPermissions> getAllPermissionsForUX() {
        return this.service.getAllPermissionsForUX();
    }

    @Override
    @Nullable
    public UxPermissionsDetails getPermissionsDetailsForUX(String uuid) {
        return this.service.getPermissionsDetailsForUX(uuid);
    }

    @Override
    public int getAuthUserCount() {
        return this.authorizedUsers.size();
    }

    @Override
    public void shutdownNow() {
        this.service.shutdownNow();
    }
}

