/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.service;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.authorization.definition.role.IOlapRoleDefinition;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinitions;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.role.OlapRoleFullControlPermissions;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.authorization.permissions.role.UxPermissions;
import crazydev.iccube.authorization.permissions.role.UxPermissionsDetails;
import crazydev.iccube.authorization.permissions.service.OlapAbstractRolePermissionsService;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import crazydev.iccube.pub.authentication.OlapAuthenticationServiceException;
import crazydev.iccube.pub.authorization.OlapMissingRoleException;
import crazydev.iccube.pub.common.IOlapServiceConfiguration;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.request.log.OlapRequestId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapNotEnabledRolePermissionsService
extends OlapAbstractRolePermissionsService {
    private final Object globalLOCK = new Object();
    private final Map<String, OlapRolePermissions> allRolePermissions = new HashMap<String, OlapRolePermissions>();

    private static OlapRoleFullControlPermissions createFullControlPermissions(String name) {
        return new OlapRoleFullControlPermissions(name);
    }

    @Override
    public void configure(IOlapServiceConfiguration configuration) throws OlapAuthenticationServiceException {
        super.configure(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupOnConfigured() {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.clearAndSetupPredefinedRoles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupOnStartupError() {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.clearAndSetupPredefinedRoles();
        }
    }

    private void clearAndSetupPredefinedRoles() {
        this.allRolePermissions.clear();
        this.allRolePermissions.put("administrator", OlapNotEnabledRolePermissionsService.createFullControlPermissions("administrator"));
        this.allRolePermissions.put("administrator-print", OlapNotEnabledRolePermissionsService.createFullControlPermissions("administrator-print"));
        this.allRolePermissions.put("anonymous", OlapNotEnabledRolePermissionsService.createFullControlPermissions("anonymous"));
    }

    @Override
    public void reportDashboardsPermissionsOnStartup(OlapRequestId requestId) {
    }

    @Override
    public void reportDocsPermissionsOnStartup(OlapRequestId requestId) {
    }

    @Override
    public void setupApplicationsPermissionsOnStartup(OlapRequestId requestId, OlapRoleDefinitions roleDefinitions) throws OlapContextualBigException {
    }

    @Override
    public boolean applyPermissions(OlapEngineRequestContext requestContext, OlapRoleDefinitions roleDefinitions) throws OlapContextualBigException {
        return false;
    }

    @Override
    public void deleteAllOnTheFlyPermissions() {
    }

    @Override
    public void deleteOnTheFlyPermissions(String uuid) {
    }

    @Override
    public void checkUserRole(OlapPrincipal user) throws OlapMissingRoleException {
    }

    @Override
    public OlapRolePermissions authorizeUser(OlapRequestId requestId, OlapPrincipal user) throws OlapMissingRoleException {
        OlapRolePermissions permissions = this.getOrCreatePermissions(user);
        return permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapRolePermissions getOrCreatePermissions(OlapPrincipal user) {
        Object object = this.globalLOCK;
        synchronized (object) {
            String roleName = user.getRoleName();
            OlapRolePermissions permissions = this.allRolePermissions.get(roleName);
            if (permissions == null) {
                permissions = OlapNotEnabledRolePermissionsService.createFullControlPermissions(roleName);
                this.allRolePermissions.put(roleName, permissions);
            }
            return permissions;
        }
    }

    @Override
    @Nullable
    public OlapRoleApplicationPermissions authorizeUserForApplications(OlapPrincipal user) throws OlapMissingRoleException {
        OlapRolePermissions permissions = this.getOrCreatePermissions(user);
        return permissions.getApplicationPermissions();
    }

    @Override
    public int getRevisionNumber() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OlapRolePermissions getAdministratorRolePermissions() {
        Object object = this.globalLOCK;
        synchronized (object) {
            OlapRolePermissions permissions = this.allRolePermissions.get("administrator");
            if (permissions == null) {
                throw new CdProgrammingException("internal error : missing administrator role");
            }
            return permissions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OlapRolePermissions getRolePermissions(String roleName) {
        Object object = this.globalLOCK;
        synchronized (object) {
            OlapRolePermissions permissions = this.allRolePermissions.get(roleName);
            return permissions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllRoleNames(boolean withAdmin, boolean withAnonymous) {
        Object object = this.globalLOCK;
        synchronized (object) {
            ArrayList<String> names = new ArrayList<String>();
            for (String roleName : this.allRolePermissions.keySet()) {
                if (!withAdmin && ("administrator".equals(roleName) || "administrator-print".equals(roleName)) || !withAnonymous && "anonymous".equals(roleName)) continue;
                names.add(roleName);
            }
            return names;
        }
    }

    @Override
    public List<String> getAllRoleNamesForUX(boolean withAdmin, boolean withAnonymous) {
        return this.getAllRoleNames(withAdmin, withAnonymous);
    }

    @Override
    public List<IOlapRoleDefinition> getAllRoleDefinitionsForUX(boolean withAdmin, boolean withAnonymous) {
        return new ArrayList<IOlapRoleDefinition>();
    }

    @Override
    @Nullable
    public OlapRoleDefinition getRoleDefinitionByUUID(String uuid) {
        return null;
    }

    @Override
    @Nullable
    public OlapRoleDefinition getRoleDefinitionByName(String name) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRole(String roleName) {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.allRolePermissions.containsKey(roleName);
        }
    }

    @Override
    public boolean isNewOrUpdated(OlapRoleDefinition definition) {
        return false;
    }

    @Override
    public List<UxPermissions> getAllPermissionsForUX() {
        return new ArrayList<UxPermissions>();
    }

    @Override
    @Nullable
    public UxPermissionsDetails getPermissionsDetailsForUX(String uuid) {
        return null;
    }

    @Override
    protected void doOnSchemaLoaded(OlapEngineRequestContext requestContext, OlapSchema schema) {
    }

    @Override
    protected void doOnSchemaIncrLoaded(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
    }

    @Override
    protected void doOnSchemaIncrLoadedOnError(OlapEngineRequestContext requestContext, OlapSchema schema) {
    }

    @Override
    protected void doOnSchemaScriptStatementApplied(OlapEngineRequestContext requestContext, OlapSchema schema, OlapScriptInformation information) {
    }

    @Override
    protected void doOnSchemaUnloaded(OlapEngineRequestContext requestContext, OlapSchema schema) {
    }

    @Override
    protected void doOnSchemaPartitionsUnloaded(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
    }

    @Override
    protected void doOnSchemaPartitionsLoaded(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
    }

    @Override
    protected void doOnSchemaPartitionsLoadError(OlapEngineRequestContext requestContext, OlapSchema schema) {
    }
}

