/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.service;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.babylon.CdLoggingBabylonService;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.authorization.definition.role.IOlapRoleDefinition;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinitions;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionError;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorManager;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.applications.builder.OlapRoleApplicationPermissionsBuilder;
import crazydev.iccube.authorization.permissions.role.OlapRoleFullControlPermissions;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.authorization.permissions.role.OlapRolePrintingPermissions;
import crazydev.iccube.authorization.permissions.role.OlapRoleRegularPermissions;
import crazydev.iccube.authorization.permissions.role.UxPermissions;
import crazydev.iccube.authorization.permissions.role.UxPermissionsDetails;
import crazydev.iccube.authorization.permissions.service.OlapAbstractRolePermissionsService;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionApplyValidationContext;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationHelper;
import crazydev.iccube.authorizationx.definition.schemas.IOlapRoleSchemasDefinition;
import crazydev.iccube.authorizationx.flat.definition.dashboards.OlapRoleFlatDashboardsProfile;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsProfile;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.schemas.OlapEngineEmptySchemaDefFactoryHelper;
import crazydev.iccube.olap.component.schemas.OlapEngineInMemorySchemaDefFactoryHelper;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.eval.cache.OlapCacheManager;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import crazydev.iccube.pub.authentication.OlapAuthenticationServiceException;
import crazydev.iccube.pub.authorization.OlapMissingRoleException;
import crazydev.iccube.pub.common.IOlapServiceConfiguration;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public abstract class OlapDefaultRolePermissionsService
extends OlapAbstractRolePermissionsService {
    private final Object globalLOCK = new Object();
    private final Map<String, OlapRolePermissions> allRolePermissions = new HashMap<String, OlapRolePermissions>();
    private int revisionNumber = -1;

    @Override
    public void configure(IOlapServiceConfiguration configuration) throws OlapAuthenticationServiceException {
        super.configure(configuration);
    }

    @Override
    public void configureEx(IOlapServiceConfiguration configuration) throws OlapAuthenticationServiceException {
        super.configureEx(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupOnConfigured() {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.clearAndSetupPredefinedRoles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupOnStartupError() {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.clearAndSetupPredefinedRoles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportDashboardsPermissionsOnStartup(OlapRequestId requestId) {
        Object object = this.globalLOCK;
        synchronized (object) {
            try {
                for (OlapRolePermissions perms : this.allRolePermissions.values()) {
                    OlapRoleFlatDashboardsProfile profile = perms.getDashboardsPermissions();
                    if (!profile.isOnError()) continue;
                    OlapLoggers.AUTHORIZATION.error((Object)("[auth] invalid dashboards authorization definition in role [" + perms.getRoleName() + "]"));
                }
            }
            catch (RuntimeException ex) {
                OlapLoggers.AUTHORIZATION.error((Object)"[auth] unexpected error while reporting dashboards authorization", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportDocsPermissionsOnStartup(OlapRequestId requestId) {
        Object object = this.globalLOCK;
        synchronized (object) {
            try {
                for (OlapRolePermissions perms : this.allRolePermissions.values()) {
                    OlapRoleFlatDocsProfile profile = perms.getDocsPermissions();
                    if (profile == null || !profile.isOnError()) continue;
                    OlapLoggers.AUTHORIZATION.error((Object)("[auth] invalid docs authorization definition in role [" + perms.getRoleName() + "]"));
                }
            }
            catch (RuntimeException ex) {
                OlapLoggers.AUTHORIZATION.error((Object)"[auth] unexpected error while reporting docs authorization", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupApplicationsPermissionsOnStartup(OlapRequestId requestId, OlapRoleDefinitions roleDefinitions) throws OlapContextualBigException {
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)"[auth] (startup) create application permissions");
        }
        Object object = this.globalLOCK;
        synchronized (object) {
            this.clearAndSetupPredefinedRoles();
            this.doCreateApplicationPermissions(requestId, roleDefinitions);
            ++this.revisionNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean applyPermissions(OlapEngineRequestContext requestContext, OlapRoleDefinitions roleDefinitions) throws OlapContextualBigException {
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)"[auth] applying (re-apply) role definitions");
        }
        Object object = this.globalLOCK;
        synchronized (object) {
            this.clearAndSetupPredefinedRoles();
            OlapEngineComponent olapEngine = this.getOlapEngineApplicationContext().getOlapEngineComponent();
            OlapEngineRequestContext elevated = requestContext.elevateForApplyPermissions();
            List<OlapSchema> schemas = olapEngine.getAllAuthorizedSchemas(elevated, IcCubeSchemaAccessLockMode.WRITE);
            boolean hasError = false;
            try {
                OlapCacheManager cacheManager = this.getOlapEngineApplicationContext().getCacheManager();
                for (OlapSchema schema : schemas) {
                    schema.removeAllPermissions();
                    cacheManager.onSchemaSecurityAllPermissionsRemoved(requestContext, schema);
                }
                this.doCreateApplicationPermissions(requestContext.getRequestId(), roleDefinitions);
                ++this.revisionNumber;
            }
            finally {
                for (OlapSchema schema : schemas) {
                    if (this.setupAuthorizedSchemaOnDemandPermissions(requestContext, schema)) continue;
                    hasError = true;
                }
            }
            return hasError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllOnTheFlyPermissions() {
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)"[auth] deleting all the on-the-fly permissions");
        }
        Object object = this.globalLOCK;
        synchronized (object) {
            ArrayList<String> toDeleteK = new ArrayList<String>();
            ArrayList<OlapRolePermissions> toDeleteP = new ArrayList<OlapRolePermissions>();
            for (Map.Entry<String, OlapRolePermissions> entry : this.allRolePermissions.entrySet()) {
                String key = entry.getKey();
                OlapRolePermissions perms = entry.getValue();
                if (!perms.isOnTheFly()) continue;
                toDeleteK.add(key);
                toDeleteP.add(perms);
            }
            this.unsafeDeletePermissions(toDeleteK, toDeleteP);
        }
    }

    private void unsafeDeletePermissions(List<String> toDeleteK, List<OlapRolePermissions> toDeleteP) {
        ArrayList<IOlapSchemasPermission> allDeleted = new ArrayList<IOlapSchemasPermission>();
        for (int ii = 0; ii < toDeleteK.size(); ++ii) {
            String key = toDeleteK.get(ii);
            OlapRolePermissions perms = toDeleteP.get(ii);
            OlapRolePermissions deleted = this.allRolePermissions.remove(key);
            if (deleted == null) continue;
            allDeleted.add(deleted.getSchemasPermissions());
            if (!OlapLoggers.AUTHORIZATION.isInfoEnabled()) continue;
            OlapLoggers.AUTHORIZATION.info((Object)("[auth] delete the permissions attached to the role [" + perms.getRoleName() + "]"));
        }
        this.getOlapEngineApplicationContext().getOlapEngineComponent().onSchemasPermissionsDeleted(allDeleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteOnTheFlyPermissions(String uuid) {
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)("[auth] deleting the on-the-fly permissions [" + uuid + "]"));
        }
        Object object = this.globalLOCK;
        synchronized (object) {
            String toDeleteK = null;
            OlapRolePermissions toDelete = null;
            for (Map.Entry<String, OlapRolePermissions> entry : this.allRolePermissions.entrySet()) {
                String key = entry.getKey();
                OlapRolePermissions perms = entry.getValue();
                OlapRoleDefinition role = perms.getDefinition();
                String roleUUID = role.getUUID();
                if (roleUUID == null || !roleUUID.equals(uuid)) continue;
                toDeleteK = key;
                toDelete = perms;
                break;
            }
            if (toDelete == null) {
                if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
                    OlapLoggers.AUTHORIZATION.info((Object)("[auth] the permissions [" + uuid + "] does not exist"));
                }
                return;
            }
            if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
                OlapLoggers.AUTHORIZATION.info((Object)("[auth] deleting the permissions [" + uuid + "] attached to the role [" + toDelete.getRoleName() + "]"));
            }
            if (!toDelete.isOnTheFly()) {
                if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
                    OlapLoggers.AUTHORIZATION.info((Object)("[auth] cannot delete the permissions [" + uuid + "] attached to the role [" + toDelete.getRoleName() + "] : on-the-fly permissions only can be deleted"));
                }
                return;
            }
            OlapRolePermissions deleted = this.allRolePermissions.remove(toDeleteK);
            if (deleted != null) {
                this.getOlapEngineApplicationContext().getOlapEngineComponent().onSchemasPermissionsDeleted(Collections.singletonList(deleted.getSchemasPermissions()));
            }
            if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
                OlapLoggers.AUTHORIZATION.info((Object)("[auth] the permissions [" + uuid + "] attached to the role [" + toDelete.getRoleName() + "] has been removed : " + (deleted != null)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupOnTheFlyIdlePermissions(int idlePeriod) {
        OlapLoggers.AUTHENTICATION.info((Object)("[auth] onTheFlyPerms housekeeping [" + idlePeriod + " min.]"));
        Object object = this.globalLOCK;
        synchronized (object) {
            ArrayList<String> toDeleteK = new ArrayList<String>();
            ArrayList<OlapRolePermissions> toDeleteP = new ArrayList<OlapRolePermissions>();
            for (Map.Entry<String, OlapRolePermissions> entry : this.allRolePermissions.entrySet()) {
                String key = entry.getKey();
                OlapRolePermissions perms = entry.getValue();
                if (!perms.isOnTheFly() || !perms.isOnTheFlyIdlePeriodExpired(idlePeriod)) continue;
                toDeleteK.add(key);
                toDeleteP.add(perms);
            }
            this.unsafeDeletePermissions(toDeleteK, toDeleteP);
        }
    }

    private void clearAndSetupPredefinedRoles() {
        this.allRolePermissions.clear();
        this.allRolePermissions.put("administrator", new OlapRoleFullControlPermissions("administrator"));
        this.allRolePermissions.put("administrator-print", new OlapRolePrintingPermissions("administrator-print"));
    }

    private void doCreateApplicationPermissions(OlapRequestId requestId, OlapRoleDefinitions roleDefinitions) throws OlapContextualBigException {
        roleDefinitions.fixForPredefinedRoles();
        ArrayList<? extends OlapContextualError> allErrors = new ArrayList<OlapContextualError>();
        for (OlapRoleDefinition roleDefinition : roleDefinitions) {
            try {
                this.doCreateApplicationPermissions(requestId, roleDefinition, false);
            }
            catch (OlapContextualBigException ex) {
                allErrors.addAll(ex.getErrors());
            }
        }
        if (!allErrors.isEmpty()) {
            throw new OlapContextualBigException(allErrors);
        }
    }

    private OlapRolePermissions doCreateApplicationPermissions(OlapRequestId requestId, OlapRoleDefinition roleDefinition, boolean validateForOnTheFlyRoleSetup) throws OlapContextualBigException {
        ArrayList<Object> allErrors = new ArrayList<Object>();
        try {
            OlapRoleDefinitionErrorManager errorManager = new OlapRoleDefinitionErrorManager(false);
            OlapRoleDefinitionValidationContext validationContext = new OlapRoleDefinitionValidationContext(requestId, this.getOlapEngineApplicationContext().getOlapEngineComponent().getProperties(), this.getOlapEngineApplicationContext().getOlapEngineComponent().getFunctionRepository(), errorManager, new OlapEngineEmptySchemaDefFactoryHelper(), true, false, validateForOnTheFlyRoleSetup);
            OlapRoleDefinitionValidationHelper.validateDefinition(validationContext, null, roleDefinition);
            if (!errorManager.hasErrors()) {
                OlapRolePermissions permissions;
                String roleName = roleDefinition.getName();
                if (roleDefinition.isFullControl()) {
                    permissions = new OlapRoleFullControlPermissions(roleName, roleDefinition);
                } else {
                    OlapRoleApplicationPermissionsBuilder builder = new OlapRoleApplicationPermissionsBuilder();
                    OlapRoleApplicationPermissions appPermissions = builder.createApplicationPermissions(roleDefinition);
                    permissions = new OlapRoleRegularPermissions(this.getOlapEngineApplicationContext(), this.getAdministratorRolePermissions(), roleDefinition, appPermissions);
                }
                OlapRolePermissions prev = this.allRolePermissions.put(roleName, permissions);
                if (prev != null) {
                    throw new RuntimeException("internal error : inconsistent permissions setup");
                }
                return permissions;
            }
            allErrors.addAll(errorManager.getErrors());
        }
        catch (OlapContextualBigException ex) {
            allErrors.addAll(ex.getErrors());
        }
        throw new OlapContextualBigException(allErrors);
    }

    @Nullable
    protected OlapRolePermissions createOnTheFlyPermissions(OlapRequestId requestId, OlapRoleDefinition roleDefinition) {
        OlapRolePermissions permissions = this.createOnTheFlyApplicationPermissions(requestId, roleDefinition, true);
        return permissions;
    }

    @Nullable
    private OlapRolePermissions createOnTheFlyApplicationPermissions(OlapRequestId requestId, OlapRoleDefinition roleDefinition, boolean validateForOnTheFlyRoleSetup) {
        try {
            return this.doCreateApplicationPermissions(requestId, roleDefinition, validateForOnTheFlyRoleSetup);
        }
        catch (OlapContextualBigException ex) {
            OlapLoggers.AUTHORIZATION.error((Object)("[auth] on-the-fly-role permissions errors [" + roleDefinition.getName() + "]"));
            for (OlapContextualError olapContextualError : ex.getErrors()) {
                OlapLoggers.AUTHORIZATION.error((Object)("[auth] " + olapContextualError.asFullMessage((CdBabylonService)CdLoggingBabylonService.INSTANCE)));
            }
            IcCubeRequestStatusManager statusManager = this.getOlapEngineApplicationContext().getRequestStatusManager();
            String string = requestId.getClientUUID();
            statusManager.onRequestError(string, new OlapRoleDefinitionError(OlapRoleDefinitionErrorCode.UNEXPECTED_ERROR, new Serializable[]{"authorization : on-the-fly-role (application) permissions errors [" + roleDefinition.getName() + "]."}));
            statusManager.onRequestErrors(string, ex.getErrors());
            return null;
        }
    }

    @Override
    public void checkUserRole(OlapPrincipal user) throws OlapMissingRoleException {
        this.getExistingRolePermissions(user);
    }

    @Override
    public OlapRolePermissions authorizeUser(OlapRequestId requestId, OlapPrincipal user) throws OlapMissingRoleException {
        OlapRolePermissions permissions = this.getExistingRolePermissions(user);
        return permissions;
    }

    @Override
    public OlapRoleApplicationPermissions authorizeUserForApplications(OlapPrincipal user) throws OlapMissingRoleException {
        OlapRolePermissions permissions = this.getExistingRolePermissions(user);
        return permissions.getApplicationPermissions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRevisionNumber() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.revisionNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OlapRolePermissions getAdministratorRolePermissions() {
        Object object = this.globalLOCK;
        synchronized (object) {
            OlapRolePermissions permissions = this.allRolePermissions.get("administrator");
            if (permissions == null) {
                throw new CdProgrammingException("internal error : missing administrator role");
            }
            return permissions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public OlapRolePermissions getRolePermissions(String roleName) {
        Object object = this.globalLOCK;
        synchronized (object) {
            OlapRolePermissions permissions = this.allRolePermissions.get(roleName);
            return permissions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllRoleNames(boolean withAdmin, boolean withAnonymous) {
        Object object = this.globalLOCK;
        synchronized (object) {
            ArrayList<String> names = new ArrayList<String>();
            for (String roleName : this.allRolePermissions.keySet()) {
                if (!withAdmin && ("administrator".equals(roleName) || "administrator-print".equals(roleName)) || !withAnonymous && "anonymous".equals(roleName)) continue;
                names.add(roleName);
            }
            return names;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllRoleNamesForUX(boolean withAdmin, boolean withAnonymous) {
        Object object = this.globalLOCK;
        synchronized (object) {
            ArrayList<String> names = new ArrayList<String>();
            for (Map.Entry<String, OlapRolePermissions> entry : this.allRolePermissions.entrySet()) {
                OlapRolePermissions perms;
                String roleName = entry.getKey();
                if (!withAdmin && ("administrator".equals(roleName) || "administrator-print".equals(roleName)) || !withAnonymous && "anonymous".equals(roleName) || (perms = entry.getValue()).isOnTheFly()) continue;
                names.add(roleName);
            }
            return names;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IOlapRoleDefinition> getAllRoleDefinitionsForUX(boolean withAdmin, boolean withAnonymous) {
        Object object = this.globalLOCK;
        synchronized (object) {
            ArrayList<IOlapRoleDefinition> names = new ArrayList<IOlapRoleDefinition>();
            for (Map.Entry<String, OlapRolePermissions> entry : this.allRolePermissions.entrySet()) {
                OlapRolePermissions perms;
                String roleName = entry.getKey();
                if (!withAdmin && ("administrator".equals(roleName) || "administrator-print".equals(roleName)) || !withAnonymous && "anonymous".equals(roleName) || (perms = entry.getValue()).isOnTheFly()) continue;
                final OlapRoleDefinition definition = perms.getDefinition();
                names.add(new IOlapRoleDefinition(){
                    {
                        Objects.requireNonNull(this$0);
                    }

                    @Override
                    public String getUUID() {
                        return definition.getUUID();
                    }

                    @Override
                    public String getName() {
                        return definition.getName();
                    }

                    @Override
                    @Nullable
                    public String getDescription() {
                        return definition.getDescription();
                    }

                    @Override
                    public OlapRoleFlatDashboardsProfile getValidatedDashboardsPermissions() {
                        return definition.getValidatedDashboardsPermissions();
                    }

                    @Override
                    @Nullable
                    public OlapRoleFlatDocsProfile getValidatedDocsPermissions() {
                        return definition.getValidatedDocsPermissions();
                    }
                });
            }
            names.sort(Comparator.comparing(IOlapRoleDefinition::getName));
            return names;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public OlapRoleDefinition getRoleDefinitionByUUID(String uuid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            for (OlapRolePermissions perms : this.allRolePermissions.values()) {
                OlapRoleDefinition definition = perms.getDefinition();
                if (!uuid.equals(definition.getUUID())) continue;
                return definition;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public OlapRoleDefinition getRoleDefinitionByName(String name) {
        Object object = this.globalLOCK;
        synchronized (object) {
            for (OlapRolePermissions perms : this.allRolePermissions.values()) {
                OlapRoleDefinition definition = perms.getDefinition();
                if (!name.equals(definition.getName())) continue;
                return definition.copy();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRole(String roleName) {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.allRolePermissions.containsKey(roleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNewOrUpdated(OlapRoleDefinition definition) {
        String definitionName = definition.getName();
        if (definitionName == null) {
            return true;
        }
        Object object = this.globalLOCK;
        synchronized (object) {
            OlapRolePermissions permissions = this.allRolePermissions.get(definitionName);
            if (permissions == null) {
                return true;
            }
            OlapRoleDefinition existingDefinition = permissions.getDefinition();
            boolean bl = !existingDefinition.equals(definition);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UxPermissions> getAllPermissionsForUX() {
        ArrayList<UxPermissions> allPerms = new ArrayList<UxPermissions>();
        Object object = this.globalLOCK;
        synchronized (object) {
            for (Map.Entry<String, OlapRolePermissions> entry : this.allRolePermissions.entrySet()) {
                String roleName = entry.getKey();
                OlapRolePermissions perms = entry.getValue();
                OlapRoleDefinition definition = perms.getDefinition();
                allPerms.add(new UxPermissions(definition.getUUID(), roleName, perms.isOnTheFly(), perms.getOnTheFlyUsed(), perms.getTotalElapsedMS()));
            }
        }
        allPerms.sort((o1, o2) -> o1.getRoleName().compareToIgnoreCase(o2.getRoleName()));
        return allPerms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public UxPermissionsDetails getPermissionsDetailsForUX(String uuid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            for (Map.Entry<String, OlapRolePermissions> entry : this.allRolePermissions.entrySet()) {
                String roleName = entry.getKey();
                OlapRolePermissions perms = entry.getValue();
                OlapRoleDefinition definition = perms.getDefinition();
                if (!definition.getUUID().equals(uuid)) continue;
                return new UxPermissionsDetails(definition.getUUID(), roleName, perms.isOnTheFly(), perms.getOnTheFlyUsed(), perms.getTotalElapsedMS(), perms.getDetailedTotalElapsedMS(), perms.getSchemaPermsDefinitionForUX(), perms.getDashboardsPermsDefinitionForUX(), perms.getDocsPermsDefinitionForUX());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOnSchemaLoaded(OlapEngineRequestContext requestContext, OlapSchema schema) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.setupAuthorizedSchemaOnDemandPermissions(requestContext, schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOnSchemaIncrLoaded(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
        Object object = this.globalLOCK;
        synchronized (object) {
            for (OlapRolePermissions rolePermissions : this.allRolePermissions.values()) {
                rolePermissions.onSchemaIncrLoaded(requestContext, schema, incrLoadInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOnSchemaIncrLoadedOnError(OlapEngineRequestContext requestContext, OlapSchema schema) {
        Object object = this.globalLOCK;
        synchronized (object) {
            for (OlapRolePermissions rolePermissions : this.allRolePermissions.values()) {
                rolePermissions.onSchemaIncrLoadedOnError(requestContext, schema);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOnSchemaScriptStatementApplied(OlapEngineRequestContext requestContext, OlapSchema schema, OlapScriptInformation information) {
        Object object = this.globalLOCK;
        synchronized (object) {
            for (OlapRolePermissions rolePermissions : this.allRolePermissions.values()) {
                rolePermissions.onSchemaScriptStatementApplied(requestContext, schema, information);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOnSchemaUnloaded(OlapEngineRequestContext requestContext, OlapSchema schema) {
        Object object = this.globalLOCK;
        synchronized (object) {
            for (OlapRolePermissions rolePermissions : this.allRolePermissions.values()) {
                rolePermissions.onSchemaUnloaded(requestContext, schema);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOnSchemaPartitionsUnloaded(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        Object object = this.globalLOCK;
        synchronized (object) {
            for (OlapRolePermissions rolePermissions : this.allRolePermissions.values()) {
                rolePermissions.onSchemaPartitionsUnloaded(requestContext, schema, unloadPartitionsInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOnSchemaPartitionsLoaded(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        Object object = this.globalLOCK;
        synchronized (object) {
            for (OlapRolePermissions rolePermissions : this.allRolePermissions.values()) {
                rolePermissions.onSchemaPartitionsLoaded(requestContext, schema, loadPartitionsInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOnSchemaPartitionsLoadError(OlapEngineRequestContext requestContext, OlapSchema schema) {
        Object object = this.globalLOCK;
        synchronized (object) {
            for (OlapRolePermissions rolePermissions : this.allRolePermissions.values()) {
                rolePermissions.onSchemaPartitionsLoadError(requestContext, schema);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setupAuthorizedSchemaOnDemandPermissions(OlapEngineRequestContext requestContext, OlapSchema schema) {
        Object object = this.globalLOCK;
        synchronized (object) {
            boolean hasError = false;
            for (OlapRolePermissions rolePermissions : this.allRolePermissions.values()) {
                if (this.setupAuthorizedSchemaOnDemandPermissions(requestContext, rolePermissions, schema)) continue;
                hasError = true;
            }
            return hasError;
        }
    }

    private boolean setupAuthorizedSchemaOnDemandPermissions(OlapEngineRequestContext requestContext, OlapRolePermissions rolePermissions, OlapSchema schema) {
        OlapRequestId requestId = requestContext.getRequestId();
        try {
            if (rolePermissions.isFullControl()) {
                return true;
            }
            OlapRoleDefinitionErrorManager errorManager = new OlapRoleDefinitionErrorManager(false);
            OlapRoleDefinitionApplyValidationContext validationContext = new OlapRoleDefinitionApplyValidationContext(this.getOlapEngineApplicationContext(), requestContext.isSessionLess(), this.getAdministratorRolePermissions(), requestId, errorManager, new OlapEngineInMemorySchemaDefFactoryHelper(schema.getDefinitionFactory()), null);
            OlapRoleDefinition olapRoleDefinition = rolePermissions.getDefinition();
            OlapRoleDefinitionValidationHelper.validateDefinition(validationContext, null, olapRoleDefinition);
            if (errorManager.hasErrors()) {
                throw errorManager.asException();
            }
            IOlapRoleSchemasDefinition schemasPermissions = olapRoleDefinition.getValidatedSchemasPermissions();
            if (schemasPermissions.isSchemaAuthorized(schema.getName())) {
                rolePermissions.onSchemaLoaded(requestContext, schema);
            }
            return true;
        }
        catch (OlapContextualBigException ex) {
            OlapLoggers.AUTHORIZATION.error((Object)("[auth] schema [" + schema.getName() + "] access is disabled for role [" + rolePermissions.getRoleName() + "] due to the following errors."));
            for (OlapContextualError olapContextualError : ex.getErrors()) {
                OlapLoggers.AUTHORIZATION.error((Object)("[auth] error - " + olapContextualError.asFullMessage((CdBabylonService)CdLoggingBabylonService.INSTANCE)));
            }
            IcCubeRequestStatusManager statusManager = this.getOlapEngineApplicationContext().getRequestStatusManager();
            String string = requestId.getClientUUID();
            statusManager.onRequestError(string, new OlapRoleDefinitionError(OlapRoleDefinitionErrorCode.UNEXPECTED_ERROR, new Serializable[]{"authorization : schema access is disabled for role [" + rolePermissions.getRoleName() + "] due to permissions definitions errors."}));
            statusManager.onRequestErrors(string, ex.getErrors());
            return false;
        }
    }

    protected OlapRolePermissions getExistingRolePermissions(OlapPrincipal user) throws OlapMissingRoleException {
        String roleName = user.getRoleName();
        return this.getExistingRolePermissions(user.getName(), roleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OlapRolePermissions getExistingRolePermissions(String userName, String roleName) throws OlapMissingRoleException {
        Object object = this.globalLOCK;
        synchronized (object) {
            OlapRolePermissions permissions = this.allRolePermissions.get(roleName);
            if (permissions == null) {
                throw new OlapMissingRoleException(userName, roleName);
            }
            return permissions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAllRolePermissions(AllRolePermissionsProcessor processor) throws OlapMissingRoleException {
        Object object = this.globalLOCK;
        synchronized (object) {
            processor.process(this.allRolePermissions);
        }
    }

    public static interface AllRolePermissionsProcessor {
        public void process(Map<String, OlapRolePermissions> var1) throws OlapMissingRoleException;
    }
}

