/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.service;

import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.schemas.IOlapEngineSchemaLifeCycleListener;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import crazydev.iccube.pub.authentication.OlapAuthenticationServiceException;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.pub.common.IOlapServiceConfiguration;
import java.util.Objects;
import org.apache.log4j.Logger;

public abstract class OlapAbstractRolePermissionsService
implements IOlapPermissionsService {
    private OlapEngineApplicationContext olapEngineApplicationContext;

    @Override
    public void configure(IOlapServiceConfiguration configuration) throws OlapAuthenticationServiceException {
        OlapEngineComponent engineComponent;
        this.olapEngineApplicationContext = (OlapEngineApplicationContext)configuration.getConfigurationProperty("olapEngineAppContext");
        if (this.olapEngineApplicationContext != null && (engineComponent = this.olapEngineApplicationContext.getOlapEngineComponent()) != null) {
            engineComponent.addStructuralSchemaLifeCycleListener(new IOlapEngineSchemaLifeCycleListener(this){
                final /* synthetic */ OlapAbstractRolePermissionsService this$0;
                {
                    OlapAbstractRolePermissionsService olapAbstractRolePermissionsService = this$0;
                    Objects.requireNonNull(olapAbstractRolePermissionsService);
                    this.this$0 = olapAbstractRolePermissionsService;
                }

                @Override
                public void onSchemaStartedPhaseI(OlapEngineRequestContext context, OlapSchema schema, String command) {
                }

                @Override
                public void onSchemaStartedPhaseII(OlapEngineRequestContext context, OlapSchema schema, String command) {
                }

                @Override
                public void onSchemaLoadedDone(OlapEngineRequestContext context, OlapSchema schema) {
                    this.this$0.onSchemaLoadedDone(context, schema);
                }

                @Override
                public void onSchemaLoaded(OlapEngineRequestContext context, OlapSchema schema) {
                    this.this$0.onSchemaLoaded(context, schema);
                }

                @Override
                public void onSchemaLoadedOnError(OlapEngineRequestContext context, OlapSchema schema) {
                    this.this$0.onSchemaLoadedOnError(context, schema);
                }

                @Override
                public void onSchemaLoadedOnErrorCleanup(OlapEngineRequestContext context, OlapSchema schema) {
                }

                @Override
                public void onSchemaIncrLoaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
                    this.this$0.onSchemaIncrLoaded(context, schema, incrLoadInfo);
                }

                @Override
                public void onSchemaIncrLoadedOnError(OlapEngineRequestContext context, OlapSchema schema) {
                    this.this$0.onSchemaIncrLoadedOnError(context, schema);
                }

                @Override
                public void onSchemaScriptStatementApplied(OlapEngineRequestContext context, OlapSchema schema, OlapScriptInformation information) {
                    this.this$0.onSchemaScriptStatementApplied(context, schema, information);
                }

                @Override
                public void onSchemaUnloaded(OlapEngineRequestContext context, OlapSchema schema) {
                    this.this$0.onSchemaUnloaded(context, schema);
                }

                @Override
                public void onSchemaPartitionsUnloaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
                    this.this$0.onSchemaPartitionsUnloaded(context, schema, unloadPartitionsInfo);
                }

                @Override
                public void onSchemaPartitionsLoaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
                    this.this$0.onSchemaPartitionsLoaded(context, schema, loadPartitionsInfo);
                }

                @Override
                public void onSchemaPartitionsLoadError(OlapEngineRequestContext context, OlapSchema schema) {
                    this.this$0.onSchemaPartitionsLoadError(context, schema);
                }
            });
        }
        this.setupOnConfigured();
    }

    @Override
    public void configureEx(IOlapServiceConfiguration configuration) throws OlapAuthenticationServiceException {
    }

    protected OlapEngineApplicationContext getOlapEngineApplicationContext() {
        if (this.olapEngineApplicationContext == null) {
            throw new RuntimeException("internal error: missing MDX engine application context");
        }
        return this.olapEngineApplicationContext;
    }

    protected final void onSchemaLoadedDone(OlapEngineRequestContext context, OlapSchema schema) {
    }

    protected final void onSchemaLoaded(OlapEngineRequestContext context, OlapSchema schema) {
        Logger logger = context.getLoggers().authorization();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("authorization : updating role permissions for loaded schema [" + schema.getName() + "]"));
        }
        this.doOnSchemaLoaded(context, schema);
    }

    protected abstract void doOnSchemaLoaded(OlapEngineRequestContext var1, OlapSchema var2);

    protected final void onSchemaLoadedOnError(OlapEngineRequestContext context, OlapSchema schema) {
    }

    protected final void onSchemaIncrLoaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
        Logger logger = context.getLoggers().authorization();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("authorization : updating role permissions for incr. loaded schema [" + schema.getName() + "]"));
        }
        this.doOnSchemaIncrLoaded(context, schema, incrLoadInfo);
    }

    protected abstract void doOnSchemaIncrLoaded(OlapEngineRequestContext var1, OlapSchema var2, OlapSchemaIncrLoadInfo var3);

    protected final void onSchemaIncrLoadedOnError(OlapEngineRequestContext context, OlapSchema schema) {
        Logger logger = context.getLoggers().authorization();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("authorization : updating role permissions for incr. loaded on-error schema [" + schema.getName() + "]"));
        }
        this.doOnSchemaIncrLoadedOnError(context, schema);
    }

    protected abstract void doOnSchemaIncrLoadedOnError(OlapEngineRequestContext var1, OlapSchema var2);

    protected final void onSchemaScriptStatementApplied(OlapEngineRequestContext context, OlapSchema schema, OlapScriptInformation information) {
        Logger logger = context.getLoggers().authorization();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("authorization : updating role permissions for script statement applied to schema [" + schema.getName() + "]"));
        }
        this.doOnSchemaScriptStatementApplied(context, schema, information);
    }

    protected abstract void doOnSchemaScriptStatementApplied(OlapEngineRequestContext var1, OlapSchema var2, OlapScriptInformation var3);

    protected final void onSchemaUnloaded(OlapEngineRequestContext context, OlapSchema schema) {
        Logger logger = context.getLoggers().authorization();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("authorization : updating role permissions for unloaded schema [" + schema.getName() + "]"));
        }
        this.doOnSchemaUnloaded(context, schema);
    }

    protected abstract void doOnSchemaUnloaded(OlapEngineRequestContext var1, OlapSchema var2);

    protected final void onSchemaPartitionsUnloaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        Logger logger = context.getLoggers().authorization();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("authorization : updating role permissions for schema unloaded partitions [" + schema.getName() + "]"));
        }
        this.doOnSchemaPartitionsUnloaded(context, schema, unloadPartitionsInfo);
    }

    protected abstract void doOnSchemaPartitionsUnloaded(OlapEngineRequestContext var1, OlapSchema var2, OlapSchemaUnloadPartitionsInfo var3);

    protected final void onSchemaPartitionsLoaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        Logger logger = context.getLoggers().authorization();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("authorization : updating role permissions for schema loaded partitions [" + schema.getName() + "]"));
        }
        this.doOnSchemaPartitionsLoaded(context, schema, loadPartitionsInfo);
    }

    protected abstract void doOnSchemaPartitionsLoaded(OlapEngineRequestContext var1, OlapSchema var2, OlapSchemaLoadPartitionsInfo var3);

    protected final void onSchemaPartitionsLoadError(OlapEngineRequestContext context, OlapSchema schema) {
        Logger logger = context.getLoggers().authorization();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("authorization : updating role permissions for schema loaded partitions error [" + schema.getName() + "]"));
        }
        this.doOnSchemaPartitionsLoadError(context, schema);
    }

    protected abstract void doOnSchemaPartitionsLoadError(OlapEngineRequestContext var1, OlapSchema var2);

    @Override
    public void shutdownNow() {
    }
}

