/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.role;

import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemasDefinition;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.authorization.permissions.schema.OlapRoleHierarchicalSchemasRegularPermissions;
import crazydev.iccube.authorizationx.definition.schemas.IOlapRoleSchemasDefinition;
import crazydev.iccube.authorizationx.flat.definition.dashboards.OlapRoleFlatDashboardsProfile;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsProfile;
import crazydev.iccube.authorizationx.flat.definition.schemas.OlapRoleFlatSchemasDefinition;
import crazydev.iccube.authorizationx.flat.permissions.schemas.OlapRoleFlatSchemasRegularPermissions;
import crazydev.iccube.authorizationx.permissions.schemas.OlapRoleSchemasPermissions;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import org.jetbrains.annotations.Nullable;

public class OlapRoleRegularPermissions
extends OlapRolePermissions {
    private final OlapRoleDefinition roleDefinition;
    private final OlapRoleApplicationPermissions applicationPermissions;
    private final OlapRoleSchemasPermissions schemasPermissions;

    public OlapRoleRegularPermissions(OlapEngineApplicationContext olapEngineApplicationContext, OlapRolePermissions administratorPermissions, OlapRoleDefinition roleDefinition, OlapRoleApplicationPermissions applicationPermissions) {
        super(roleDefinition.getName());
        this.roleDefinition = roleDefinition;
        this.applicationPermissions = applicationPermissions;
        IOlapRoleSchemasDefinition schemasDefinitions = roleDefinition.getSchemasPermissions();
        if (schemasDefinitions instanceof OlapRoleSchemasDefinition) {
            this.schemasPermissions = new OlapRoleHierarchicalSchemasRegularPermissions(olapEngineApplicationContext, administratorPermissions, roleDefinition);
        } else if (schemasDefinitions instanceof OlapRoleFlatSchemasDefinition) {
            this.schemasPermissions = new OlapRoleFlatSchemasRegularPermissions(olapEngineApplicationContext, administratorPermissions, roleDefinition);
        } else {
            throw new RuntimeException("internal error: unexpected role definition type");
        }
    }

    @Override
    public long getTotalElapsedMS() {
        return this.schemasPermissions.getTotalElapsedMS();
    }

    @Override
    public String getDetailedTotalElapsedMS() {
        return this.schemasPermissions.getDetailedTotalElapsedMS();
    }

    @Override
    public OlapRoleDefinition getDefinition() {
        return this.roleDefinition;
    }

    @Override
    public String getSchemaPermsDefinitionForUX() {
        return this.schemasPermissions.getDefinitionForUX();
    }

    @Override
    public String getDashboardsPermsDefinitionForUX() {
        return this.roleDefinition.getDashboardsDefinitionForUX();
    }

    @Override
    public String getDocsPermsDefinitionForUX() {
        return this.roleDefinition.getDocsDefinitionForUX();
    }

    @Override
    public boolean isFullControl() {
        return false;
    }

    @Override
    public OlapRoleApplicationPermissions getApplicationPermissions() {
        return this.applicationPermissions;
    }

    @Override
    public OlapRoleSchemasPermissions getSchemasPermissions() {
        return this.schemasPermissions;
    }

    @Override
    public OlapRoleFlatDashboardsProfile getDashboardsPermissions() {
        return this.roleDefinition.getValidatedDashboardsPermissions();
    }

    @Override
    @Nullable
    public OlapRoleFlatDocsProfile getDocsPermissions() {
        return this.roleDefinition.getValidatedDocsPermissions();
    }

    @Override
    public void onSchemaLoaded(OlapEngineRequestContext requestContext, OlapSchema schema) {
        this.schemasPermissions.onSchemaLoaded(requestContext, schema);
    }

    @Override
    public void onSchemaIncrLoaded(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
        this.schemasPermissions.onSchemaIncrLoaded(requestContext, schema, incrLoadInfo);
    }

    @Override
    public void onSchemaIncrLoadedOnError(OlapEngineRequestContext requestContext, OlapSchema schema) {
        this.schemasPermissions.onSchemaIncrLoadedOnError(requestContext, schema);
    }

    @Override
    public void onSchemaScriptStatementApplied(OlapEngineRequestContext requestContext, OlapSchema schema, OlapScriptInformation information) {
        this.schemasPermissions.onSchemaScriptStatementApplied(requestContext, schema, information);
    }

    @Override
    public void onSchemaUnloaded(OlapEngineRequestContext requestContext, OlapSchema schema) {
        this.schemasPermissions.onSchemaUnloaded(requestContext, schema);
    }

    @Override
    public void onSchemaPartitionsUnloaded(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        this.schemasPermissions.onSchemaPartitionsUnloaded(requestContext, schema, unloadPartitionsInfo);
    }

    @Override
    public void onSchemaPartitionsLoaded(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        this.schemasPermissions.onSchemaPartitionsLoaded(requestContext, schema, loadPartitionsInfo);
    }

    @Override
    public void onSchemaPartitionsLoadError(OlapEngineRequestContext requestContext, OlapSchema schema) {
        this.schemasPermissions.onSchemaPartitionsLoadError(requestContext, schema);
    }
}

