/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.role;

import crazydev.iccube.authorization.definition.application.OlapRoleApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleApplicationFeatureDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleApplicationsDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleReportDashboardApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleReportDocManagementApplicationDefinition;
import crazydev.iccube.authorization.definition.common.OlapRoleAccessDefinition;
import crazydev.iccube.authorization.definition.common.OlapRoleEntityListTypeDefinition;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemaEntityListDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemasDefinition;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.applications.builder.OlapRoleApplicationPermissionsBuilder;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.authorizationx.permissions.schemas.OlapRolePrintingSchemasPermissions;
import crazydev.iccube.authorizationx.permissions.schemas.OlapRoleSchemasPermissions;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import java.util.ArrayList;
import java.util.Arrays;

public class OlapRolePrintingPermissions
extends OlapRolePermissions {
    private final OlapRoleDefinition roleDefinition;
    private final OlapRoleApplicationPermissions applicationsPermissions;
    private final OlapRoleSchemasPermissions schemasPermissions;

    public OlapRolePrintingPermissions(String name) {
        super(name);
        ArrayList<OlapRoleApplicationDefinition> applications = new ArrayList<OlapRoleApplicationDefinition>();
        applications.add(new OlapRoleReportDocManagementApplicationDefinition(Arrays.asList(new OlapRoleApplicationFeatureDefinition("app.reportDocManagement.reader", true))));
        applications.add(new OlapRoleReportDashboardApplicationDefinition(Arrays.asList(new OlapRoleApplicationFeatureDefinition("app.reportDashboard.reader", true))));
        OlapRoleApplicationsDefinition applicationPerms = new OlapRoleApplicationsDefinition(applications);
        OlapRoleSchemasDefinition schemasPerms = new OlapRoleSchemasDefinition(OlapRoleAccessDefinition.READ, new OlapRoleSchemaEntityListDefinition(OlapRoleEntityListTypeDefinition.SELECTION, new String[0]));
        this.roleDefinition = new OlapRoleDefinition(name, false);
        this.roleDefinition.setApplicationsPermissions(applicationPerms);
        this.roleDefinition.setSchemasPermissions(schemasPerms);
        this.applicationsPermissions = OlapRoleApplicationPermissionsBuilder.create("print", applicationPerms);
        this.schemasPermissions = new OlapRolePrintingSchemasPermissions(schemasPerms);
    }

    @Override
    public OlapRoleDefinition getDefinition() {
        return this.roleDefinition;
    }

    @Override
    public String getSchemaPermsDefinitionForUX() {
        return "printing";
    }

    @Override
    public String getDashboardsPermsDefinitionForUX() {
        return "printing";
    }

    @Override
    public String getDocsPermsDefinitionForUX() {
        return "printing";
    }

    @Override
    public boolean isFullControl() {
        return false;
    }

    @Override
    public OlapRoleApplicationPermissions getApplicationPermissions() {
        return this.applicationsPermissions;
    }

    @Override
    public OlapRoleSchemasPermissions getSchemasPermissions() {
        return this.schemasPermissions;
    }

    @Override
    public void onSchemaLoaded(OlapEngineRequestContext requestContext, OlapSchema schema) {
        this.schemasPermissions.onSchemaLoaded(requestContext, schema);
    }

    @Override
    public void onSchemaIncrLoaded(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
        this.schemasPermissions.onSchemaIncrLoaded(requestContext, schema, incrLoadInfo);
    }

    @Override
    public void onSchemaIncrLoadedOnError(OlapEngineRequestContext requestContext, OlapSchema schema) {
        this.schemasPermissions.onSchemaIncrLoadedOnError(requestContext, schema);
    }

    @Override
    public void onSchemaScriptStatementApplied(OlapEngineRequestContext requestContext, OlapSchema schema, OlapScriptInformation information) {
        this.schemasPermissions.onSchemaScriptStatementApplied(requestContext, schema, information);
    }

    @Override
    public void onSchemaUnloaded(OlapEngineRequestContext requestContext, OlapSchema schema) {
        this.schemasPermissions.onSchemaUnloaded(requestContext, schema);
    }

    @Override
    public void onSchemaPartitionsUnloaded(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        this.schemasPermissions.onSchemaPartitionsUnloaded(requestContext, schema, unloadPartitionsInfo);
    }

    @Override
    public void onSchemaPartitionsLoaded(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        this.schemasPermissions.onSchemaPartitionsLoaded(requestContext, schema, loadPartitionsInfo);
    }

    @Override
    public void onSchemaPartitionsLoadError(OlapEngineRequestContext requestContext, OlapSchema schema) {
        this.schemasPermissions.onSchemaPartitionsLoadError(requestContext, schema);
    }
}

