/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.measuregroup.builder;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.mdx.error.CdMdxException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorization.definition.cube.OlapRoleCubeDefinition;
import crazydev.iccube.authorization.definition.measuregroup.OlapRoleMeasureGroupDefinition;
import crazydev.iccube.authorization.definition.measuregroup.OlapRoleMeasureGroupEntityListDefinition;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionError;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorManager;
import crazydev.iccube.authorization.permissions.common.builder.OlapRoleAbstractPermissionsBuilder;
import crazydev.iccube.authorization.permissions.measuregroup.OlapRoleHierarchicalMeasureGroupRegularPermissions;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionApplyValidationContext;
import crazydev.iccube.authorizationx.permissions.common.OlapRolePermissionsBuilderHelper;
import crazydev.iccube.authorizationx.permissions.measuregroup.OlapRoleMeasureGroupAllPermissions;
import crazydev.iccube.authorizationx.permissions.measuregroup.OlapRoleMeasureGroupPermissions;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.schemas.OlapEngineSchemaDefFactoryHelper;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.olap.util.OlapCaseInsensitiveNames;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapRoleHierarchicalMeasureGroupPermissionsBuilder
extends OlapRoleAbstractPermissionsBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapRoleMeasureGroupPermissions> createAuthorizedMeasureGroups(OlapRoleDefinitionApplyValidationContext validationContext, OlapRoleCubeDefinition validDefinition, OlapSchema schema, OlapCube cube) {
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
        OlapNameContext nameContext = validationContext.getNameContext();
        errorManager.pushContext(validDefinition);
        try {
            OlapEngineSchemaDefFactoryHelper helper = validationContext.getSchemaDefFactoryHelper();
            OlapRoleMeasureGroupEntityListDefinition authorizedMeasureGroupNamesDefinition = validDefinition.getValidatedAuthorizedMeasureGroupNames();
            OlapCaseInsensitiveNames authorizedMeasureGroupNames = authorizedMeasureGroupNamesDefinition.resolveAuthorizedNames(helper.getAllMeasureGroupNames(schema.getName(), cube.getName(nameContext)));
            ArrayList<OlapRoleMeasureGroupPermissions> allMeasureGroups = new ArrayList<OlapRoleMeasureGroupPermissions>();
            for (String authorizedMeasureGroupName : authorizedMeasureGroupNames) {
                IOlapBuilderBaseFactsDef measureGroup = this.resolveMeasureGroup(cube, authorizedMeasureGroupName);
                if (measureGroup == null) {
                    errorManager.addError(OlapRoleDefinitionErrorCode.MEASURE_GROUP_UNKNOWN, new Serializable[]{cube.getName(nameContext), authorizedMeasureGroupName});
                    continue;
                }
                OlapRoleMeasureGroupDefinition measureGroupDefinition = validDefinition.getMeasureGroupPermission(authorizedMeasureGroupName);
                if (measureGroupDefinition != null) {
                    OlapIterator<? extends OlapTuple> allowedTuples = this.validateAllowedCells(validationContext, schema, cube, measureGroup, measureGroupDefinition);
                    OlapIterator<? extends OlapTuple> deniedTuples = this.validateDeniedCells(validationContext, schema, cube, measureGroup, measureGroupDefinition);
                    if (allowedTuples == null && deniedTuples == null) {
                        validationContext.addError(OlapRoleDefinitionErrorCode.MDX_PARSE_MEASURE_GROUP_MISSING_CELLS, new Serializable[]{measureGroupDefinition.getName()});
                    }
                    allMeasureGroups.add(new OlapRoleHierarchicalMeasureGroupRegularPermissions(measureGroup, allowedTuples, deniedTuples));
                    continue;
                }
                allMeasureGroups.add(new OlapRoleMeasureGroupAllPermissions(measureGroup));
            }
            ArrayList<OlapRoleMeasureGroupPermissions> arrayList = allMeasureGroups;
            return arrayList;
        }
        finally {
            errorManager.popContext();
        }
    }

    @Nullable
    private OlapIterator<? extends OlapTuple> validateAllowedCells(OlapRoleDefinitionApplyValidationContext validationContext, OlapSchema schema, OlapCube cube, IOlapBuilderBaseFactsDef measureGroup, OlapRoleMeasureGroupDefinition measureGroupDefinition) {
        OlapEntity allowedCells = this.executeCellsMdxExpression(validationContext, schema, cube, measureGroup, OlapRoleDefinitionErrorCode.MDX_EVAL_MEASURE_GROUP_ALLOWED_CELLS_ERROR, measureGroupDefinition.getAllowedCells());
        OlapIterator<? extends OlapTuple> allowedTuples = allowedCells != null ? this.validateTuples(validationContext, cube, measureGroup, allowedCells, true) : null;
        return allowedTuples;
    }

    @Nullable
    private OlapIterator<? extends OlapTuple> validateDeniedCells(OlapRoleDefinitionApplyValidationContext validationContext, OlapSchema schema, OlapCube cube, IOlapBuilderBaseFactsDef measureGroup, OlapRoleMeasureGroupDefinition measureGroupDefinition) {
        OlapEntity deniedCells = this.executeCellsMdxExpression(validationContext, schema, cube, measureGroup, OlapRoleDefinitionErrorCode.MDX_EVAL_MEASURE_GROUP_DENIED_CELLS_ERROR, measureGroupDefinition.getDeniedCells());
        OlapIterator<? extends OlapTuple> deniedTuples = deniedCells != null ? this.validateTuples(validationContext, cube, measureGroup, deniedCells, false) : null;
        return deniedTuples;
    }

    @Nullable
    private OlapEntity executeCellsMdxExpression(OlapRoleDefinitionApplyValidationContext validationContext, OlapSchema schema, OlapCube cube, IOlapBuilderBaseFactsDef measureGroup, OlapRoleDefinitionErrorCode errorCode, String mdx) {
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
        try {
            if (CdStringUtils.isNullOrBlank((String)mdx)) {
                return null;
            }
            return OlapRolePermissionsBuilderHelper.executeMdxExpressionWithNoEval(validationContext, schema, cube, mdx);
        }
        catch (CdMdxException ex) {
            LOGGER.error((Object)"Role measure-group permissions setup : reporting an MDX (allowed/denied cells) evaluation error", (Throwable)ex);
            errorManager.addError(new OlapRoleDefinitionError(ex.getError(), errorCode, new Serializable[]{measureGroup.getName(), ex.getError()}));
            return OlapNullEntity.INSTANCE;
        }
        catch (CdRuntimeException ex) {
            LOGGER.error((Object)"Role measure-group permissions setup : reporting an MDX (allowed/denied cells) evaluation error", (Throwable)ex);
            errorManager.addError(new OlapRoleDefinitionError(ex.getError(), errorCode, new Serializable[]{measureGroup.getName(), ex.getError()}));
            return OlapNullEntity.INSTANCE;
        }
    }

    @Nullable
    private OlapIterator<? extends OlapTuple> validateTuples(OlapRoleDefinitionApplyValidationContext validationContext, OlapCube cube, IOlapBuilderBaseFactsDef measureGroup, OlapEntity result, boolean isAllowed) {
        if (result instanceof OlapTuple) {
            OlapIterator<OlapTuple> tuples = OlapIteratorFactory.singleton((OlapTuple)result);
            return this.validateTupleSet(validationContext, cube, measureGroup, tuples, isAllowed);
        }
        if (result instanceof OlapTupleSet) {
            OlapIterator tuples = ((OlapTupleSet)result).getIterator(false);
            return this.validateTupleSet(validationContext, cube, measureGroup, tuples, isAllowed);
        }
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
        errorManager.addError(isAllowed ? OlapRoleDefinitionErrorCode.MDX_EVAL_MEASURE_GROUP_ALLOWED_CELLS_TYPE_MISMATCH : OlapRoleDefinitionErrorCode.MDX_EVAL_MEASURE_GROUP_DENIED_CELLS_TYPE_MISMATCH, new Serializable[]{measureGroup.getName(), result.getFriendlyTypeName()});
        return null;
    }

    private OlapIterator<? extends OlapTuple> validateTupleSet(OlapRoleDefinitionApplyValidationContext validationContext, OlapCube cube, IOlapBuilderBaseFactsDef measureGroup, OlapIterator<? extends OlapTuple> tuples, boolean isAllowed) {
        OlapTuple tuple;
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
        boolean isEmpty = true;
        tuples.reset();
        int number = 1;
        while ((tuple = tuples.next()) != null) {
            if (this.validateNotNull(validationContext, measureGroup, tuple, number, isAllowed) && this.validateNotInvalid(validationContext, measureGroup, tuple, number, isAllowed) && this.validateExists(validationContext, measureGroup, tuple, number, isAllowed) && this.validateHasNoMeasure(validationContext, measureGroup, tuple, number, isAllowed) && this.validateDimensionality(validationContext, cube, measureGroup, tuple, number, isAllowed)) {
                isEmpty = false;
            }
            ++number;
        }
        if (isEmpty) {
            errorManager.addError(isAllowed ? OlapRoleDefinitionErrorCode.MDX_EVAL_MEASURE_GROUP_ALLOWED_CELLS_EMPTY : OlapRoleDefinitionErrorCode.MDX_EVAL_MEASURE_GROUP_DENIED_CELLS_EMPTY, new Serializable[]{measureGroup.getName()});
        }
        return tuples;
    }

    private boolean validateNotNull(OlapRoleDefinitionApplyValidationContext validationContext, IOlapBuilderBaseFactsDef measureGroup, OlapTuple tuple, int number, boolean isAllowed) {
        if (tuple.isMdxNull()) {
            OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
            String tupleString = "nb:" + number;
            errorManager.addError(isAllowed ? OlapRoleDefinitionErrorCode.MDX_EVAL_MEASURE_GROUP_ALLOWED_CELLS_TUPLE_NULL : OlapRoleDefinitionErrorCode.MDX_EVAL_MEASURE_GROUP_DENIED_CELLS_TUPLE_NULL, new Serializable[]{measureGroup.getName(), tupleString});
            return false;
        }
        return true;
    }

    private boolean validateNotInvalid(OlapRoleDefinitionApplyValidationContext validationContext, IOlapBuilderBaseFactsDef measureGroup, OlapTuple tuple, int number, boolean isAllowed) {
        if (tuple.isInvalid()) {
            OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
            String tupleString = "nb:" + number;
            errorManager.addError(isAllowed ? OlapRoleDefinitionErrorCode.MDX_EVAL_MEASURE_GROUP_ALLOWED_CELLS_TUPLE_INVALID : OlapRoleDefinitionErrorCode.MDX_EVAL_MEASURE_GROUP_DENIED_CELLS_TUPLE_INVALID, new Serializable[]{measureGroup.getName(), tupleString});
            return false;
        }
        return true;
    }

    private boolean validateExists(OlapRoleDefinitionApplyValidationContext validationContext, IOlapBuilderBaseFactsDef measureGroup, OlapTuple tuple, int number, boolean isAllowed) {
        if (!tuple.exists(null)) {
            OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
            String tupleString = "nb:" + number;
            errorManager.addError(isAllowed ? OlapRoleDefinitionErrorCode.MDX_EVAL_MEASURE_GROUP_ALLOWED_CELLS_TUPLE_NON_EXIST : OlapRoleDefinitionErrorCode.MDX_EVAL_MEASURE_GROUP_DENIED_CELLS_TUPLE_NON_EXIST, new Serializable[]{measureGroup.getName(), tupleString});
            return false;
        }
        return true;
    }

    private boolean validateHasNoMeasure(OlapRoleDefinitionApplyValidationContext validationContext, IOlapBuilderBaseFactsDef measureGroup, OlapTuple tuple, int number, boolean isAllowed) {
        OlapMember measureMember = tuple.getMeasureMember();
        if (measureMember != null) {
            OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
            OlapNameContext nameContext = validationContext.getNameContext();
            String tupleString = "nb:" + number;
            errorManager.addError(isAllowed ? OlapRoleDefinitionErrorCode.MDX_EVAL_MEASURE_GROUP_ALLOWED_CELLS_TUPLE_MEASURE : OlapRoleDefinitionErrorCode.MDX_EVAL_MEASURE_GROUP_DENIED_CELLS_TUPLE_MEASURE, new Serializable[]{measureGroup.getName(), tupleString, measureMember.getName(nameContext)});
            return false;
        }
        return true;
    }

    private boolean validateDimensionality(OlapRoleDefinitionApplyValidationContext validationContext, OlapCube cube, IOlapBuilderBaseFactsDef measureGroup, OlapTuple tuple, int number, boolean isAllowed) {
        OlapFactMeasureGroupBaseManager factBaseManager = cube.getFactManager(measureGroup.getName());
        for (int idx = 0; idx < tuple.getMemberCount(); ++idx) {
            OlapMember member = tuple.getMember(idx);
            OlapDimension dimension = member.getDimension();
            if (factBaseManager.containsDimension(dimension)) continue;
            OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
            OlapNameContext nameContext = validationContext.getNameContext();
            String tupleString = "nb:" + number;
            errorManager.addError(isAllowed ? OlapRoleDefinitionErrorCode.MDX_EVAL_MEASURE_GROUP_ALLOWED_CELLS_TUPLE_DIMENSIONALITY : OlapRoleDefinitionErrorCode.MDX_EVAL_MEASURE_GROUP_DENIED_CELLS_TUPLE_DIMENSIONALITY, new Serializable[]{measureGroup.getName(), tupleString, dimension.getName(nameContext)});
            return false;
        }
        return true;
    }

    @Nullable
    private IOlapBuilderBaseFactsDef resolveMeasureGroup(OlapCube cube, String measureGroupName) {
        for (IOlapBuilderBaseFactsDef measureGroup : cube.getCubeFacts()) {
            if (!OlapCaseInsensitiveName.equals(measureGroup.getName(), measureGroupName)) continue;
            return measureGroup;
        }
        return null;
    }
}

