/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.filter.dimension;

import crazydev.iccube.authorization.permissions.filter.dimension.OlapRoleAllHierarchyFilter;
import crazydev.iccube.olap.entity.IOlapHierarchyFilter;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.eval.filter.dimension.OlapAbstractMemberFilter;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapRoleSchemaMemberFilter
extends OlapAbstractMemberFilter {
    private final Map<OlapHierarchy, IOlapHierarchyFilter> hierarchyDimensionFilters;

    public OlapRoleSchemaMemberFilter(List<IOlapHierarchyFilter> filters) {
        this.hierarchyDimensionFilters = new HashMap<OlapHierarchy, IOlapHierarchyFilter>();
        for (IOlapHierarchyFilter filter : filters) {
            this.hierarchyDimensionFilters.put(filter.getHierarchy(), filter);
        }
    }

    private OlapRoleSchemaMemberFilter(Map<OlapHierarchy, IOlapHierarchyFilter> filters) {
        this.hierarchyDimensionFilters = filters;
    }

    public OlapRoleSchemaMemberFilter copyForIncrementalLoad(OlapSchemaIncrLoadInfo incrLoadInfo) {
        return new OlapRoleSchemaMemberFilter(this.hierarchyDimensionFilters);
    }

    public OlapRoleSchemaMemberFilter copyForLoadPartitions(OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        return new OlapRoleSchemaMemberFilter(this.hierarchyDimensionFilters);
    }

    public OlapRoleSchemaMemberFilter copyForUnloadPartitions(OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        return new OlapRoleSchemaMemberFilter(this.hierarchyDimensionFilters);
    }

    @Override
    public String getName() {
        return "role-dimension";
    }

    @Override
    @Nullable
    public boolean isNotFiltering(OlapHierarchy hierarchy) {
        IOlapHierarchyFilter filter = this.hierarchyDimensionFilters.get(hierarchy);
        return filter instanceof OlapRoleAllHierarchyFilter;
    }

    @Override
    public boolean isAccepting(OlapMember member) {
        OlapMember secMember = member.getMemberForSecurity();
        IOlapHierarchyFilter filter = this.hierarchyDimensionFilters.get(secMember.getHierarchy());
        if (filter == null) {
            return false;
        }
        return filter.isAccepting(secMember);
    }

    @Override
    public boolean isAccepting(OlapLevel level) {
        return true;
    }

    @Override
    @Nullable
    public OlapMember getRedefinedDefaultMember(OlapHierarchy hierarchy) {
        IOlapHierarchyFilter filter = this.hierarchyDimensionFilters.get(hierarchy);
        if (filter != null) {
            return filter.getRedefinedDefaultMember();
        }
        return null;
    }
}

