/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.filter.dimension;

import crazydev.iccube.authorization.permissions.filter.dimension.OlapRoleHierarchyFilter;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class OlapRolePositiveHierarchyFilter
extends OlapRoleHierarchyFilter {
    private final MutableRoaringBitmap allowedMembers;

    public OlapRolePositiveHierarchyFilter(OlapCalculatedMemberManager calcMembers, OlapHierarchy hierarchy, @Nullable OlapMember defaultMember, OlapIterator<? extends OlapMember> selection) {
        super(hierarchy, defaultMember);
        this.allowedMembers = OlapRolePositiveHierarchyFilter.setupAllowedMembers(calcMembers, hierarchy, OlapRolePositiveHierarchyFilter.toList(selection));
    }

    private static MutableRoaringBitmap setupAllowedMembers(OlapCalculatedMemberManager calcMembers, OlapHierarchy hierarchy, List<? extends OlapMember> selection) {
        MutableRoaringBitmap allowed = new MutableRoaringBitmap();
        for (OlapMember olapMember : selection) {
            OlapRolePositiveHierarchyFilter.registerMember(allowed, olapMember);
        }
        for (OlapMember olapMember : calcMembers.getAllCalculatedMembers(null)) {
            if (!olapMember.isMeasure()) continue;
            OlapRolePositiveHierarchyFilter.registerMember(allowed, olapMember);
        }
        allowed.runOptimize();
        return allowed;
    }

    private static void registerMember(MutableRoaringBitmap allowed, OlapMember member) {
        OlapMember ascendant;
        OlapIterator ascendants = member.getAscendants().getIterator(false);
        ascendants.reset();
        while ((ascendant = (OlapMember)ascendants.next()) != null) {
            allowed.add(ascendant.getUniqueHierarchyMemberIndex());
        }
    }

    @Override
    public boolean isAccepting(OlapMember member) {
        return this.allowedMembers.contains(member.getUniqueHierarchyMemberIndex());
    }
}

