/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.dimension.builder;

import crazydev.iccube.authorization.definition.dimension.OlapRoleDimensionDefinition;
import crazydev.iccube.authorization.definition.dimension.OlapRoleDimensionEntityListDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemaDefinition;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorManager;
import crazydev.iccube.authorization.permissions.common.builder.OlapRoleAbstractPermissionsBuilder;
import crazydev.iccube.authorization.permissions.dimension.OlapRoleHierarchicalDimensionRegularPermissions;
import crazydev.iccube.authorization.permissions.hierarchy.builder.OlapRoleHierarchicalHierarchyPermissionsBuilder;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionApplyValidationContext;
import crazydev.iccube.authorizationx.permissions.dimension.OlapRoleDimensionPermissions;
import crazydev.iccube.authorizationx.permissions.hierarchy.OlapRoleHierarchyPermissions;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.schemas.OlapEngineSchemaDefFactoryHelper;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.olap.util.OlapCaseInsensitiveNames;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapRoleHierarchicalDimensionPermissionsBuilder
extends OlapRoleAbstractPermissionsBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapRoleDimensionPermissions> createAuthorizedDimensionsPermissions(OlapRoleDefinitionApplyValidationContext validationContext, OlapRoleSchemaDefinition validDefinition, OlapSchema schema) {
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
        OlapNameContext nameContext = validationContext.getNameContext();
        errorManager.pushContext(validDefinition);
        try {
            OlapEngineSchemaDefFactoryHelper helper = validationContext.getSchemaDefFactoryHelper();
            OlapRoleDimensionEntityListDefinition authorizedDimensionNamesDefinition = validDefinition.getValidatedAuthorizedDimensionNames();
            OlapCaseInsensitiveNames authorizedDimensionNames = authorizedDimensionNamesDefinition.resolveAuthorizedNames(helper.getAllDimensionNames(schema.getName()));
            ArrayList<OlapRoleDimensionPermissions> allDimensions = new ArrayList<OlapRoleDimensionPermissions>();
            for (String authorizedDimensionName : authorizedDimensionNames) {
                OlapDimension dimension = this.resolveDimension(nameContext, schema.getDimensions(), authorizedDimensionName);
                if (dimension == null) {
                    errorManager.addError(OlapRoleDefinitionErrorCode.DIMENSION_UNKNOWN, new Serializable[]{schema.getName(), authorizedDimensionName});
                    continue;
                }
                OlapRoleDimensionDefinition dimensionDefinition = validDefinition.getDimensionPermission(authorizedDimensionName);
                if (dimensionDefinition != null) {
                    OlapRoleHierarchicalHierarchyPermissionsBuilder builder = new OlapRoleHierarchicalHierarchyPermissionsBuilder();
                    List<OlapRoleHierarchyPermissions> authorizedHierarchies = builder.createAuthorizedHierarchies(validationContext, dimensionDefinition, schema, dimension);
                    allDimensions.add(new OlapRoleHierarchicalDimensionRegularPermissions(dimension, authorizedHierarchies));
                    continue;
                }
                allDimensions.add(dimension.getAllPermissions());
            }
            ArrayList<OlapRoleDimensionPermissions> arrayList = allDimensions;
            return arrayList;
        }
        finally {
            errorManager.popContext();
        }
    }

    @Nullable
    private OlapDimension resolveDimension(OlapNameContext nameContext, List<OlapDimension> dimensions, String dimensionName) {
        for (OlapDimension dimension : dimensions) {
            if (!OlapCaseInsensitiveName.equals(dimension.getName(nameContext), dimensionName)) continue;
            return dimension;
        }
        return null;
    }
}

