/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.cube.builder;

import crazydev.iccube.authorization.definition.cube.OlapRolePerspectiveEntityListDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemaDefinition;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorManager;
import crazydev.iccube.authorization.permissions.common.builder.OlapRoleAbstractPermissionsBuilder;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionApplyValidationContext;
import crazydev.iccube.authorizationx.permissions.cube.OlapRoleCubePermissions;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.schemas.OlapEngineSchemaDefFactoryHelper;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapPerspectiveCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveManager;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.olap.util.OlapCaseInsensitiveNames;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapRoleHierarchicalPerspectivePermissionsBuilder
extends OlapRoleAbstractPermissionsBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapPerspectiveCube> createAuthorizedPerspectivePermissions(OlapRoleDefinitionApplyValidationContext validationContext, OlapRoleSchemaDefinition validDefinition, OlapSchema schema, List<OlapRoleCubePermissions> authorizedCubes) {
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
        OlapNameContext nameContext = validationContext.getNameContext();
        errorManager.pushContext(validDefinition);
        try {
            OlapEngineSchemaDefFactoryHelper helper = validationContext.getSchemaDefFactoryHelper();
            OlapRolePerspectiveEntityListDefinition authorizedNamesDefinition = validDefinition.getValidatedAuthorizedPerspectivesNames();
            OlapCaseInsensitiveNames authorizedNames = authorizedNamesDefinition.resolveAuthorizedNames(helper.getAllCubePerspectiveNames(schema.getName()));
            OlapPerspectiveManager perspectiveManager = schema.getPerspectiveManager();
            List<OlapPerspectiveCube> schemaPerspectives = perspectiveManager.getCubePerspectives();
            ArrayList<OlapPerspectiveCube> allPerspectives = new ArrayList<OlapPerspectiveCube>();
            for (String authorizedName : authorizedNames) {
                OlapPerspectiveCube perspective = OlapRoleHierarchicalPerspectivePermissionsBuilder.resolvePerspective(nameContext, schemaPerspectives, authorizedName);
                if (perspective == null) {
                    errorManager.addError(OlapRoleDefinitionErrorCode.PERSPECTIVE_UNKNOWN, new Serializable[]{schema.getName(), authorizedName});
                    continue;
                }
                OlapRegularCube actualCube = perspective.getRegularCube();
                if (!OlapRoleHierarchicalPerspectivePermissionsBuilder.isCubeAuthorized(authorizedCubes, actualCube)) {
                    errorManager.addError(OlapRoleDefinitionErrorCode.PERSPECTIVE_WITH_DENIED_CUBE, new Serializable[]{schema.getName(), authorizedName, actualCube.getName(nameContext)});
                    continue;
                }
                allPerspectives.add(perspective);
            }
            ArrayList<OlapPerspectiveCube> arrayList = allPerspectives;
            return arrayList;
        }
        finally {
            errorManager.popContext();
        }
    }

    @Nullable
    private static OlapPerspectiveCube resolvePerspective(OlapNameContext nameContext, List<OlapPerspectiveCube> perspectives, String cubeName) {
        for (OlapPerspectiveCube perspective : perspectives) {
            if (!OlapCaseInsensitiveName.equals(perspective.getName(nameContext), cubeName)) continue;
            return perspective;
        }
        return null;
    }

    private static boolean isCubeAuthorized(List<OlapRoleCubePermissions> authorizedCubes, OlapCube cube) {
        for (OlapRoleCubePermissions authorizedCube : authorizedCubes) {
            OlapCube aCube = authorizedCube.getCube();
            if (!aCube.equals(cube)) continue;
            return true;
        }
        return false;
    }
}

