/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.applications.builder;

import crazydev.iccube.authorization.definition.application.OlapRoleApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleApplicationFeatureDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleApplicationsDefinition;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationFeaturePermissions;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.builder.OlapRoleAbstractPermissionsBuilder;
import java.util.ArrayList;

public class OlapRoleApplicationPermissionsBuilder
extends OlapRoleAbstractPermissionsBuilder {
    public OlapRoleApplicationPermissions createApplicationPermissions(OlapRoleDefinition validDefinition) {
        OlapRoleApplicationPermissions permissions;
        if (validDefinition.isFullControl()) {
            permissions = OlapRoleApplicationPermissions.FULL_CONTROL;
        } else {
            OlapRoleApplicationsDefinition validatedApplicationsDefinitions = validDefinition.getApplicationsPermissions();
            permissions = OlapRoleApplicationPermissionsBuilder.create(validDefinition.getName(), validatedApplicationsDefinitions);
        }
        return permissions;
    }

    public static OlapRoleApplicationPermissions create(String debug, OlapRoleApplicationsDefinition validatedApplicationsDefinitions) {
        ArrayList<OlapRoleApplicationFeaturePermissions> applications = new ArrayList<OlapRoleApplicationFeaturePermissions>();
        for (OlapRoleApplicationDefinition validatedApplicationsDefinition : validatedApplicationsDefinitions.getValidatedPermissions()) {
            ArrayList<String> authorizedFeatureNames = new ArrayList<String>();
            for (OlapRoleApplicationFeatureDefinition featureDefinition : validatedApplicationsDefinition.getValidatedFeatures()) {
                if (!featureDefinition.isEnabled()) continue;
                authorizedFeatureNames.add(featureDefinition.getName());
            }
            applications.add(new OlapRoleApplicationFeaturePermissions(validatedApplicationsDefinition.getName(), authorizedFeatureNames));
        }
        return new OlapRoleApplicationPermissions(debug, applications);
    }
}

