/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.meta;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorization.meta.MetaAuthorizationDescription;
import crazydev.iccube.authorization.meta.MetaAuthorizationLines;
import crazydev.iccube.authorization.meta.MetaOnTheFlyRoleDefinitionBuilder;
import crazydev.iccube.pub.role.IOlapOnTheFlyRoleDescription;
import crazydev.iccube.pub.role.OlapOnTheFlyRoleDescriptionException;
import crazydev.iccube.pub.role.OlapOnTheFlyRoleNameFactory;
import org.jetbrains.annotations.Nullable;

public class MetaOnTheFlyRoleDescription
implements IOlapOnTheFlyRoleDescription<MetaOnTheFlyRoleDescription> {
    private static final long serialVersionUID = 2926288208948960706L;
    private static OlapOnTheFlyRoleNameFactory roleNameFactory = OlapOnTheFlyRoleNameFactory.INSTANCE;
    private final String templateRoleName;
    private final String roleName;
    private final String roleNameForMdxExecutionProfile;
    private final String roleNameForDocs;
    private final MetaAuthorizationLines lines;
    @Nullable
    private final String dashboards;
    @Nullable
    private final String docs;

    public MetaOnTheFlyRoleDescription(String userName, String templateRoleName, String roleNameForMdxExecutionProfile, String roleNameForDocs, MetaAuthorizationDescription description, @Nullable String dashboards, @Nullable String docs) throws OlapOnTheFlyRoleDescriptionException {
        this(null, userName, templateRoleName, roleNameForMdxExecutionProfile, roleNameForDocs, description, dashboards, docs);
    }

    public MetaOnTheFlyRoleDescription(@Nullable String tenantName, String userName, String templateRoleName, String roleNameForMdxExecutionProfile, String roleNameForDocs, MetaAuthorizationDescription description, @Nullable String dashboards, @Nullable String docs) throws OlapOnTheFlyRoleDescriptionException {
        if (templateRoleName == null) {
            throw new OlapOnTheFlyRoleDescriptionException(userName, "unexpected missing role template");
        }
        this.templateRoleName = templateRoleName;
        this.lines = new MetaAuthorizationLines(description);
        this.roleNameForMdxExecutionProfile = roleNameForMdxExecutionProfile;
        this.roleNameForDocs = roleNameForDocs;
        this.dashboards = dashboards;
        this.docs = docs;
        this.roleName = roleNameFactory.getOrCreateUniqueRoleName(tenantName, this, this.createFullRoleName());
    }

    protected String createFullRoleName() {
        StringBuilder sb = new StringBuilder(this.templateRoleName);
        sb.append("-").append(this.roleNameForMdxExecutionProfile);
        sb.append("-").append(this.roleNameForDocs);
        sb.append("-").append(this.getSchemasForFullRoleName());
        if (this.dashboards != null) {
            sb.append("-").append(this.dashboards);
        }
        if (this.docs != null) {
            sb.append("-").append(this.docs);
        }
        String fullRoleName = sb.toString();
        return fullRoleName;
    }

    protected String getSchemasForFullRoleName() {
        return this.lines.getDataForFullRoleName();
    }

    @Override
    public String getNameSpace() {
        String ns = CdStringUtils.isNotNullAndNotBlank((String)this.templateRoleName) ? this.templateRoleName : "META";
        return "$" + ns + "$";
    }

    @Override
    public String getTemplateRoleName() {
        return this.templateRoleName;
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public String getRoleNameForMdxExecutionProfile() {
        return this.roleNameForMdxExecutionProfile;
    }

    @Override
    public String getRoleNameForDocs() {
        return this.roleNameForDocs;
    }

    public MetaAuthorizationLines getLines() {
        return this.lines;
    }

    @Nullable
    public String getDashboards() {
        return this.dashboards;
    }

    @Nullable
    public String getDocs() {
        return this.docs;
    }

    public MetaOnTheFlyRoleDefinitionBuilder createBuilder() {
        return new MetaOnTheFlyRoleDefinitionBuilder();
    }

    public boolean equals(Object o) {
        throw new RuntimeException("internal error : inconsistent MetaOnTheFlyRoleDescription.equals usage");
    }

    public int hashCode() {
        throw new RuntimeException("internal error : inconsistent MetaOnTheFlyRoleDescription.equals usage");
    }
}

