/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.meta;

import crazydev.iccube.authorization.definition.application.OlapRoleApplicationsDefinition;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.meta.MetaAuthorizationLines;
import crazydev.iccube.authorization.meta.MetaOnTheFlyRoleDescription;
import crazydev.iccube.authorizationx.flat.definition.schemas.OlapRoleFlatSchemasDefinition;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.role.IOlapOnTheFlyRoleDefinitionBuilder;

public class MetaOnTheFlyRoleDefinitionBuilder
implements IOlapOnTheFlyRoleDefinitionBuilder<MetaOnTheFlyRoleDescription> {
    @Override
    public OlapRoleDefinition createRoleDefinition(MetaOnTheFlyRoleDescription onTheFlyRoleDescription, OlapPrincipal principal, OlapRoleDefinition template) {
        String existingRoleName;
        String templateRoleName = onTheFlyRoleDescription.getTemplateRoleName();
        if (!templateRoleName.equals(existingRoleName = template.getName())) {
            throw new RuntimeException("internal error : inconsistent on-the-fly template role name [" + templateRoleName + "][" + existingRoleName + "]");
        }
        String roleName = onTheFlyRoleDescription.getRoleName();
        if (principal.isAdministrator()) {
            OlapRoleDefinition role = new OlapRoleDefinition("administrator", true);
            return role;
        }
        if (template.isFullControl()) {
            OlapRoleDefinition role = new OlapRoleDefinition(roleName, true);
            return role;
        }
        OlapRoleDefinition role = new OlapRoleDefinition(roleName);
        OlapRoleApplicationsDefinition applications = template.getValidatedApplicationsPermissions().copy();
        role.setApplicationsPermissions(applications);
        MetaAuthorizationLines lines = onTheFlyRoleDescription.getLines();
        OlapRoleFlatSchemasDefinition schemas = new OlapRoleFlatSchemasDefinition(lines.getLines());
        role.setSchemasPermissions(schemas);
        String dashboards = onTheFlyRoleDescription.getDashboards();
        String docs = onTheFlyRoleDescription.getDocs();
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)("[auth] creating on-the-fly-role permissions for user [" + principal.getName() + "] [" + onTheFlyRoleDescription.getRoleName() + "] from meta definition"));
            OlapLoggers.AUTHORIZATION.info((Object)("[auth]    dashboards: [" + dashboards + "]"));
            OlapLoggers.AUTHORIZATION.info((Object)("[auth]          docs: [" + docs + "]"));
        }
        role.setDashboardsPermissions(dashboards);
        role.setDocsPermissions(docs);
        return role;
    }
}

