/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.meta;

import crazydev.iccube.authorization.meta.MetaAuthorizationDescription;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class MetaAuthorizationLines {
    private final MetaAuthorizationDescription description;
    private final String rawLines;
    private final String sortedRawLines;

    public MetaAuthorizationLines(MetaAuthorizationDescription description) {
        this.description = description;
        this.rawLines = description.getLines();
        try {
            List sortedLines = IOUtils.readLines((Reader)new StringReader(this.rawLines));
            Collections.sort(sortedLines);
            StringBuilder sb = new StringBuilder();
            for (String sortedLine : sortedLines) {
                sb.append(sortedLine);
            }
            this.sortedRawLines = sb.toString();
        }
        catch (UncheckedIOException unlikely) {
            throw new RuntimeException("internal error: could not read role definition");
        }
    }

    public String getLines() {
        return this.rawLines;
    }

    public String getDataForFullRoleName() {
        String data = this.description.getDataForFullRoleName();
        if (data != null) {
            return data;
        }
        return this.sortedRawLines;
    }
}

