/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.definition.schema;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.authorization.definition.common.IOlapRoleConstraintDefaultValueDefinition;
import crazydev.iccube.authorization.definition.common.IOlapRoleNamedDefinition;
import crazydev.iccube.authorization.definition.common.OlapRoleAccessDefinition;
import crazydev.iccube.authorization.definition.common.OlapRoleEntityListTypeDefinition;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemaDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemaEntityListDefinition;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.authorization.validation.schema.OlapRoleSchemasDefinitionValidator;
import crazydev.iccube.authorizationx.definition.schemas.IOlapRoleSchemasDefinition;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="schemas")
public class OlapRoleSchemasDefinition
implements IOlapRoleSchemasDefinition<OlapRoleSchemasDefinition>,
IOlapRoleConstraintDefaultValueDefinition,
IOlapRoleNamedDefinition {
    public static final CdProperty ACCESS = new CdReadWriteProperty(OlapRoleSchemasDefinition.class, "defaultSchemaAccess");
    public static final CdProperty AUTHORIZED_SCHEMA_NAMES = new CdReadWriteProperty(OlapRoleSchemasDefinition.class, "authorizedSchemaNames");
    @XmlAttribute(name="defaultSchemaAccess")
    @Nullable
    private OlapRoleAccessDefinition defaultSchemaAccess;
    @XmlElement(name="authorizedSchemaNames", required=true)
    @Nullable
    private OlapRoleSchemaEntityListDefinition authorizedSchemaNames;
    @XmlElement(name="schema", required=false)
    @Nullable
    private List<OlapRoleSchemaDefinition> schemaPermissions;

    public OlapRoleSchemasDefinition() {
    }

    public OlapRoleSchemasDefinition(OlapRoleSchemaEntityListDefinition authorizedSchemaNames) {
        this.authorizedSchemaNames = authorizedSchemaNames;
    }

    public OlapRoleSchemasDefinition(OlapRoleAccessDefinition defaultSchemaAccess, OlapRoleSchemaEntityListDefinition authorizedSchemaNames) {
        this.defaultSchemaAccess = defaultSchemaAccess;
        this.authorizedSchemaNames = authorizedSchemaNames;
    }

    public OlapRoleSchemasDefinition(OlapRoleAccessDefinition defaultSchemaAccess, OlapRoleSchemaEntityListDefinition authorizedSchemaNames, List<OlapRoleSchemaDefinition> schemaPermissions) {
        this.defaultSchemaAccess = defaultSchemaAccess;
        this.authorizedSchemaNames = authorizedSchemaNames;
        this.schemaPermissions = schemaPermissions;
    }

    @Override
    public IOlapRoleSchemasDefinition<OlapRoleSchemasDefinition> copy() {
        return new OlapRoleSchemasDefinition();
    }

    @Override
    public void setupConstrainedDefaultValues(@Nullable Object owner) {
        OlapRoleDefinition role;
        if (owner instanceof OlapRoleDefinition && (role = (OlapRoleDefinition)owner).isFullControl()) {
            this.defaultSchemaAccess = OlapRoleAccessDefinition.WRITE;
            this.authorizedSchemaNames = new OlapRoleSchemaEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
            return;
        }
        this.defaultSchemaAccess = OlapRoleAccessDefinition.WRITE;
        this.authorizedSchemaNames = new OlapRoleSchemaEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
    }

    @Override
    public String getName() {
        return "Schemas";
    }

    @Override
    public boolean isSchemaAuthorized(String schema) {
        if (this.authorizedSchemaNames == null) {
            throw new CdProgrammingException("internal error: missing authorized schema names permissions");
        }
        return this.authorizedSchemaNames.isAuthorizedName(schema);
    }

    @Override
    public String getDefinition() {
        return "";
    }

    @Nullable
    public OlapRoleAccessDefinition getDefaultSchemaAccess() {
        return this.defaultSchemaAccess;
    }

    public void setDefaultSchemaAccess(@Nullable OlapRoleAccessDefinition defaultSchemaAccess) {
        this.defaultSchemaAccess = defaultSchemaAccess;
    }

    @Nullable
    public OlapRoleAccessDefinition getDefaultAccess() {
        return this.defaultSchemaAccess;
    }

    public void setDefaultAccess(OlapRoleAccessDefinition defaultSchemaAccess) {
        this.defaultSchemaAccess = defaultSchemaAccess;
    }

    @Nullable
    public OlapRoleSchemaEntityListDefinition getAuthorizedSchemaNames() {
        return this.authorizedSchemaNames;
    }

    public void setAuthorizedSchemaNames(OlapRoleSchemaEntityListDefinition authorizedSchemaNames) {
        this.authorizedSchemaNames = authorizedSchemaNames;
    }

    @Nullable
    public List<OlapRoleSchemaDefinition> getSchemaPermissions() {
        return this.schemaPermissions;
    }

    public List<OlapRoleSchemaDefinition> getValidSchemaPermissions() {
        if (this.schemaPermissions == null) {
            return Collections.emptyList();
        }
        return this.schemaPermissions;
    }

    public void clearSchemaPermissions() {
        if (this.schemaPermissions != null) {
            this.schemaPermissions.clear();
        }
    }

    public void addSchemaPermission(OlapRoleSchemaDefinition permission) {
        if (this.schemaPermissions == null) {
            this.schemaPermissions = new ArrayList<OlapRoleSchemaDefinition>();
        }
        this.schemaPermissions.add(permission);
    }

    public boolean removeSchemaPermission(OlapRoleSchemaDefinition definition) {
        return this.schemaPermissions != null && this.schemaPermissions.remove(definition);
    }

    @Nullable
    public OlapRoleSchemaDefinition getSchemaPermission(String schemaName) {
        if (this.schemaPermissions != null) {
            for (OlapRoleSchemaDefinition schemaPermission : this.schemaPermissions) {
                String schemaPermissionName = schemaPermission.getName();
                if (schemaPermissionName == null || !OlapCaseInsensitiveName.equals(schemaPermissionName, schemaName)) continue;
                return schemaPermission;
            }
        }
        return null;
    }

    @Override
    public OlapValidator<OlapRoleDefinitionValidationContext, OlapRoleDefinition, OlapRoleSchemasDefinition> getValidator() {
        return new OlapRoleSchemasDefinitionValidator();
    }

    @Override
    public String getContextVisualId() {
        return String.valueOf(this.getName());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapRoleSchemasDefinition that = (OlapRoleSchemasDefinition)o;
        if (this.authorizedSchemaNames != null ? !this.authorizedSchemaNames.equals(that.authorizedSchemaNames) : that.authorizedSchemaNames != null) {
            return false;
        }
        if (this.defaultSchemaAccess != that.defaultSchemaAccess) {
            return false;
        }
        return !(this.schemaPermissions != null ? !this.schemaPermissions.equals(that.schemaPermissions) : that.schemaPermissions != null);
    }

    @Override
    public int hashCode() {
        int result = this.defaultSchemaAccess != null ? this.defaultSchemaAccess.hashCode() : 0;
        result = 31 * result + (this.authorizedSchemaNames != null ? this.authorizedSchemaNames.hashCode() : 0);
        result = 31 * result + (this.schemaPermissions != null ? this.schemaPermissions.hashCode() : 0);
        return result;
    }
}

