/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.definition.role;

import crazydev.common.bean.IEmptyable;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.authorization.definition.application.OlapRoleApplicationsDefinition;
import crazydev.iccube.authorization.definition.common.IOlapRoleNamedDefinition;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinitions;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemasDefinition;
import crazydev.iccube.authorization.validation.common.IOlapRoleDefinitionValidationEnabled;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.authorization.validation.role.OlapRoleDefinitionValidator;
import crazydev.iccube.authorizationx.definition.dashboards.IOlapRoleDashboardsDefinition;
import crazydev.iccube.authorizationx.definition.docs.IOlapRoleDocsDefinition;
import crazydev.iccube.authorizationx.definition.schemas.IOlapRoleSchemasDefinition;
import crazydev.iccube.authorizationx.flat.definition.dashboards.OlapRoleFlatDashboardsDefinition;
import crazydev.iccube.authorizationx.flat.definition.dashboards.OlapRoleFlatDashboardsDefinitionParser;
import crazydev.iccube.authorizationx.flat.definition.dashboards.OlapRoleFlatDashboardsProfile;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsDefinition;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsDefinitionParser;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsProfile;
import crazydev.iccube.authorizationx.flat.definition.schemas.OlapRoleFlatSchemasDefinition;
import crazydev.iccube.builder.factory.schema.IOlapBuilderJaxbListener;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="role")
public class OlapRoleDefinition
implements IOlapRoleDefinitionValidationEnabled<OlapRoleDefinitions, OlapRoleDefinition>,
IEmptyable<OlapRoleDefinition>,
IOlapRoleNamedDefinition,
IOlapBuilderJaxbListener {
    public static final CdProperty UUID = new CdReadWriteProperty(OlapRoleDefinition.class, "uuid");
    public static final CdProperty NAME = new CdReadWriteProperty(OlapRoleDefinition.class, "name");
    public static final CdProperty DESCRIPTION = new CdReadWriteProperty(OlapRoleDefinition.class, "description");
    public static final CdProperty FULL_CONTROL = new CdReadWriteProperty(OlapRoleDefinition.class, "fullControl");
    public static final CdProperty APPLICATIONS = new CdReadWriteProperty(OlapRoleDefinition.class, "applicationsPermissions");
    public static final CdProperty SCHEMAS = new CdReadWriteProperty(OlapRoleDefinition.class, "schemasPermissions");
    public static final CdProperty DASHBOARDS = new CdReadWriteProperty(OlapRoleDefinition.class, "dashboardsPermissions");
    public static final CdProperty DOCS = new CdReadWriteProperty(OlapRoleDefinition.class, "docsPermissions");
    @XmlAttribute(name="uuid", required=false)
    @Nullable
    private String uuid = java.util.UUID.randomUUID().toString();
    @XmlAttribute(name="name", required=true)
    @Nullable
    private String name;
    @XmlAttribute(name="description", required=false)
    @Nullable
    private String description;
    @XmlAttribute(name="fullControl", required=true)
    private boolean fullControl;
    @XmlElement(name="applications", required=false)
    @Nullable
    private OlapRoleApplicationsDefinition applicationsPermissions;
    @XmlElementRefs(value={@XmlElementRef(type=OlapRoleSchemasDefinition.class, required=false), @XmlElementRef(type=OlapRoleFlatSchemasDefinition.class, required=false)})
    @Nullable
    private IOlapRoleSchemasDefinition schemasPermissions;
    @XmlElementRefs(value={@XmlElementRef(type=OlapRoleFlatDashboardsDefinition.class, required=false)})
    @Nullable
    private IOlapRoleDashboardsDefinition dashboardsPermissions;
    @XmlTransient
    @Nullable
    private volatile OlapRoleFlatDashboardsProfile validatedDashboardsPermissions;
    @XmlElementRefs(value={@XmlElementRef(type=OlapRoleFlatDocsDefinition.class, required=false)})
    @Nullable
    private IOlapRoleDocsDefinition docsPermissions;
    @XmlTransient
    @Nullable
    private volatile OlapRoleFlatDocsProfile validatedDocsPermissions;
    @XmlTransient
    private boolean updated;

    public OlapRoleDefinition() {
    }

    public OlapRoleDefinition(String name) {
        this(name, false);
    }

    public OlapRoleDefinition(String name, boolean fullControl) {
        this.name = name;
        this.fullControl = fullControl;
    }

    protected OlapRoleDefinition(@Nullable String name, @Nullable String description, boolean fullControl, @Nullable OlapRoleApplicationsDefinition applicationsPermissions, @Nullable IOlapRoleSchemasDefinition schemasPermissions, @Nullable IOlapRoleDashboardsDefinition dashboardsPermissions, @Nullable IOlapRoleDocsDefinition docsPermissions) {
        this.name = name;
        this.description = description;
        this.fullControl = fullControl;
        this.applicationsPermissions = applicationsPermissions;
        this.schemasPermissions = schemasPermissions;
        this.dashboardsPermissions = dashboardsPermissions;
        this.docsPermissions = docsPermissions;
    }

    @Override
    public void beforeMarshal() {
    }

    @Override
    public void afterUnmarshal() {
        if (this.uuid == null) {
            this.uuid = java.util.UUID.randomUUID().toString();
        }
    }

    public OlapRoleDefinition setupForEmptyModel() {
        this.fullControl = false;
        this.applicationsPermissions = new OlapRoleApplicationsDefinition();
        this.applicationsPermissions.setupConstrainedDefaultValues(null);
        OlapRoleFlatSchemasDefinition schemas = new OlapRoleFlatSchemasDefinition();
        schemas.setupConstrainedDefaultValues(null);
        this.schemasPermissions = schemas;
        OlapRoleFlatDashboardsDefinition dashboards = new OlapRoleFlatDashboardsDefinition();
        dashboards.setupConstrainedDefaultValues(null);
        this.dashboardsPermissions = dashboards;
        this.validatedDashboardsPermissions = null;
        OlapRoleFlatDocsDefinition docs = new OlapRoleFlatDocsDefinition();
        docs.setupConstrainedDefaultValues(null);
        this.docsPermissions = docs;
        this.validatedDocsPermissions = null;
        return this;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public String getUUID() {
        return this.uuid;
    }

    public boolean isFullControl() {
        return this.fullControl;
    }

    public void setAsFullControl() {
        this.fullControl = true;
    }

    public String getSchemaPermsDefinitionForUX() {
        if (this.fullControl) {
            return "full-control (schemas)";
        }
        if (this.schemasPermissions instanceof OlapRoleSchemasDefinition) {
            return "n/a (deprecated UI schemas perms. definition)";
        }
        if (this.schemasPermissions instanceof OlapRoleFlatSchemasDefinition) {
            return ((OlapRoleFlatSchemasDefinition)this.schemasPermissions).getDefinitionForUX();
        }
        return "n/a";
    }

    public String getDashboardsDefinitionForUX() {
        if (this.fullControl) {
            return "full-control (dashboards)";
        }
        if (this.dashboardsPermissions instanceof OlapRoleFlatDashboardsDefinition) {
            return ((OlapRoleFlatDashboardsDefinition)this.dashboardsPermissions).getDefinitionForUX();
        }
        return "n/a";
    }

    public String getDocsDefinitionForUX() {
        if (this.fullControl) {
            return "full-control (docs)";
        }
        if (this.docsPermissions instanceof OlapRoleFlatDocsDefinition) {
            return ((OlapRoleFlatDocsDefinition)this.docsPermissions).getDefinitionForUX();
        }
        return "n/a";
    }

    @Nullable
    public OlapRoleApplicationsDefinition getApplicationsPermissions() {
        return this.applicationsPermissions;
    }

    public void setApplicationsPermissions(OlapRoleApplicationsDefinition applicationsPermissions) {
        this.applicationsPermissions = applicationsPermissions;
    }

    public OlapRoleApplicationsDefinition getValidatedApplicationsPermissions() {
        if (this.applicationsPermissions == null) {
            throw new CdProgrammingException("internal error: missing application permissions");
        }
        return this.applicationsPermissions;
    }

    @Nullable
    public IOlapRoleSchemasDefinition getSchemasPermissions() {
        return this.schemasPermissions;
    }

    public void setSchemasPermissions(IOlapRoleSchemasDefinition schemasPermissions) {
        this.schemasPermissions = schemasPermissions;
    }

    public IOlapRoleSchemasDefinition getValidatedSchemasPermissions() {
        if (this.schemasPermissions == null) {
            throw new CdProgrammingException("internal error: missing schemas permissions");
        }
        return this.schemasPermissions;
    }

    public void setDashboardsPermissions(@Nullable String dashboardsPermissions) {
        this.dashboardsPermissions = dashboardsPermissions != null ? new OlapRoleFlatDashboardsDefinition(dashboardsPermissions) : null;
        this.validatedDashboardsPermissions = null;
    }

    public OlapRoleFlatDashboardsProfile getValidatedDashboardsPermissions() {
        if (this.validatedDashboardsPermissions != null) {
            return this.validatedDashboardsPermissions;
        }
        if (this.dashboardsPermissions == null) {
            this.validatedDashboardsPermissions = new OlapRoleFlatDashboardsProfile(new OlapRoleFlatDashboardsDefinition(""));
            return this.validatedDashboardsPermissions;
        }
        this.validatedDashboardsPermissions = OlapRoleFlatDashboardsDefinitionParser.parse(this.name, this.dashboardsPermissions);
        return this.validatedDashboardsPermissions;
    }

    public void setDocsPermissions(@Nullable String docsPermissions) {
        this.docsPermissions = docsPermissions != null ? new OlapRoleFlatDocsDefinition(docsPermissions) : null;
        this.validatedDocsPermissions = null;
    }

    @Nullable
    public OlapRoleFlatDocsProfile getValidatedDocsPermissions() {
        if (this.validatedDocsPermissions != null) {
            return this.validatedDocsPermissions;
        }
        if (this.docsPermissions == null) {
            return null;
        }
        this.validatedDocsPermissions = OlapRoleFlatDocsDefinitionParser.parse(this.name, this.docsPermissions);
        return this.validatedDocsPermissions;
    }

    @Override
    public OlapValidator<OlapRoleDefinitionValidationContext, OlapRoleDefinitions, OlapRoleDefinition> getValidator() {
        return new OlapRoleDefinitionValidator();
    }

    @Override
    public String getContextVisualId() {
        return String.valueOf(this.getName());
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
        this.validatedDashboardsPermissions = null;
        this.validatedDocsPermissions = null;
    }

    public OlapRoleDefinition copy() {
        return new OlapRoleDefinition(this.name, this.description, this.fullControl, this.applicationsPermissions != null ? this.applicationsPermissions.copy() : null, this.schemasPermissions != null ? this.schemasPermissions.copy() : null, this.dashboardsPermissions != null ? this.dashboardsPermissions.copy() : null, this.docsPermissions != null ? this.docsPermissions.copy() : null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapRoleDefinition that = (OlapRoleDefinition)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.fullControl != that.fullControl) {
            return false;
        }
        if (!this.fullControl) {
            if (this.applicationsPermissions != null ? !this.applicationsPermissions.equals(that.applicationsPermissions) : that.applicationsPermissions != null) {
                return false;
            }
            if (this.schemasPermissions != null ? !this.schemasPermissions.equals(that.schemasPermissions) : that.schemasPermissions != null) {
                return false;
            }
            if (this.dashboardsPermissions != null ? !this.dashboardsPermissions.equals(that.dashboardsPermissions) : that.dashboardsPermissions != null) {
                return false;
            }
            if (this.docsPermissions != null ? !this.docsPermissions.equals(that.docsPermissions) : that.docsPermissions != null) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.fullControl ? 1 : 0);
        result = 31 * result + (this.applicationsPermissions != null ? this.applicationsPermissions.hashCode() : 0);
        result = 31 * result + (this.schemasPermissions != null ? this.schemasPermissions.hashCode() : 0);
        result = 31 * result + (this.dashboardsPermissions != null ? this.dashboardsPermissions.hashCode() : 0);
        result = 31 * result + (this.docsPermissions != null ? this.docsPermissions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.name == null ? "<null>" : this.name + (String)(this.description != null ? " [" + this.description + "]" : "");
    }
}

